/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbdev.phighlight;

import java.awt.Color;
import java.util.Collections;
import java.util.List;
import oracle.dbdev.phighlight.HighlightEditorPlugin;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.EditorPluginsFactory;
import oracle.ide.model.Node;
import oracle.javatools.editor.FileOverviewMargin;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.jdeveloper.cm.dt.browser.jdbc.PlSqlBaseNode;

public class HighlightAddin
implements Addin {
    private static HighlightStyle _errorHighlightStyle;
    private static HighlightStyle _warningHighlightStyle;
    static final String ERROR_CATEGORY = "PLSQLERROR";
    static final String WARNING_CATEGORY = "PLSQLWARNING";

    public void initialize() {
        _errorHighlightStyle = CodeEditor.createHighlightStyle((String)(this.getClass().getName() + "-E"), (String)"PLSQL Errors", (int)50, null, null, (int)0, (int)4, (Color)Color.RED);
        _warningHighlightStyle = CodeEditor.createHighlightStyle((String)(this.getClass().getName() + "-W"), (String)"PLSQL Warnings", (int)50, null, null, (int)0, (int)4, (Color)new Color(240, 240, 0));
        FileOverviewMargin.setMarkColor((String)ERROR_CATEGORY, (HighlightStyle)_errorHighlightStyle);
        FileOverviewMargin.setMarkColor((String)WARNING_CATEGORY, (HighlightStyle)_warningHighlightStyle);
        CodeEditor.registerFactory((EditorPluginsFactory)new EditorPluginsFactory(){

            public List createPlugins(Context context) {
                List<HighlightEditorPlugin> ret = Collections.EMPTY_LIST;
                Node node = context.getNode();
                if (node instanceof PlSqlBaseNode) {
                    ret = Collections.singletonList(new HighlightEditorPlugin());
                }
                return ret;
            }
        });
    }

    public static HighlightStyle getErrorHighlightStyle() {
        return _errorHighlightStyle;
    }

    public static HighlightStyle getWarningHighlightStyle() {
        return _warningHighlightStyle;
    }
}

