/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbdev.phighlight;

import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import oracle.dbdev.phighlight.HighlightAddin;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeListener;
import oracle.ide.util.Assert;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.db.Database;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.FileOverviewMargin;
import oracle.javatools.editor.FileOverviewMark;
import oracle.javatools.editor.ToolTipProvider;
import oracle.javatools.editor.highlight.HighlightLayer;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.jdeveloper.cm.dt.browser.jdbc.PlSqlBaseNode;
import oracle.jdevimpl.refactoring.highlight.HighlightMark;

public class HighlightEditorPlugin
implements EditorPlugin {
    private BasicEditorPane _editorPane;
    private NodeListener _nodeListener;
    private HighlightLayer _highlightLayer;
    private boolean _hasAlterSession;
    private Boolean _hasWarnings;
    private PlSqlError[] _errors;

    public void install(BasicEditorPane editorPane) {
        this._editorPane = editorPane;
        PlSqlBaseNode plSqlBaseNode = this.getNode();
        this._nodeListener = new NodeListener(){

            public void nodeSaved(NodeEvent e) {
                HighlightEditorPlugin.this.updateHighlight();
            }
        };
        plSqlBaseNode.addNodeListener(this._nodeListener);
        this.updateHighlight();
        editorPane.addToolTipProvider(new ToolTipProvider(){

            public String getToolTipText(BasicEditorPane editorPane, MouseEvent mouseEvent, int offset) {
                for (int i = 0; i < HighlightEditorPlugin.this._errors.length; ++i) {
                    PlSqlError error = HighlightEditorPlugin.this._errors[i];
                    if (!error.isInHighlight(offset)) continue;
                    String[] lines = error._message.split("\n");
                    String tooltip = lines[0];
                    if (lines.length > 1) {
                        tooltip = tooltip + "...";
                    }
                    return tooltip;
                }
                return null;
            }
        });
    }

    public void deinstall(BasicEditorPane editorPane) {
        PlSqlBaseNode node = this.getNode();
        node.removeNodeListener(this._nodeListener);
    }

    public void propertyChange(PropertyChangeEvent evt) {
    }

    private PlSqlBaseNode getNode() {
        Context context = (Context)this._editorPane.getProperty("editor-ide-context");
        PlSqlBaseNode plSqlBaseNode = (PlSqlBaseNode)context.getNode();
        return plSqlBaseNode;
    }

    public HighlightLayer getHighlightLayer() {
        if (this._highlightLayer == null) {
            this._highlightLayer = this._editorPane.createHighlightLayer();
        }
        return this._highlightLayer;
    }

    private void updateHighlight() {
        HighlightLayer highlightLayer = this.getHighlightLayer();
        highlightLayer.removeAllHighlights();
        HighlightStyle errorHighlightStyle = HighlightAddin.getErrorHighlightStyle();
        HighlightStyle warningHighlightStyle = HighlightAddin.getWarningHighlightStyle();
        Context context = (Context)this._editorPane.getProperty("editor-ide-context");
        CodeEditor codeEditor = (CodeEditor)context.getView();
        FileOverviewMargin fileOverviewMargin = codeEditor.getFileOverviewMargin();
        fileOverviewMargin.clearMarks("PLSQLERROR");
        fileOverviewMargin.clearMarks("PLSQLWARNING");
        TextBuffer textBuffer = this.getNode().acquireTextBuffer();
        String code = textBuffer.getString(0, textBuffer.getLength());
        this._errors = this.getErrors();
        for (int i = 0; i < this._errors.length; ++i) {
            HighlightStyle highlightStyle;
            String category;
            PlSqlError error = this._errors[i];
            int line = error._line;
            String message = error._message;
            if (error._isError) {
                category = "PLSQLERROR";
                highlightStyle = errorHighlightStyle;
            } else {
                category = "PLSQLWARNING";
                highlightStyle = warningHighlightStyle;
            }
            try {
                HighlightMark highlightMark;
                int lineStartOffset = this._editorPane.getLineStartOffset(line);
                int lineEndOffset = this._editorPane.getLineEndOffset(line);
                if (message.startsWith("PLS-00103:")) {
                    int offset = error._offset;
                    int position = this.getPositionBefore(code, lineStartOffset + offset);
                    line = this._editorPane.getLineFromOffset(position);
                    highlightLayer.addHighlight(highlightStyle, position, position + 1);
                    highlightMark = new HighlightMark(position, position, message);
                    fileOverviewMargin.addMark(category, line, (FileOverviewMark)highlightMark);
                    error.setHighlights(position, position);
                    continue;
                }
                int from = lineStartOffset + error._offset;
                int to = lineEndOffset - 1;
                highlightLayer.addHighlight(highlightStyle, from, to);
                highlightMark = new HighlightMark(from, from, message);
                fileOverviewMargin.addMark(category, line, (FileOverviewMark)highlightMark);
                error.setHighlights(from, to);
                continue;
            }
            catch (Exception e) {
                Assert.println((String)("Could not highlight:" + e.getMessage()));
            }
        }
    }

    private int getPositionBefore(String code, int i) {
        int ret = i;
        int state = 0;
        int pos = 0;
        while (pos < i) {
            char c = code.charAt(pos++);
            block0 : switch (state) {
                case 0: {
                    if (Character.isWhitespace(c)) break;
                    switch (c) {
                        case '-': {
                            state = 1;
                            break block0;
                        }
                        case '/': {
                            state = 3;
                            break block0;
                        }
                    }
                    ret = pos;
                    break;
                }
                case 1: {
                    state = c == '-' ? 2 : 0;
                    break;
                }
                case 2: {
                    if (c != '\n') break;
                    state = 0;
                    break;
                }
                case 3: {
                    state = c == '*' ? 4 : 0;
                }
                case 4: {
                    if (c != '*') break;
                    state = 5;
                    break;
                }
                case 5: {
                    state = c == '*' ? 0 : 4;
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PlSqlError[] getErrors() {
        ArrayList<PlSqlError> errors = new ArrayList<PlSqlError>();
        PlSqlBaseNode node = this.getNode();
        String objectType = node.getObjectType();
        String shortLabel = node.getShortLabel();
        Database database = node.getDatabase();
        Connection connection = database.getConnection();
        try {
            PreparedStatement preparedStatement = this.getPreparedStatement(connection);
            try {
                boolean hasWarnings;
                preparedStatement.setString(1, objectType);
                preparedStatement.setString(2, shortLabel);
                ResultSet resultSet = preparedStatement.executeQuery();
                ResultSetMetaData metaData = resultSet.getMetaData();
                boolean bl = hasWarnings = metaData.getColumnCount() == 4;
                while (resultSet.next()) {
                    int line = resultSet.getInt(1) - 1;
                    int offset = resultSet.getInt(2) - 1;
                    String text = resultSet.getString(3);
                    boolean isError = hasWarnings ? "ERROR".equals(resultSet.getString(4)) : true;
                    PlSqlError plSqlError = new PlSqlError(line, offset, text, isError);
                    errors.add(plSqlError);
                }
            }
            finally {
                preparedStatement.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return errors.toArray(new PlSqlError[errors.size()]);
    }

    private PreparedStatement getPreparedStatement(Connection connection) throws SQLException {
        PreparedStatement preparedStatement = null;
        try {
            if (this._hasWarnings != Boolean.FALSE) {
                this.enableWarnings(connection);
                this._hasWarnings = Boolean.TRUE;
            }
        }
        catch (SQLException e) {
            this._hasWarnings = Boolean.FALSE;
        }
        preparedStatement = this._hasWarnings == Boolean.TRUE ? connection.prepareStatement("SELECT LINE,POSITION,TEXT,ATTRIBUTE FROM USER_ERRORS WHERE TYPE=?AND NAME=?") : connection.prepareStatement("SELECT LINE,POSITION,TEXT FROM USER_ERRORS WHERE TYPE=?AND NAME=?");
        return preparedStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enableWarnings(Connection connection) throws SQLException {
        if (!this._hasAlterSession) {
            this._hasAlterSession = true;
            Statement alterStatement = connection.createStatement();
            try {
                alterStatement.execute("ALTER SESSION SET PLSQL_WARNINGS = 'ENABLE:ALL'");
            }
            finally {
                alterStatement.close();
            }
        }
    }

    private static class PlSqlError {
        private int _line;
        private int _offset;
        private String _message;
        private boolean _isError;
        private int _highlightedFrom;
        private int _highlightedTo;

        public PlSqlError(int line, int offset, String message, boolean error) {
            this._line = line;
            this._offset = offset;
            this._message = message;
            this._isError = error;
        }

        void setHighlights(int from, int to) {
            this._highlightedFrom = from;
            this._highlightedTo = to;
        }

        boolean isInHighlight(int offset) {
            return this._highlightedFrom <= offset && offset <= this._highlightedTo;
        }
    }
}

