/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.schema;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XMLSchemaNode;
import oracle.xml.parser.schema.XSDAnnotation;
import oracle.xml.parser.schema.XSDAny;
import oracle.xml.parser.schema.XSDAttrGroup;
import oracle.xml.parser.schema.XSDAttribute;
import oracle.xml.parser.schema.XSDComplexType;
import oracle.xml.parser.schema.XSDConstantValues;
import oracle.xml.parser.schema.XSDElement;
import oracle.xml.parser.schema.XSDException;
import oracle.xml.parser.schema.XSDGroup;
import oracle.xml.parser.schema.XSDIdentity;
import oracle.xml.parser.schema.XSDNode;
import oracle.xml.parser.schema.XSDNotation;
import oracle.xml.parser.schema.XSDSchemaDefaults;
import oracle.xml.parser.schema.XSDSimpleType;
import oracle.xml.parser.v2.DOMLocator;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.NSResolver;
import oracle.xml.parser.v2.XMLAttr;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLError;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLParseException;
import oracle.xml.parser.v2.XMLUtil;
import oracle.xml.parser.v2.XSLException;
import oracle.xml.util.QxName;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XSDBuilder
implements XSDConstantValues {
    private Vector unresolvedNodes;
    private Stack schemaDefStack;
    private XSDSchemaDefaults schemaDefs;
    private EntityResolver entResolver;
    private DOMParser domParser;
    private DOMLocator domLocator;
    private XMLSchema schemaxml = new XMLSchema(10);
    private Locale locale;
    private boolean localErr;
    private XMLError err;
    private String xsdNamespace;
    private boolean redefine;
    private boolean isJAXP;
    private String includingNS;
    private boolean debugMode = true;
    private XMLDocument doc;
    private Vector keyRefs;
    private Hashtable idenConsTable;

    public XSDBuilder() throws XSDException {
        this.schemaxml.setBuilder(this);
        this.schemaDefStack = new Stack();
        this.unresolvedNodes = new Vector(10);
        this.localErr = true;
        this.err = new XMLError();
        this.domLocator = new DOMLocator();
        this.doc = new XMLDocument();
        this.keyRefs = new Vector();
        this.idenConsTable = new Hashtable();
        this.err.setErrorStream(new PrintWriter(System.out));
        this.err.setLocator(this.domLocator);
    }

    public void setError(XMLError xMLError) {
        this.localErr = false;
        this.err = xMLError;
        this.err.setLocator(this.domLocator);
    }

    public void setDebugMode(boolean bl) {
        this.debugMode = bl;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entResolver = entityResolver;
        if (this.domParser != null) {
            this.domParser.setEntityResolver(entityResolver);
        }
    }

    void setJAXP(boolean bl) {
        this.isJAXP = bl;
    }

    public Object getObject() {
        return this.schemaxml;
    }

    public XMLSchema build(String string) throws XSDException {
        this.initParser(null);
        try {
            this.domParser.parse(string);
        }
        catch (XMLParseException xMLParseException) {
            throw new XSDException(xMLParseException.getMessage());
        }
        catch (SAXException sAXException) {
            throw new XSDException(sAXException.getMessage());
        }
        catch (IOException iOException) {
            throw new XSDException(iOException.getMessage());
        }
        XMLDocument xMLDocument = this.domParser.getDocument();
        if (xMLDocument != null) {
            URL uRL = null;
            XMLElement xMLElement = (XMLElement)xMLDocument.getDocumentElement();
            String string2 = xMLElement.getAttribute("targetNamespace");
            if (this.schemaxml.isNewSchemaNS(string, string2)) {
                try {
                    uRL = new URL(string);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
                this.buildSchema(xMLElement, 0, uRL);
            }
        }
        return this.schemaxml;
    }

    public XMLSchema build(InputStream inputStream, URL uRL) throws XSDException {
        this.initParser(uRL);
        try {
            this.domParser.parse(inputStream);
        }
        catch (XMLParseException xMLParseException) {
            throw new XSDException(xMLParseException.getMessage());
        }
        catch (SAXException sAXException) {
            throw new XSDException(sAXException.getMessage());
        }
        catch (IOException iOException) {
            throw new XSDException(iOException.getMessage());
        }
        XMLDocument xMLDocument = this.domParser.getDocument();
        return this.build(xMLDocument, uRL);
    }

    public XMLSchema build(Reader reader, URL uRL) throws XSDException {
        this.initParser(uRL);
        try {
            this.domParser.parse(reader);
        }
        catch (XMLParseException xMLParseException) {
            throw new XSDException(xMLParseException.getMessage());
        }
        catch (SAXException sAXException) {
            throw new XSDException(sAXException.getMessage());
        }
        catch (IOException iOException) {
            throw new XSDException(iOException.getMessage());
        }
        XMLDocument xMLDocument = this.domParser.getDocument();
        return this.build(xMLDocument, uRL);
    }

    public XMLSchema build(URL uRL) throws XSDException {
        this.initParser(null);
        try {
            this.domParser.parse(uRL);
        }
        catch (XMLParseException xMLParseException) {
            throw new XSDException(xMLParseException.getMessage());
        }
        catch (SAXException sAXException) {
            throw new XSDException(sAXException.getMessage());
        }
        catch (IOException iOException) {
            throw new XSDException(iOException.getMessage());
        }
        XMLDocument xMLDocument = this.domParser.getDocument();
        if (xMLDocument != null) {
            XMLElement xMLElement = (XMLElement)xMLDocument.getDocumentElement();
            String string = xMLElement.getAttribute("targetNamespace");
            if (this.schemaxml.isNewSchemaNS(uRL.toString(), string)) {
                this.buildSchema(xMLElement, 0, uRL);
            }
        }
        return this.schemaxml;
    }

    public XMLSchema build(InputSource inputSource) throws XSDException {
        this.initParser(null);
        try {
            this.domParser.parse(inputSource);
        }
        catch (XMLParseException xMLParseException) {
            throw new XSDException(xMLParseException.getMessage());
        }
        catch (SAXException sAXException) {
            throw new XSDException(sAXException.getMessage());
        }
        catch (IOException iOException) {
            throw new XSDException(iOException.getMessage());
        }
        XMLDocument xMLDocument = this.domParser.getDocument();
        if (xMLDocument != null) {
            XMLElement xMLElement = (XMLElement)xMLDocument.getDocumentElement();
            URL uRL = null;
            String string = inputSource.getSystemId();
            String string2 = xMLElement.getAttribute("targetNamespace");
            if (string != null && this.schemaxml.isNewSchemaNS(string, string2)) {
                try {
                    uRL = new URL(string);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            this.buildSchema(xMLElement, 0, uRL);
        }
        return this.schemaxml;
    }

    public XMLSchema build(XMLDocument xMLDocument, URL uRL) throws XSDException {
        if (xMLDocument == null) {
            return null;
        }
        XMLElement xMLElement = (XMLElement)xMLDocument.getDocumentElement();
        this.buildSchema(xMLElement, 0, uRL);
        return this.schemaxml;
    }

    public XMLSchema build(XMLDocument[] xMLDocumentArray, URL uRL) throws XSDException {
        int n = xMLDocumentArray.length;
        if (xMLDocumentArray == null || n == 0) {
            return null;
        }
        for (int i = 0; i < n; ++i) {
            this.includingNS = "";
            XMLElement xMLElement = (XMLElement)xMLDocumentArray[i].getDocumentElement();
            if (i == n - 1) {
                this.buildSchema(xMLElement, 0, uRL);
                continue;
            }
            this.buildSchema(xMLElement, 2, uRL);
        }
        return this.schemaxml;
    }

    public XMLSchema build(XMLDocument xMLDocument, String string, String string2, URL uRL) throws XSDException {
        if (!this.schemaxml.isNewSchemaNS(string, string2)) {
            return this.schemaxml;
        }
        string = string.substring(1);
        NSResolver nSResolver = (NSResolver)((Object)xMLDocument.getDocumentElement());
        XMLElement xMLElement = null;
        try {
            xMLElement = (XMLElement)xMLDocument.selectSingleNode(string, nSResolver);
        }
        catch (XSLException xSLException) {
            throw new XSDException(xSLException.getMessage());
        }
        this.checkTargetNS(xMLElement, string2.intern(), 0);
        this.buildSchema(xMLElement, 0, uRL);
        return this.schemaxml;
    }

    public XMLSchema build(String string, String string2) throws XSDException {
        this.initParser(null);
        if (this.schemaxml.isNewSchemaNS(string2, string)) {
            try {
                this.domParser.parse(string2);
            }
            catch (XMLParseException xMLParseException) {
                throw new XSDException(xMLParseException.getMessage());
            }
            catch (SAXException sAXException) {
                throw new XSDException(sAXException.getMessage());
            }
            catch (IOException iOException) {
                throw new XSDException(iOException.getMessage());
            }
        } else {
            return this.schemaxml;
        }
        XMLDocument xMLDocument = this.domParser.getDocument();
        XMLElement xMLElement = (XMLElement)xMLDocument.getDocumentElement();
        this.checkTargetNS(xMLElement, string.intern(), 0);
        URL uRL = null;
        try {
            uRL = new URL(string2);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return this.build(xMLDocument, uRL);
    }

    public XMLSchema build(String string, URL uRL) throws XSDException {
        this.initParser(null);
        if (this.schemaxml.isNewSchemaNS(uRL.toString(), string)) {
            try {
                this.domParser.parse(uRL);
            }
            catch (XMLParseException xMLParseException) {
                throw new XSDException(xMLParseException.getMessage());
            }
            catch (SAXException sAXException) {
                throw new XSDException(sAXException.getMessage());
            }
            catch (IOException iOException) {
                throw new XSDException(iOException.getMessage());
            }
        } else {
            return this.schemaxml;
        }
        XMLDocument xMLDocument = this.domParser.getDocument();
        XMLElement xMLElement = (XMLElement)xMLDocument.getDocumentElement();
        this.checkTargetNS(xMLElement, string.intern(), 0);
        return this.build(xMLDocument, uRL);
    }

    private void initParser(URL uRL) throws XSDException {
        try {
            if (this.domParser == null) {
                this.domParser = new DOMParser();
            }
            this.domParser.setBaseURL(uRL);
            this.domParser.setPreserveWhitespace(true);
            this.domParser.setValidationMode(0);
            this.domParser.setDebugMode(this.debugMode);
            if (this.entResolver != null) {
                this.domParser.setEntityResolver(this.entResolver);
            }
            this.domParser.setErrorStream(System.out);
        }
        catch (Exception exception) {
            throw new XSDException(exception.getMessage());
        }
    }

    private boolean checkTargetNS(XMLElement xMLElement, String string, int n) throws XSDException {
        string = string == null ? "" : string.intern();
        String string2 = xMLElement.getAttribute("targetNamespace");
        if (string != (string2 = string2 == null ? "" : string2.intern())) {
            if (string == "") {
                if (n == 1) {
                    this.error(xMLElement, 24127, string2, false);
                } else {
                    this.error(xMLElement, 24124, string2, false);
                }
            } else if (string2 == "") {
                this.error(xMLElement, 24122, string, false);
            } else {
                this.error2(xMLElement, 24123, string2, string, false);
            }
        }
        return true;
    }

    private void buildSchema(XMLElement xMLElement, int n, URL uRL) throws XSDException {
        if (xMLElement.getLocalName() != "schema") {
            this.error(xMLElement, 24534, xMLElement.getTagName(), false);
        }
        XMLSchemaNode xMLSchemaNode = null;
        String string = "";
        if (this.schemaDefs != null) {
            string = this.schemaDefs.getTargetNSDefault();
        }
        this.schemaDefs = this.schemaDefStack.push(new XSDSchemaDefaults());
        String string2 = this.parseSchema(xMLElement);
        switch (n) {
            case 0: {
                this.includingNS = "";
            }
            case 2: {
                xMLSchemaNode = this.schemaxml.getSchemaByTargetNS(string2);
                this.schemaDefs.setTargetNSDefault(string2);
                break;
            }
            case 1: {
                if (string2.equals("")) {
                    string2 = string;
                } else if (!string2.equals(string)) {
                    this.error(xMLElement, 24126, string2, false);
                }
                this.schemaDefs.setTargetNSDefault(string2);
                xMLSchemaNode = this.schemaxml.getSchemaByTargetNS(string2);
            }
        }
        if (xMLSchemaNode == null) {
            xMLSchemaNode = new XMLSchemaNode(30);
            xMLSchemaNode.targetNS = string2;
            this.schemaxml.setXMLSchemaNode(string2, xMLSchemaNode);
        }
        this.parseTopLevelElem(xMLElement, xMLSchemaNode, uRL);
        if (n == 0) {
            this.schemaxml.schemaTargetNS = string2;
            this.resolveNodes();
            this.resolveKeyRefs();
            QxName qxName = this.schemaxml.checkNotation();
            if (qxName != null) {
                this.error(xMLElement, 24034, qxName.getQName(), false);
            }
            try {
                try {
                    this.schemaxml.postProcessSchema();
                }
                catch (XSDException xSDException) {
                    this.error(xSDException.getErrorNode(), xSDException.getErrorId(), xSDException.getErrorPara1(), false);
                }
                if (this.localErr) {
                    this.err.flushErrors();
                }
            }
            catch (Exception exception) {
                throw new XSDException(exception.getMessage());
            }
        }
        this.schemaDefStack.pop();
        this.schemaDefs = !this.schemaDefStack.empty() ? (XSDSchemaDefaults)this.schemaDefStack.peek() : null;
    }

    private String parseSchema(XMLElement xMLElement) throws XSDException {
        String string = "unqualified";
        String string2 = "unqualified";
        BitSet bitSet = new BitSet(8);
        String string3 = "";
        NamedNodeMap namedNodeMap = xMLElement.getAttributes();
        int n = namedNodeMap.getLength();
        for (int i = 0; i < n; ++i) {
            XMLAttr xMLAttr = (XMLAttr)namedNodeMap.item(i);
            String string4 = xMLAttr.getNodeLocalName();
            String string5 = xMLAttr.getValue().intern();
            String string6 = xMLAttr.getNamespace();
            if (this.skipAttribute(string4, string6)) continue;
            try {
                if (string4 == "targetNamespace") {
                    string3 = string5;
                    continue;
                }
                if (string4 == "blockDefault") {
                    this.parseBlockValue(string5, bitSet);
                    continue;
                }
                if (string4 == "finalDefault") {
                    if (this.parseFinalValue(string5, bitSet, false)) continue;
                    this.error2(xMLElement, 24523, string5, string4, false);
                    continue;
                }
                if (string4 == "attributeFormDefault") {
                    if (string5 != "qualified" && string5 != "unqualified") {
                        this.error2(xMLElement, 24523, string5, string4, false);
                        continue;
                    }
                    string = string5;
                    continue;
                }
                if (string4 == "elementFormDefault") {
                    if (string5 != "qualified" && string5 != "unqualified") {
                        this.error2(xMLElement, 24523, string5, string4, false);
                        continue;
                    }
                    string2 = string5;
                    continue;
                }
                if (string4 == "version" || string4 == "id") continue;
                this.error2(xMLElement, 24526, string4, "element", false);
                continue;
            }
            catch (XSDException xSDException) {
                this.error2(xMLElement, 24523, string5, string4, false);
            }
        }
        this.schemaDefs.setDefaults(string, string2, bitSet, this.redefine);
        return string3;
    }

    private void parseTopLevelElem(XMLElement xMLElement, XMLSchemaNode xMLSchemaNode, URL uRL) throws XSDException {
        Object object;
        if (xMLElement == null) {
            return;
        }
        NamedNodeMap namedNodeMap = xMLElement.getAttributes();
        int n = namedNodeMap.getLength();
        for (int i = 0; i < n; ++i) {
            XMLAttr xMLAttr = (XMLAttr)namedNodeMap.item(i);
            if (xMLAttr.getPrefix() == "xmlns" || xMLAttr.getName() == "xmlns" || !this.skipAttribute(xMLAttr.getNodeLocalName(), xMLAttr.getNamespace())) continue;
            object = (XMLAttr)xMLAttr.cloneNode(true);
            object = (XMLAttr)this.doc.importNode((Node)object, true);
            xMLSchemaNode.addAnnotationAttr((XMLAttr)object);
        }
        this.xsdNamespace = xMLElement.getNamespace().intern();
        if (this.xsdNamespace != "http://www.w3.org/2001/XMLSchema") {
            this.error2(xMLElement, 24530, "schema", this.xsdNamespace, false);
        }
        this.schemaxml.setSchemaNS(this.xsdNamespace);
        object = null;
        NodeList nodeList = xMLElement.getChildNodes();
        int n2 = nodeList.getLength();
        String string = this.includingNS;
        String string2 = this.schemaDefs.getTargetNSDefault();
        for (int i = 0; i < n2; ++i) {
            object = null;
            XMLNode xMLNode = (XMLNode)nodeList.item(i);
            if (xMLNode.getNodeType() != 1) continue;
            XMLElement xMLElement2 = (XMLElement)xMLNode;
            String string3 = xMLElement2.getNodeLocalName();
            if (string3 == "annotation") {
                xMLSchemaNode.annotation = this.parseAnnotation(xMLElement2, xMLSchemaNode.annotation);
                continue;
            }
            if (string3 == "complexType") {
                object = this.parseComplexType(xMLElement2);
            } else if (string3 == "element") {
                object = this.parseElement(xMLElement2);
            } else if (string3 == "attribute") {
                object = this.parseAttribute(xMLElement2);
            } else if (string3 == "simpleType") {
                object = this.parseSimpleType(xMLElement2);
            } else if (string3 == "group") {
                object = this.parseGroup(xMLElement2);
            } else if (string3 == "attributeGroup") {
                object = this.parseAttrGroup(xMLElement2);
            } else if (string3 == "include") {
                if (!string2.equals("")) {
                    this.includingNS = string2;
                }
                this.parseIncludeAndImport(xMLElement2, 1, uRL);
                this.includingNS = string;
            } else if (string3 == "import") {
                this.redefine = false;
                this.includingNS = "";
                this.parseIncludeAndImport(xMLElement2, 2, uRL);
                this.redefine = this.schemaDefs.getModificationDefault();
                this.includingNS = string;
            } else if (string3 == "redefine") {
                this.redefine = true;
                if (!string2.equals("")) {
                    this.includingNS = string2;
                }
                this.parseIncludeAndImport(xMLElement2, 1, uRL);
                this.redefine = this.schemaDefs.getModificationDefault();
                this.parseRedefine(xMLElement2, xMLSchemaNode);
                this.includingNS = string;
            } else if (string3 == "notation") {
                object = this.parseNotation(xMLElement2);
            } else {
                this.error2(xMLElement, 24527, string3, "schema", false);
                continue;
            }
            if (object == null || ((XSDNode)object).getName() == null) continue;
            if (((XSDNode)object).domNode == null) {
                ((XSDNode)object).domNode = xMLElement2;
            }
            if (!xMLSchemaNode.addComponent((XSDNode)object)) continue;
            this.error(xMLElement2, 24509, ((XSDNode)object).name, false);
        }
    }

    private void parseRedefine(XMLElement xMLElement, XMLSchemaNode xMLSchemaNode) throws XSDException {
        NodeList nodeList = xMLElement.getChildNodes();
        int n = nodeList.getLength();
        XSDNode xSDNode = null;
        for (int i = 0; i < n; ++i) {
            XMLNode xMLNode = (XMLNode)nodeList.item(i);
            if (xMLNode.getNodeType() != 1) continue;
            XMLElement xMLElement2 = (XMLElement)xMLNode;
            String string = xMLElement2.getNodeLocalName();
            if (string == "complexType") {
                xSDNode = this.parseComplexType(xMLElement2);
            } else if (string == "simpleType") {
                xSDNode = this.parseSimpleType(xMLElement2);
            } else if (string == "group") {
                xSDNode = this.parseGroup(xMLElement2);
            } else if (string == "attributeGroup") {
                xSDNode = this.parseAttrGroup(xMLElement2);
            } else if (string == "notation") {
                xSDNode = this.parseNotation(xMLElement2);
            } else {
                this.error2(xMLElement, 24527, string, "schema", false);
            }
            if (xSDNode == null) continue;
            if (xSDNode.domNode == null) {
                xSDNode.domNode = xMLElement2;
            }
            xMLSchemaNode.addComponent(xSDNode);
        }
    }

    private void parseIncludeAndImport(XMLElement xMLElement, int n, URL uRL) throws XSDException {
        String string;
        boolean bl = false;
        URL uRL2 = null;
        String string2 = xMLElement.getAttribute("schemaLocation");
        String string3 = this.schemaDefs.getTargetNSDefault();
        String string4 = string2;
        if (this.domParser == null) {
            this.initParser(null);
        } else {
            this.domParser.setBaseURL(null);
        }
        if (n == 2) {
            string = xMLElement.getAttribute("namespace");
            if (string3.equals(string)) {
                this.error2(xMLElement, 24121, string, string3, false);
            }
        } else {
            string = string3;
        }
        XMLDocument xMLDocument = null;
        XMLElement xMLElement2 = null;
        if (string2.equals("")) {
            return;
        }
        if (string2.charAt(0) == '#') {
            if (!this.schemaxml.isNewSchemaNS(string2, string)) {
                return;
            }
            xMLDocument = (XMLDocument)xMLElement.getOwnerDocument();
            string2 = string2.substring(1);
            NSResolver nSResolver = (NSResolver)((Object)xMLDocument.getDocumentElement());
            try {
                xMLElement2 = (XMLElement)xMLDocument.selectSingleNode(string2, nSResolver);
            }
            catch (XSLException xSLException) {
                // empty catch block
            }
            if (xMLElement2 == null) {
                this.error2(xMLElement, 24500, string, string2, false);
                return;
            }
        } else {
            try {
                uRL2 = uRL != null ? new URL(uRL, string2) : new URL(string2);
                string4 = uRL2.toString();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            try {
                if (this.entResolver != null) {
                    InputSource inputSource;
                    if (this.isJAXP) {
                        inputSource = this.entResolver.resolveEntity(null, string4);
                    } else {
                        inputSource = this.entResolver.resolveEntity(null, string2);
                        if (inputSource == null && !string2.equals(string4)) {
                            inputSource = this.entResolver.resolveEntity(null, string4);
                        }
                    }
                    if (inputSource != null) {
                        if (inputSource.getSystemId() != null) {
                            string4 = inputSource.getSystemId();
                        }
                        if (!this.schemaxml.isNewSchemaNS(string4, string)) {
                            return;
                        }
                        string4 = inputSource.getSystemId();
                        bl = true;
                        Reader reader = inputSource.getCharacterStream();
                        if (reader != null) {
                            this.domParser.parse(reader);
                        } else {
                            InputStream inputStream = inputSource.getByteStream();
                            if (inputStream != null) {
                                String string5 = inputSource.getEncoding();
                                if (string5 == null) {
                                    this.domParser.parse(inputStream);
                                } else {
                                    this.domParser.parse(new InputStreamReader(inputStream, string5));
                                }
                            } else if (string4 != null) {
                                this.domParser.parse(string4);
                            } else {
                                bl = false;
                            }
                        }
                    }
                }
                if (!bl && uRL2 != null) {
                    if (!this.schemaxml.isNewSchemaNS(string4, string)) {
                        return;
                    }
                    this.domParser.parse(uRL2);
                    bl = true;
                }
                if (!bl) {
                    this.error2(xMLElement, 24500, string, string4, false);
                    return;
                }
                xMLDocument = this.domParser.getDocument();
                xMLElement2 = (XMLElement)xMLDocument.getDocumentElement();
            }
            catch (Exception exception) {
                this.error2(xMLElement, 24500, string, string4, false);
                return;
            }
        }
        if (n == 2) {
            this.checkTargetNS(xMLElement2, string, n);
        }
        this.buildSchema(xMLElement2, n, uRL2);
    }

    private XSDElement parseElement(XMLElement xMLElement) throws XSDException {
        boolean bl = this.isRef(xMLElement);
        boolean bl2 = this.isTopLevel(xMLElement);
        boolean bl3 = false;
        boolean bl4 = false;
        if (xMLElement.getNamespaceURI() != this.xsdNamespace) {
            this.error(xMLElement, 24100, "element", false);
        }
        if (bl && bl2) {
            this.error2(xMLElement, 24526, "ref", "element", false);
            return null;
        }
        XSDElement xSDElement = new XSDElement();
        xSDElement.domNode = xMLElement;
        BitSet bitSet = xSDElement.getProperties();
        bitSet.or(this.schemaDefs.getDefaults());
        if (bl2) {
            xSDElement.targetNS = this.schemaDefs.getTargetNSDefault();
        }
        if (!bl2 && !bl) {
            xSDElement.setForm(this.schemaDefs.getElemFormDefault());
        }
        NamedNodeMap namedNodeMap = xMLElement.getAttributes();
        int n = namedNodeMap.getLength();
        for (int i = 0; i < n; ++i) {
            XMLAttr xMLAttr = (XMLAttr)namedNodeMap.item(i);
            String string = xMLAttr.getNodeLocalName();
            String string2 = xMLAttr.getValue().intern();
            String string3 = xMLAttr.getNamespace();
            if (this.skipAttribute(string, string3)) {
                XMLAttr xMLAttr2 = (XMLAttr)xMLAttr.cloneNode(true);
                xMLAttr2 = (XMLAttr)this.doc.importNode(xMLAttr2, true);
                xSDElement.addAnnotationAttr(xMLAttr2);
                continue;
            }
            try {
                if (string == "ref") {
                    xSDElement.setRef(this.getNamespace(xMLElement, string2, this.includingNS), this.getLocalName(string2));
                    continue;
                }
                if (string == "id") {
                    xSDElement.setID(string2);
                    if (this.schemaDefs.isNewId(string2)) continue;
                    this.error(xMLElement, 24544, string2, false);
                    continue;
                }
                if (string == "default" && !bl) {
                    xSDElement.setDefault(string2);
                    continue;
                }
                if (string == "form" && !bl) {
                    xSDElement.setForm(string2);
                    continue;
                }
                if (string == "fixed" && !bl) {
                    xSDElement.setFixed(string2);
                    continue;
                }
                if (string == "nillable" && !bl) {
                    xSDElement.setNillable(this.getBooleanValue(string2));
                    continue;
                }
                if (string == "block" && !bl) {
                    this.parseBlockValue(string2, bitSet);
                    continue;
                }
                if (string == "final" && !bl) {
                    if (this.parseFinalValue(string2, bitSet, false)) continue;
                    this.error2(xMLElement, 24523, string2, string, false);
                    continue;
                }
                if (string == "type" && !bl) {
                    xSDElement.setTypeRef(this.getNamespace(xMLElement, string2, this.includingNS), this.getLocalName(string2));
                    bl4 = true;
                    continue;
                }
                if (string == "name" && !bl) {
                    xSDElement.setName(string2);
                    continue;
                }
                if (string == "substitutionGroup" && !bl && bl2) {
                    xSDElement.setEquivClassRef(this.getNamespace(xMLElement, string2, this.includingNS), this.getLocalName(string2));
                    bl3 = true;
                    continue;
                }
                if (string == "abstract") {
                    if (bl) continue;
                    xSDElement.setAbstract(this.getBooleanValue(string2));
                    continue;
                }
                if (string == "minOccurs" && !bl2) {
                    xSDElement.setMinOccurs(this.getMinValue(string2));
                    continue;
                }
                if (string == "maxOccurs" && !bl2) {
                    xSDElement.setMaxOccurs(this.getMaxValue(string2));
                    continue;
                }
                this.error2(xMLElement, 24526, string, "element", false);
                continue;
            }
            catch (Exception exception) {
                this.error2(xMLElement, 24523, string2, string, false);
            }
        }
        NodeList nodeList = xMLElement.getChildNodes();
        int n2 = nodeList.getLength();
        boolean bl5 = false;
        for (int i = 0; i < n2; ++i) {
            XSDNode xSDNode;
            XMLNode xMLNode = (XMLNode)nodeList.item(i);
            if (xMLNode.getNodeType() != 1) continue;
            XMLElement xMLElement2 = (XMLElement)xMLNode;
            String string = xMLElement2.getNodeLocalName();
            if (string == "annotation" && !bl5) {
                xSDElement.annotation = this.parseAnnotation(xMLElement2, xSDElement.annotation);
                bl5 = true;
            } else if (string == "complexType" && !bl && !bl4) {
                xSDNode = this.parseComplexType(xMLElement2);
                xSDNode.parent = xSDElement;
                xSDElement.setComplexType((XSDComplexType)xSDNode);
                bl4 = true;
            } else if (string == "simpleType" && !bl && !bl4) {
                xSDNode = this.parseSimpleType(xMLElement2);
                ((XSDSimpleType)xSDNode).parent = xSDElement;
                xSDElement.setSimpleType((XSDSimpleType)xSDNode);
                bl4 = true;
            } else if (!(bl || string != "unique" && string != "key" && string != "keyref")) {
                XSDIdentity xSDIdentity = this.parseIdentity(xMLElement2, string, xSDElement.getForm());
                xSDElement.addIdentity(xSDIdentity);
                String string4 = xSDIdentity.getExpandedName();
                if (this.idenConsTable.get(string4) != null) {
                    this.error2(xMLElement2, 24527, string, "element", false);
                } else {
                    this.idenConsTable.put(string4, xSDIdentity);
                }
                if (string == "keyref") {
                    this.keyRefs.addElement(xSDIdentity);
                }
            } else {
                this.error2(xMLElement, 24527, string, "element", false);
            }
            bl5 = true;
        }
        xSDElement.seenType = bl4;
        if (xSDElement.maxOccurs < xSDElement.minOccurs) {
            this.error2(xMLElement, 24545, "element", "max < min", false);
        }
        if (!this.redefine) {
            if (xSDElement.refState == 3) {
                xSDElement.resolveTypeReference(this.schemaxml);
            } else if (xSDElement.refState == 1) {
                xSDElement.resolveReference(this.schemaxml);
            }
        }
        if (xSDElement.refState == 1 || xSDElement.refState == 3) {
            xSDElement.domNode = xMLElement;
            this.addUnresolvedNode(xSDElement);
        } else if (!xSDElement.isValidDecl()) {
            this.error(xMLElement, 24542, xSDElement.getName(), false);
        }
        return xSDElement;
    }

    private XSDIdentity parseIdentity(XMLElement xMLElement, String string, int n) throws XSDException {
        if (xMLElement.getNamespaceURI() != this.xsdNamespace) {
            this.error(xMLElement, 24100, string, false);
        }
        XSDIdentity xSDIdentity = new XSDIdentity();
        String string2 = this.schemaDefs.getTargetNSDefault();
        if (string == "unique") {
            xSDIdentity.setNodeType(22);
        } else if (string == "key") {
            xSDIdentity.setNodeType(23);
        } else if (string == "keyref") {
            xSDIdentity.setNodeType(24);
            xSDIdentity.domNode = xMLElement;
        }
        NamedNodeMap namedNodeMap = xMLElement.getAttributes();
        int n2 = namedNodeMap.getLength();
        for (int i = 0; i < n2; ++i) {
            Object object;
            XMLAttr xMLAttr = (XMLAttr)namedNodeMap.item(i);
            String string3 = xMLAttr.getNodeLocalName();
            String string4 = xMLAttr.getValue();
            String string5 = xMLAttr.getNamespace();
            if (this.skipAttribute(string3, string5)) {
                object = (XMLAttr)xMLAttr.cloneNode(true);
                object = (XMLAttr)this.doc.importNode((Node)object, true);
                xSDIdentity.addAnnotationAttr((XMLAttr)object);
                continue;
            }
            if (string3 == "name") {
                if (n == 1 && string2 != null && string2 != "") {
                    xSDIdentity.setExpandedName(string2 + ":" + string4);
                } else {
                    xSDIdentity.setExpandedName(string4);
                }
                xSDIdentity.setName(string4);
                continue;
            }
            if (string3 == "id") {
                xSDIdentity.setID(string4);
                if (this.schemaDefs.isNewId(string4)) continue;
                this.error(xMLElement, 24544, string4, false);
                continue;
            }
            if (string3 == "refer" && string == "keyref") {
                String string6;
                object = XMLUtil.getPrefix(string4);
                if (object == null || object == "") {
                    object = "#default";
                }
                if ((string6 = xMLElement.resolveNamespacePrefix((String)object)) != null && string6 != "") {
                    string4 = string6 + ":" + XMLUtil.getLocalName(string4);
                }
                xSDIdentity.setRefer(string4);
                continue;
            }
            this.error2(xMLElement, 24526, string, "element", false);
        }
        NodeList nodeList = xMLElement.getChildNodes();
        int n3 = nodeList.getLength();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i = 0; i < n3; ++i) {
            XMLNode xMLNode = (XMLNode)nodeList.item(i);
            if (xMLNode.getNodeType() != 1) continue;
            XMLElement xMLElement2 = (XMLElement)xMLNode;
            String string7 = xMLElement2.getNodeLocalName();
            if (string7 == "annotation" && !bl) {
                xSDIdentity.annotation = this.parseAnnotation(xMLElement2, xSDIdentity.annotation);
            } else if (string7 == "selector" && !bl2) {
                xSDIdentity.setSelector(this.parseSelectorField(xMLElement2));
                bl2 = true;
            } else if (string7 == "field" && bl2) {
                bl3 = true;
                xSDIdentity.addField(this.parseSelectorField(xMLElement2));
            } else {
                this.error2(xMLElement, 24527, string7, "element", false);
            }
            bl = true;
        }
        if (!bl3) {
            this.error2(xMLElement, 24527, string, "element", false);
        }
        if (!xSDIdentity.compileExpr(xMLElement)) {
            this.error2(xMLElement, 24527, string, "element", false);
        }
        return xSDIdentity;
    }

    private String parseSelectorField(XMLElement xMLElement) throws XSDException {
        String string;
        boolean bl;
        boolean bl2 = bl = xMLElement.getLocalName() == "field";
        if (xMLElement.getNamespaceURI() != this.xsdNamespace) {
            this.error(xMLElement, 24100, xMLElement.getLocalName(), false);
        }
        NamedNodeMap namedNodeMap = xMLElement.getAttributes();
        int n = namedNodeMap.getLength();
        String string2 = null;
        for (int i = 0; i < n; ++i) {
            XMLAttr xMLAttr = (XMLAttr)namedNodeMap.item(i);
            string = xMLAttr.getNodeLocalName();
            String string3 = xMLAttr.getValue();
            String string4 = xMLAttr.getNamespace();
            if (this.skipAttribute(string, string4)) continue;
            if (string == "xpath") {
                string2 = string3.intern();
                continue;
            }
            if (string == "id") {
                if (XSDSimpleType.isNCName(string3) && this.schemaDefs.isNewId(string3)) continue;
                this.error(xMLElement, 24544, string3, false);
                continue;
            }
            this.error2(xMLElement, 24526, string, "element", false);
        }
        boolean bl3 = false;
        for (XMLNode xMLNode = (XMLNode)xMLElement.getFirstChild(); xMLNode != null; xMLNode = (XMLNode)xMLNode.getNextSibling()) {
            if (xMLNode.getNodeType() != 1) continue;
            string = ((XMLElement)xMLNode).getLocalName();
            if (string == "annotation" && !bl3) {
                bl3 = true;
                continue;
            }
            this.error2(xMLElement, 24527, string, "element", false);
        }
        string = xMLElement.getLocalName();
        if (string2 == null || string2 == "" || !this.parsePaths(string2, bl)) {
            this.error2(xMLElement, 24527, string, "element", false);
        }
        return string2;
    }

    private boolean parsePaths(String string, boolean bl) {
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            int n3 = string.indexOf(124, n);
            if (n3 < 0) {
                n3 = n2;
            }
            boolean bl2 = true;
            while (n < n3) {
                String string2;
                boolean bl3 = false;
                int n4 = string.indexOf(47, n);
                if (n4 < 0 || n4 > n3) {
                    n4 = n3;
                }
                int n5 = string.indexOf("::", n);
                while (Character.isWhitespace(string.charAt(n))) {
                    ++n;
                }
                if (n5 > n && n5 < n4) {
                    string2 = string.substring(n, n5).trim();
                    if (!(string2.equals("child") || string2.equals("attribute") && n3 == n4 && bl)) {
                        return false;
                    }
                    n = n5 + 2;
                } else if (string.charAt(n) == '@') {
                    if (n3 != n4 || !bl) {
                        return false;
                    }
                    ++n;
                } else if (string.charAt(n) == '.') {
                    ++n;
                    bl3 = true;
                }
                while (n < n4 && Character.isWhitespace(string.charAt(n))) {
                    ++n;
                }
                n5 = string.indexOf(58, n);
                if (n5 > n && n5 < n4) {
                    string2 = string.substring(n, n5);
                    if (!XSDSimpleType.isNCName(string2) || bl3) {
                        return false;
                    }
                    n = n5 + 1;
                }
                string2 = string.substring(n, n4).trim();
                if (bl3) {
                    if (!string2.equals("")) {
                        return false;
                    }
                    if (bl2 && n4 + 1 < n3 && string.charAt(n4 + 1) == '/') {
                        ++n4;
                    }
                } else if (!string2.equals("*") && !XSDSimpleType.isNCName(string2)) {
                    return false;
                }
                n = n4 + 1;
                bl2 = false;
            }
            n = n3 + 1;
        }
        return true;
    }

    private XSDComplexType parseComplexType(XMLElement xMLElement) throws XSDException {
        Object object;
        XMLElement xMLElement2;
        if (xMLElement.getNamespaceURI() != this.xsdNamespace) {
            this.error(xMLElement, 24100, "complexType", false);
        }
        XSDComplexType xSDComplexType = new XSDComplexType();
        xSDComplexType.includingNS = this.includingNS;
        xSDComplexType.domNode = xMLElement2 = xMLElement;
        BitSet bitSet = xSDComplexType.getProperties();
        bitSet.or(this.schemaDefs.getDefaults());
        boolean bl = this.isTopLevel(xMLElement2);
        if (bl) {
            xSDComplexType.targetNS = this.schemaDefs.getTargetNSDefault();
        }
        for (XMLAttr xMLAttr = (XMLAttr)xMLElement2.getFirstAttribute(); xMLAttr != null; xMLAttr = xMLAttr.getNextAttribute()) {
            String string = xMLAttr.getNodeLocalName();
            String string2 = xMLAttr.getValue();
            String string3 = xMLAttr.getNamespace();
            if (this.skipAttribute(string, string3)) {
                object = (XMLAttr)xMLAttr.cloneNode(true);
                object = (XMLAttr)this.doc.importNode((Node)object, true);
                xSDComplexType.addAnnotationAttr((XMLAttr)object);
                continue;
            }
            try {
                if (string == "name" && bl) {
                    xSDComplexType.setName(string2);
                    continue;
                }
                if (string == "abstract") {
                    xSDComplexType.setAbstract(this.getBooleanValue(string2));
                    continue;
                }
                if (string == "block") {
                    this.parseBlockValue(string2, bitSet);
                    continue;
                }
                if (string == "final") {
                    if (this.parseFinalValue(string2, bitSet, false)) continue;
                    this.error2(xMLElement2, 24523, string2, string, false);
                    continue;
                }
                if (string == "id") {
                    xSDComplexType.setID(string2);
                    if (this.schemaDefs.isNewId(string2)) continue;
                    this.error(xMLElement2, 24544, string2, false);
                    continue;
                }
                if (string == "mixed") {
                    xSDComplexType.setMixedContent(this.getBooleanValue(string2));
                    continue;
                }
                this.error2(xMLElement2, 24526, string, "complexType", false);
                continue;
            }
            catch (XSDException xSDException) {
                this.error2(xMLElement2, 24523, string2, string, false);
            }
        }
        object = xMLElement2.getChildNodes();
        int n = object.getLength();
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i = 0; i < n; ++i) {
            XMLNode xMLNode = (XMLNode)object.item(i);
            if (xMLNode.getNodeType() != 1) continue;
            XMLElement xMLElement3 = (XMLElement)xMLNode;
            String string = xMLElement3.getNodeLocalName();
            if (bl2) {
                this.error2(xMLElement3, 24527, string, "element", false);
                continue;
            }
            if (string == "annotation" && !bl3) {
                bl3 = true;
                xSDComplexType.annotation = this.parseAnnotation(xMLElement3, xSDComplexType.annotation);
                continue;
            }
            if (string == "simpleContent") {
                xMLElement2 = this.checkContent(xSDComplexType, xMLElement3);
                xSDComplexType.setSimpleContent(true);
            } else if (string == "complexContent") {
                xMLElement2 = this.checkContent(xSDComplexType, xMLElement3);
            } else {
                xSDComplexType.setBaseRef(this.xsdNamespace, "anyType");
                xSDComplexType.setBaseType(XSDComplexType.urType);
                xSDComplexType.setDerivedBy("restriction");
                break;
            }
            bl2 = true;
        }
        if (xSDComplexType.refState == 7) {
            XSDNode xSDNode = this.schemaxml.getType(xSDComplexType.refNamespace, xSDComplexType.refLocalname);
            if (xSDNode != null && (!this.redefine || xSDNode.equals(xSDComplexType))) {
                xSDComplexType.setBaseType(xSDNode);
            }
        } else {
            xSDComplexType.setBaseType(XSDComplexType.urType);
        }
        if (xSDComplexType.isSimpleContent()) {
            this.parseSimpleContent(xSDComplexType, xMLElement2);
        } else {
            this.parseComplexContent(xSDComplexType, xMLElement2);
        }
        if (!xSDComplexType.isParsed()) {
            xSDComplexType.domNode = xMLElement2;
            this.addUnresolvedNode(xSDComplexType);
        }
        return xSDComplexType;
    }

    private XMLElement checkContent(XSDComplexType xSDComplexType, XMLElement xMLElement) throws XSDException {
        String string;
        String string2;
        String string3;
        XMLAttr xMLAttr;
        if (xMLElement.getNamespaceURI() != this.xsdNamespace) {
            this.error(xMLElement, 24100, xMLElement.getLocalName(), false);
        }
        XMLElement xMLElement2 = xMLElement;
        for (xMLAttr = (XMLAttr)xMLElement2.getFirstAttribute(); xMLAttr != null; xMLAttr = xMLAttr.getNextAttribute()) {
            string3 = xMLAttr.getNodeLocalName();
            string2 = xMLAttr.getValue();
            string = xMLAttr.getNamespace();
            if (this.skipAttribute(string3, string)) continue;
            if (string3 == "mixed") {
                xSDComplexType.setMixedContent(this.getBooleanValue(string2));
                continue;
            }
            if (string3 == "id") {
                if (!this.schemaDefs.isNewId(string2)) {
                    this.error(xMLElement2, 24544, string2, false);
                }
                if (XSDSimpleType.isNCName(string2)) continue;
                this.error2(xMLElement2, 24523, string2, string3, false);
                continue;
            }
            this.error2(xMLElement2, 24526, string3, "complexType", false);
        }
        NodeList nodeList = xMLElement2.getChildNodes();
        int n = nodeList.getLength();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        XMLElement xMLElement3 = null;
        for (int i = 0; i < n; ++i) {
            XMLNode xMLNode = (XMLNode)nodeList.item(i);
            if (xMLNode.getNodeType() != 1) continue;
            XMLElement xMLElement4 = (XMLElement)xMLNode;
            String string4 = xMLElement4.getNodeLocalName();
            if (string4 == "annotation" && !bl2 && !bl) {
                xSDComplexType.annotation = this.parseAnnotation(xMLElement4, xSDComplexType.annotation);
                bl2 = true;
                continue;
            }
            if (!(string4 != "restriction" && string4 != "extension" || bl)) {
                xSDComplexType.setDerivedBy(string4);
                bl = true;
                for (xMLAttr = (XMLAttr)xMLElement4.getFirstAttribute(); xMLAttr != null; xMLAttr = xMLAttr.getNextAttribute()) {
                    string3 = xMLAttr.getNodeLocalName();
                    string2 = xMLAttr.getValue();
                    string = xMLAttr.getNamespace();
                    if (this.skipAttribute(string3, string)) continue;
                    try {
                        if (string3 == "id") {
                            if (!this.schemaDefs.isNewId(string2)) {
                                this.error(xMLElement2, 24544, string2, false);
                            }
                            if (XSDSimpleType.isNCName(string2)) continue;
                            this.error2(xMLElement2, 24523, string2, string3, false);
                            continue;
                        }
                        if (string3 == "base" && !bl3) {
                            string = this.getNamespace(xMLElement4, string2, this.includingNS);
                            String string5 = this.getLocalName(string2);
                            if (string == this.xsdNamespace && string5 == "anyType" && xSDComplexType.derivedBy != "restriction") {
                                this.error(xMLElement4, 24226, string3, false);
                            }
                            xSDComplexType.setBaseRef(string, string5);
                            bl3 = true;
                            continue;
                        }
                        this.error2(xMLElement4, 24523, string2, string3, false);
                        continue;
                    }
                    catch (XSDException xSDException) {
                        this.error2(xMLElement4, 24523, string2, string3, false);
                    }
                }
                xMLElement3 = xMLElement4;
                continue;
            }
            this.error2(xMLElement2, 24527, string4, "complexType", false);
        }
        if (!bl || !bl3) {
            this.error(xMLElement2, 24226, xMLElement2.getNodeLocalName(), false);
        }
        return xMLElement3;
    }

    private void parseSimpleContent(XSDComplexType xSDComplexType, XMLElement xMLElement) throws XSDException {
        if (xMLElement.getNamespaceURI() != this.xsdNamespace) {
            this.error(xMLElement, 24100, "element", false);
        }
        xSDComplexType.parsed = false;
        if (xSDComplexType.base == null) {
            return;
        }
        boolean bl = xSDComplexType.derivedBy == "restriction";
        XSDComplexType xSDComplexType2 = null;
        XSDSimpleType xSDSimpleType = null;
        if (xSDComplexType.base.isNodeType(2)) {
            xSDSimpleType = (XSDSimpleType)xSDComplexType.base;
        } else {
            xSDComplexType2 = (XSDComplexType)xSDComplexType.base;
        }
        if (xSDSimpleType != null) {
            if (!xSDSimpleType.isParsed()) {
                if (xSDSimpleType.isResolved()) {
                    xSDSimpleType.parseDerivation();
                }
                if (!xSDSimpleType.isParsed()) {
                    return;
                }
            }
            if (bl) {
                this.error(xMLElement, 24226, xMLElement.getNodeLocalName(), false);
                xSDComplexType.parsed = true;
                return;
            }
            if (xSDSimpleType.properties.get(3)) {
                this.error(xMLElement, 24539, "extension", false);
            }
        } else if (xSDComplexType2 != null) {
            if (!xSDComplexType2.isParsed()) {
                return;
            }
            if (bl) {
                if (xSDComplexType2.properties.get(4)) {
                    this.error(xMLElement, 24539, "restriction", false);
                }
            } else if (xSDComplexType2.properties.get(3)) {
                this.error(xMLElement, 24539, "extension", false);
            }
            if (xSDComplexType2.isSimpleContent()) {
                if (bl) {
                    xSDSimpleType = new XSDSimpleType();
                    xSDSimpleType.setDerivation("restriction");
                    xSDSimpleType.setBaseType(xSDComplexType2.simpleType);
                } else {
                    xSDSimpleType = xSDComplexType2.simpleType;
                }
            } else if (!bl || xSDComplexType2.getContent() != 13) {
                this.error(xMLElement, 24226, xSDComplexType2.getName(), false);
                return;
            }
        }
        xSDComplexType.parsed = true;
        XSDAttrGroup xSDAttrGroup = xSDComplexType.getAttrGroup();
        NodeList nodeList = xMLElement.getChildNodes();
        int n = nodeList.getLength();
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        String string = null;
        for (int i = 0; i < n; ++i) {
            XMLNode xMLNode = (XMLNode)nodeList.item(i);
            if (xMLNode.getNodeType() != 1) continue;
            XMLElement xMLElement2 = (XMLElement)xMLNode;
            String string2 = xMLElement2.getNodeLocalName();
            if (string2 == "annotation" && !bl2) {
                xSDAttrGroup.annotation = this.parseAnnotation(xMLElement2, xSDComplexType.annotation);
                bl2 = true;
            } else if (string2 == "attribute" && !bl4) {
                xSDAttrGroup.addNode(this.parseAttribute(xMLElement2));
                bl3 = true;
            } else if (string2 == "anyAttribute" && !bl4) {
                xSDAttrGroup.setWildcard(this.parseAnyAttribute(xMLElement2));
                bl3 = true;
                bl4 = true;
            } else if (string2 == "attributeGroup" && !bl4) {
                xSDAttrGroup.addNode(this.parseAttrGroup(xMLElement2));
                bl3 = true;
            } else if (string2 == "simpleType" && bl && !bl3 && !bl5) {
                xSDSimpleType = new XSDSimpleType();
                xSDSimpleType.setDerivation("restriction");
                xSDSimpleType.setBaseType(this.parseSimpleType(xMLElement2));
            } else if (this.isFacet(string2) && bl && !bl3) {
                try {
                    String string3 = xMLElement2.getAttribute("value");
                    if (string2 == "pattern") {
                        string = string == null ? string3 : string + "|" + string3;
                    } else {
                        if (xSDSimpleType == null) {
                            this.error(xMLElement, 24226, xSDComplexType.base.getName(), false);
                            return;
                        }
                        if (string2 == "enumeration") {
                            XMLElement xMLElement3 = (XMLElement)xMLElement2.getElementsByTagName("annotation").item(0);
                            XSDAnnotation xSDAnnotation = null;
                            if (xMLElement3 != null) {
                                xSDAnnotation = this.parseAnnotation(xMLElement3, null);
                            }
                            xSDSimpleType.setEnumeration(xMLElement2, xSDAnnotation);
                        } else {
                            xSDSimpleType.setFacet(string2, string3);
                        }
                    }
                    bl5 = true;
                }
                catch (Exception exception) {
                    this.error2(xMLElement, 24068, string2, "complexType", false);
                }
            } else {
                this.error2(xMLElement, 24527, string2, "complexType", false);
                return;
            }
            bl2 = true;
        }
        if (xSDSimpleType == null) {
            this.error(xMLElement, 24226, xSDComplexType.base.getName(), false);
            return;
        }
        if (string != null) {
            try {
                xSDSimpleType.setFacet("pattern", string);
            }
            catch (Exception exception) {
                this.error2(xMLElement, 24068, "pattern", "complexType", false);
            }
        }
        xSDComplexType.simpleType = xSDSimpleType;
        xSDComplexType.setContent("textOnly");
        if (xSDComplexType2 != null) {
            xSDAttrGroup.restriction = bl;
            xSDAttrGroup.base = xSDComplexType2.getAttrGroup();
        }
        xSDComplexType.domNode = null;
    }

    private void parseComplexContent(XSDComplexType xSDComplexType, XMLElement xMLElement) throws XSDException {
        Object object;
        int n;
        if (xMLElement.getNamespaceURI() != this.xsdNamespace) {
            this.error(xMLElement, 24100, "element", false);
        }
        if (xSDComplexType.base == null || !xSDComplexType.base.isParsed()) {
            xSDComplexType.parsed = false;
            return;
        }
        xSDComplexType.parsed = true;
        XSDComplexType xSDComplexType2 = null;
        if (xSDComplexType.base.isNodeType(2)) {
            this.error(xMLElement, 24226, xMLElement.getNodeLocalName(), false);
            return;
        }
        xSDComplexType2 = (XSDComplexType)xSDComplexType.base;
        if (xSDComplexType2.isSimpleContent()) {
            this.error(xMLElement, 24226, xMLElement.getNodeLocalName(), false);
            return;
        }
        if (xSDComplexType.derivedBy == "restriction") {
            if (xSDComplexType2.properties.get(4)) {
                this.error(xMLElement, 24539, "restriction", false);
            }
        } else if (xSDComplexType2.properties.get(3)) {
            this.error(xMLElement, 24539, "extension", false);
        }
        XSDAttrGroup xSDAttrGroup = xSDComplexType.getAttrGroup();
        XSDGroup xSDGroup = null;
        NodeList nodeList = xMLElement.getChildNodes();
        int n2 = nodeList.getLength();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        for (n = 0; n < n2; ++n) {
            object = (XMLNode)nodeList.item(n);
            if (((XMLNode)object).getNodeType() != 1) continue;
            XMLElement xMLElement2 = (XMLElement)object;
            String string = xMLElement2.getNodeLocalName();
            if (string == "annotation" && !bl) {
                xSDAttrGroup.annotation = this.parseAnnotation(xMLElement2, xSDComplexType.annotation);
                bl = true;
            } else if (string == "attribute" && !bl3) {
                xSDAttrGroup.addNode(this.parseAttribute(xMLElement2));
                bl4 = true;
            } else if (string == "anyAttribute" && !bl3) {
                xSDAttrGroup.setWildcard(this.parseAnyAttribute(xMLElement2));
                bl4 = true;
                bl3 = true;
            } else if (string == "attributeGroup" && !bl3) {
                xSDAttrGroup.addNode(this.parseAttrGroup(xMLElement2));
                bl4 = true;
            } else if (!bl4 && !bl2) {
                if (string == "group") {
                    xSDGroup = this.parseGroup(xMLElement2);
                } else if (string == "sequence" || string == "choice" || string == "all") {
                    xSDGroup = this.parseCompositor(xMLElement2, string);
                } else {
                    this.error2(xMLElement, 24527, string, "complexType", false);
                    continue;
                }
                bl2 = true;
            } else {
                this.error2(xMLElement, 24527, string, "complexType", false);
                return;
            }
            bl = true;
        }
        n = 0;
        if (xSDGroup == null) {
            n = 1;
        } else if (xSDGroup.length() == 0) {
            if (xSDGroup.order != 0) {
                n = 1;
            } else if (xSDGroup.getMinOccurs() == 0) {
                n = 1;
            }
        }
        if (xSDComplexType.derivedBy == "restriction") {
            if (xSDComplexType.content != 13) {
                if (n != 0) {
                    xSDComplexType.setContent("empty");
                } else {
                    xSDComplexType.setContent("elementOnly");
                }
            }
        } else if (xSDComplexType.content != 13) {
            if (n != 0 && xSDComplexType2 != null) {
                xSDComplexType.content = xSDComplexType2.content;
            } else {
                xSDComplexType.setContent("elementOnly");
            }
        }
        if (xSDComplexType2 != null && xSDComplexType2 != XSDComplexType.urType) {
            xSDAttrGroup.restriction = xSDComplexType.derivedBy == "restriction";
            xSDAttrGroup.base = xSDComplexType2.getAttrGroup();
            if (xSDComplexType.derivedBy == "extension" && xSDComplexType2.typeGroup != null) {
                if (xSDGroup == null) {
                    xSDComplexType.typeGroup = xSDComplexType2.typeGroup;
                } else {
                    xSDComplexType.initTypeGroup(0);
                    object = xSDComplexType.getTypeGroup();
                    ((XSDGroup)object).addParticleNode(xSDComplexType2.typeGroup);
                    ((XSDGroup)object).addParticleNode(xSDGroup);
                }
            }
        }
        if (xSDComplexType.typeGroup == null && xSDGroup != null) {
            xSDComplexType.setTypeGroup(xSDGroup);
        }
    }

    private XSDSimpleType parseSimpleType(XMLElement xMLElement) throws XSDException {
        XMLElement xMLElement2 = xMLElement;
        XSDSimpleType xSDSimpleType = new XSDSimpleType();
        String string = xMLElement2.getNamespace();
        String string2 = null;
        String string3 = null;
        if (string != this.xsdNamespace) {
            this.error(xMLElement2, 24100, "simpleType", false);
        }
        XSDAnnotation xSDAnnotation = null;
        boolean bl = this.isTopLevel(xMLElement2);
        if (bl) {
            xSDSimpleType.targetNS = this.schemaDefs.getTargetNSDefault();
        }
        for (XMLAttr xMLAttr = (XMLAttr)xMLElement2.getFirstAttribute(); xMLAttr != null; xMLAttr = xMLAttr.getNextAttribute()) {
            String string4 = xMLAttr.getNodeLocalName();
            String string5 = xMLAttr.getValue();
            String string6 = xMLAttr.getNamespace();
            if (this.skipAttribute(string4, string6)) {
                if (xSDAnnotation == null) {
                    xSDAnnotation = new XSDAnnotation();
                }
                XMLAttr xMLAttr2 = (XMLAttr)xMLAttr.cloneNode(true);
                xMLAttr2 = (XMLAttr)this.doc.importNode(xMLAttr2, true);
                xSDAnnotation.addAttribute(xMLAttr2);
                continue;
            }
            try {
                if (string4 == "name" && bl) {
                    xSDSimpleType.setName(string5);
                    continue;
                }
                if (string4 == "id") {
                    string2 = string5;
                    if (this.schemaDefs.isNewId(string5)) continue;
                    this.error(xMLElement2, 24544, string5, true);
                    continue;
                }
                if (string4 == "final") {
                    string3 = string5;
                    continue;
                }
                this.error2(xMLElement2, 24526, string4, "simpleType", false);
                continue;
            }
            catch (XSDException xSDException) {
                this.error2(xMLElement2, 24523, string5, string4, false);
            }
        }
        if (string3 != null) {
            if (!this.parseFinalValue(string3, xSDSimpleType.properties, true)) {
                this.error2(xMLElement2, 24523, string3, "final", false);
            }
        } else {
            xSDSimpleType.properties.or(this.schemaDefs.getDefaults());
        }
        boolean bl2 = false;
        boolean bl3 = false;
        for (XMLNode xMLNode = (XMLNode)xMLElement2.getFirstChild(); xMLNode != null; xMLNode = (XMLNode)xMLNode.getNextSibling()) {
            if (xMLNode.getNodeType() != 1) continue;
            XMLElement xMLElement3 = (XMLElement)xMLNode;
            String string7 = xMLElement3.getLocalName();
            if (bl3) {
                this.error(xMLElement3, 24534, string7, false);
                continue;
            }
            if (string7 == "annotation" && !bl2) {
                xSDSimpleType.annotation = this.parseAnnotation(xMLElement3, xSDAnnotation);
                bl2 = true;
                continue;
            }
            if (string7 == "restriction") {
                bl3 = true;
                this.parseRestriction(xMLElement3, xSDSimpleType);
                continue;
            }
            if (string7 == "list") {
                bl3 = true;
                this.parseList(xMLElement3, xSDSimpleType);
                continue;
            }
            if (string7 == "union") {
                bl3 = true;
                this.parseUnion(xMLElement3, xSDSimpleType);
                continue;
            }
            this.error(xMLElement2, 24226, string7, false);
        }
        if (!bl3) {
            this.error(xMLElement2, 24226, "missing derivation", false);
        }
        return xSDSimpleType;
    }

    private XSDSimpleType parseRestriction(XMLElement xMLElement, XSDSimpleType xSDSimpleType) throws XSDException {
        String string;
        String string2 = xMLElement.getAttribute("base");
        XSDSimpleType xSDSimpleType2 = null;
        xSDSimpleType.setDerivation("restriction");
        xSDSimpleType.resolved = true;
        boolean bl = false;
        if (string2 != null && !string2.equals("")) {
            String string3 = this.getNamespace(xMLElement, string2, this.includingNS);
            string = this.getLocalName(string2);
            xSDSimpleType2 = (XSDSimpleType)this.schemaxml.getType(string3, string, 2);
            bl = true;
            if (xSDSimpleType2 != null && (!this.redefine || xSDSimpleType2.equals(xSDSimpleType))) {
                xSDSimpleType.setBaseType(xSDSimpleType2);
                if (xSDSimpleType2.properties.get(4)) {
                    this.error(xMLElement, 24214, "restriction", false);
                }
            } else {
                xSDSimpleType.setReference(string3, string);
            }
        }
        boolean bl2 = false;
        string = null;
        boolean bl3 = false;
        for (XMLNode xMLNode = (XMLNode)xMLElement.getFirstChild(); xMLNode != null; xMLNode = (XMLNode)xMLNode.getNextSibling()) {
            block21: {
                if (xMLNode.getNodeType() != 1) continue;
                XMLElement xMLElement2 = (XMLElement)xMLNode;
                String string4 = xMLElement2.getNodeLocalName();
                String string5 = xMLElement2.getAttribute("value");
                if (string4 == "annotation" && !bl2) {
                    bl2 = true;
                    continue;
                }
                if (string4 == "simpleType" && !bl3 && !bl) {
                    bl = true;
                    xSDSimpleType2 = this.parseSimpleType(xMLElement2);
                    xSDSimpleType.setBaseType(xSDSimpleType2);
                } else if (this.isFacet(string4)) {
                    try {
                        bl3 = true;
                        if (string4 == "pattern") {
                            string = string == null ? string5 : string + "|" + string5;
                            break block21;
                        }
                        if (string4 == "enumeration") {
                            Object object;
                            Object object2;
                            if (xSDSimpleType.getBasicType() == 19) {
                                object2 = XMLUtil.getPrefix(string5);
                                object = xMLElement.resolveNamespacePrefix((String)(object2 == "" ? "#default" : object2));
                                String string6 = XMLUtil.getLocalName(string5);
                                this.schemaxml.addNotationValue(new QxName((String)object, string6, (String)object2, string5));
                            }
                            object2 = (XMLElement)xMLElement2.getElementsByTagName("annotation").item(0);
                            object = null;
                            if (object2 != null) {
                                object = this.parseAnnotation((XMLElement)object2, null);
                            }
                            xSDSimpleType.setEnumeration(xMLElement2, (XSDAnnotation)object);
                            break block21;
                        }
                        xSDSimpleType.setFacet(string4, string5);
                    }
                    catch (Exception exception) {
                        this.error2(xMLElement, 24068, string4, "simpleType", false);
                    }
                } else {
                    this.error(xMLElement, 24226, string4, false);
                }
            }
            bl2 = true;
        }
        if (!bl) {
            this.error(xMLElement, 24226, "restriction", false);
        }
        if (string != null) {
            try {
                xSDSimpleType.setFacet("pattern", string);
            }
            catch (Exception exception) {
                this.error2(xMLElement, 24068, "pattern", "simpleType", false);
            }
        }
        if (!xSDSimpleType.isResolved()) {
            this.addUnresolvedNode(xSDSimpleType);
        }
        return xSDSimpleType;
    }

    private XSDSimpleType parseList(XMLElement xMLElement, XSDSimpleType xSDSimpleType) throws XSDException {
        Object object;
        xSDSimpleType.setDerivation("list");
        boolean bl = false;
        String string = xMLElement.getAttribute("itemType");
        XSDSimpleType xSDSimpleType2 = null;
        if (string != null && !string.equals("")) {
            bl = true;
            String string2 = this.getNamespace(xMLElement, string, this.includingNS);
            xSDSimpleType2 = (XSDSimpleType)this.schemaxml.getType(string2, (String)(object = this.getLocalName(string)), 2);
            if (xSDSimpleType2 != null) {
                xSDSimpleType.setItemType(xSDSimpleType2);
            } else {
                xSDSimpleType.setReference(string2, (String)object);
            }
        }
        boolean bl2 = false;
        for (object = (XMLNode)xMLElement.getFirstChild(); object != null; object = (XMLNode)((XMLNode)object).getNextSibling()) {
            if (((XMLNode)object).getNodeType() != 1) continue;
            XMLElement xMLElement2 = (XMLElement)object;
            String string3 = xMLElement2.getNodeLocalName();
            String string4 = xMLElement2.getAttribute("value");
            if (string3 == "annotation" && !bl2) {
                bl2 = true;
                continue;
            }
            if (string3 == "simpleType" && !bl) {
                bl = true;
                xSDSimpleType2 = this.parseSimpleType(xMLElement2);
                xSDSimpleType.setItemType(xSDSimpleType2);
            } else {
                this.error(xMLElement, 24226, string3, false);
            }
            bl2 = true;
        }
        if (!bl) {
            this.error(xMLElement, 24226, "list", false);
        }
        if (!xSDSimpleType.isResolved()) {
            this.addUnresolvedNode(xSDSimpleType);
        }
        return xSDSimpleType;
    }

    private XSDSimpleType parseUnion(XMLElement xMLElement, XSDSimpleType xSDSimpleType) throws XSDException {
        Object object;
        String string = xMLElement.getAttribute("memberTypes");
        xSDSimpleType.setDerivation("union");
        XSDSimpleType xSDSimpleType2 = null;
        boolean bl = false;
        if (string != null && !string.equals("")) {
            bl = true;
            object = new StringTokenizer(string);
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string2 = ((StringTokenizer)object).nextToken();
                String string3 = this.getNamespace(xMLElement, string2, this.includingNS);
                String string4 = this.getLocalName(string2);
                xSDSimpleType2 = (XSDSimpleType)this.schemaxml.getType(string3, string4, 2);
                try {
                    if (xSDSimpleType2 != null) {
                        xSDSimpleType.addMemberType(xSDSimpleType2);
                        continue;
                    }
                    xSDSimpleType.addMemberType(new XSDNode(string3, string4));
                }
                catch (XSDException xSDException) {
                    this.error(xMLElement, 24539, "union", false);
                }
            }
        }
        boolean bl2 = false;
        for (object = (XMLNode)xMLElement.getFirstChild(); object != null; object = (XMLNode)((XMLNode)object).getNextSibling()) {
            if (((XMLNode)object).getNodeType() != 1) continue;
            XMLElement xMLElement2 = (XMLElement)object;
            String string5 = xMLElement2.getNodeLocalName();
            String string6 = xMLElement2.getAttribute("value");
            if (string5 == "annotation" && !bl2) {
                bl2 = true;
                continue;
            }
            if (string5 == "simpleType") {
                bl = true;
                xSDSimpleType2 = this.parseSimpleType(xMLElement2);
                try {
                    xSDSimpleType.addMemberType(xSDSimpleType2);
                }
                catch (XSDException xSDException) {
                    this.error(xMLElement, 24539, "union", false);
                }
            } else {
                this.error(xMLElement, 24226, string5, false);
            }
            bl2 = true;
        }
        if (!bl) {
            this.error(xMLElement, 24226, "union", false);
        }
        if (!xSDSimpleType.isResolved()) {
            this.addUnresolvedNode(xSDSimpleType);
        }
        return xSDSimpleType;
    }

    private XSDGroup parseGroup(XMLElement xMLElement) throws XSDException {
        if (xMLElement.getNamespaceURI() != this.xsdNamespace) {
            this.error(xMLElement, 24100, "group", false);
        }
        boolean bl = this.isRef(xMLElement);
        boolean bl2 = this.isTopLevel(xMLElement);
        if (bl && bl2) {
            this.error2(xMLElement, 24526, "ref", "group", false);
            return null;
        }
        XSDGroup xSDGroup = new XSDGroup();
        xSDGroup.order = 0;
        NamedNodeMap namedNodeMap = xMLElement.getAttributes();
        int n = namedNodeMap.getLength();
        for (int i = 0; i < n; ++i) {
            XMLAttr xMLAttr = (XMLAttr)namedNodeMap.item(i);
            String string = xMLAttr.getNodeLocalName();
            String string2 = xMLAttr.getValue();
            String string3 = xMLAttr.getNamespace();
            if (this.skipAttribute(string, string3)) {
                XMLAttr xMLAttr2 = (XMLAttr)xMLAttr.cloneNode(true);
                xMLAttr2 = (XMLAttr)this.doc.importNode(xMLAttr2, true);
                xSDGroup.addAnnotationAttr(xMLAttr2);
                continue;
            }
            try {
                if (string == "ref" && !bl2) {
                    xSDGroup.setRef(this.getNamespace(xMLElement, string2, this.includingNS), this.getLocalName(string2));
                    continue;
                }
                if (string == "name" && !bl && bl2) {
                    xSDGroup.setName(string2);
                    continue;
                }
                if (string == "id") {
                    xSDGroup.setID(string2);
                    if (this.schemaDefs.isNewId(string2)) continue;
                    this.error(xMLElement, 24544, string2, false);
                    continue;
                }
                if (string == "minOccurs" && !bl2) {
                    xSDGroup.setMinOccurs(this.getMinValue(string2));
                    continue;
                }
                if (string == "maxOccurs" && !bl2) {
                    xSDGroup.setMaxOccurs(this.getMaxValue(string2));
                    continue;
                }
                this.error2(xMLElement, 24526, string, "group", false);
                continue;
            }
            catch (Exception exception) {
                this.error2(xMLElement, 24523, string2, string, false);
            }
        }
        if (xSDGroup.maxOccurs < xSDGroup.minOccurs) {
            this.error2(xMLElement, 24545, "group", "max < min", false);
        }
        NodeList nodeList = xMLElement.getChildNodes();
        int n2 = nodeList.getLength();
        int n3 = 0;
        boolean bl3 = false;
        for (int i = 0; i < n2; ++i) {
            XMLNode xMLNode = (XMLNode)nodeList.item(i);
            if (xMLNode.getNodeType() != 1) continue;
            XMLElement xMLElement2 = (XMLElement)xMLNode;
            String string = xMLElement2.getNodeLocalName();
            if (string == "annotation" && !bl3) {
                xSDGroup.annotation = this.parseAnnotation(xMLElement2, xSDGroup.annotation);
                bl3 = true;
            } else if (!bl) {
                if (string == "all" && n3 == 0) {
                    xSDGroup.addParticleNode(this.parseCompositor(xMLElement2, string));
                } else if ((string == "choice" || string == "sequence") && n3 == 0) {
                    xSDGroup.addParticleNode(this.parseCompositor(xMLElement2, string));
                } else {
                    --n3;
                    this.error2(xMLElement, 24527, string, "group", false);
                }
                ++n3;
            } else {
                this.error2(xMLElement, 24527, string, "group", false);
            }
            bl3 = true;
        }
        if (bl) {
            if (!this.redefine) {
                xSDGroup.resolveReference(this.schemaxml);
            }
            if (xSDGroup.refState == 1) {
                this.addUnresolvedNode(xSDGroup);
            }
        }
        return xSDGroup;
    }

    private XSDGroup parseCompositor(XMLElement xMLElement, String string) throws XSDException {
        if (xMLElement.getNamespaceURI() != this.xsdNamespace) {
            this.error(xMLElement, 24100, string, false);
        }
        XSDGroup xSDGroup = new XSDGroup();
        xSDGroup.order = string == "sequence" ? 0 : (string == "choice" ? 1 : 2);
        NamedNodeMap namedNodeMap = xMLElement.getAttributes();
        int n = namedNodeMap.getLength();
        for (int i = 0; i < n; ++i) {
            XMLAttr xMLAttr = (XMLAttr)namedNodeMap.item(i);
            String string2 = xMLAttr.getNodeLocalName();
            String string3 = xMLAttr.getValue();
            String string4 = xMLAttr.getNamespace();
            if (this.skipAttribute(string2, string4)) {
                XMLAttr xMLAttr2 = (XMLAttr)xMLAttr.cloneNode(true);
                xMLAttr2 = (XMLAttr)this.doc.importNode(xMLAttr2, true);
                xSDGroup.addAnnotationAttr(xMLAttr2);
                continue;
            }
            try {
                if (string2 == "id") {
                    xSDGroup.setID(string3);
                    if (this.schemaDefs.isNewId(string3)) continue;
                    this.error(xMLElement, 24544, string3, false);
                    continue;
                }
                if (string2 == "minOccurs") {
                    int n2 = this.getMinValue(string3);
                    if (n2 <= 1 || xSDGroup.order != 2) {
                        xSDGroup.setMinOccurs(n2);
                        continue;
                    }
                    this.error2(xMLElement, 24523, string3, string2, false);
                    continue;
                }
                if (string2 == "maxOccurs") {
                    int n3 = this.getMaxValue(string3);
                    if (n3 == 1 || xSDGroup.order != 2) {
                        xSDGroup.setMaxOccurs(n3);
                        continue;
                    }
                    this.error(xMLElement, 24523, string2, false);
                    continue;
                }
                this.error2(xMLElement, 24526, string2, string, false);
                continue;
            }
            catch (Exception exception) {
                this.error2(xMLElement, 24523, string3, string2, false);
            }
        }
        if (xSDGroup.maxOccurs < xSDGroup.minOccurs) {
            this.error2(xMLElement, 24545, "group", "max < min", false);
        }
        NodeList nodeList = xMLElement.getChildNodes();
        int n4 = nodeList.getLength();
        boolean bl = false;
        for (int i = 0; i < n4; ++i) {
            XMLNode xMLNode = (XMLNode)nodeList.item(i);
            if (xMLNode.getNodeType() != 1) continue;
            XMLElement xMLElement2 = (XMLElement)xMLNode;
            String string5 = xMLElement2.getNodeLocalName();
            if (string5 == "annotation" && !bl) {
                xSDGroup.annotation = this.parseAnnotation(xMLElement2, xSDGroup.annotation);
                bl = true;
            } else if (string5 == "element") {
                XSDElement xSDElement = this.parseElement(xMLElement2);
                if (xSDGroup.order == 2 && xSDElement.maxOccurs > 1) {
                    this.error2(xMLElement, 24527, string5, string, false);
                }
                xSDGroup.addParticleNode(xSDElement);
            } else if (xSDGroup.order != 2) {
                if (string5 == "group") {
                    xSDGroup.addParticleNode(this.parseGroup(xMLElement2));
                } else if (string5 == "any") {
                    xSDGroup.addParticleNode(this.parseAny(xMLElement2));
                } else if (string5 == "choice" || string5 == "sequence") {
                    xSDGroup.addParticleNode(this.parseCompositor(xMLElement2, string5));
                } else {
                    this.error2(xMLElement, 24527, string5, string, false);
                }
            } else {
                this.error2(xMLElement, 24527, string5, string, false);
            }
            bl = true;
        }
        return xSDGroup;
    }

    private XSDAttrGroup parseAttrGroup(XMLElement xMLElement) throws XSDException {
        if (xMLElement.getNamespaceURI() != this.xsdNamespace) {
            this.error(xMLElement, 24100, "attributeGroup", false);
        }
        boolean bl = this.isRef(xMLElement);
        boolean bl2 = this.isTopLevel(xMLElement);
        XSDAttrGroup xSDAttrGroup = new XSDAttrGroup(6);
        NamedNodeMap namedNodeMap = xMLElement.getAttributes();
        int n = namedNodeMap.getLength();
        for (int i = 0; i < n; ++i) {
            XMLAttr xMLAttr = (XMLAttr)namedNodeMap.item(i);
            String string = xMLAttr.getNodeLocalName();
            String string2 = xMLAttr.getValue();
            String string3 = xMLAttr.getNamespace();
            if (this.skipAttribute(string, string3)) {
                XMLAttr xMLAttr2 = (XMLAttr)xMLAttr.cloneNode(true);
                xMLAttr2 = (XMLAttr)this.doc.importNode(xMLAttr2, true);
                xSDAttrGroup.addAnnotationAttr(xMLAttr2);
                continue;
            }
            if (string == "id") {
                xSDAttrGroup.setID(string2);
                if (this.schemaDefs.isNewId(string2)) continue;
                this.error(xMLElement, 24544, string2, false);
                continue;
            }
            if (string == "ref" && !bl2) {
                xSDAttrGroup.setRef(this.getNamespace(xMLElement, string2, this.includingNS), this.getLocalName(string2));
                continue;
            }
            if (string == "name" && !bl && bl2) {
                xSDAttrGroup.setName(string2);
                continue;
            }
            this.error2(xMLElement, 24526, string, "attributeGroup", false);
        }
        NodeList nodeList = xMLElement.getChildNodes();
        int n2 = nodeList.getLength();
        boolean bl3 = false;
        boolean bl4 = bl;
        for (int i = 0; i < n2; ++i) {
            XMLNode xMLNode = (XMLNode)nodeList.item(i);
            if (xMLNode.getNodeType() != 1) continue;
            XMLElement xMLElement2 = (XMLElement)xMLNode;
            String string = xMLElement2.getNodeLocalName();
            if (string == "annotation" && !bl3) {
                xSDAttrGroup.annotation = this.parseAnnotation(xMLElement2, xSDAttrGroup.annotation);
                bl3 = true;
            } else if (string == "attribute" && !bl4) {
                xSDAttrGroup.addNode(this.parseAttribute(xMLElement2));
            } else if (string == "attributeGroup" && !bl4) {
                xSDAttrGroup.addNode(this.parseAttrGroup(xMLElement2));
            } else if (string == "anyAttribute" && !bl4) {
                xSDAttrGroup.setWildcard(this.parseAnyAttribute(xMLElement2));
                bl4 = true;
            } else {
                this.error2(xMLElement, 24527, string, "attributeGroup", false);
            }
            bl3 = true;
        }
        if (bl) {
            if (!this.redefine) {
                xSDAttrGroup.resolveReference(this.schemaxml);
            }
            if (xSDAttrGroup.refState == 1) {
                xSDAttrGroup.domNode = xMLElement;
                this.addUnresolvedNode(xSDAttrGroup);
            }
        }
        return xSDAttrGroup;
    }

    private XSDAttribute parseAttribute(XMLElement xMLElement) throws XSDException {
        if (xMLElement.getNamespaceURI() != this.xsdNamespace) {
            this.error(xMLElement, 24100, "attribute", false);
        }
        boolean bl = false;
        boolean bl2 = this.isRef(xMLElement);
        boolean bl3 = this.isTopLevel(xMLElement);
        XSDAttribute xSDAttribute = new XSDAttribute();
        String string = null;
        Object var7_7 = null;
        if (!bl3 & !bl2) {
            xSDAttribute.setForm(this.schemaDefs.getAttrFormDefault());
        }
        NamedNodeMap namedNodeMap = xMLElement.getAttributes();
        int n = namedNodeMap.getLength();
        for (int i = 0; i < n; ++i) {
            XMLAttr xMLAttr = (XMLAttr)namedNodeMap.item(i);
            String string2 = xMLAttr.getNodeLocalName();
            String string3 = xMLAttr.getValue().intern();
            String string4 = xMLAttr.getNamespace();
            if (this.skipAttribute(string2, string4)) {
                XMLAttr xMLAttr2 = (XMLAttr)xMLAttr.cloneNode(true);
                xMLAttr2 = (XMLAttr)this.doc.importNode(xMLAttr2, true);
                xSDAttribute.addAnnotationAttr(xMLAttr2);
                continue;
            }
            try {
                if (string2 == "id") {
                    xSDAttribute.setID(string3);
                    if (this.schemaDefs.isNewId(string3)) continue;
                    this.error(xMLElement, 24544, string3, false);
                    continue;
                }
                if (string2 == "ref") {
                    xSDAttribute.setRef(this.getNamespace(xMLElement, string3, this.includingNS), this.getLocalName(string3));
                    continue;
                }
                if (string2 == "name" && !bl2) {
                    xSDAttribute.setName(string3);
                    continue;
                }
                if (string2 == "type" && !bl2) {
                    xSDAttribute.setTypeRef(this.getNamespace(xMLElement, string3, this.includingNS), this.getLocalName(string3));
                    bl = true;
                    continue;
                }
                if (string2 == "form" && !bl3 && !bl2) {
                    xSDAttribute.setForm(string3);
                    continue;
                }
                if (string2 == "use" && !bl3) {
                    if (string3 == "required") {
                        xSDAttribute.setMinOccurs(1);
                        continue;
                    }
                    if (string3 == "prohibited") {
                        xSDAttribute.setMaxOccurs(0);
                        continue;
                    }
                    if (string3 == "optional") {
                        xSDAttribute.setMinOccurs(0);
                        continue;
                    }
                    this.error2(xMLElement, 24523, string3, string2, false);
                    continue;
                }
                if (string2 == "default") {
                    xSDAttribute.setDefault(string3);
                    continue;
                }
                if (string2 == "fixed") {
                    xSDAttribute.setFixed(string3);
                    continue;
                }
                this.error2(xMLElement, 24526, string2, "attribute", false);
                continue;
            }
            catch (Exception exception) {
                this.error2(xMLElement, 24523, string3, string2, false);
            }
        }
        if (string != null) {
            if (var7_7 == "default") {
                xSDAttribute.setDefault(string);
            } else {
                xSDAttribute.setFixed(string);
            }
        } else if (var7_7 == "default" || var7_7 == "fixed") {
            this.error2(xMLElement, 24523, string, "value", false);
        }
        NodeList nodeList = xMLElement.getChildNodes();
        int n2 = nodeList.getLength();
        boolean bl4 = false;
        for (int i = 0; i < n2; ++i) {
            XMLNode xMLNode = (XMLNode)nodeList.item(i);
            if (xMLNode.getNodeType() != 1) continue;
            XMLElement xMLElement2 = (XMLElement)xMLNode;
            String string5 = xMLElement2.getNodeLocalName();
            if (string5 == "annotation" && !bl4) {
                xSDAttribute.annotation = this.parseAnnotation(xMLElement2, xSDAttribute.annotation);
                bl4 = true;
            } else if (string5 == "simpleType" && !bl && !bl2) {
                XSDSimpleType xSDSimpleType = this.parseSimpleType(xMLElement2);
                if (xSDSimpleType == null) {
                    XSDSimpleType xSDSimpleType2 = new XSDSimpleType();
                    xSDSimpleType2.domNode = xMLElement2;
                    xSDSimpleType2.parent = xSDAttribute;
                    this.addUnresolvedNode(xSDSimpleType2);
                } else {
                    xSDSimpleType.parent = xSDAttribute;
                    xSDAttribute.setSimpleType(xSDSimpleType);
                }
                bl = true;
            } else {
                this.error2(xMLElement, 24527, string5, "attribute", false);
            }
            bl4 = true;
        }
        if (!this.redefine) {
            if (xSDAttribute.refState == 3) {
                xSDAttribute.resolveTypeReference(this.schemaxml);
            } else if (xSDAttribute.refState == 1) {
                xSDAttribute.resolveReference(this.schemaxml);
            }
        }
        xSDAttribute.domNode = xMLElement;
        if (xSDAttribute.refState == 3 || xSDAttribute.refState == 1) {
            this.addUnresolvedNode(xSDAttribute);
        }
        return xSDAttribute;
    }

    private XSDAny parseAny(XMLElement xMLElement) throws XSDException {
        if (xMLElement.getNamespaceURI() != this.xsdNamespace) {
            this.error(xMLElement, 24100, "any", false);
        }
        XSDAny xSDAny = new XSDAny();
        NamedNodeMap namedNodeMap = xMLElement.getAttributes();
        int n = namedNodeMap.getLength();
        for (int i = 0; i < n; ++i) {
            XMLAttr xMLAttr = (XMLAttr)namedNodeMap.item(i);
            String string = xMLAttr.getNodeLocalName();
            String string2 = xMLAttr.getValue();
            String string3 = xMLAttr.getNamespace();
            if (this.skipAttribute(string, string3)) {
                XMLAttr xMLAttr2 = (XMLAttr)xMLAttr.cloneNode(true);
                xMLAttr2 = (XMLAttr)this.doc.importNode(xMLAttr, true);
                xSDAny.addAnnotationAttr(xMLAttr2);
                continue;
            }
            try {
                if (string == "id") {
                    xSDAny.setID(string2);
                    if (this.schemaDefs.isNewId(string2)) continue;
                    this.error(xMLElement, 24544, string2, false);
                    continue;
                }
                if (string == "minOccurs") {
                    xSDAny.setMinOccurs(this.getMinValue(string2));
                    continue;
                }
                if (string == "maxOccurs") {
                    xSDAny.setMaxOccurs(this.getMaxValue(string2));
                    continue;
                }
                if (string == "processContents") {
                    xSDAny.setProcessContents(string2);
                    continue;
                }
                if (string == "namespace") {
                    xSDAny.setNamespace(string2);
                    continue;
                }
                this.error2(xMLElement, 24526, string, "any", false);
                continue;
            }
            catch (Exception exception) {
                this.error2(xMLElement, 24523, string2, "any", false);
            }
        }
        if (xSDAny.maxOccurs < xSDAny.minOccurs) {
            this.error2(xMLElement, 24545, "any", "max < min", false);
        }
        NodeList nodeList = xMLElement.getChildNodes();
        int n2 = nodeList.getLength();
        boolean bl = false;
        for (int i = 0; i < n2; ++i) {
            XMLNode xMLNode = (XMLNode)nodeList.item(i);
            if (xMLNode.getNodeType() != 1) continue;
            XMLElement xMLElement2 = (XMLElement)xMLNode;
            String string = xMLElement2.getNodeLocalName();
            if (string == "annotation" && !bl) {
                xSDAny.annotation = this.parseAnnotation(xMLElement2, xSDAny.annotation);
                bl = true;
                continue;
            }
            this.error2(xMLElement, 24527, string, "any", false);
        }
        return xSDAny;
    }

    private XSDAny parseAnyAttribute(XMLElement xMLElement) throws XSDException {
        if (xMLElement.getNamespaceURI() != this.xsdNamespace) {
            this.error(xMLElement, 24100, "anyAttribute", false);
        }
        XSDAny xSDAny = new XSDAny(7);
        xSDAny.processContents = "skip";
        NamedNodeMap namedNodeMap = xMLElement.getAttributes();
        int n = namedNodeMap.getLength();
        for (int i = 0; i < n; ++i) {
            XMLAttr xMLAttr = (XMLAttr)namedNodeMap.item(i);
            String string = xMLAttr.getNodeLocalName();
            String string2 = xMLAttr.getValue();
            String string3 = xMLAttr.getNamespace();
            if (this.skipAttribute(string, string3)) {
                XMLAttr xMLAttr2 = (XMLAttr)xMLAttr.cloneNode(true);
                xMLAttr2 = (XMLAttr)this.doc.importNode(xMLAttr, true);
                xSDAny.addAnnotationAttr(xMLAttr2);
                continue;
            }
            if (string == "id") {
                xSDAny.setID(string2);
                if (this.schemaDefs.isNewId(string2)) continue;
                this.error(xMLElement, 24544, string2, false);
                continue;
            }
            if (string == "namespace") {
                xSDAny.setNamespace(string2);
                continue;
            }
            if (string == "processContents") {
                xSDAny.setProcessContents(string2);
                continue;
            }
            this.error2(xMLElement, 24526, string, "anyAttribute", false);
        }
        NodeList nodeList = xMLElement.getChildNodes();
        boolean bl = false;
        int n2 = nodeList.getLength();
        for (int i = 0; i < n2; ++i) {
            XMLNode xMLNode = (XMLNode)nodeList.item(i);
            if (xMLNode.getNodeType() != 1) continue;
            XMLElement xMLElement2 = (XMLElement)xMLNode;
            String string = xMLElement2.getNodeLocalName();
            if (string == "annotation" && !bl) {
                xSDAny.annotation = this.parseAnnotation(xMLElement2, xSDAny.annotation);
                bl = true;
                continue;
            }
            this.error2(xMLElement, 24527, xMLElement2.getNodeLocalName(), "anyAttribute", false);
        }
        return xSDAny;
    }

    private XSDNotation parseNotation(XMLElement xMLElement) throws XSDException {
        XSDNotation xSDNotation = new XSDNotation();
        if (xMLElement.getNamespaceURI() != this.xsdNamespace) {
            this.error(xMLElement, 24100, "notation", false);
        }
        NamedNodeMap namedNodeMap = xMLElement.getAttributes();
        int n = namedNodeMap.getLength();
        for (int i = 0; i < n; ++i) {
            XMLAttr xMLAttr = (XMLAttr)namedNodeMap.item(i);
            String string = xMLAttr.getNodeLocalName();
            String string2 = xMLAttr.getValue();
            String string3 = xMLAttr.getNamespace();
            if (this.skipAttribute(string, string3)) continue;
            try {
                if (string == "id") {
                    xSDNotation.setID(string2);
                    if (this.schemaDefs.isNewId(string2)) continue;
                    this.error(xMLElement, 24544, string2, false);
                    continue;
                }
                if (string == "name") {
                    xSDNotation.setName(string2);
                    continue;
                }
                if (string == "public") {
                    xSDNotation.setPublicID(string2);
                    continue;
                }
                if (string == "system") {
                    xSDNotation.setSystemID(string2);
                    continue;
                }
                this.error2(xMLElement, 24526, string, "notation", false);
                continue;
            }
            catch (XSDException xSDException) {
                this.error2(xMLElement, 24523, string2, "notation", false);
            }
        }
        if (xSDNotation.name == null) {
            this.error(xMLElement, 24282, "", false);
            return null;
        }
        NodeList nodeList = xMLElement.getChildNodes();
        int n2 = nodeList.getLength();
        boolean bl = false;
        for (int i = 0; i < n2; ++i) {
            XMLNode xMLNode = (XMLNode)nodeList.item(i);
            if (xMLNode.getNodeType() != 1) continue;
            XMLElement xMLElement2 = (XMLElement)xMLNode;
            String string = xMLElement2.getNodeLocalName();
            if (string == "annotation" && !bl) {
                xSDNotation.annotation = this.parseAnnotation(xMLElement2, xSDNotation.annotation);
                bl = true;
                continue;
            }
            this.error2(xMLElement, 24527, string, "notation", false);
        }
        return xSDNotation;
    }

    private XSDAnnotation parseAnnotation(XMLElement xMLElement, XSDAnnotation xSDAnnotation) throws XSDException {
        if (xMLElement.getNamespaceURI() != this.xsdNamespace) {
            this.error(xMLElement, 24100, "annotation", false);
        }
        if (xSDAnnotation == null) {
            xSDAnnotation = new XSDAnnotation();
        }
        NamedNodeMap namedNodeMap = xMLElement.getAttributes();
        int n = namedNodeMap.getLength();
        for (int i = 0; i < n; ++i) {
            XMLAttr xMLAttr = (XMLAttr)namedNodeMap.item(i);
            String string = xMLAttr.getLocalName();
            String string2 = xMLAttr.getValue();
            String string3 = xMLAttr.getNamespace();
            if (this.skipAttribute(string, string3)) {
                XMLAttr xMLAttr2 = (XMLAttr)xMLAttr.cloneNode(true);
                xMLAttr2 = (XMLAttr)this.doc.importNode(xMLAttr2, true);
                xSDAnnotation.addAttribute(xMLAttr2);
                continue;
            }
            try {
                if (string == "id") {
                    if (this.schemaDefs.isNewId(string2)) continue;
                    this.error(xMLElement, 24544, string2, false);
                    continue;
                }
                this.error2(xMLElement, 24526, string, "notation", false);
                continue;
            }
            catch (XSDException xSDException) {
                this.error2(xMLElement, 24523, string2, "notation", false);
            }
        }
        NodeList nodeList = xMLElement.getChildNodes();
        int n2 = nodeList.getLength();
        for (int i = 0; i < n2; ++i) {
            XMLNode xMLNode = (XMLNode)nodeList.item(i);
            if (xMLNode.getNodeType() != 1) continue;
            XMLElement xMLElement2 = (XMLElement)this.doc.importNode(xMLNode, true);
            String string = xMLElement2.getLocalName();
            if (string == "documentation") {
                xSDAnnotation.addUserInfo(xMLElement2);
                continue;
            }
            if (string == "appinfo") {
                xSDAnnotation.addAppInfo(xMLElement2);
                continue;
            }
            this.error2(xMLElement, 24527, string, "annotation", false);
        }
        return xSDAnnotation;
    }

    private int getMinValue(String string) throws Exception {
        int n = Integer.parseInt(string);
        if (n < 0) {
            throw new XSDException();
        }
        return n;
    }

    private int getMaxValue(String string) throws Exception {
        if (string.equals("unbounded")) {
            return 0x7FFFFFF8;
        }
        return Integer.parseInt(string);
    }

    private boolean getBooleanValue(String string) throws XSDException {
        String string2 = string.intern();
        if (string2 == "false" || string2 == "0") {
            return false;
        }
        if (string2 == "true" || string2 == "1") {
            return true;
        }
        throw new XSDException();
    }

    private boolean isTopLevel(XMLElement xMLElement) {
        XMLElement xMLElement2 = (XMLElement)xMLElement.getParentNode();
        String string = xMLElement2.getNodeLocalName();
        return (string == "schema" || string == "redefine") && xMLElement2.getNamespace() == this.xsdNamespace;
    }

    private boolean isRef(XMLElement xMLElement) {
        XMLAttr xMLAttr = (XMLAttr)xMLElement.getAttributeNode("ref");
        return xMLAttr != null;
    }

    boolean skipAttribute(String string, String string2) {
        return !string2.equals("") || string2.equals("") && string.equals("xmlns");
    }

    void resolveKeyRefs() throws XSDException {
        for (int i = this.keyRefs.size() - 1; i >= 0; --i) {
            XSDIdentity xSDIdentity = (XSDIdentity)this.keyRefs.elementAt(i);
            String string = xSDIdentity.getRefer();
            XSDIdentity xSDIdentity2 = (XSDIdentity)this.idenConsTable.get(string);
            if (xSDIdentity2 == null || xSDIdentity2.getNodeType() == 24 || xSDIdentity.nfields != xSDIdentity2.nfields) {
                this.error2(xSDIdentity.domNode, 24527, "keyref", "element", false);
            }
            xSDIdentity.domNode = null;
        }
        this.keyRefs.clear();
        this.idenConsTable.clear();
    }

    void resolveNodes() throws XSDException {
        int n = 0;
        boolean bl = false;
        int n2 = this.unresolvedNodes.size();
        String string = null;
        while (n2 > 0) {
            XSDNode xSDNode = (XSDNode)this.unresolvedNodes.elementAt(n);
            switch (xSDNode.nodeType) {
                case 3: {
                    XSDElement xSDElement = (XSDElement)xSDNode;
                    string = xSDElement.refNamespace + ":" + xSDElement.refLocalname;
                    if (xSDElement.refState == 1) {
                        xSDElement.resolveReference(this.schemaxml);
                    } else if (xSDElement.refState == 3) {
                        xSDElement.resolveTypeReference(this.schemaxml);
                    }
                    if (xSDElement.refState == 0 || xSDElement.refState == 2) {
                        if (!xSDElement.isValidDecl()) {
                            this.error(xSDElement.domNode, 24542, xSDElement.getName(), false);
                        }
                        this.unresolvedNodes.removeElementAt(n);
                        bl = true;
                        --n2;
                        break;
                    }
                    ++n;
                    break;
                }
                case 4: {
                    XSDAttribute xSDAttribute = (XSDAttribute)xSDNode;
                    string = xSDAttribute.refNamespace + ":" + xSDAttribute.refLocalname;
                    if (xSDAttribute.refState == 1) {
                        xSDAttribute.resolveReference(this.schemaxml);
                    } else if (xSDAttribute.refState == 3) {
                        xSDAttribute.resolveTypeReference(this.schemaxml);
                    }
                    if (xSDAttribute.refState == 0 || xSDAttribute.refState == 2) {
                        this.unresolvedNodes.removeElementAt(n);
                        bl = true;
                        --n2;
                        break;
                    }
                    ++n;
                    break;
                }
                case 5: {
                    XSDGroup xSDGroup = (XSDGroup)xSDNode;
                    string = xSDGroup.refNamespace + ":" + xSDGroup.refLocalname;
                    if (xSDGroup.refState == 1) {
                        xSDGroup.resolveReference(this.schemaxml);
                    }
                    if (xSDGroup.refState == 0) {
                        this.unresolvedNodes.removeElementAt(n);
                        bl = true;
                        --n2;
                        break;
                    }
                    ++n;
                    break;
                }
                case 6: {
                    XSDAttrGroup xSDAttrGroup = (XSDAttrGroup)xSDNode;
                    string = xSDAttrGroup.refNamespace + ":" + xSDAttrGroup.refLocalname;
                    if (xSDAttrGroup.refState == 1) {
                        xSDAttrGroup.resolveReference(this.schemaxml);
                    }
                    if (xSDAttrGroup.refState == 0) {
                        this.unresolvedNodes.removeElementAt(n);
                        bl = true;
                        --n2;
                        break;
                    }
                    ++n;
                    break;
                }
                case 2: {
                    XSDSimpleType xSDSimpleType = (XSDSimpleType)xSDNode;
                    XSDSimpleType xSDSimpleType2 = xSDSimpleType.resolveReference(this.schemaxml);
                    if (xSDSimpleType2 != null && xSDSimpleType2.properties.get(4) && xSDSimpleType.derivedBy == "restriction") {
                        this.error(xSDSimpleType.domNode, 24539, "restriction", false);
                    }
                    if (xSDSimpleType.isResolved()) {
                        this.unresolvedNodes.removeElementAt(n);
                        bl = true;
                        --n2;
                        break;
                    }
                    ++n;
                    break;
                }
                case 1: {
                    XSDNode xSDNode2;
                    XSDComplexType xSDComplexType = (XSDComplexType)xSDNode;
                    string = xSDComplexType.refNamespace + ":" + xSDComplexType.refLocalname;
                    this.includingNS = xSDComplexType.includingNS;
                    if (xSDComplexType.refState != 6 && (xSDNode2 = this.schemaxml.getType(xSDComplexType.refNamespace, xSDComplexType.refLocalname)) != null) {
                        xSDComplexType.setBaseType(xSDNode2);
                    }
                    if (xSDComplexType.isSimpleContent()) {
                        this.parseSimpleContent(xSDComplexType, xSDComplexType.domNode);
                    } else {
                        this.parseComplexContent(xSDComplexType, xSDComplexType.domNode);
                    }
                    if (xSDComplexType.isParsed()) {
                        bl = true;
                        --n2;
                        this.unresolvedNodes.removeElementAt(n);
                        break;
                    }
                    ++n;
                }
            }
            if (n != n2) continue;
            if (!bl && n2 == this.unresolvedNodes.size()) {
                if (this.unresolvedNodes.size() <= 0) break;
                this.error(xSDNode.domNode, 24528, string, false);
                break;
            }
            bl = false;
            n = 0;
            n2 = this.unresolvedNodes.size();
        }
    }

    void addUnresolvedNode(XSDNode xSDNode) {
        this.unresolvedNodes.addElement(xSDNode);
    }

    void error(XMLElement xMLElement, int n, String string, boolean bl) throws XSDException {
        if (string == null || string.length() < 1) {
            string = " ";
        }
        this.sendError(xMLElement, n, this.err.getMessage1(n, string), bl);
    }

    void error2(XMLElement xMLElement, int n, String string, String string2, boolean bl) throws XSDException {
        if (string == null || string.length() < 1) {
            string = " ";
        }
        this.sendError(xMLElement, n, this.err.getMessage2(n, string, string2), bl);
    }

    private void sendError(XMLElement xMLElement, int n, String string, boolean bl) throws XSDException {
        this.domLocator.setCurrentNode(xMLElement);
        this.err.error(n, 1, string);
        if (bl) {
            throw new XSDException();
        }
    }

    String getNamespace(XMLElement xMLElement, String string, String string2) throws XSDException {
        String string3;
        String string4 = "#default";
        int n = string.length();
        int n2 = string.indexOf(58);
        if (n2 > 0) {
            string4 = string.substring(0, n2);
        }
        if ((string3 = xMLElement.resolveNamespacePrefix(string4)) == null || string3 == "") {
            if (string4 == "#default") {
                string3 = string2;
            } else {
                this.error(xMLElement, 24520, string, false);
                string3 = "";
            }
        }
        return string3;
    }

    String getLocalName(String string) {
        int n = string.length();
        int n2 = string.indexOf(58);
        if (n2 < 0) {
            return string;
        }
        return string.substring(n2 + 1, n);
    }

    private void parseBlockValue(String string, BitSet bitSet) throws XSDException {
        bitSet.clear(0);
        bitSet.clear(1);
        bitSet.clear(2);
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        boolean bl = false;
        boolean bl2 = false;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("substitution") && !bl) {
                bl2 = true;
                bitSet.set(0);
                continue;
            }
            if (string2.equals("extension") && !bl) {
                bl2 = true;
                bitSet.set(1);
                continue;
            }
            if (string2.equals("restriction") && !bl) {
                bl2 = true;
                bitSet.set(2);
                continue;
            }
            if (string2.equals("#all") && !bl && !bl2) {
                bl = true;
                bitSet.or(XSDComplexType.BlockAll);
                continue;
            }
            throw new XSDException();
        }
    }

    private boolean parseFinalValue(String string, BitSet bitSet, boolean bl) throws XSDException {
        bitSet.clear(3);
        bitSet.clear(4);
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("extension") && !bl) {
                bitSet.set(3);
                continue;
            }
            if (string2.equals("restriction")) {
                bitSet.set(4);
                continue;
            }
            if (string2.equals("list") && bl) {
                bitSet.set(5);
                continue;
            }
            if (string2.equals("union") && bl) {
                bitSet.set(6);
                continue;
            }
            if (string2.equals("#all")) {
                bitSet.or(XSDComplexType.FinalAll);
                continue;
            }
            return false;
        }
        return true;
    }

    private boolean isFacet(String string) {
        try {
            return XSDSimpleType.getFacetId(string) >= 0;
        }
        catch (XSDException xSDException) {
            return false;
        }
    }
}

