/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import oracle.xml.parser.schema.XSDValidator;
import oracle.xml.parser.v2.AttrDecl;
import oracle.xml.parser.v2.ContentModel;
import oracle.xml.parser.v2.DTD;
import oracle.xml.parser.v2.DocumentBuilder;
import oracle.xml.parser.v2.ElementDecl;
import oracle.xml.parser.v2.ParserState;
import oracle.xml.parser.v2.SAXAttrList;
import oracle.xml.parser.v2.XMLConstants;
import oracle.xml.parser.v2.XMLEntity;
import oracle.xml.parser.v2.XMLError;
import oracle.xml.parser.v2.XMLExternalReader;
import oracle.xml.parser.v2.XMLMultiHandler;
import oracle.xml.parser.v2.XMLNotation;
import oracle.xml.parser.v2.XMLParseException;
import oracle.xml.parser.v2.XMLParser;
import oracle.xml.parser.v2.XMLReader;
import oracle.xml.parser.v2.XMLUtil;
import oracle.xml.util.QxNameHash;
import org.w3c.dom.NamedNodeMap;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;

class NonValidatingParser
implements XMLConstants {
    String[] parseAttrParts = new String[2];
    boolean namespaceFeature = false;
    boolean namespacePrefixFeature = true;
    boolean stringInternFeature = true;
    boolean parsing;
    EntityResolver entResolver;
    DTDHandler dtdHandler;
    LexicalHandler lexHandler;
    DeclHandler declHandler;
    ContentHandler cntHandler;
    XMLError err;
    XMLReader reader;
    URL baseURL;
    DTD dtd;
    int externalDTD;
    boolean doctypePresent = false;
    boolean fixedDTD;
    boolean standalone = false;
    boolean expanderef = true;
    boolean charChunks = false;
    ParserState currentState;
    ParserState[] parserStates;
    int stateIndex;
    int maxIndex;
    int stateSize = 16;
    Boolean entResolution = null;
    int[] charLimits = new int[2];
    int valMode = 0;
    int preserveWS = -1;
    HashMap attrHash;
    static final int WS_UNINIT = -1;
    static final int WS_TRUE = 0;
    static final int WS_FALSE = 1;

    public NonValidatingParser() {
        this.parserStates = new ParserState[this.stateSize];
        this.stateIndex = -1;
        this.maxIndex = -1;
        this.dtd = new DTD();
    }

    public NonValidatingParser(NonValidatingParser nonValidatingParser) {
        this.reader = nonValidatingParser.reader;
        this.baseURL = nonValidatingParser.baseURL;
        this.entResolver = nonValidatingParser.entResolver;
        this.entResolution = nonValidatingParser.entResolution;
        this.dtdHandler = nonValidatingParser.dtdHandler;
        this.lexHandler = nonValidatingParser.lexHandler;
        this.declHandler = nonValidatingParser.declHandler;
        this.cntHandler = nonValidatingParser.cntHandler;
        this.parserStates = nonValidatingParser.parserStates;
        this.currentState = nonValidatingParser.currentState;
        this.stateSize = nonValidatingParser.stateSize;
        this.stateIndex = nonValidatingParser.stateIndex;
        this.maxIndex = nonValidatingParser.maxIndex;
        this.dtd = nonValidatingParser.dtd;
        this.err = nonValidatingParser.err;
        this.fixedDTD = nonValidatingParser.fixedDTD;
        this.standalone = nonValidatingParser.standalone;
        this.preserveWS = nonValidatingParser.preserveWS;
        this.doctypePresent = nonValidatingParser.doctypePresent;
        this.valMode = nonValidatingParser.valMode;
        this.expanderef = nonValidatingParser.expanderef;
        nonValidatingParser = null;
    }

    void init() throws SAXException, IOException {
        this.doctypePresent = false;
        if (this.reader != null) {
            this.reader.close();
        }
        if (!this.fixedDTD) {
            this.dtd = new DTD();
        } else {
            this.doctypePresent = true;
        }
        this.attrHash = new HashMap(20);
        this.externalDTD = 0;
        this.stateIndex = -1;
        this.err.reset();
    }

    void reset() {
        this.reader = null;
        if (!this.fixedDTD) {
            this.dtd = null;
        }
        for (int i = 0; i < this.stateSize; ++i) {
            if (this.parserStates[i] == null) continue;
            this.parserStates[i].reset(null, null, null, null);
        }
        this.externalDTD = 0;
        this.currentState = null;
        this.stateIndex = -1;
    }

    final void parseDTD(String string) throws SAXException, IOException {
        this.dtd.setRootTag(string);
        this.dtd.xdkSetPublicId(this.reader.getPublicId());
        this.dtd.xdkSetSystemId(this.reader.getSystemId());
        this.reader.setLexicalHandler(this.lexHandler);
        this.reader = this.reader.getExternalReader();
        this.err.setLocator(this.reader);
        ++this.externalDTD;
        this.lexHandler.startDTD(string, this.dtd.getPublicId(), this.dtd.getSystemId());
        this.parseMarkupDecl();
        this.lexHandler.endDTD();
        --this.externalDTD;
        if (!this.reader.isEOF()) {
            this.err.error1(100, 0, "EOF");
        }
        this.err.flushErrors1();
    }

    void parseDocument() throws XMLParseException, SAXException, IOException {
        this.reader.setLexicalHandler(this.lexHandler);
        this.cntHandler.setDocumentLocator(this.reader);
        try {
            this.cntHandler.startDocument();
            if (this.cntHandler instanceof XSDValidator) {
                XSDValidator xSDValidator = (XSDValidator)this.cntHandler;
                try {
                    xSDValidator.setXMLProperty("baseURL", this.getBaseURL());
                }
                catch (MalformedURLException malformedURLException) {}
            }
        }
        catch (SAXException sAXException) {
            this.err.setException(sAXException);
            this.err.error0(180, 1);
            this.err.flushErrors1();
        }
        this.parsing = true;
        this.parseProlog();
        this.parseRootElement();
        this.parseMisc();
        this.parsing = false;
        if (!this.reader.isEOF()) {
            this.err.error1(100, 0, "EOF");
        }
        this.checkNames(this.err);
        if (this.err.getFirstError() == -1) {
            this.cntHandler.endDocument();
        }
        this.err.flushErrors1();
    }

    void parseProlog() throws XMLParseException, SAXException, IOException {
        this.parseMisc();
        this.parseDoctypeDecl();
        this.parseMisc();
    }

    void parseRootElement() throws XMLParseException, SAXException, IOException {
        if (this.reader.tryRead(60)) {
            this.parseElement();
        } else {
            this.err.error0(108, 0);
            this.err.flushErrors1();
        }
    }

    void parseMisc() throws XMLParseException, SAXException, IOException {
        while (true) {
            this.reader.skipWhiteSpace();
            if (this.reader.tryRead(XMLConstants.cPISTART, 0, XMLConstants.cPISTART.length)) {
                this.parsePI();
                continue;
            }
            if (!this.reader.tryRead(XMLConstants.cCOMMENTSTART, 0, XMLConstants.cCOMMENTSTART.length)) break;
            this.parseComment();
        }
    }

    void parsePI() throws XMLParseException, SAXException, IOException {
        boolean bl = false;
        String string = this.reader.scanQName();
        if (string.toLowerCase().equals("xml")) {
            this.err.error0(109, 0);
            bl = true;
        }
        boolean bl2 = this.reader.skipWhiteSpace();
        String string2 = this.reader.scanPI();
        if (!bl2 && string2.length() != 0) {
            this.err.error0(190, 0);
        }
        if (!bl) {
            this.cntHandler.processingInstruction(string, string2);
        }
    }

    void parseComment() throws XMLParseException, SAXException, IOException {
        char[] cArray = this.reader.scanComment(this.charLimits);
        if (this.charLimits[1] != 0) {
            this.lexHandler.comment(cArray, this.charLimits[0], this.charLimits[1]);
        }
    }

    void parseDoctypeDecl() throws XMLParseException, SAXException, IOException {
        if (!this.reader.tryRead(XMLConstants.cDECLSTART, 0, XMLConstants.cDECLSTART.length)) {
            return;
        }
        if (!this.reader.tryRead(XMLConstants.cDOCTYPE, 0, XMLConstants.cDOCTYPE.length)) {
            this.err.error1(100, 0, "DOCTYPE");
            this.err.flushErrors1();
        }
        this.doctypePresent = true;
        this.reader.requireWhiteSpace();
        String string = null;
        String string2 = null;
        String string3 = this.reader.scanQName();
        if (this.reader.skipWhiteSpace()) {
            if (this.reader.tryRead(XMLConstants.cPUBLIC, 0, XMLConstants.cPUBLIC.length)) {
                this.reader.requireWhiteSpace();
                string2 = this.reader.scanPubIdLiteral();
                this.reader.requireWhiteSpace();
                string = this.reader.scanQuotedString();
                this.reader.skipWhiteSpace();
            } else if (this.reader.tryRead(XMLConstants.cSYSTEM, 0, XMLConstants.cSYSTEM.length)) {
                this.reader.requireWhiteSpace();
                string = this.reader.scanQuotedString();
                this.reader.skipWhiteSpace();
            }
        }
        this.lexHandler.startDTD(string3, string2, string);
        if (this.reader.tryRead(91)) {
            this.dtd.setNodeFlag(65536);
            this.parseMarkupDecl();
        }
        this.reader.skipWhiteSpace();
        if (!this.reader.tryRead(62)) {
            this.err.error0(191, 0);
        }
        if (string != null && !this.fixedDTD) {
            try {
                if (!this.standalone) {
                    URL uRL = new URL(this.getBaseURL(), string);
                    string = uRL.toString();
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            if (!(this.standalone || this.reader.isStandalone() && this.reader.valMode == 0)) {
                if (!this.pushExternalDTD(string, string2)) {
                    return;
                }
                this.reader = this.reader.getExternalReader();
                this.err.setLocator(this.reader);
                ++this.externalDTD;
                this.parseMarkupDecl();
                if (!this.reader.isEOF()) {
                    this.err.error0(192, 0);
                }
                --this.externalDTD;
                this.reader = this.reader.getInternalReader();
                this.err.setLocator(this.reader);
            }
        }
        if (!this.fixedDTD) {
            this.dtd.setRootTag(string3);
            this.dtd.xdkSetSystemId(string);
            this.dtd.xdkSetPublicId(string2);
        }
        this.lexHandler.endDTD();
    }

    URL getBaseURL() throws MalformedURLException {
        if (this.reader.isTopLevelReader() && this.baseURL != null) {
            return this.baseURL;
        }
        return new URL(this.reader.getSystemId());
    }

    boolean pushExternalDTD(String string, String string2) throws SAXException, IOException {
        InputSource inputSource = this.entResolver.resolveEntity(string2, string);
        if (inputSource != null) {
            Reader reader = inputSource.getCharacterStream();
            if (reader != null) {
                this.reader.pushXMLReader(reader, inputSource.getSystemId(), inputSource.getPublicId());
            } else {
                InputStream inputStream = inputSource.getByteStream();
                if (inputStream != null) {
                    String string3 = inputSource.getEncoding();
                    if (string3 == null) {
                        this.reader.pushXMLReader(inputStream, inputSource.getSystemId(), inputSource.getPublicId());
                    } else {
                        this.reader.pushXMLReader(new InputStreamReader(inputStream, string3), inputSource.getSystemId(), inputSource.getPublicId());
                    }
                } else {
                    string = inputSource.getSystemId();
                    if (string != null) {
                        try {
                            this.reader.pushXMLReader(new URL(string), string, inputSource.getPublicId());
                        }
                        catch (MalformedURLException malformedURLException) {
                            this.err.setException(malformedURLException);
                            this.err.error1(112, 0, string);
                            this.err.flushErrors1();
                        }
                    } else {
                        this.err.error1(113, 0, string);
                        this.err.flushErrors1();
                    }
                }
            }
        } else {
            try {
                this.reader.pushXMLReader(new URL(string), string, string2);
            }
            catch (MalformedURLException malformedURLException) {
                this.err.setException(malformedURLException);
                this.err.error1(112, 0, string);
                this.err.flushErrors1();
                return false;
            }
        }
        return true;
    }

    void parseMarkupDecl() throws XMLParseException, SAXException, IOException {
        this.reader.skipWhiteSpace();
        while (!this.reader.isEOF()) {
            Object object;
            while (this.externalDTD == 0 && this.reader.tryRead(37)) {
                boolean bl;
                object = this.reader.getEntity(true);
                if (object == null) {
                    this.reader.skipWhiteSpace();
                    continue;
                }
                boolean bl2 = bl = this.entResolution == null ? XMLParser.extValue : this.entResolution;
                if (!this.reader.pushEntityRef((XMLEntity)object, bl, false)) {
                    this.reader.skipWhiteSpace();
                    continue;
                }
                if (((XMLEntity)object).isExternalEntity()) {
                    this.reader = this.reader.getExternalReader();
                    this.err.setLocator(this.reader);
                    ++this.externalDTD;
                }
                this.parseMarkupDecl();
                if (((XMLEntity)object).isExternalEntity()) {
                    --this.externalDTD;
                    this.reader = this.reader.getInternalReader();
                    this.err.setLocator(this.reader);
                } else {
                    this.reader.popXMLReader();
                }
                this.reader.skipWhiteSpace();
            }
            this.reader.skipWhiteSpace();
            if (this.reader.setMarkupDepth(XMLConstants.cDECLSTART, 0, XMLConstants.cDECLSTART.length)) {
                if (this.reader.tryRead(XMLConstants.cELEMENT, 0, XMLConstants.cELEMENT.length)) {
                    this.parseElementDecl();
                } else if (this.reader.tryRead(XMLConstants.cATTLIST, 0, XMLConstants.cATTLIST.length)) {
                    this.parseAttlistDecl();
                } else if (this.reader.tryRead(XMLConstants.cENTITY, 0, XMLConstants.cENTITY.length)) {
                    this.parseEntityDecl();
                } else if (this.reader.tryRead(XMLConstants.cNOTATION, 0, XMLConstants.cNOTATION.length)) {
                    this.parseNotationDecl();
                } else if (this.reader.tryRead(XMLConstants.cCOMMENTSTART, 2, XMLConstants.cCOMMENTSTART.length - 2)) {
                    this.parseComment();
                } else if (this.externalDTD > 0 && this.reader.checkMarkupDepth(91)) {
                    this.reader.skipWhiteSpace();
                    if (this.reader.tryRead(XMLConstants.cINCLUDE, 0, XMLConstants.cINCLUDE.length)) {
                        this.reader.skipWhiteSpace();
                        if (!this.reader.checkMarkupDepth(91)) {
                            this.err.error0(114, 0);
                        }
                        object = ((XMLExternalReader)this.reader).markupDepth;
                        this.parseMarkupDecl();
                        ((XMLExternalReader)this.reader).markupDepth = object;
                        if (!this.reader.checkMarkupDepth(XMLConstants.cCDATAEND, 1, XMLConstants.cCDATAEND.length - 1)) {
                            this.err.error0(115, 0);
                        }
                    } else if (this.reader.tryRead(XMLConstants.cIGNORE, 0, XMLConstants.cIGNORE.length)) {
                        this.reader.skipIgnoreSection();
                        this.reader.skipWhiteSpace();
                    } else {
                        this.err.error2(101, 0, "IGNORE", "INCLUDE");
                        this.reader.skipIgnoreSection();
                        this.reader.skipWhiteSpace();
                    }
                }
            } else if (this.reader.setMarkupDepth(XMLConstants.cPISTART, 0, XMLConstants.cPISTART.length)) {
                this.parsePI();
            } else {
                if (this.reader.tryRead(93)) {
                    return;
                }
                this.reader.skipWhiteSpace();
                if (this.reader.isEOF()) {
                    return;
                }
                this.err.error0(192, 0);
                this.err.flushErrors();
            }
            this.reader.skipWhiteSpace();
        }
    }

    void parseElementDecl() throws XMLParseException, SAXException, IOException {
        this.reader.requireWhiteSpace();
        String string = this.reader.scanQName();
        ElementDecl elementDecl = this.dtd.findElementDecl(string);
        if (elementDecl != null && elementDecl.isNodeFlag(65536)) {
            int n = this.reader.valMode == 2 ? 1 : 2;
            this.err.error1(131, n, string);
        }
        if (elementDecl == null) {
            elementDecl = this.dtd.createElementDecl(string);
            this.dtd.addElementDecl(elementDecl);
        } else {
            elementDecl.setNodeFlag(65536);
        }
        if (this.externalDTD > 0) {
            elementDecl.setNodeFlag(128);
        }
        this.reader.requireWhiteSpace();
        this.parseContentModel(elementDecl.xdkGetContentModel());
        this.declHandler.elementDecl(string, elementDecl.xdkGetContentModel().getStringValue());
        this.reader.skipWhiteSpace();
        if (!this.reader.checkMarkupDepth(62)) {
            this.err.error1(100, 0, ">");
        }
    }

    void parseContentModel(ContentModel contentModel) throws XMLParseException, SAXException, IOException {
        if (this.reader.tryRead(XMLConstants.cEMPTY, 0, XMLConstants.cEMPTY.length)) {
            contentModel.type = 1;
        } else if (this.reader.tryRead(XMLConstants.cANY, 0, XMLConstants.cANY.length)) {
            contentModel.type = (byte)2;
        } else if (this.reader.tryRead(40)) {
            this.reader.push(40);
            contentModel.parseContentModel(this.err, this.reader);
        } else {
            this.err.error3(102, 0, "EMPTY", "ANY", "(");
            this.err.flushErrors1();
        }
    }

    ElementDecl parseAttlistDecl() throws XMLParseException, SAXException, IOException {
        ElementDecl elementDecl = null;
        this.reader.requireWhiteSpace();
        String string = this.reader.scanQName();
        elementDecl = this.dtd.findElementDecl(string);
        if (elementDecl == null) {
            elementDecl = this.dtd.createElementDecl(string, (byte)2);
            elementDecl.resetNodeFlag(65536);
            this.dtd.addElementDecl(elementDecl);
            if (this.externalDTD > 0) {
                elementDecl.setNodeFlag(128);
            }
        }
        boolean bl = this.reader.skipWhiteSpace();
        while (!this.reader.checkMarkupDepth(62)) {
            AttrDecl attrDecl;
            String string2;
            int n;
            if (!bl) {
                this.err.error0(190, 0);
            }
            if ((n = elementDecl.getAttrDeclIndex(string2 = (attrDecl = this.parseAttrDecl(elementDecl)).getNodeName())) != -1) {
                this.err.error1(135, 2, string2);
                if (this.fixedDTD) {
                    elementDecl.removeAttrDeclAt(n);
                    elementDecl.addAttrDecl(attrDecl);
                }
            } else {
                if (this.externalDTD > 0) {
                    attrDecl.setNodeFlag(128);
                }
                elementDecl.addAttrDecl(attrDecl);
                this.declHandler.attributeDecl(string, string2, AttrDecl.attrDeclTypes[attrDecl.atttype], AttrDecl.attrDeclPresence[attrDecl.attpres], attrDecl.getDefaultValue());
            }
            bl = this.reader.skipWhiteSpace();
        }
        return elementDecl;
    }

    AttrDecl parseAttrDecl(ElementDecl elementDecl) throws XMLParseException, SAXException, IOException {
        String string;
        AttrDecl attrDecl = null;
        boolean bl = false;
        String string2 = this.reader.scanQName();
        attrDecl = (AttrDecl)elementDecl.getDocument().createNodeFromType((short)14);
        attrDecl.xdkSetQxName(QxNameHash.create("", string2, "", string2));
        this.reader.requireWhiteSpace();
        if (this.reader.tryRead(XMLConstants.cCDATA, 0, XMLConstants.cCDATA.length)) {
            attrDecl.atttype = 0;
        } else if (this.reader.tryRead(XMLConstants.cIDREFS, 0, XMLConstants.cIDREFS.length)) {
            attrDecl.atttype = 3;
        } else if (this.reader.tryRead(XMLConstants.cIDREF, 0, XMLConstants.cIDREF.length)) {
            attrDecl.atttype = 2;
        } else if (this.reader.tryRead(XMLConstants.cID, 0, XMLConstants.cID.length)) {
            attrDecl.atttype = 1;
        } else if (this.reader.tryRead(XMLConstants.cENTITY, 0, XMLConstants.cENTITY.length)) {
            attrDecl.atttype = 4;
        } else if (this.reader.tryRead(XMLConstants.cENTITIES, 0, XMLConstants.cENTITIES.length)) {
            attrDecl.atttype = 5;
        } else if (this.reader.tryRead(XMLConstants.cNMTOKENS, 0, XMLConstants.cNMTOKENS.length)) {
            attrDecl.atttype = 7;
        } else if (this.reader.tryRead(XMLConstants.cNMTOKEN, 0, XMLConstants.cNMTOKEN.length)) {
            attrDecl.atttype = 6;
        } else if (this.reader.tryRead(XMLConstants.cNOTATION, 0, XMLConstants.cNOTATION.length)) {
            attrDecl.atttype = 8;
            this.reader.requireWhiteSpace();
        } else if (this.reader.tryRead(40)) {
            attrDecl.atttype = 9;
        } else {
            this.err.error0(133, 0);
            attrDecl.atttype = 0;
        }
        if (attrDecl.atttype == 8 || attrDecl.atttype == 9) {
            Vector<String> vector = new Vector<String>();
            attrDecl.xdkSetEnumValue(vector);
            if (attrDecl.atttype == 8 && !this.reader.tryRead(40)) {
                this.err.error1(100, 0, "(");
            }
            while (!this.reader.isEOF()) {
                this.reader.skipWhiteSpace();
                string = attrDecl.atttype == 8 ? this.reader.scanQName() : this.reader.scanNmToken();
                vector.addElement(string);
                this.reader.skipWhiteSpace();
                if (this.reader.tryRead(124)) continue;
                if (this.reader.tryRead(41)) break;
                this.err.error2(101, 0, ")", "|");
                this.err.flushErrors1();
            }
        }
        this.reader.requireWhiteSpace();
        attrDecl.attpres = 0;
        if (this.reader.tryRead(35)) {
            if (this.reader.tryRead(XMLConstants.cFIXED, 0, XMLConstants.cFIXED.length)) {
                attrDecl.attpres = 3;
                this.reader.requireWhiteSpace();
            } else if (this.reader.tryRead(XMLConstants.cREQUIRED, 0, XMLConstants.cREQUIRED.length)) {
                attrDecl.attpres = 1;
            } else if (this.reader.tryRead(XMLConstants.cIMPLIED, 0, XMLConstants.cIMPLIED.length)) {
                attrDecl.attpres = 2;
            } else {
                this.err.error0(288, 0);
            }
        }
        if (attrDecl.attpres == 3 || attrDecl.attpres == 0) {
            string = this.parseAttrValue();
            string = this.normalizeAttrValue(string, attrDecl, true);
            attrDecl.xdkSetAttrDeclDefault(string);
        }
        return attrDecl;
    }

    String normalizeAttrValue(String string, AttrDecl attrDecl, boolean bl) throws XMLParseException, SAXException, IOException {
        if (attrDecl != null && attrDecl.atttype != 0) {
            int n;
            char[] cArray = string.toCharArray();
            int n2 = cArray.length;
            int n3 = 0;
            for (n = 0; n < n2 && cArray[n] == ' '; ++n) {
            }
            for (int i = n + 1; i < n2; ++i) {
                if (n3 != 0) {
                    cArray[i - n3] = cArray[i];
                }
                if (cArray[i] != ' ' || cArray[i - 1] != ' ') continue;
                ++n3;
            }
            if ((n2 = n2 - n - n3) != 0 && cArray[n + n2 - 1] == ' ') {
                --n2;
            }
            return new String(cArray, n, n2);
        }
        return string;
    }

    XMLEntity parseEntityDecl() throws XMLParseException, SAXException, IOException {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        String string = null;
        String string2 = null;
        this.reader.requireWhiteSpace();
        bl = this.reader.checkParEntity();
        String string3 = this.reader.scanQName();
        String string4 = bl ? "%" + string3 : string3;
        XMLEntity xMLEntity = (XMLEntity)this.dtd.findEntity(string3, bl);
        if (xMLEntity != null) {
            this.err.error1(116, 2, string3);
            xMLEntity = this.dtd.createEntityDecl(string3, bl);
            bl3 = true;
            if (this.fixedDTD) {
                this.dtd.addEntity(xMLEntity, bl);
                xMLEntity.expanderef = this.expanderef;
                if (this.externalDTD > 0) {
                    xMLEntity.setNodeFlag(128);
                }
            }
        } else {
            xMLEntity = this.dtd.createEntityDecl(string3, bl);
            xMLEntity.expanderef = this.expanderef;
            this.dtd.addEntity(xMLEntity, bl);
            if (this.externalDTD > 0) {
                xMLEntity.setNodeFlag(128);
            }
        }
        this.reader.requireWhiteSpace();
        if (this.reader.tryRead(XMLConstants.cPUBLIC, 0, XMLConstants.cPUBLIC.length)) {
            bl2 = true;
            this.reader.requireWhiteSpace();
            string2 = this.reader.scanPubIdLiteral();
            xMLEntity.xdkSetPublicId(string2);
            this.reader.requireWhiteSpace();
            string = this.reader.scanQuotedString();
            xMLEntity.xdkSetSystemId(string);
        } else if (this.reader.tryRead(XMLConstants.cSYSTEM, 0, XMLConstants.cSYSTEM.length)) {
            bl2 = true;
            this.reader.requireWhiteSpace();
            string = this.reader.scanQuotedString();
            xMLEntity.xdkSetSystemId(string);
        }
        if (bl2) {
            Serializable serializable;
            String string5 = xMLEntity.getSystemId();
            try {
                URL uRL = new URL(this.getBaseURL(), string5);
                String string6 = uRL.toString();
                if (!string6.startsWith("file:///") && string6.startsWith("file://")) {
                    serializable = new StringBuffer(string6);
                    serializable.insert(7, '/');
                    string6 = serializable.toString();
                }
                xMLEntity.setURL(string6);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            boolean bl4 = false;
            boolean bl5 = this.reader.skipWhiteSpace();
            if (this.reader.tryRead(XMLConstants.cNDATA, 0, XMLConstants.cNDATA.length)) {
                if (!bl5) {
                    this.err.error0(190, 0);
                }
                if (bl) {
                    this.err.error0(117, 0);
                }
                this.reader.requireWhiteSpace();
                xMLEntity.setNotationName(this.reader.scanQName());
                if (!bl && xMLEntity.getNotationName() == null) {
                    this.err.error0(118, 0);
                }
                this.dtdHandler.unparsedEntityDecl(string3, xMLEntity.getPublicId(), xMLEntity.getSystemId(), xMLEntity.getNotationName());
                bl4 = true;
            }
            this.declHandler.externalEntityDecl(string4, xMLEntity.getPublicId(), string5);
            if (!(this.standalone || bl4 || string.equals(""))) {
                serializable = null;
                try {
                    serializable = new URL(this.getBaseURL(), xMLEntity.getSystemId());
                    InputStream inputStream = this.reader.openURL((URL)serializable);
                    if (inputStream.available() != 0) {
                        this.reader.pushXMLReader(inputStream, xMLEntity.getSystemId(), xMLEntity.getPublicId());
                        xMLEntity.setInputEncoding(this.reader.encoding);
                        xMLEntity.setXmlEncoding(this.reader.xmlDeclEncoding);
                        xMLEntity.setXmlVersion(this.reader.xmlDeclVersion);
                        this.reader.popXMLReader();
                    }
                }
                catch (Exception exception) {}
            }
        } else {
            String string7 = this.parseEntityValue();
            xMLEntity.setNodeValue(string7);
            xMLEntity.setNodeFlag(131072);
            if (!bl3) {
                this.declHandler.internalEntityDecl(string4, string7);
            }
        }
        this.reader.skipWhiteSpace();
        if (!this.reader.checkMarkupDepth(62)) {
            this.err.error1(100, 0, ">");
        }
        return xMLEntity;
    }

    String parseEntityValue() throws SAXException, IOException {
        String string;
        block4: {
            string = "";
            int n = this.reader.read();
            if (n != 34 && n != 39) {
                this.err.error0(119, 0);
                this.err.flushErrors1();
            }
            while (true) {
                string = string.concat(this.reader.scanEntityString(n));
                if (this.reader.tryRead(n)) break block4;
                if (this.reader.tryRead(37)) {
                    if (this.externalDTD > 0) {
                        string = string.concat(this.parseEntityRefValue());
                        continue;
                    }
                    this.err.error1(210, 0, "%");
                    continue;
                }
                if (this.reader.isEOF()) break;
            }
            this.err.error0(193, 0);
            this.err.flushErrors1();
            return string;
        }
        return string;
    }

    String parseEntityRefValue() throws XMLParseException, SAXException, IOException {
        boolean bl;
        String string = "";
        XMLEntity xMLEntity = this.reader.getEntity(true);
        if (xMLEntity == null) {
            return "";
        }
        if (xMLEntity.getLength() == -1) {
            return xMLEntity.getNodeValue();
        }
        boolean bl2 = bl = this.entResolution == null ? XMLParser.extValue : this.entResolution;
        if (!this.reader.pushEntityRef(xMLEntity, bl, true)) {
            return "";
        }
        while (true) {
            string = string.concat(this.reader.scanEntityString(65535));
            if (this.reader.tryRead(37)) {
                string = string.concat(this.parseEntityRefValue());
                continue;
            }
            if (this.reader.isEOF()) break;
        }
        this.reader.popXMLReader();
        return string;
    }

    void parseNotationDecl() throws XMLParseException, SAXException, IOException {
        this.reader.requireWhiteSpace();
        String string = this.reader.scanQName();
        XMLNotation xMLNotation = (XMLNotation)this.dtd.findNotation(string);
        if (xMLNotation != null) {
            if (this.valMode == 2) {
                this.err.error1(136, 1, string);
            } else {
                this.err.error1(136, 2, string);
            }
            xMLNotation = this.dtd.createNotationDecl(string);
        } else {
            xMLNotation = this.dtd.createNotationDecl(string);
            this.dtd.addNotation(xMLNotation);
            if (this.externalDTD > 0) {
                xMLNotation.setNodeFlag(128);
            }
        }
        this.reader.skipWhiteSpace();
        if (this.reader.tryRead(XMLConstants.cPUBLIC, 0, XMLConstants.cPUBLIC.length)) {
            this.reader.requireWhiteSpace();
            xMLNotation.setPublicId(this.reader.scanPubIdLiteral());
            boolean bl = this.reader.skipWhiteSpace();
            if (!this.reader.checkMarkupDepth(62)) {
                if (!bl) {
                    this.err.error0(190, 0);
                }
                xMLNotation.setSystemId(this.reader.scanQuotedString());
                this.reader.skipWhiteSpace();
                if (!this.reader.checkMarkupDepth(62)) {
                    this.err.error1(100, 0, ">");
                }
            }
        } else if (this.reader.tryRead(XMLConstants.cSYSTEM, 0, XMLConstants.cSYSTEM.length)) {
            this.reader.requireWhiteSpace();
            xMLNotation.setSystemId(this.reader.scanQuotedString());
            this.reader.skipWhiteSpace();
            if (!this.reader.checkMarkupDepth(62)) {
                this.err.error1(100, 0, ">");
            }
        } else {
            this.err.error2(101, 0, "PUBLIC", "SYSTEM");
            this.err.flushErrors1();
            if (this.reader.checkMarkupDepth(62)) {
                this.err.error1(100, 0, ">");
            }
            return;
        }
        try {
            URL uRL = this.baseURL != null ? new URL(this.baseURL, xMLNotation.getSystemId()) : new URL(new URL(this.reader.getSystemId()), xMLNotation.getSystemId());
            xMLNotation.setSystemId(uRL.toString());
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        this.dtdHandler.notationDecl(string, xMLNotation.getPublicId(), xMLNotation.getSystemId());
    }

    /*
     * Unable to fully structure code
     */
    String parseElement() throws XMLParseException, SAXException, IOException {
        var2_1 = new String[2];
        var3_2 = "";
        block0: while (true) {
            var5_5 = this.reader.scanQName(var2_1);
            var3_2 = var2_1[0];
            var4_4 = var2_1[1];
            this.pushState(var3_2, var4_4, var5_5);
            this.parseAttributes();
            this.cntHandler.startElement(this.currentState.namespace, this.currentState.localname, this.currentState.qname, this.currentState.attrlist);
            if (this.currentState.empty) {
                this.cntHandler.endElement(this.currentState.namespace, this.currentState.localname, this.currentState.qname);
                this.popState();
                if (this.stateIndex == -1) {
                    return this.parserStates[0].qname;
                }
            }
            while (true) {
                if (this.stateIndex < 0) continue block0;
                this.parseText();
                if (this.reader.tryRead(38)) {
                    if (!this.parseContentEntityRef()) continue;
                    ++this.currentState.markupDepth;
                    continue;
                }
                if (this.reader.tryRead(XMLConstants.cENDTAGSTART, 0, XMLConstants.cENDTAGSTART.length)) {
                    this.parseEndTag();
                    if (this.currentState.markupDepth != 0) {
                        this.err.error0(120, 0);
                    }
                    this.cntHandler.endElement(this.currentState.namespace, this.currentState.localname, this.currentState.qname);
                    this.popState();
                    if (this.stateIndex != -1) continue;
                    return this.parserStates[0].qname;
                }
                if (this.reader.tryRead(XMLConstants.cPISTART, 0, XMLConstants.cPISTART.length)) {
                    this.parsePI();
                    continue;
                }
                if (this.reader.tryRead(XMLConstants.cCOMMENTSTART, 0, XMLConstants.cCOMMENTSTART.length)) {
                    this.parseComment();
                    continue;
                }
                if (this.reader.tryRead(XMLConstants.cCDATASTART, 0, XMLConstants.cCDATASTART.length)) {
                    this.lexHandler.startCDATA();
                    do {
                        var1_3 = this.reader.scanCDATA(this.charLimits, this.charChunks);
                        if (this.charLimits[1] == 0) break;
                        this.reportCharacters(var1_3, this.charLimits[0], this.charLimits[1]);
                    } while (this.charChunks);
                    this.lexHandler.endCDATA();
                    continue;
                }
                if (!this.reader.tryRead(60)) ** break;
                continue block0;
                if (!this.reader.isEOF()) continue;
                this.reader.popXMLReader();
                --this.currentState.markupDepth;
            }
            break;
        }
    }

    void parseEndTag() throws XMLParseException, SAXException, IOException {
        String string = "";
        String string2 = this.reader.scanName();
        if (this.reader.tryRead(58)) {
            string = string2;
            string2 = this.reader.scanName();
        }
        if (string != this.currentState.prefix || string2 != this.currentState.localname) {
            this.err.error1(121, 0, this.currentState.qname);
            this.err.flushErrors1();
        }
        this.reader.skipWhiteSpace();
        if (!this.reader.tryRead(62)) {
            this.err.error0(123, 0);
        }
    }

    boolean isMarkup() throws SAXException, IOException {
        return this.reader.peek() == 60 || this.reader.peek(XMLConstants.cPISTART, 0, XMLConstants.cPISTART.length) || this.reader.peek(XMLConstants.cCOMMENTSTART, 0, XMLConstants.cCOMMENTSTART.length) || this.reader.peek(XMLConstants.cCDATASTART, 0, XMLConstants.cCDATASTART.length);
    }

    void parseText() throws XMLParseException, SAXException, IOException {
        char[] cArray;
        if (this.preserveWS != 0) {
            cArray = this.reader.scanWhiteSpace(this.charLimits);
            if (this.charLimits[1] != 0) {
                ElementDecl elementDecl = this.currentState.ed;
                if (this.isMarkup() && (this.preserveWS == 1 || elementDecl != null && elementDecl.getContentType() == 4)) {
                    this.cntHandler.ignorableWhitespace(cArray, this.charLimits[0], this.charLimits[1]);
                } else {
                    this.reportCharacters(cArray, this.charLimits[0], this.charLimits[1]);
                }
            }
        }
        do {
            cArray = this.reader.scanChars(this.charLimits, this.charChunks);
            if (this.charLimits[1] == 0) break;
            this.reportCharacters(cArray, this.charLimits[0], this.charLimits[1]);
        } while (this.charChunks);
    }

    void parseAttributes() throws XMLParseException, SAXException, IOException {
        boolean bl = false;
        this.reader.skipWhiteSpace();
        if (this.reader.tryRead(62)) {
            this.checkDefaultAttributes();
            this.expandNamespace();
            return;
        }
        if (this.reader.tryRead(XMLConstants.cEMPTYTAGEND, 0, XMLConstants.cEMPTYTAGEND.length)) {
            this.currentState.empty = true;
            this.checkDefaultAttributes();
            this.expandNamespace();
            return;
        }
        while (true) {
            this.parseAttr();
            bl = this.reader.skipWhiteSpace();
            if (this.reader.tryRead(62)) break;
            if (this.reader.tryRead(XMLConstants.cEMPTYTAGEND, 0, XMLConstants.cEMPTYTAGEND.length)) {
                this.currentState.empty = true;
                break;
            }
            if (bl) continue;
            this.err.error0(190, 0);
        }
        this.checkDefaultAttributes();
        this.expandNamespace();
    }

    DocumentBuilder getDocumentBuilder() {
        if (this.cntHandler instanceof XMLMultiHandler) {
            ContentHandler[] contentHandlerArray = ((XMLMultiHandler)this.cntHandler).getContentHandlers();
            int n = ((XMLMultiHandler)this.cntHandler).getNumContentHandlers();
            for (int i = 0; i < n; ++i) {
                if (!(contentHandlerArray[i] instanceof DocumentBuilder)) continue;
                return (DocumentBuilder)contentHandlerArray[i];
            }
        }
        return null;
    }

    AttrDecl parseAttr() throws XMLParseException, SAXException, IOException {
        AttrDecl attrDecl = null;
        int n = 0;
        String string = this.reader.scanQName(this.parseAttrParts);
        String string2 = this.parseAttrParts[0];
        String string3 = this.parseAttrParts[1];
        if (this.currentState.ed != null) {
            attrDecl = this.currentState.ed.findAttrDecl(string);
        }
        if (attrDecl != null) {
            n = attrDecl.atttype;
        }
        this.reader.skipWhiteSpace();
        if (!this.reader.tryRead(61)) {
            this.err.error0(122, 0);
        }
        this.reader.skipWhiteSpace();
        String string4 = this.normalizeAttrValue(this.parseAttrValue(), attrDecl, false);
        this.addNamespaceDef(string2, string3, string4);
        if (!(this.namespacePrefixFeature || string3 != "xmlns" && string2 != "xmlns")) {
            return attrDecl;
        }
        this.currentState.attrlist.addAttr(string2, string3, string, string4, true, 0);
        return attrDecl;
    }

    void addNamespaceDef(String string, String string2, String string3) throws SAXException {
        if (string2 == "xmlns" || string == "xmlns") {
            if (this.currentState.nameSpaceTable == null) {
                this.currentState.nameSpaceTable = new Hashtable(20);
            }
            string3 = string3.intern();
            if (string == "xmlns") {
                this.cntHandler.startPrefixMapping(string2, string3);
                this.currentState.prefixes.addElement(string2);
            } else {
                this.cntHandler.startPrefixMapping("", string3);
                this.currentState.prefixes.addElement("");
            }
            this.currentState.nameSpaceTable.put(string2, string3);
        }
    }

    void checkDefaultAttributes() throws XMLParseException, SAXException {
        NamedNodeMap namedNodeMap;
        if (this.currentState.ed != null && (namedNodeMap = this.currentState.ed.getAttrDecls()) != null) {
            AttrDecl attrDecl;
            int n;
            SAXAttrList sAXAttrList = this.currentState.attrlist;
            this.attrHash.clear();
            for (n = 0; n < sAXAttrList.count; ++n) {
                this.attrHash.put(sAXAttrList.qname[n], sAXAttrList.qname[n]);
                attrDecl = (AttrDecl)namedNodeMap.getNamedItem(sAXAttrList.qname[n]);
                if (attrDecl == null) continue;
                this.currentState.attrlist.attrType[n] = attrDecl.atttype;
            }
            n = namedNodeMap.getLength();
            for (int i = 0; i < n; ++i) {
                String string;
                attrDecl = (AttrDecl)namedNodeMap.item(i);
                String string2 = attrDecl.getNodeName();
                if (this.attrHash.get(string2) != null || (string = attrDecl.getDefaultValue()) == null) continue;
                String string3 = XMLUtil.getPrefix(string2);
                String string4 = XMLUtil.getLocalName(string2);
                this.addNamespaceDef(string3, string4, string);
                this.currentState.attrlist.addAttr(string3, string4, string2, string, false, attrDecl.atttype);
            }
        }
    }

    String parseAttrValue() throws XMLParseException, SAXException, IOException {
        String string;
        block4: {
            string = null;
            int n = this.reader.read();
            if (n != 34 && n != 39) {
                this.err.error0(125, 0);
                this.err.flushErrors1();
            }
            while (true) {
                string = string == null ? this.reader.scanAttrString(n) : string.concat(this.reader.scanAttrString(n));
                if (this.reader.tryRead(n)) break block4;
                if (this.reader.tryRead(60)) {
                    this.err.error0(126, 0);
                    continue;
                }
                if (this.reader.tryRead(38)) {
                    string = string.concat(this.parseAttrEntityRef());
                    continue;
                }
                if (this.reader.isEOF()) break;
            }
            this.err.error0(193, 0);
            this.err.flushErrors1();
            return string;
        }
        return string;
    }

    String parseAttrEntityRef() throws XMLParseException, SAXException, IOException {
        String string = "";
        XMLEntity xMLEntity = this.reader.getEntity(false);
        if (xMLEntity == null) {
            return "";
        }
        if (xMLEntity.getSystemId() != null) {
            this.err.error0(127, 0);
            return "";
        }
        if (xMLEntity.getLength() == -1) {
            return xMLEntity.getNodeValue();
        }
        if (!this.reader.pushEntityRef(xMLEntity, false, false)) {
            return "";
        }
        while (true) {
            String string2 = this.reader.scanAttrString(65535);
            string = string.concat(string2);
            if (this.reader.isEOF()) {
                this.reader.popXMLReader();
                return string;
            }
            if (this.reader.tryRead(60)) {
                this.err.error0(126, 0);
                continue;
            }
            if (!this.reader.tryRead(38)) continue;
            string = string.concat(this.parseAttrEntityRef());
        }
    }

    boolean parseContentEntityRef() throws XMLParseException, SAXException, IOException {
        XMLEntity xMLEntity = this.reader.getEntity(false);
        if (xMLEntity == null) {
            return false;
        }
        if (xMLEntity.getLength() == -1) {
            char[] cArray = new char[]{xMLEntity.getChar(0)};
            this.reportCharacters(cArray, 0, 1);
            return false;
        }
        if (xMLEntity.getNotationName() != null) {
            this.err.error0(128, 0);
            return false;
        }
        boolean bl = this.entResolution == null ? XMLParser.extValue : this.entResolution;
        return this.reader.pushEntityRef(xMLEntity, bl, true);
    }

    void reportCharacters(char[] cArray, int n, int n2) throws XMLParseException, SAXException, IOException {
        this.cntHandler.characters(cArray, n, n2);
    }

    void pushState(String string, String string2, String string3) throws XMLParseException, SAXException, IOException {
        ElementDecl elementDecl = this.dtd.findElementDecl(string3);
        ++this.stateIndex;
        if (this.stateIndex > this.maxIndex) {
            if (this.stateIndex >= this.stateSize) {
                ParserState[] parserStateArray = this.parserStates;
                this.parserStates = new ParserState[this.stateSize * 2];
                System.arraycopy(parserStateArray, 0, this.parserStates, 0, this.stateSize);
                this.stateSize *= 2;
            }
            this.parserStates[this.stateIndex] = this.currentState = new ParserState(string, string2, string3, elementDecl);
            ++this.maxIndex;
        } else {
            this.currentState = this.parserStates[this.stateIndex];
            this.currentState.reset(string, string2, string3, elementDecl);
        }
    }

    ParserState popState() throws XMLParseException, SAXException, IOException {
        ParserState parserState = this.currentState;
        int n = this.currentState.prefixes.size();
        for (int i = 0; i < n; ++i) {
            String string = (String)this.currentState.prefixes.elementAt(i);
            this.cntHandler.endPrefixMapping(string);
        }
        --this.stateIndex;
        this.currentState = this.stateIndex >= 0 ? this.parserStates[this.stateIndex] : null;
        return parserState;
    }

    void expandNamespace() throws XMLParseException, SAXException, IOException {
        this.attrHash.clear();
        if (this.currentState.prefix != "") {
            this.currentState.namespace = this.resolveNS(this.currentState.prefix);
            if (this.currentState.namespace == "") {
                this.err.error1(129, 1, this.currentState.prefix);
            }
        } else {
            this.currentState.namespace = this.resolveNS("xmlns");
        }
        SAXAttrList sAXAttrList = this.currentState.attrlist;
        for (int i = 0; i < sAXAttrList.count; ++i) {
            if (this.attrHash.get(sAXAttrList.qname[i]) == null) {
                this.attrHash.put(sAXAttrList.qname[i], sAXAttrList.qname[i]);
            } else {
                this.err.error0(124, 0);
            }
            String string = sAXAttrList.prefix[i];
            if (string != "") {
                sAXAttrList.namespace[i] = string == "xmlns" ? "http://www.w3.org/2000/xmlns/" : this.resolveNS(string);
                if (sAXAttrList.namespace[i] != "") continue;
                this.err.error1(129, 1, string);
                continue;
            }
            if (sAXAttrList.name[i] != "xmlns") continue;
            sAXAttrList.namespace[i] = "http://www.w3.org/2000/xmlns/";
        }
    }

    String resolveNS(String string) {
        String string2 = null;
        if (string == "xml") {
            return "http://www.w3.org/XML/1998/namespace";
        }
        for (int i = this.stateIndex; i >= 0; --i) {
            ParserState parserState = this.parserStates[i];
            if (parserState.nameSpaceTable != null) {
                string2 = (String)parserState.nameSpaceTable.get(string);
            }
            if (string2 == null) continue;
            return string2;
        }
        return "";
    }

    void checkNames(XMLError xMLError) throws XMLParseException {
    }

    public boolean getFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ((string = string.intern()) == "http://xml.org/sax/features/namespaces") {
            return this.namespaceFeature;
        }
        if (string == "http://xml.org/sax/features/namespace-prefixes") {
            return this.namespacePrefixFeature;
        }
        if (string == "http://xml.org/sax/features/string-interning") {
            return this.stringInternFeature;
        }
        if (string == "http://xml.org/sax/features/validation") {
            return this.valMode != 0;
        }
        if (string == "http://xml.org/sax/features/external-general-entities") {
            return true;
        }
        if (string == "http://xml.org/sax/features/external-parameter-entities") {
            return true;
        }
        if (string == "http://xml.org/sax/features/use-locator2") {
            return true;
        }
        throw new SAXNotRecognizedException(this.err.getMessage1(500, string));
    }

    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ((string = string.intern()) == "http://xml.org/sax/features/namespaces" || string == "http://xml.org/sax/features/namespace-prefixes" || string == "http://xml.org/sax/features/string-interning" || string == "http://xml.org/sax/features/validation") {
            if (this.parsing) {
                throw new SAXNotSupportedException(this.err.getMessage1(501, string));
            }
            if (string == "http://xml.org/sax/features/namespaces") {
                this.namespaceFeature = bl;
            } else if (string == "http://xml.org/sax/features/namespace-prefixes") {
                this.namespacePrefixFeature = bl;
            } else if (string == "http://xml.org/sax/features/string-interning") {
                this.stringInternFeature = bl;
            }
            return;
        }
        if (string == "http://xml.org/sax/features/external-general-entities") {
            if (!bl) {
                throw new SAXNotSupportedException(this.err.getMessage1(501, string));
            }
        } else if (string == "http://xml.org/sax/features/external-parameter-entities") {
            if (!bl) {
                throw new SAXNotSupportedException(this.err.getMessage1(501, string));
            }
        } else if (string == "http://xml.org/sax/features/use-locator2") {
            if (!bl) {
                throw new SAXNotSupportedException(this.err.getMessage1(501, string));
            }
        } else {
            throw new SAXNotRecognizedException(this.err.getMessage1(500, string));
        }
    }
}

