/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xqxp.functions.builtIns;

import java.util.HashMap;
import java.util.HashSet;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.util.QxName;
import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xml.xqxp.functions.OXMLFunctionContext;
import oracle.xml.xslt.XSLNamespace;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;

public class FNUtil {
    static HashMap XDTTYPE = new HashMap(3);
    public static final OXMLSequenceType TNSTRING;
    public static final OXMLSequenceType TTOKEN;
    public static final OXMLSequenceType TLANGUAGE;
    public static final OXMLSequenceType TNMTOKEN;
    public static final OXMLSequenceType TNAME;
    public static final OXMLSequenceType TNCNAME;
    public static final OXMLSequenceType TID;
    public static final OXMLSequenceType TIDREF;
    public static final OXMLSequenceType TENTITY;
    public static final OXMLSequenceType TNPINTEGER;
    public static final OXMLSequenceType TNINTEGER;
    public static final OXMLSequenceType TLONG;
    public static final OXMLSequenceType TINT;
    public static final OXMLSequenceType TSHORT;
    public static final OXMLSequenceType TBYTE;
    public static final OXMLSequenceType TNNINTEGER;
    public static final OXMLSequenceType TULONG;
    public static final OXMLSequenceType TUINT;
    public static final OXMLSequenceType TUSHORT;
    public static final OXMLSequenceType TUBYTE;
    public static final OXMLSequenceType TPINTEGER;
    static HashMap XSDTYPE;
    public static final String CODEPOINT_COLLA = "http://www.w3.org/2005/04/xpath-functions/collation/codepoint";
    private static final String NFC = "NFC";

    public static void main(String[] stringArray) {
        boolean bl = TPINTEGER.isOfType(OXMLSequenceType.TINTEGER);
        boolean bl2 = TLANGUAGE.isOfType(OXMLSequenceType.TSTRING);
        boolean bl3 = TUINT.isOfType(TSHORT);
        System.out.println(bl + " " + bl2 + " " + bl3);
    }

    static OXMLItem getSingleItem(OXMLSequence oXMLSequence) throws XQException {
        if (!oXMLSequence.next()) {
            throw new XQException("XPTY0004");
        }
        OXMLItem oXMLItem = oXMLSequence.getItem();
        if (oXMLSequence.next()) {
            throw new XQException("XPTY0004");
        }
        return oXMLItem;
    }

    static OXMLItem getEmptyOrSingleItem(OXMLSequence oXMLSequence) throws XQException {
        if (!oXMLSequence.next()) {
            return null;
        }
        OXMLItem oXMLItem = oXMLSequence.getItem();
        if (oXMLSequence.next()) {
            throw new XQException("XPTY0004");
        }
        return oXMLItem;
    }

    public static Node getFirstElement(Node node) {
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (node2.getNodeType() != 1) continue;
            return node2;
        }
        return null;
    }

    public static Node getOnlyElementChild(Node node) {
        boolean bl = false;
        Node node2 = null;
        for (Node node3 = node.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
            if (node3.getNodeType() != 1) continue;
            if (!bl) {
                bl = true;
                node2 = node3;
                continue;
            }
            return null;
        }
        return node2;
    }

    private static XMLNode getNextElementOrTextSibling(XMLNode xMLNode) {
        for (Node node = xMLNode.getNextSibling(); node != null; node = node.getNextSibling()) {
            switch (FNUtil.getNodeType(node)) {
                case 1: 
                case 3: {
                    return (XMLNode)node;
                }
            }
        }
        return null;
    }

    private static XMLNode getFirstElementOrTextChild(Node node) {
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            switch (FNUtil.getNodeType(node2)) {
                case 1: 
                case 3: {
                    return (XMLNode)node2;
                }
            }
        }
        return null;
    }

    public static void checkCollation(String string) throws XQException {
        if (string != null && !string.equals(CODEPOINT_COLLA)) {
            throw new XQException("FOCH0002");
        }
    }

    public static void checkSubstringCollation(OXMLFunctionContext oXMLFunctionContext, String string) throws XQException {
        if (string == null) {
            return;
        }
        if (string != null) {
            if (string.equals(CODEPOINT_COLLA)) {
                return;
            }
            if (string.compareToIgnoreCase("BINARY") == 0) {
                String string2 = oXMLFunctionContext.getDBCharSet();
                if (string2 == null) {
                    return;
                }
                if (string2.equals("AL32UTF8") || string2.equals("US7ASCII") || string2.equals("WE8ISO8859P1")) {
                    return;
                }
            }
        }
        throw new XQException("FOCH0004");
    }

    static void checkUNF(String string) throws XQException {
        if (string != null && !string.trim().equalsIgnoreCase(NFC)) {
            throw new XQException("FOCH0003");
        }
    }

    private static QxName getQName(Node node) {
        String string = node.getNodeName();
        if (string == null) {
            return null;
        }
        int n = string.indexOf(58);
        QxName qxName = null;
        qxName = n > 0 ? new QxName(node.getNamespaceURI(), string.substring(n + 1)) : new QxName("", string);
        return qxName;
    }

    public static QxName getNodeQName(XMLNode xMLNode) {
        QxName qxName = null;
        if (xMLNode instanceof XSLNamespace) {
            String string = xMLNode.getNodeName();
            if (string.equals("xmlns")) {
                qxName = new QxName("", "");
            } else if (string.startsWith("xmlns:")) {
                qxName = new QxName("", string.substring(6));
            }
        } else {
            qxName = xMLNode.getQName();
        }
        return qxName;
    }

    private static String getLocalPart(Node node) {
        String string = node.getNodeName();
        if (string == null) {
            return null;
        }
        int n = string.indexOf(58);
        String string2 = n > 0 ? string.substring(n + 1) : string;
        return string2;
    }

    static String getNodeName(Node node) {
        String string = null;
        switch (node.getNodeType()) {
            case 3: 
            case 8: 
            case 9: {
                string = "";
                break;
            }
            case 7: {
                string = ((ProcessingInstruction)node).getTarget();
                break;
            }
            default: {
                string = node.getNodeName();
            }
        }
        return string;
    }

    static String getLocalName(Node node) {
        String string = null;
        switch (node.getNodeType()) {
            case 3: 
            case 8: 
            case 9: {
                string = "";
                break;
            }
            case 7: {
                string = ((ProcessingInstruction)node).getTarget();
                break;
            }
            default: {
                string = FNUtil.getLocalPart(node);
            }
        }
        return string;
    }

    static String recGetAttribute(Node node, String string, String string2) {
        String string3 = null;
        if (node.getNodeType() == 1 && (string3 = ((Element)node).getAttributeNS(string, string2)) != null && string3.length() != 0) {
            return string3;
        }
        Node node2 = node.getParentNode();
        if (node2 != null) {
            string3 = FNUtil.recGetAttribute(node2, string, string2);
        }
        return string3;
    }

    static Node getRoot(Node node) {
        Node node2 = node;
        Node node3 = FNUtil.getParentNode(node);
        if (node3 != null) {
            node2 = FNUtil.getRoot(node3);
        }
        return node2;
    }

    private static Node getParentNode(Node node) {
        if (node.getNodeType() == 2) {
            return ((Attr)node).getOwnerElement();
        }
        return node.getParentNode();
    }

    public static boolean isNode(OXMLItem oXMLItem) {
        return oXMLItem.getPrimitiveType() == 90;
    }

    public static boolean isUntypedAtomic(OXMLItem oXMLItem) {
        return oXMLItem.getPrimitiveType() == 0;
    }

    private static boolean recEqualNode(XMLNode xMLNode, XMLNode xMLNode2) {
        int n;
        int n2 = FNUtil.getNodeType(xMLNode);
        if (n2 != (n = FNUtil.getNodeType(xMLNode2))) {
            return false;
        }
        QxName qxName = xMLNode.getQName();
        QxName qxName2 = xMLNode2.getQName();
        if (qxName != null && qxName2 != null && !qxName.equals(qxName2)) {
            return false;
        }
        switch (n2) {
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 99: {
                return xMLNode.getNodeValue().equals(xMLNode2.getNodeValue());
            }
            case 1: {
                NamedNodeMap namedNodeMap = xMLNode.getAttributes();
                NamedNodeMap namedNodeMap2 = xMLNode2.getAttributes();
                Object object = null;
                Node node = null;
                int n3 = -1;
                if (namedNodeMap != null) {
                    object = namedNodeMap;
                    node = (Element)((Object)xMLNode2);
                    n3 = namedNodeMap2 == null ? 0 : namedNodeMap2.getLength();
                } else if (namedNodeMap2 != null) {
                    object = namedNodeMap2;
                    node = (Element)((Object)xMLNode);
                    n3 = 0;
                }
                if (object != null) {
                    String string;
                    Object object2;
                    int n4;
                    int n5 = object.getLength();
                    int n6 = 0;
                    for (n4 = 0; n4 < n5; ++n4) {
                        Attr attr = (Attr)object.item(n4);
                        object2 = attr.getNodeName();
                        if (((String)object2).equals("xmlns") || ((String)object2).startsWith("xmlns:")) continue;
                        ++n6;
                        string = node.getAttribute((String)object2);
                        if (string != null && string.equals(attr.getNodeValue())) continue;
                        return false;
                    }
                    n4 = 0;
                    if (n3 != 0) {
                        for (int i = 0; i < n5; ++i) {
                            object2 = (Attr)namedNodeMap2.item(i);
                            string = object2.getNodeName();
                            if (string.equals("xmlns") || string.startsWith("xmlns:")) continue;
                            ++n4;
                        }
                    }
                    if (n6 != n4) {
                        return false;
                    }
                }
            }
            case 9: {
                int n3;
                Node node;
                Object object;
                boolean bl = xMLNode.hasChildNodes();
                boolean bl2 = xMLNode2.hasChildNodes();
                if (bl && bl2) {
                    object = FNUtil.getFirstElementOrTextChild(xMLNode);
                    node = FNUtil.getFirstElementOrTextChild(xMLNode2);
                    n3 = 0;
                    do {
                        if (!FNUtil.recEqualNode((XMLNode)object, (XMLNode)node)) {
                            return false;
                        }
                        object = FNUtil.getNextElementOrTextSibling((XMLNode)object);
                        node = FNUtil.getNextElementOrTextSibling((XMLNode)node);
                    } while (object != null && node != null);
                    if (object == null && node == null) break;
                    return false;
                }
                if (!bl && !bl2) break;
                return false;
            }
        }
        return true;
    }

    static boolean isEqualNode(XMLNode xMLNode, XMLNode xMLNode2) {
        return FNUtil.recEqualNode(xMLNode, xMLNode2);
    }

    static int getNodeType(Node node) {
        int n = -1;
        switch (node.getNodeType()) {
            case 11: {
                n = 9;
                break;
            }
            case 4: {
                n = 3;
                break;
            }
            case 2: {
                String string = node.getNodeName();
                if (string.startsWith("xmlns:") || string.equals("xmlns")) {
                    n = 99;
                    break;
                }
                n = 2;
                break;
            }
            default: {
                n = node.getNodeType();
            }
        }
        return n;
    }

    static String getNodeKind(Node node) {
        String string = null;
        switch (node.getNodeType()) {
            case 1: {
                string = "element";
                break;
            }
            case 8: {
                string = "comment";
                break;
            }
            case 7: {
                string = "processing-instruction";
                break;
            }
            case 9: 
            case 11: {
                string = "document";
                break;
            }
            case 3: 
            case 4: {
                string = "text";
                break;
            }
            case 2: {
                String string2 = node.getNodeName();
                string = string2.startsWith("xmlns:") || string2.equals("xmlns") ? "namespace" : "attribute";
            }
        }
        return string;
    }

    static String getNamespaceURI(String string, Element element) {
        String string2;
        String string3;
        int n = string == null ? 0 : string.length();
        StringBuffer stringBuffer = new StringBuffer(n + 6);
        stringBuffer.append("xmlns");
        if (n != 0) {
            stringBuffer.append(':').append(string);
        }
        if ((string3 = element.getAttribute(string2 = stringBuffer.toString())) != null && string3.length() != 0) {
            return string3;
        }
        for (Node node = element.getParentNode(); node != null; node = node.getParentNode()) {
            String string4;
            if (node.getNodeType() != 1 || (string4 = ((Element)node).getAttribute(string2)) == null || string4.length() == 0) continue;
            return string4;
        }
        return null;
    }

    static void getPrefixes(Node node, HashSet hashSet) {
        if (node == null) {
            return;
        }
        if (node.getNodeType() != 1) {
            FNUtil.getPrefixes(node.getParentNode(), hashSet);
            return;
        }
        Element element = (Element)node;
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = namedNodeMap == null ? 0 : namedNodeMap.getLength();
        for (int i = 0; i < n; ++i) {
            Attr attr = (Attr)namedNodeMap.item(i);
            String string = attr.getNodeName();
            if (string.equals("xmlns")) {
                hashSet.add("");
                continue;
            }
            if (!string.startsWith("xmlns:")) continue;
            hashSet.add(string.substring(6));
        }
        FNUtil.getPrefixes(node.getParentNode(), hashSet);
    }

    public static int compareNodeOrder(XMLNode xMLNode, XMLNode xMLNode2) {
        short s = xMLNode.compareDocumentPosition(xMLNode2);
        int n = 1;
        if ((s & 2) == 2 || (s & 8) == 8) {
            n = 1;
        } else if ((s & 4) == 4 || (s & 0x10) == 16) {
            n = -1;
        } else if ((s & 0) == 0) {
            n = 0;
        }
        return n;
    }

    static boolean isWhitespace(char c) {
        switch (c) {
            case '\t': 
            case '\n': 
            case '\r': 
            case ' ': {
                return true;
            }
        }
        return false;
    }

    static {
        XDTTYPE.put("yearMonthDuration", OXMLSequenceType.TYMDURATION);
        XDTTYPE.put("dayTimeDuration", OXMLSequenceType.TDTDURATION);
        XDTTYPE.put("untypedAtomic", OXMLSequenceType.TUNTYPED);
        TNSTRING = OXMLSequenceType.createValueType(new QxName("http://www.w3.org/2001/XMLSchema", "normalizedString"), 1);
        TTOKEN = OXMLSequenceType.createValueType(new QxName("http://www.w3.org/2001/XMLSchema", "token"), 1);
        TLANGUAGE = OXMLSequenceType.createValueType(new QxName("http://www.w3.org/2001/XMLSchema", "language"), 1);
        TNMTOKEN = OXMLSequenceType.createValueType(new QxName("http://www.w3.org/2001/XMLSchema", "NMTOKEN"), 1);
        TNAME = OXMLSequenceType.createValueType(new QxName("http://www.w3.org/2001/XMLSchema", "Name"), 1);
        TNCNAME = OXMLSequenceType.createValueType(new QxName("http://www.w3.org/2001/XMLSchema", "NCName"), 1);
        TID = OXMLSequenceType.createValueType(new QxName("http://www.w3.org/2001/XMLSchema", "ID"), 1);
        TIDREF = OXMLSequenceType.createValueType(new QxName("http://www.w3.org/2001/XMLSchema", "IDREF"), 1);
        TENTITY = OXMLSequenceType.createValueType(new QxName("http://www.w3.org/2001/XMLSchema", "ENTITY"), 1);
        TNPINTEGER = OXMLSequenceType.createValueType(new QxName("http://www.w3.org/2001/XMLSchema", "nonPositiveInteger"), 1);
        TNINTEGER = OXMLSequenceType.createValueType(new QxName("http://www.w3.org/2001/XMLSchema", "negativeInteger"), 1);
        TLONG = OXMLSequenceType.createValueType(new QxName("http://www.w3.org/2001/XMLSchema", "long"), 1);
        TINT = OXMLSequenceType.createValueType(new QxName("http://www.w3.org/2001/XMLSchema", "int"), 1);
        TSHORT = OXMLSequenceType.createValueType(new QxName("http://www.w3.org/2001/XMLSchema", "short"), 1);
        TBYTE = OXMLSequenceType.createValueType(new QxName("http://www.w3.org/2001/XMLSchema", "byte"), 1);
        TNNINTEGER = OXMLSequenceType.createValueType(new QxName("http://www.w3.org/2001/XMLSchema", "nonNegativeInteger"), 1);
        TULONG = OXMLSequenceType.createValueType(new QxName("http://www.w3.org/2001/XMLSchema", "unsignedLong"), 1);
        TUINT = OXMLSequenceType.createValueType(new QxName("http://www.w3.org/2001/XMLSchema", "unsignedInt"), 1);
        TUSHORT = OXMLSequenceType.createValueType(new QxName("http://www.w3.org/2001/XMLSchema", "unsignedShort"), 1);
        TUBYTE = OXMLSequenceType.createValueType(new QxName("http://www.w3.org/2001/XMLSchema", "unsignedByte"), 1);
        TPINTEGER = OXMLSequenceType.createValueType(new QxName("http://www.w3.org/2001/XMLSchema", "positiveInteger"), 1);
        XSDTYPE = new HashMap(43);
        XSDTYPE.put("string", OXMLSequenceType.TSTRING);
        XSDTYPE.put("boolean", OXMLSequenceType.TBOOLEAN);
        XSDTYPE.put("decimal", OXMLSequenceType.TDECIMAL);
        XSDTYPE.put("float", OXMLSequenceType.TFLOAT);
        XSDTYPE.put("double", OXMLSequenceType.TDOUBLE);
        XSDTYPE.put("QName", OXMLSequenceType.TQNAME);
        XSDTYPE.put("duration", OXMLSequenceType.TDURATION);
        XSDTYPE.put("dateTime", OXMLSequenceType.TDATETIME);
        XSDTYPE.put("time", OXMLSequenceType.TTIME);
        XSDTYPE.put("date", OXMLSequenceType.TDATE);
        XSDTYPE.put("gYearMonth", OXMLSequenceType.TGYEARMONTH);
        XSDTYPE.put("gYear", OXMLSequenceType.TGYEAR);
        XSDTYPE.put("gMonthDay", OXMLSequenceType.TGMONTHDAY);
        XSDTYPE.put("gDay", OXMLSequenceType.TGDAY);
        XSDTYPE.put("gMonth", OXMLSequenceType.TGMONTH);
        XSDTYPE.put("hexBinary", OXMLSequenceType.THEXBINARY);
        XSDTYPE.put("base64Binary", OXMLSequenceType.TBASE64BINARY);
        XSDTYPE.put("anyURI", OXMLSequenceType.TANYURI);
        XSDTYPE.put("NOTATION", OXMLSequenceType.TNOTATION);
        XSDTYPE.put("normalizedString", TNSTRING);
        XSDTYPE.put("token", TTOKEN);
        XSDTYPE.put("language", TLANGUAGE);
        XSDTYPE.put("NMTOKEN", TNMTOKEN);
        XSDTYPE.put("Name", TNAME);
        XSDTYPE.put("NCName", TNCNAME);
        XSDTYPE.put("ID", TID);
        XSDTYPE.put("IDREF", TIDREF);
        XSDTYPE.put("ENTITY", TENTITY);
        XSDTYPE.put("integer", OXMLSequenceType.TINTEGER);
        XSDTYPE.put("nonPositiveInteger", TNPINTEGER);
        XSDTYPE.put("negativeInteger", TNINTEGER);
        XSDTYPE.put("long", TLONG);
        XSDTYPE.put("int", TINT);
        XSDTYPE.put("short", TSHORT);
        XSDTYPE.put("byte", TBYTE);
        XSDTYPE.put("nonNegativeInteger", TNNINTEGER);
        XSDTYPE.put("unsignedLong", TULONG);
        XSDTYPE.put("unsignedInt", TUINT);
        XSDTYPE.put("unsignedShort", TUSHORT);
        XSDTYPE.put("unsignedByte", TUBYTE);
        XSDTYPE.put("positiveInteger", TPINTEGER);
    }
}

