/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor;

import oracle.dbtools.raptor.dialogs.dblink.TabbedOracleDblinkLauncher;
import oracle.dbtools.raptor.dialogs.mview.TabbedOracleMViewLauncher;
import oracle.dbtools.raptor.dialogs.plsql.PlSqlFunctionLauncher;
import oracle.dbtools.raptor.dialogs.plsql.PlSqlProcedureLauncher;
import oracle.dbtools.raptor.dialogs.sequence.TabbedOracleSequenceLauncher;
import oracle.dbtools.raptor.dialogs.synonym.TabbedOracleSynonymLauncher;
import oracle.dbtools.raptor.dialogs.table.TabbedOracleTableLauncher;
import oracle.dbtools.raptor.dialogs.type.PlSqlTypeLauncher;
import oracle.dbtools.raptor.dialogs.view.TabbedOracleViewLauncher;
import oracle.dbtools.raptor.utils.Translate;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controls.WaitCursor;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.Database;
import oracle.javatools.db.Sequence;
import oracle.javatools.db.Synonym;
import oracle.javatools.db.Table;
import oracle.javatools.db.View;
import oracle.javatools.db.ora.DatabaseLink;
import oracle.javatools.db.ora.MaterializedView;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.jdeveloper.cm.dt.ui.OracleDBWizardFactory;

public class RaptorWizardFactory
extends OracleDBWizardFactory {
    protected boolean createTable(Context ctx, OracleDatabase odb) {
        return TabbedOracleTableLauncher.createTable(ctx, odb);
    }

    protected boolean editTable(Database db, DBObject object) {
        return TabbedOracleTableLauncher.editTable((OracleDatabase)db, (Table)object);
    }

    protected boolean createView(Context ctx, OracleDatabase odb) {
        return TabbedOracleViewLauncher.createView(ctx, odb);
    }

    protected boolean editView(Database db, DBObject object) {
        return TabbedOracleViewLauncher.editView((OracleDatabase)db, (View)object);
    }

    protected boolean createMView(Context ctx, OracleDatabase odb) {
        return TabbedOracleMViewLauncher.createMView(ctx, odb);
    }

    protected boolean editMView(Database db, DBObject object) {
        return TabbedOracleMViewLauncher.editMView((OracleDatabase)db, (MaterializedView)object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean editTrigger(Context ctx, Database db, DBObject object) {
        OpenEditorOptions openEditorOptions = new OpenEditorOptions(ctx);
        openEditorOptions.setFlags(1);
        WaitCursor waitCursor = Ide.getWaitCursor();
        try {
            waitCursor.show(0L);
            EditorManager.getEditorManager().openEditor(openEditorOptions);
        }
        finally {
            waitCursor.hide();
        }
        return true;
    }

    protected boolean createSequence(Context ctx, OracleDatabase odb) {
        return TabbedOracleSequenceLauncher.createSequence(ctx, odb);
    }

    protected boolean editSequence(Database db, DBObject object) {
        return TabbedOracleSequenceLauncher.editSequence((OracleDatabase)db, (Sequence)object);
    }

    protected boolean createSynonym(Context ctx, OracleDatabase odb) {
        return TabbedOracleSynonymLauncher.createSynonym(ctx, odb);
    }

    protected boolean editSynonym(Database db, DBObject object) {
        return TabbedOracleSynonymLauncher.editSynonym((OracleDatabase)db, (Synonym)object);
    }

    public boolean canCreateDBObject(Context ctx, Database db, String dbObjectType) {
        return "DATABASE LINK".equals(dbObjectType) || "TYPE".equals(dbObjectType) ? true : super.canCreateDBObject(ctx, db, dbObjectType);
    }

    public boolean canEditDBObject(Context ctx, Database db, DBObject object) {
        String dbObjectType = object.getType();
        if ("TRIGGER".equals(dbObjectType)) {
            return true;
        }
        return super.canEditDBObject(ctx, db, object);
    }

    public boolean isCreateSupported(String dbObjectType) {
        return "MATERIALIZED VIEW".equals(dbObjectType) || "DATABASE LINK".equals(dbObjectType) || "TYPE".equals(dbObjectType) ? true : super.isCreateSupported(dbObjectType);
    }

    public String getCreateLabel(String string) {
        return Translate.translate("Create_" + string);
    }

    protected boolean createDblink(Context ctx, OracleDatabase odb) {
        return TabbedOracleDblinkLauncher.createDblink(ctx, odb);
    }

    protected boolean editDblink(Database db, DBObject object) {
        return TabbedOracleDblinkLauncher.editDblink((OracleDatabase)db, (DatabaseLink)object);
    }

    public boolean editDBObject(Context ctx, Database db, DBObject object) {
        String dbObjectType = object.getType();
        if ("TRIGGER".equals(dbObjectType)) {
            return this.editTrigger(ctx, db, object);
        }
        return super.editDBObject(ctx, db, object);
    }

    public boolean createDBObject(Context ctx, Database db, String type) {
        if ("FUNCTION".equals(type)) {
            return PlSqlFunctionLauncher.createFunction(ctx, (OracleDatabase)db);
        }
        if ("PROCEDURE".equals(type)) {
            return PlSqlProcedureLauncher.createProcedure(ctx, (OracleDatabase)db);
        }
        if ("TYPE".equals(type)) {
            return PlSqlTypeLauncher.createType(ctx, (OracleDatabase)db);
        }
        return super.createDBObject(ctx, db, type);
    }
}

