/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.config;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URL;
import javax.ide.util.Version;
import oracle.dbtools.raptor.dialogs.conn.RaptorConnectionStore;
import oracle.ide.ExtensionRegistry;
import oracle.ide.config.ClientSetting;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.webupdate.PostStartupHook;
import oracle.jdeveloper.cm.ConnectionDescriptor;
import oracle.jdeveloper.cm.ConnectionManager;
import oracle.jdeveloper.cm.ConnectionStore;
import oracle.jdeveloper.cm.DefaultConnectionStore;
import oracle.jdeveloper.cm.WritableConnectionStore;

public class ConnectionMigrator
implements PostStartupHook {
    public void install() {
        URL prev = null;
        prev = this.findPrevious("oracle.onlinedb");
        if (prev != null) {
            this.migrateConnections(prev);
            this.migrateSettings(prev, "oracle.onlinedb");
        }
        if ((prev = this.findPrevious("oracle.sqldeveloper")) != null) {
            this.migrateSettings(prev, "oracle.sqldeveloper");
        }
    }

    private URL findPrevious(String extID) {
        URL prev = null;
        URL extDir = ExtensionRegistry.getOracleRegistry().getSystemDirectory(extID);
        URL sysDir = URLFileSystem.getParent((URL)extDir);
        URL[] allVersions = URLFileSystem.list((URL)sysDir, (URLFilter)new ExtFilter(extID));
        if (allVersions != null) {
            Version myVer = ConnectionMigrator.getVersion(extDir, extID);
            for (URL dir : allVersions) {
                Version ver = ConnectionMigrator.getVersion(dir, extID);
                if (ver == null || ver.compareTo((Object)myVer) >= 0 || prev != null && ver.compareTo((Object)ConnectionMigrator.getVersion(prev, extID)) <= 0) continue;
                prev = dir;
            }
        }
        return prev;
    }

    private void migrateConnections(URL prev) {
        URL oldConns = URLFactory.newURL((URL)prev, (String)"IDEConnections.xml");
        ConnectionManager oldMgr = ConnectionManager.getPrivateInstance();
        oldMgr.setConnectionStore((ConnectionStore)new RaptorConnectionStore((WritableConnectionStore)new DefaultConnectionStore(URLFileSystem.getPlatformPathName((URL)oldConns), true)));
        ConnectionManager newMgr = ConnectionManager.getInstance();
        try {
            String[] dbNames = oldMgr.getConnectionNamesForClass("CLASS_DATABASE");
            for (int i = 0; i < dbNames.length; ++i) {
                ConnectionDescriptor cd = oldMgr.getConnectionDescriptor(dbNames[i]);
                newMgr.putConnectionDescriptor(cd.getConnectionName(), cd);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    private void migrateSettings(URL prev, String extID) {
        URL oldURL = URLFactory.newURL((URL)prev, (String)"preferences.xml");
        try {
            Class<ClientSetting> cls = ClientSetting.class;
            Constructor ctor = cls.getDeclaredConstructor(URL.class);
            ctor.setAccessible(true);
            ClientSetting oldSettings = (ClientSetting)ctor.newInstance(oldURL);
            ClientSetting settings = ClientSetting.findOrCreate((String)extID);
            oldSettings.copyTo((Object)settings);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Version getVersion(URL dir, String extID) {
        String verString;
        Version ver = null;
        String fName = URLFileSystem.getFileName((URL)dir);
        if (fName != null && fName.startsWith(extID) && (verString = fName.substring(extID.length() + 1)).length() > 0 && Character.isDigit(verString.charAt(0))) {
            ver = new Version(verString);
        }
        return ver;
    }

    private static class ExtFilter
    implements URLFilter {
        String _extID;

        private ExtFilter(String extID) {
            this._extID = extID;
        }

        public boolean accept(URL url) {
            String fName = URLFileSystem.getFileName((URL)url);
            if (fName != null) {
                String end = fName.startsWith(this._extID) ? fName.substring(this._extID.length() + 1) : "";
                return end.length() > 0 && Character.isDigit(end.charAt(0));
            }
            return false;
        }

        public boolean equals(Object o) {
            return o instanceof ExtFilter;
        }
    }
}

