/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.ide.controls.customtab.CustomTab;
import oracle.ide.controls.customtab.DefaultCustomTabPage;

public class CustomTabbedPane
extends JPanel {
    private CustomTab _customTab;
    private ArrayList _panels;
    private DefaultListModel _model;
    private int _selectedIdx = -1;
    private JPanel _content;
    private ArrayList<ChangeListener> _listeners = new ArrayList();

    public CustomTabbedPane() {
        this(new DefaultListModel(), 1);
    }

    public CustomTabbedPane(ListModel model, int position) {
        this._customTab = new CustomTab(model, 1);
        this._customTab.setCompressible(true);
        this._customTab.setGradientHighlight(true);
        this._model = (DefaultListModel)model;
        this._content = new JPanel(new CardLayout());
        this._content.setBackground(Color.RED);
        this.setLayout(new BorderLayout());
        this.add((Component)this._customTab, "North");
        this.add((Component)this._content, "Center");
        if (this._model.getSize() > 0) {
            for (int i = 0; i < this._model.getSize(); ++i) {
                ((JPanel)((DefaultCustomTabPage)this._model.get(i)).getUserObject()).setVisible(false);
                this._content.add((Component)((JPanel)((DefaultCustomTabPage)this._model.get(i)).getUserObject()), ((DefaultCustomTabPage)this._model.get(i)).getLabel());
            }
            this.setSelectedIndex(0);
        }
        this._customTab.addSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                int selectedIndex = CustomTabbedPane.this._customTab.getSelectedPage();
                DefaultCustomTabPage selectedPage = (DefaultCustomTabPage)CustomTabbedPane.this._customTab.getPage(selectedIndex);
                Object userObject = selectedPage.getUserObject();
                CustomTabbedPane.this.setSelectedIndex(selectedIndex);
            }
        });
    }

    public JComponent getActivePanel() {
        return (JComponent)this._content.getComponent(this._customTab.getSelectedPage());
    }

    public void setSelectedIndex(int selectedIndex) {
        if (this._customTab.getSelectedPage() != selectedIndex) {
            this._customTab.setSelectedPage(selectedIndex);
        }
        String label = ((DefaultCustomTabPage)this._model.get(selectedIndex)).getLabel();
        ((CardLayout)this._content.getLayout()).show(this._content, label);
        ((JComponent)this._content.getComponent(selectedIndex)).grabFocus();
        this._selectedIdx = selectedIndex;
        this.fireChangeListeners();
    }

    public void addTab(Icon icon, String title, JComponent panel) {
        DefaultCustomTabPage page = new DefaultCustomTabPage(icon, title, (Object)panel);
        page.setTooltip(title);
        this._model.addElement(page);
        this._content.add((Component)panel, title);
        this.setSelectedIndex(0);
    }

    public int getSelectedIndex() {
        return this._customTab.getSelectedPage();
    }

    public void removeChangeListener(ChangeListener sl) {
        this._listeners.remove(sl);
    }

    public void addChangeListener(ChangeListener sl) {
        this._listeners.add(sl);
    }

    public void fireChangeListeners() {
        for (int i = 0; i < this._listeners.size(); ++i) {
            this._listeners.get(i).stateChanged(new ChangeEvent(this));
        }
    }

    public static void main(String[] args) {
        CustomTabbedPane tabs = new CustomTabbedPane();
        for (int i = 1; i < 10; ++i) {
            JPanel panel = new JPanel(new BorderLayout());
            panel.setBackground(Color.BLUE);
            panel.add((Component)new JTextField("tab" + i), "Center");
            String title = "tab" + i;
            tabs.addTab(null, title, panel);
        }
        JDialog j = new JDialog();
        j.add(tabs);
        j.setSize(400, 400);
        j.setVisible(true);
    }

    public int getNumberOfTabs() {
        return this._customTab.getModel().getSize();
    }
}

