/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls;

import java.awt.Color;
import java.awt.Container;
import java.sql.Connection;
import java.text.Collator;
import java.util.Arrays;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import oracle.dbtools.raptor.controls.ConnectionSelectorUI;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.controls.JLabelListCellRenderer;
import oracle.javatools.db.Database;
import oracle.jdeveloper.cm.ConnectionDescriptor;
import oracle.jdeveloper.cm.ConnectionEvent;
import oracle.jdeveloper.cm.ConnectionListener;
import oracle.jdeveloper.cm.dt.ConnectionArb;
import oracle.jdeveloper.cm.dt.DatabaseConnectionNode;

public class DBConnectionComboBox {
    private JComboBox _dbConns;
    private Connections _conns;

    public DBConnectionComboBox() {
        this.init();
    }

    public DBConnectionComboBox(Container parent) {
        this.init();
        this.add(parent);
    }

    public void init() {
        this._conns = new Connections();
        this._dbConns = new JComboBox();
        this._dbConns.setRenderer(new JLabelListCellRenderer());
        this._conns.getCm().addConnectionListener((ConnectionListener)new ConnListener());
        this.populate();
    }

    public void setCurrentConnection(String s) {
        if (s != null) {
            for (int i = 0; i < this._dbConns.getItemCount(); ++i) {
                Object o = this._dbConns.getItemAt(i);
                if (!((JLabel)this._dbConns.getItemAt(i)).getText().equals(s)) continue;
                this._dbConns.setSelectedIndex(i);
                return;
            }
        }
        this._dbConns.setSelectedIndex(-1);
    }

    public JComboBox getJComboBox() {
        return this._dbConns;
    }

    public void add(Container parent) {
        parent.add(this._dbConns);
    }

    public DatabaseConnectionNode getCurrentConnectionNode() {
        return this._dbConns.getItemCount() > 0 ? this._conns.getDBConnectionNode(((JLabel)this._dbConns.getSelectedItem()).getText()) : null;
    }

    public Connection getCurrentConnection() {
        return this._dbConns.getItemCount() > 0 ? this._conns.getConnection(((JLabel)this._dbConns.getSelectedItem()).getText()) : null;
    }

    public Database getCurrentDatabase() {
        return this._dbConns.getItemCount() > 0 ? this._conns.getDatabase(((JLabel)this._dbConns.getSelectedItem()).getText()) : null;
    }

    public String getCurrentConnectionName() {
        String ret = null;
        try {
            ret = this._dbConns.getItemCount() > 0 ? ((JLabel)this._dbConns.getSelectedItem()).getText() : null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    private void resize() {
        for (int i = 0; i < this._dbConns.getItemCount(); ++i) {
            JLabel option = (JLabel)this._dbConns.getItemAt(i);
            option.setSize(option.getPreferredSize());
        }
        this._dbConns.setSize(this._dbConns.getPreferredSize());
        this._dbConns.setMaximumSize(this._dbConns.getPreferredSize());
    }

    private void populate() {
        Object conn = null;
        String[] names = this._conns.getConnNames();
        Arrays.sort(names, Collator.getInstance());
        for (int i = 0; conn == null && i < names.length; ++i) {
            this.addConnection(names[i]);
        }
    }

    public Connection getConnection(String connName) {
        return this._conns.getConnection(connName);
    }

    public String[] getConnNames() {
        return this._conns.getConnNames();
    }

    public void addConnection(String connName) {
        String curr = this.getCurrentConnectionName();
        boolean exists = false;
        for (int i = 0; i < this._dbConns.getItemCount(); ++i) {
            if (!((JLabel)this._dbConns.getItemAt(i)).getText().equals(connName)) continue;
            exists = true;
        }
        if (!exists) {
            boolean connOpen = this._conns.getDBConnectionNode(connName).isOpen();
            JLabel jt = null;
            jt = new JLabel();
            jt.setText(connName);
            jt.setToolTipText("Select this Connection");
            if (connOpen) {
                jt.setBackground(Color.RED);
            } else {
                jt.setBackground(Color.GREEN);
            }
            jt.setSize(jt.getPreferredSize());
            this._dbConns.addItem(jt);
            this.resize();
        }
        if (curr == null) {
            this.setCurrentConnection("");
        }
    }

    public void makeNewConnection() {
        String dbName = null;
        dbName = ConnectionSelectorUI.getConnection(ConnectionArb.getString((int)165), ConnectionArb.getString((int)164), dbName, "CLASS_DATABASE", true);
        this.setCurrentConnection(dbName);
    }

    public void removeConnection(String connName) {
        String curr = this.getCurrentConnectionName();
        this._dbConns.removeAllItems();
        this.populate();
        this.setCurrentConnection(curr);
        this.resize();
    }

    private class ConnListener
    implements ConnectionListener {
        private ConnListener() {
        }

        public void connectionAdded(ConnectionEvent connectionEvent) {
            String connName = ((ConnectionDescriptor)connectionEvent.getSource()).getConnectionName();
            DBConnectionComboBox.this.addConnection(connName);
        }

        public void connectionRemoved(ConnectionEvent connectionEvent) {
            String connName = ((ConnectionDescriptor)connectionEvent.getSource()).getConnectionName();
            DBConnectionComboBox.this.removeConnection(connName);
        }

        public void connectionModified(ConnectionEvent connectionEvent) {
        }

        public void connectionOpened(ConnectionEvent connectionEvent) {
        }

        public void connectionClosed(ConnectionEvent connectionEvent) {
        }
    }
}

