/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.KeyEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import oracle.dbtools.raptor.controls.IActionUpdater;
import oracle.dbtools.raptor.controls.ResultSetTable;
import oracle.dbtools.raptor.models.EditableResultSetTableModel;
import oracle.dbtools.raptor.models.ResultSetTableModel;
import oracle.dbtools.raptor.utils.Translate;
import oracle.ide.layout.ViewId;
import oracle.ide.log.DefaultLogPage;
import oracle.ide.log.LogManager;
import oracle.ide.log.LogPage;
import oracle.jdeveloper.cm.dt.ConnectionArb;

public class EditableResultSetTable
extends ResultSetTable {
    private String _nullValue = "(null)";
    private String _where;
    private static DataEditorLogPage _logPage;
    private IActionUpdater actionUpdater = null;
    private final KeyStroke tabKeyStroke = KeyStroke.getKeyStroke(9, 0);

    public EditableResultSetTable(IActionUpdater actionUpdater) {
        this.setSurrendersFocusOnKeystroke(true);
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.putClientProperty("JTable.autoStartsEdit", Boolean.TRUE);
        this.actionUpdater = actionUpdater;
        EditableResultSetCellRenderer renderer = new EditableResultSetCellRenderer();
        try {
            this.setDefaultRenderer(Class.forName("java.lang.Object"), renderer);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
        AWTEvent currentEvent = EventQueue.getCurrentEvent();
        if (currentEvent instanceof KeyEvent) {
            KeyEvent ke = (KeyEvent)currentEvent;
            if (ke.getSource() != this) {
                return;
            }
            if (rowIndex == 0 && columnIndex == 0 && KeyStroke.getKeyStrokeForEvent(ke).equals(this.tabKeyStroke)) {
                rowIndex = this.getRowCount();
                ((EditableResultSetTableModel)this.getModel()).addRow(rowIndex);
            }
        }
        super.changeSelection(rowIndex, columnIndex, toggle, extend);
    }

    public boolean isFocusCycleRoot() {
        return this.isEditing();
    }

    public void setValueAt(Object aValue, int row, int column) {
        super.setValueAt(aValue, row, column);
        this.actionUpdater.updateActions();
    }

    public boolean save() {
        TableModel model = this.getModel();
        boolean success = true;
        DataEditorLogPage logPage = this.getLogPage();
        logPage.log("\n\n");
        if (model instanceof EditableResultSetTableModel) {
            TableCellEditor cellEditor;
            if (this.isEditing() && (cellEditor = this.getCellEditor(this.getEditingRow(), this.getEditingColumn())) != null) {
                cellEditor.stopCellEditing();
            }
            EditableResultSetTableModel mdl = (EditableResultSetTableModel)model;
            mdl.setColumnModel(this.getColumnModel());
            int numErrors = mdl.save();
            logPage.show();
            logPage.activate();
            ArrayList log = mdl.getLog();
            for (int i = 0; i < log.size(); ++i) {
                if (log.get(i) == null) continue;
                logPage.log(log.get(i) + System.getProperty("line.separator"));
            }
            logPage.log(System.getProperty("line.separator"));
            if (numErrors > 0) {
                success = false;
                if (numErrors == 1) {
                    logPage.log(MessageFormat.format(ConnectionArb.getString((int)668), mdl.getTableName()) + System.getProperty("line.separator"));
                } else {
                    logPage.log(MessageFormat.format(ConnectionArb.getString((int)669), new Integer(numErrors), mdl.getTableName()) + System.getProperty("line.separator"));
                }
                for (int i = 0; i < mdl.getRowCount(); ++i) {
                    if (!mdl.isRowError(i)) continue;
                    logPage.log(MessageFormat.format(ConnectionArb.getString((int)670), new Integer(i + 1), mdl.getErrorMessage(i)));
                }
            } else {
                logPage.log(Translate.translate("Commit Successful") + System.getProperty("line.separator"));
            }
        }
        return success;
    }

    public boolean rollback() {
        TableModel model = this.getModel();
        boolean success = true;
        DataEditorLogPage logPage = this.getLogPage();
        logPage.clearAll();
        if (model instanceof EditableResultSetTableModel) {
            TableCellEditor cellEditor;
            if (this.isEditing() && (cellEditor = this.getCellEditor(this.getEditingRow(), this.getEditingColumn())) != null) {
                cellEditor.stopCellEditing();
            }
            EditableResultSetTableModel mdl = (EditableResultSetTableModel)model;
            int numErrors = mdl.rollback();
            logPage.show();
            logPage.activate();
            logPage.log(Translate.translate("Rollback Successful") + System.getProperty("line.separator"));
        }
        return success;
    }

    public boolean deleteRow() {
        int count = this.getSelectedRowCount();
        if (count < 1) {
            return true;
        }
        TableModel model = this.getModel();
        if (model instanceof EditableResultSetTableModel) {
            EditableResultSetTableModel mdl = (EditableResultSetTableModel)model;
            if (count == 1) {
                if (mdl.isRowDeleted(this.getSelectedRow())) {
                    mdl.markRowDeleted(this.getSelectedRow(), false);
                } else {
                    mdl.markRowDeleted(this.getSelectedRow(), true);
                }
            } else {
                int[] selections = this.getSelectedRows();
                for (int i = 0; i < count; ++i) {
                    if (mdl.isRowDeleted(selections[i])) {
                        mdl.markRowDeleted(selections[i], false);
                        continue;
                    }
                    mdl.markRowDeleted(selections[i], true);
                }
            }
            this.repaint();
        }
        return true;
    }

    public boolean insertRow() {
        TableModel model;
        TableCellEditor cellEditor;
        int selection = this.getSelectedRow();
        if (selection < 0) {
            selection = 0;
        }
        if (this.isEditing() && (cellEditor = this.getCellEditor(this.getEditingRow(), this.getEditingColumn())) != null) {
            cellEditor.stopCellEditing();
        }
        if ((model = this.getModel()) instanceof EditableResultSetTableModel) {
            EditableResultSetTableModel mdl = (EditableResultSetTableModel)model;
            mdl.addRow(selection);
            this.changeSelection(selection, 0, false, false);
            this.actionUpdater.updateActions();
            this.repaint();
        }
        return true;
    }

    public void setInsertOnly() {
        TableModel model = this.getModel();
        if (model instanceof EditableResultSetTableModel) {
            EditableResultSetTableModel mdl = (EditableResultSetTableModel)model;
            mdl.setInsertOnly();
        }
    }

    public boolean getChanged() {
        TableModel model = this.getModel();
        if (model instanceof EditableResultSetTableModel) {
            EditableResultSetTableModel mdl = (EditableResultSetTableModel)model;
            return mdl.getChanged();
        }
        return false;
    }

    public boolean getValid() {
        TableModel model = this.getModel();
        if (model instanceof EditableResultSetTableModel) {
            EditableResultSetTableModel mdl = (EditableResultSetTableModel)model;
            return mdl.getValid();
        }
        return false;
    }

    public boolean getUpdatedByAnotherUser() {
        TableModel model = this.getModel();
        if (model instanceof EditableResultSetTableModel) {
            EditableResultSetTableModel mdl = (EditableResultSetTableModel)model;
            return mdl.getUpdatedByAnotherUser();
        }
        return false;
    }

    public void setChanged(boolean changed) {
        TableModel model = this.getModel();
        if (model instanceof EditableResultSetTableModel) {
            EditableResultSetTableModel mdl = (EditableResultSetTableModel)model;
            mdl.setChanged(changed);
        }
    }

    public void showLogPage(boolean show) {
        if (this.getLogPage() != null) {
            if (show) {
                this.getLogPage().show();
            } else {
                this.getLogPage().close();
            }
        }
    }

    public String getColumnDBName(int col) {
        TableModel model = this.getModel();
        if (model instanceof ResultSetTableModel) {
            ResultSetTableModel mdl = (ResultSetTableModel)model;
            return mdl.getRawColumnName(col);
        }
        return null;
    }

    public void setOrderBy(String orderBy) {
        TableModel model = this.getModel();
        if (model instanceof ResultSetTableModel) {
            ResultSetTableModel mdl = (ResultSetTableModel)model;
            mdl.setOrderBy(orderBy);
        }
    }

    public void setWhere(String where) {
        TableModel model = this.getModel();
        if (model instanceof ResultSetTableModel) {
            ResultSetTableModel mdl = (ResultSetTableModel)model;
            mdl.setWhere(where);
        }
    }

    private DataEditorLogPage getLogPage() {
        if (_logPage != null) {
            return _logPage;
        }
        LogManager logManager = LogManager.getLogManager();
        if (logManager != null) {
            TableModel model = this.getModel();
            if (model instanceof EditableResultSetTableModel) {
                EditableResultSetTableModel mdl = (EditableResultSetTableModel)model;
                _logPage = new DataEditorLogPage(mdl.getTableName());
                logManager.addPage((LogPage)_logPage);
            }
            return _logPage;
        }
        return null;
    }

    private final class DataEditorLogPage
    extends DefaultLogPage {
        public DataEditorLogPage(String tablename) {
            super(new ViewId("DataEditorLogPage", "Data Editor"), null, false, HIDE_FIX_SOURCE_MENU);
        }
    }

    private class EditableResultSetCellRenderer
    extends DefaultTableCellRenderer {
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component cell = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            TableModel model = table.getModel();
            cell.setFont(cell.getFont().deriveFont(8));
            if (model instanceof EditableResultSetTableModel) {
                EditableResultSetTableModel mdl = (EditableResultSetTableModel)model;
                if (mdl.isRowDeleted(row) && !table.isRowSelected(row)) {
                    cell.setForeground(Color.lightGray);
                } else if (!table.isRowSelected(row)) {
                    cell.setForeground(Color.black);
                }
                if (mdl.isRowError(row) && !table.isRowSelected(row)) {
                    cell.setBackground(Color.red);
                } else if (!table.isRowSelected(row)) {
                    if (!mdl.isCellEditable(row, column + 1)) {
                        cell.setBackground(new Color(230, 230, 230));
                    } else {
                        cell.setBackground(Color.white);
                    }
                }
            }
            return cell;
        }
    }
}

