/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import oracle.dbtools.raptor.utils.SpringUtilities;
import oracle.dbtools.raptor.utils.Translate;

public class PropertyPanel
extends JPanel {
    private String _helpId = null;
    private JPanel _northPanel;
    private int _northRows = 0;
    private JPanel _southPanel;
    private GridLayout _northGrid;

    public PropertyPanel() {
        this.init();
        this.addMouseListener(new DebugMouseListener(this));
    }

    private void add(JComponent comp) {
        this._northPanel.add(comp);
    }

    public void addSingleComp(String value) {
        JLabel label = new JLabel();
        label.setText(value == null ? "" : value.toString());
        label.setSize(200, label.getSize().height);
        this._southPanel.add(label);
    }

    public void addSingleComp(JComponent comp) {
        this._southPanel.add(comp);
    }

    public void addValueAsLabel(String name, Object value) {
        JLabel label = new JLabel();
        label.setText(value == null ? "" : value.toString());
        label.setSize(200, label.getSize().height);
        this.addComp(name, label);
    }

    public void addItem(String name, Object value) {
        this.addValueAsLabel(name, value);
    }

    public void addComp(String label, JComponent comp) {
        JLabel l = new JLabel(Translate.translate(label));
        l.setSize(l.getPreferredSize());
        this._northPanel.add(l);
        this._northPanel.add(comp);
        ++this._northRows;
        SpringUtilities.makeCompactGrid(this._northPanel, this._northRows, 2, 0, 0, 6, 6);
    }

    private void init() {
        this._northPanel = new JPanel();
        this._southPanel = new JPanel();
        this._northPanel.setLayout(new SpringLayout());
        this._southPanel.setLayout(new GridLayout(0, 1));
        this.setLayout(new BorderLayout());
        this.add((Component)this._northPanel, "North");
        this.add((Component)this._southPanel, "South");
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (this._northPanel != null) {
            this._northPanel.setBackground(color);
        }
        if (this._southPanel != null) {
            this._southPanel.setBackground(color);
        }
    }

    public void removeAll() {
        this._northPanel.removeAll();
        this._northRows = 0;
        this._southPanel.removeAll();
    }

    private class DebugMouseListener
    implements MouseListener {
        private JPanel _panel = null;
        private Color[] colors = new Color[]{Color.RED, Color.BLACK, Color.BLUE, Color.ORANGE, Color.YELLOW};
        private int colorIdx = 0;

        public DebugMouseListener(JPanel panel) {
            this._panel = panel;
        }

        public void mouseClicked(MouseEvent e) {
            if (e.isControlDown() && e.isAltDown()) {
                this.colorIdx = 0;
                this.processPanel(this._panel, this.colors[this.colorIdx]);
            }
        }

        public void processPanel(JPanel panel, Color color) {
            int cnt = panel.getComponentCount();
            if (panel.getBorder() == null) {
                panel.setBorder(BorderFactory.createLineBorder(color));
                ++this.colorIdx;
                for (int i = 0; i < cnt; ++i) {
                    if (panel.getComponent(i) instanceof JPanel) {
                        this.processPanel((JPanel)panel.getComponent(i), this.colors[this.colorIdx++]);
                        continue;
                    }
                    if (!(panel.getComponent(i) instanceof JComponent)) continue;
                    ((JComponent)panel.getComponent(i)).setBorder(BorderFactory.createLineBorder(color));
                }
            } else {
                for (int i = 0; i < cnt; ++i) {
                    panel.setBorder(null);
                    if (panel.getComponent(i) instanceof JPanel) {
                        this.processPanel((JPanel)panel.getComponent(i), this.colors[this.colorIdx++]);
                        continue;
                    }
                    if (!(panel.getComponent(i) instanceof JComponent)) continue;
                    ((JComponent)panel.getComponent(i)).setBorder(null);
                }
            }
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }
    }
}

