/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SpringLayout;
import oracle.dbtools.raptor.utils.SpringUtilities;

public class RadioGroupPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private ButtonGroup group;
    private ArrayList<JRadioButton> buttons;
    private ArrayList<ActionListener> _listeners;
    private ActionListener _listener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            for (int i = 0; RadioGroupPanel.this._listeners != null && i < RadioGroupPanel.this._listeners.size(); ++i) {
                ((ActionListener)RadioGroupPanel.this._listeners.get(i)).actionPerformed(e);
            }
        }
    };

    public RadioGroupPanel(String values) {
        super(new SpringLayout());
        this.process(values);
    }

    public void process(String s) {
        String[] values = s.substring(7).split(":");
        this.group = new ButtonGroup();
        this.buttons = new ArrayList();
        int cols = 0;
        for (int ii = 0; ii < values.length; ++ii) {
            ++cols;
            JRadioButton button = new JRadioButton(values[ii]);
            button.addActionListener(this._listener);
            if (ii == 0) {
                button.setSelected(true);
            }
            this.group.add(button);
            this.add(button);
            this.buttons.add(button);
        }
        SpringUtilities.makeCompactGrid(this, 1, cols, 0, 0, 1, 1);
    }

    public void setSelectedValue(String s) {
        for (int i = 0; i < this.buttons.size(); ++i) {
            if (!this.buttons.get(i).getText().equals(s)) continue;
            this.buttons.get(i).setSelected(true);
        }
    }

    public String getSelectedValue() {
        String ret = null;
        for (int i = 0; i < this.buttons.size(); ++i) {
            if (!this.buttons.get(i).isSelected()) continue;
            ret = this.buttons.get(i).getText();
        }
        return ret;
    }

    public void addActionListener(ActionListener l) {
        if (this._listeners == null) {
            this._listeners = new ArrayList();
        }
        this._listeners.add(l);
    }
}

