/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.utils.CMHelper;
import oracle.ide.model.Node;
import oracle.ide.util.dnd.TransferableTreeNode;
import oracle.ide.util.dnd.TransferablesList;
import oracle.ideimpl.explorer.dnd.MultiTransferable;
import oracle.javatools.db.Column;
import oracle.javatools.db.Function;
import oracle.javatools.db.PlSqlParameter;
import oracle.javatools.db.Procedure;
import oracle.javatools.db.SchemaObject;
import oracle.jdeveloper.cm.dt.browser.RelationNode;
import oracle.jdeveloper.cm.dt.browser.jdbc.PlSqlBaseNode;

public class RaptorDnD
extends DropTargetAdapter {
    private JTextComponent _target;

    public RaptorDnD(JTextComponent target) {
        this._target = target;
        this.init();
    }

    private void init() {
        DropTarget dt = new DropTarget(this._target, 1, this, true, null);
    }

    public void dragOver(DropTargetDragEvent dtde) {
        int loc = this._target.viewToModel(dtde.getLocation());
        this._target.setCaretPosition(loc);
    }

    public void drop(DropTargetDropEvent dtde) {
        Document doc = this._target.getDocument();
        int loc = this._target.viewToModel(dtde.getLocation());
        Object o = dtde.getSource();
        Transferable tr = dtde.getTransferable();
        DataFlavor[] flas = tr.getTransferDataFlavors();
        this._target.setAutoscrolls(true);
        try {
            if (tr.isDataFlavorSupported(TransferablesList.TRANSFERABLE_LIST_FLAVOR) || tr.isDataFlavorSupported(TransferableTreeNode.TREE_NODE_FLAVOR)) {
                doc.insertString(loc, this.nodeDrop(tr, loc), null);
            } else if (tr.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                doc.insertString(loc, (String)tr.getTransferData(DataFlavor.stringFlavor), null);
            }
            this._target.setCaretPosition(loc);
        }
        catch (UnsupportedFlavorException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    private String nodeDrop(Transferable tr, int loc) throws UnsupportedFlavorException, IOException {
        ArrayList<DefaultMutableTreeNode> nodes = new ArrayList<DefaultMutableTreeNode>();
        String ret = null;
        if (tr.isDataFlavorSupported(TransferablesList.TRANSFERABLE_LIST_FLAVOR)) {
            nodes.addAll((Collection<DefaultMutableTreeNode>)((TransferablesList)tr.getTransferData(TransferablesList.TRANSFERABLE_LIST_FLAVOR)));
        } else {
            nodes.add((DefaultMutableTreeNode)tr.getTransferData(TransferableTreeNode.TREE_NODE_FLAVOR));
        }
        StringBuilder sql = new StringBuilder();
        for (int i = 0; i < nodes.size(); ++i) {
            Object transferObject = null;
            DefaultMutableTreeNode node = null;
            node = nodes.get(i) instanceof MultiTransferable ? (DefaultMutableTreeNode)((MultiTransferable)nodes.get(i)).getTransferData(TransferableTreeNode.TREE_NODE_FLAVOR) : (DefaultMutableTreeNode)nodes.get(i);
            transferObject = node.getUserObject();
            if (transferObject instanceof RelationNode) {
                sql.append(this.getRelationDrop((RelationNode)transferObject));
                continue;
            }
            if (transferObject instanceof PlSqlBaseNode) {
                SchemaObject so = CMHelper.getbaseObject((Node)((PlSqlBaseNode)transferObject));
                if (so instanceof Procedure) {
                    sql.append(this.getProcedureDrop((Procedure)so));
                    continue;
                }
                if (!(so instanceof Function)) continue;
                sql.append(this.getFunctionDrop((Function)so));
                continue;
            }
            sql.append(transferObject.toString() + ",");
        }
        if (sql.charAt(sql.length() - 1) == ',') {
            sql.setLength(sql.length() - 1);
        }
        if (sql.length() > 1) {
            ret = sql.toString();
        }
        return ret;
    }

    private String getFunctionDrop(Function function) {
        StringBuilder sb = new StringBuilder("ret/*" + function.getReturnType() + "*/ := " + DBUtil.enquote(function.getSchema().getName()) + "." + DBUtil.enquote(function.getName()));
        PlSqlParameter[] params = function.getParameters();
        for (int i = 0; i < params.length; ++i) {
            if (i == 0) {
                sb.append("(");
            }
            sb.append(DBUtil.enquote(params[i].getName()) + "/*" + params[i].getDataType().getName() + "*/");
            if (i != params.length - 1) {
                sb.append(",");
                continue;
            }
            sb.append(")");
        }
        sb.append(";\n");
        return sb.toString();
    }

    public String getRelationDrop(RelationNode rn) {
        StringBuilder sql = new StringBuilder("select ");
        Column[] cols = rn.getRelation().getColumns();
        for (int i = 0; i < cols.length; ++i) {
            sql.append(DBUtil.enquote(cols[i].getName()));
            if (i == cols.length - 1) continue;
            sql.append(",");
        }
        sql.append(" from " + DBUtil.enquote(rn.getRelation().getSchema().getName()) + "." + DBUtil.enquote(rn.getRelation().getName()) + ";\n");
        return sql.toString();
    }

    public String getProcedureDrop(Procedure proc) {
        StringBuilder sb = new StringBuilder(DBUtil.enquote(proc.getSchema().getName()) + "." + DBUtil.enquote(proc.getName()));
        PlSqlParameter[] params = proc.getParameters();
        for (int i = 0; i < params.length; ++i) {
            if (i == 0) {
                sb.append("(");
            }
            sb.append(DBUtil.enquote(params[i].getName()) + "/*" + params[i].getDataType().getName() + "*/");
            if (i != params.length - 1) {
                sb.append(",");
                continue;
            }
            sb.append(")");
        }
        sb.append(";\n");
        return sb.toString();
    }
}

