/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.FileNotFoundException;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.dbtools.raptor.controls.ColumnAutoSize;
import oracle.dbtools.raptor.controls.CopyableResultSetTableAdapter;
import oracle.dbtools.raptor.controls.IResultSetTableDrillDown;
import oracle.dbtools.raptor.controls.cellrenderers.DefaultCellRenderer;
import oracle.dbtools.raptor.dialogs.actions.TableExportAction;
import oracle.dbtools.raptor.models.EditableResultSetTableModel;
import oracle.dbtools.raptor.models.ResultSetTableColumnModel;
import oracle.dbtools.raptor.models.ResultSetTableModel;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.NLSUtils;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.controls.KeyNavigationManager;
import oracle.ide.controls.WaitCursor;
import oracle.ide.marshal.xml.Object2Dom;
import oracle.ide.model.Node;
import oracle.ide.net.URLFactory;
import oracle.ide.util.Assert;
import oracle.ide.util.SwingWorker;
import oracle.ide.xml.XMLUtil;
import oracle.javatools.controls.nicetable.NiceTablePersistentSettings;
import oracle.javatools.db.Database;
import oracle.jdeveloper.cm.dt.browser.jdbc.JdbcNodeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultSetTable
extends JTable {
    private static IResultSetTableDrillDown _drillDown;
    private static final int ROW_NUMBER_WIDTH = 40;
    private static final int ROW_HEIGHT = 20;
    private String _sql;
    private JTable _rowHeader;
    private Object LOCK = new Object();
    private volatile SwingWorker _worker;
    private JPopupMenu _gridCtxMenu;
    private ResultSetTablePersistenceInvoker persistenceInvoker = new ResultSetTablePersistenceInvoker();
    private static final String NAMESPACE_URI;
    private static final String ROOT_TAG = "TableSettings";
    private KeyNavigationManager _knm;
    private CopyableResultSetTableAdapter _copyAdapter;
    private String _defaultExportName;
    private boolean _translatedColNames = true;
    private boolean _threaded = true;
    private boolean _verticalDisplay = false;
    private ArrayList<String> _skipCols;
    private TableExportAction _tabExpAct;
    private KeyStroke copy = KeyStroke.getKeyStroke(67, 2, false);
    private KeyStroke fetchAll = KeyStroke.getKeyStroke(34, 2, false);
    private KeyStroke fetchEndAll = KeyStroke.getKeyStroke(35, 2, false);
    private ActionListener _copyListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            ResultSetTable.this.setRowSelectionAllowed(false);
            ResultSetTable.this._copyAdapter.setNullString("");
            ResultSetTable.this._copyAdapter.copyToClipboard();
            ResultSetTable.this.setRowSelectionAllowed(false);
            ResultSetTable.this.setColumnSelectionAllowed(false);
            ResultSetTable.this.setCellSelectionEnabled(true);
        }
    };

    public ResultSetTable() {
        this(true);
    }

    public ResultSetTable(boolean initMenu) {
        if (this._tabExpAct == null) {
            this._tabExpAct = new TableExportAction();
        }
        this.setColumnModel(new ResultSetTableColumnModel(this));
        this.setAutoResizeMode(0);
        this.setDefaultRenderer(TableColumn.class, new DefaultCellRenderer());
        if (initMenu) {
            this.createContextMenu();
        }
        this.getTableHeader().addMouseListener(new ColumnAutoSize());
        this.getTableHeader().addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
                JTable table;
                if (e.getSource() instanceof JTableHeader && (table = ((JTableHeader)e.getSource()).getTable()).isEditing()) {
                    table.getCellEditor().stopCellEditing();
                }
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }
        });
        this.getTableHeader().addMouseListener(this.persistenceInvoker);
        this.getColumnModel().addColumnModelListener(this.persistenceInvoker);
        this.setCellSelectionEnabled(true);
        this.setColumnSelectionAllowed(true);
        this.setRowSelectionAllowed(true);
        this.setRowHeight(20);
        this._knm = new KeyNavigationManager((KeyNavigationManager.KeyComponentAdapter)new KeyNavigationManager.TableKeyAdapter((JTable)this));
        this.registerKeyboardAction(this._copyListener, "Copy", this.copy, 0);
        this.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ResultSetTable.this.fetchAll();
            }
        }, "FetchAll", this.fetchAll, 0);
        this.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ResultSetTable.this.fetchAll();
            }
        }, "FetchAll", this.fetchEndAll, 0);
        this._copyAdapter = new CopyableResultSetTableAdapter(this);
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && _drillDown != null && ResultSetTable.this.getModel() instanceof ResultSetTableModel) {
                    ResultSetTableModel mdl = (ResultSetTableModel)ResultSetTable.this.getModel();
                    int rowIndex = ResultSetTable.this.getSelectionModel().getAnchorSelectionIndex();
                    if (rowIndex > -1 && mdl.getDrillUrls().size() > rowIndex) {
                        URL url = mdl.getDrillUrls().get(rowIndex);
                        Node node = JdbcNodeFactory.getNode((Database)Connections.getInstance().getDatabase(mdl.getConnName()), (URL)url);
                        if (node != null) {
                            _drillDown.performDrill(node);
                        }
                    }
                }
            }
        });
    }

    public TableExportAction getTableExporter() {
        return this._tabExpAct;
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        if (this._knm != null) {
            this._knm.preProcessKeyEvent(e);
        }
        super.processKeyEvent(e);
        if (this._knm != null) {
            this._knm.postProcessKeyEvent(e);
        }
    }

    public void setDefaultExportName(String name) {
        this._defaultExportName = name;
    }

    public String getDefaultExportName() {
        return this._defaultExportName;
    }

    private void createContextMenu() {
        if (this._gridCtxMenu == null) {
            this._gridCtxMenu = new JPopupMenu("Context Menu");
            this._tabExpAct.setTable(this);
            this._gridCtxMenu.add(this._tabExpAct.getMenu());
            this.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    int nModifier = e.getModifiers();
                    if ((nModifier & 8) != 0 || (nModifier & 4) != 0) {
                        if (ResultSetTable.this.getModel() instanceof ResultSetTableModel) {
                            ResultSetTable.this._tabExpAct.setSql(((ResultSetTableModel)ResultSetTable.this.getModel()).getSQL());
                        }
                        JTable table = (JTable)e.getSource();
                        if (ResultSetTable.this._gridCtxMenu.getComponentCount() == 0) {
                            ResultSetTable.this._gridCtxMenu.add(ResultSetTable.this._tabExpAct.getMenu());
                        }
                        ResultSetTable.this._gridCtxMenu.show(table, e.getX(), e.getY());
                    }
                }
            });
        }
    }

    public void refresh() {
        TableModel mdl = this.getModel();
        if (mdl instanceof ResultSetTableModel) {
            ((ResultSetTableModel)mdl).refresh();
            this.applyPersistentSettings();
        }
    }

    @Override
    public void setModel(TableModel mdl) {
        TableModel oldModel = this.getModel();
        if (oldModel != mdl && oldModel instanceof ResultSetTableModel) {
            ((ResultSetTableModel)oldModel).close();
        }
        super.setModel(mdl);
        if (this._rowHeader != null) {
            this._rowHeader.setModel(mdl);
        }
        if (mdl instanceof ResultSetTableModel) {
            this._sql = ((ResultSetTableModel)mdl).getSQL();
            if (this._sql != null) {
                this.applyPersistentSettings();
            }
        }
    }

    public void setQuery(Connection conn, ResultSet rs, String sql, HashMap binds) {
        ResultSetTableModel mdl;
        if (this.getModel() != null && this.getModel() instanceof ResultSetTableModel) {
            mdl = (ResultSetTableModel)this.getModel();
            mdl.close();
        } else {
            mdl = new ResultSetTableModel();
        }
        mdl.setConn(conn);
        mdl.setSql(sql);
        mdl.setBindMap(binds);
        mdl.setTranslatedColNames(this._translatedColNames);
        mdl.setThreaded(this.isThreaded());
        mdl.setVerticalDisplay(this._verticalDisplay);
        mdl.setSkipCols(this._skipCols);
        mdl.open();
        this.setModel(mdl);
        this._tabExpAct.setConn(conn);
        this._tabExpAct.setSql(sql);
        this._tabExpAct.setBindMap(binds);
    }

    public void setQuery(Connection conn, ResultSet rs, String sql) {
        this.setQuery(conn, rs, sql, (HashMap)null);
        this._tabExpAct.setConn(conn);
        this._tabExpAct.setSql(sql);
    }

    public void setQuery(Connection conn, ResultSet rs, String sql, ArrayList binds) {
        ResultSetTableModel mdl = this.getModel() != null && this.getModel() instanceof ResultSetTableModel ? (ResultSetTableModel)this.getModel() : new ResultSetTableModel();
        mdl.setConn(conn);
        mdl.setSql(sql);
        mdl.setBindList(binds);
        mdl.setTranslatedColNames(this._translatedColNames);
        mdl.setThreaded(this.isThreaded());
        mdl.setSkipCols(this._skipCols);
        mdl.open();
        mdl.setVerticalDisplay(this._verticalDisplay);
        this.setModel(mdl);
        this._tabExpAct.setConn(conn);
        this._tabExpAct.setSql(sql);
        this._tabExpAct.setBindList(binds);
    }

    public void setQuery(Connection conn, ResultSet rs, String sql, boolean editable, Database db) {
        if (editable) {
            EditableResultSetTableModel mdl = new EditableResultSetTableModel(conn, rs, sql, db);
            this.setModel(mdl);
            this._tabExpAct.setConn(conn);
            this._tabExpAct.setSql(sql);
        } else {
            this.setQuery(conn, rs, sql);
            this._tabExpAct.setConn(conn);
            this._tabExpAct.setSql(sql);
        }
    }

    public JTable getRowHeader() {
        if (this._rowHeader == null) {
            this._rowHeader = new JTable();
            this._rowHeader.setRowHeight(20);
            this._rowHeader.setColumnModel(new RowHeaderTableColumnModel());
            this._rowHeader.setModel(this.getModel());
            this._rowHeader.setSelectionModel(this.getSelectionModel());
            this._rowHeader.setAutoResizeMode(0);
            this._rowHeader.setColumnSelectionAllowed(false);
            this._rowHeader.setCellSelectionEnabled(false);
            this._rowHeader.setSelectionBackground(this._rowHeader.getBackground());
            this._rowHeader.setMaximumSize(new Dimension(40, Integer.MAX_VALUE));
            this._rowHeader.addHierarchyListener(new HierarchyListener(){
                private JViewport view;

                public void hierarchyChanged(HierarchyEvent e) {
                    for (Container parent = ResultSetTable.this._rowHeader.getParent(); parent != null; parent = parent.getParent()) {
                        if (!(parent instanceof JViewport)) continue;
                        if (this.view == parent) break;
                        this.view = (JViewport)parent;
                        this.view.setPreferredSize(ResultSetTable.this._rowHeader.getMaximumSize());
                        break;
                    }
                }
            });
            this._rowHeader.registerKeyboardAction(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ResultSetTable.this.fetchAll();
                }
            }, "FetchAll", this.fetchAll, 0);
            this._rowHeader.registerKeyboardAction(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ResultSetTable.this.fetchAll();
                }
            }, "FetchAll", this.fetchEndAll, 0);
        }
        return this._rowHeader;
    }

    public void closeModel() {
        this.setModel(this.createDefaultDataModel());
    }

    public void fetchAll() {
        TableModel model = this.getModel();
        if (model instanceof ResultSetTableModel) {
            final ResultSetTableModel rsModel = (ResultSetTableModel)model;
            final boolean priorThread = rsModel.getThreaded();
            rsModel.setThreaded(true);
            rsModel.fetchAll();
            Runnable scroller = new Runnable(){
                int lastScroll = 0;

                public void run() {
                    rsModel.setThreaded(priorThread);
                    if (this.lastScroll != rsModel.getLoadedCount()) {
                        Assert.println((String)("Scrolling to:" + rsModel.getLoadedCount()));
                        ResultSetTable.this.scrollToRow(rsModel.getLoadedCount());
                        this.lastScroll = rsModel.getLoadedCount();
                    }
                    if (!rsModel.allFetched()) {
                        SwingUtilities.invokeLater(this);
                    }
                }
            };
            SwingUtilities.invokeLater(scroller);
        }
    }

    public void scrollToRow(int row) {
        JViewport viewport = (JViewport)this.getParent();
        Rectangle rect = this.getCellRect(row, 0, true);
        Rectangle viewRect = viewport.getViewRect();
        rect.setLocation(rect.x - viewRect.x, rect.y - viewRect.y);
        viewport.scrollRectToVisible(rect);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void selectAll() {
        Object object = this.LOCK;
        synchronized (object) {
            this._worker = new SwingWorker(){
                WaitCursor wc;

                public Object construct() {
                    this.wc = Ide.getWaitCursor();
                    this.wc.show(500L);
                    TableModel model = ResultSetTable.this.getModel();
                    if (model instanceof ResultSetTableModel) {
                        ResultSetTableModel rsModel = (ResultSetTableModel)model;
                        rsModel.fetchAll();
                    }
                    return this;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void finished() {
                    ResultSetTable.this.superSelectAll();
                    this.wc.hide();
                    Object object = ResultSetTable.this.LOCK;
                    synchronized (object) {
                        ResultSetTable.this._worker = null;
                    }
                }
            };
            this._worker.start();
        }
    }

    private void superSelectAll() {
        super.selectAll();
    }

    void savePersistentSettings() {
        final NiceTablePersistentSettings settings = this.getPersistentSettings();
        final URL url = this._getSaveURL();
        final Object2Dom o2d = Object2Dom.newInstance();
        o2d.setNamespaceURI(NAMESPACE_URI);
        this._worker = new SwingWorker(){

            public Object construct() {
                try {
                    o2d.toDocument((Object)settings, ResultSetTable.ROOT_TAG, url);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                return this;
            }
        };
        this._worker.start();
    }

    void applyDefaultSettings() {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            TableColumn column = this.getColumnModel().getColumn(i);
            column.setPreferredWidth(this.getRequiredColumnWidth(column));
        }
    }

    int getRequiredColumnWidth(TableColumn column) {
        int col = this.getColumnModel().getColumnIndex(column.getIdentifier());
        int width = (int)this.getDefaultRenderer(column.getClass()).getTableCellRendererComponent(this, column.getIdentifier(), false, false, -1, col).getPreferredSize().getWidth();
        int count = this.getModel() instanceof ResultSetTableModel ? ((ResultSetTableModel)this.getModel()).getLoadedCount() : this.getRowCount();
        for (int row = 0; row < count; ++row) {
            int preferedWidth = (int)this.getCellRenderer(row, col).getTableCellRendererComponent(this, this.getValueAt(row, col), false, false, row, col).getPreferredSize().getWidth();
            width = Math.max(width, preferedWidth);
        }
        if (width > 200) {
            width = 200;
        }
        return width;
    }

    void applyPersistentSettings() {
        NiceTablePersistentSettings settings = null;
        try {
            URL url = this._getSaveURL();
            if (url != null) {
                Object2Dom o2d = Object2Dom.newInstance();
                settings = (NiceTablePersistentSettings)o2d.toObject(url);
            }
        }
        catch (FileNotFoundException ex) {
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (settings != null) {
            this.setPersistentSettings(settings);
        } else {
            this.applyDefaultSettings();
        }
    }

    private NiceTablePersistentSettings getPersistentSettings() {
        int i;
        NiceTablePersistentSettings settings = new NiceTablePersistentSettings();
        int[] widths = new int[this.getModel().getColumnCount()];
        ArrayList<Object> order = new ArrayList<Object>();
        for (i = 0; i < this.getModel().getColumnCount(); ++i) {
            int viewColumn = this.convertColumnIndexToView(i);
            TableColumn tc = null;
            if (viewColumn != -1) {
                tc = this.getTableHeader().getColumnModel().getColumn(viewColumn);
            }
            widths[i] = tc == null ? 0 : tc.getWidth();
        }
        for (i = 0; i < this.getColumnModel().getColumnCount(); ++i) {
            TableColumn col = this.getColumnModel().getColumn(i);
            Object id = col.getIdentifier();
            order.add(id);
        }
        settings.setColumnWidths(widths);
        settings.setColumnPositions(order);
        return settings;
    }

    private void setPersistentSettings(NiceTablePersistentSettings settings) {
        for (int i = 0; i < settings.getColumnWidths().length; ++i) {
            int viewColumn = this.convertColumnIndexToView(i);
            TableColumn tc = null;
            if (viewColumn != -1) {
                tc = this.getTableHeader().getColumnModel().getColumn(viewColumn);
            }
            if (tc == null) continue;
            tc.setPreferredWidth(settings.getColumnWidths()[i]);
        }
        List positions = settings.getColumnPositions();
        try {
            if (positions != null) {
                for (int pos = 0; pos < positions.size(); ++pos) {
                    int oldPos = this.getColumnModel().getColumnIndex(positions.get(pos));
                    if (oldPos == pos) continue;
                    this.getColumnModel().moveColumn(oldPos, pos);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private URL _getSaveURL() {
        ExtensionRegistry er = ExtensionRegistry.getOracleRegistry();
        if (er.findExtension("oracle.sqldeveloper") != null) {
            URL url = er.getSystemDirectory("oracle.sqldeveloper");
            return URLFactory.newURL((URL)url, (String)(this._sql.hashCode() + "TableSettings.xml"));
        }
        return null;
    }

    public void setTranslatedColNames(boolean _translatedColNames) {
        this._translatedColNames = _translatedColNames;
    }

    public boolean isTranslatedColNames() {
        return this._translatedColNames;
    }

    public void setThreaded(boolean _threaded) {
        this._threaded = _threaded;
    }

    public boolean isThreaded() {
        return this._threaded;
    }

    public String getRawColumnName(int i) {
        return this.getModel() instanceof ResultSetTableModel ? ((ResultSetTableModel)this.getModel()).getRawColumnName(i) : null;
    }

    public boolean isVerticalDisplay() {
        return this._verticalDisplay;
    }

    public void setVerticalDisplay(boolean display) {
        this._verticalDisplay = display;
    }

    public void setSkipCols(ArrayList<String> skipCols) {
        this._skipCols = skipCols;
    }

    public TableExportAction getAction() {
        return this._tabExpAct;
    }

    public static synchronized void setDrillDown(IResultSetTableDrillDown drillDown) {
        _drillDown = drillDown;
    }

    public String convertValueToText(Object value, int row, int column) {
        String sValue;
        if (value != null && (sValue = NLSUtils.getValue(((ResultSetTableModel)this.getModel()).getConn(), value).toString()) != null) {
            return sValue;
        }
        return "";
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        Object value;
        TableCellRenderer renderer;
        Component component;
        String tip = null;
        Point p = event.getPoint();
        int hitColumnIndex = this.columnAtPoint(p);
        int hitRowIndex = this.rowAtPoint(p);
        if (hitColumnIndex != -1 && hitRowIndex != -1 && (component = this.prepareRenderer(renderer = this.getCellRenderer(hitRowIndex, hitColumnIndex), hitRowIndex, hitColumnIndex)) instanceof JComponent) {
            Rectangle cellRect = this.getCellRect(hitRowIndex, hitColumnIndex, false);
            if (cellRect.width >= component.getPreferredSize().width) {
                return null;
            }
            p.translate(-cellRect.x, -cellRect.y);
            MouseEvent newEvent = new MouseEvent(component, event.getID(), event.getWhen(), event.getModifiers(), p.x, p.y, event.getClickCount(), event.isPopupTrigger());
            tip = ((JComponent)component).getToolTipText(newEvent);
        }
        if (tip == null) {
            tip = this.getToolTipText();
        }
        if (tip == null && (tip = this.convertValueToText(value = this.getValueAt(hitRowIndex, hitColumnIndex), hitRowIndex, hitColumnIndex)).length() == 0) {
            tip = null;
        }
        return tip;
    }

    @Override
    public Point getToolTipLocation(MouseEvent event) {
        int row = this.rowAtPoint(event.getPoint());
        if (row == -1) {
            return null;
        }
        int col = this.columnAtPoint(event.getPoint());
        if (col == -1) {
            return null;
        }
        boolean hasTooltip = this.getToolTipText() == null ? this.getToolTipText(event) != null : true;
        return hasTooltip ? this.getCellRect(row, col, false).getLocation() : null;
    }

    @Override
    protected JTableHeader createDefaultTableHeader() {
        return new JTableHeader(this.columnModel){

            public String getToolTipText(MouseEvent e) {
                Point p = e.getPoint();
                int hitColumnIndex = this.columnAtPoint(p);
                int hitRowIndex = ResultSetTable.this.rowAtPoint(p);
                Rectangle cellRect = ResultSetTable.this.getCellRect(hitRowIndex, hitColumnIndex, false);
                int index = this.columnModel.getColumnIndexAtX(p.x);
                if (index != -1) {
                    int headerSize = new Double(new JLabel(((ResultSetTableModel)ResultSetTable.this.getModel()).getRawColumnName(index)).getPreferredSize().getWidth()).intValue();
                    return cellRect.width > headerSize ? null : ((ResultSetTableModel)ResultSetTable.this.getModel()).getRawColumnName(index);
                }
                return null;
            }
        };
    }

    static {
        NAMESPACE_URI = XMLUtil.toNamespaceURI((String)"Table-attributes");
    }

    private class ResultSetTablePersistenceInvoker
    extends MouseAdapter
    implements TableColumnModelListener {
        private boolean colMoved = false;
        private boolean marginChanged = false;
        private int movedFrom = -1;
        private int movedTo = -1;

        private ResultSetTablePersistenceInvoker() {
        }

        public void columnAdded(TableColumnModelEvent e) {
        }

        public void columnRemoved(TableColumnModelEvent e) {
        }

        public void columnMoved(TableColumnModelEvent e) {
            if (e.getFromIndex() != e.getToIndex()) {
                ResultSetTableModel rsTm;
                int[] types;
                TableModel tm;
                this.colMoved = true;
                this.movedFrom = e.getFromIndex();
                this.movedTo = e.getToIndex();
                if (this.movedFrom != this.movedTo && this.movedFrom != -1 && this.movedTo != -1 && (tm = ResultSetTable.this.getModel()) instanceof ResultSetTableModel && this.movedFrom <= (types = (rsTm = (ResultSetTableModel)tm).getTypes()).length && this.movedTo <= types.length) {
                    try {
                        rsTm.reorderColumnNamesList(this.movedFrom, this.movedTo);
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
                this.movedFrom = -1;
                this.movedTo = -1;
            }
        }

        public void columnMarginChanged(ChangeEvent e) {
            this.marginChanged = true;
        }

        public void columnSelectionChanged(ListSelectionEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
            if (this.colMoved || this.marginChanged) {
                this.colMoved = false;
                this.marginChanged = false;
                ResultSetTable.this.savePersistentSettings();
            }
        }
    }

    private static class RowHeaderCellRenderer
    extends DefaultTableCellRenderer {
        static final RowHeaderCellRenderer INSTANCE = new RowHeaderCellRenderer();

        private RowHeaderCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setHorizontalAlignment(4);
            JComponent comp = (JComponent)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            Border oldBorder = comp.getBorder();
            if (table.getModel() instanceof EditableResultSetTableModel) {
                EditableResultSetTableModel mdl = (EditableResultSetTableModel)table.getModel();
                oldBorder = mdl.getRowCountBorder(row, column);
            }
            if (oldBorder != null) {
                oldBorder = BorderFactory.createCompoundBorder(oldBorder, BorderFactory.createEmptyBorder(0, 0, 0, 2));
            }
            comp.setBorder(oldBorder);
            return comp;
        }

        public void paint(Graphics g) {
            super.paint(g);
        }
    }

    private class RowHeaderTableColumnModel
    extends DefaultTableColumnModel {
        private RowHeaderTableColumnModel() {
        }

        public void addColumn(TableColumn tc) {
            if (tc.getModelIndex() == 0) {
                tc.setCellRenderer(RowHeaderCellRenderer.INSTANCE);
                tc.setMaxWidth(40);
                super.addColumn(tc);
            }
        }
    }
}

