/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;

public class TabularPropertyPanel
extends JPanel {
    private String _helpId = null;
    private JPanel _northPanel;
    private int _northRows = 0;
    private JPanel _southPanel;
    private GridLayout _northGrid;
    private JTable _table;
    private DefaultTableModel _model;

    public TabularPropertyPanel() {
        this.init();
    }

    public JTable getTable() {
        return this._table;
    }

    public void addSingleComp(String value) {
        JLabel label = new JLabel();
        label.setText(value == null ? "" : value.toString());
        label.setSize(200, label.getSize().height);
        this.addFooter(label);
    }

    public void addFooter(JComponent comp) {
        this._southPanel.add(comp);
    }

    public void addRow(String label, Object comp) {
        Object[] vals = new Object[]{label, comp};
        this._model.addRow(vals);
    }

    private void init() {
        this._northPanel = new JPanel();
        this._southPanel = new JPanel();
        this.setLayout(new BorderLayout());
        this._northPanel.setLayout(new BorderLayout());
        this._southPanel.setLayout(new BoxLayout(this._southPanel, 1));
        this.add((Component)this._northPanel, "North");
        this.add((Component)this._southPanel, "South");
        Vector<String> cols = new Vector<String>();
        cols.add("Name");
        cols.add("Value");
        Object[][] data = new Object[][]{{"", ""}};
        this._model = new DefaultTableModel(new Vector(), cols);
        this._table = new JTable();
        this._table.setModel(this._model);
        this._table.setShowGrid(true);
        JScrollPane sp = new JScrollPane(this._table);
        sp.setVerticalScrollBarPolicy(21);
        this._northPanel.add(sp);
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (this._northPanel != null) {
            this._northPanel.setBackground(color);
        }
        if (this._southPanel != null) {
            this._southPanel.setBackground(color);
        }
    }

    public void removeAll() {
        this._model.setRowCount(0);
        this._northPanel.removeAll();
        this._northRows = 0;
        this._southPanel.removeAll();
    }

    public static void main(String[] args) {
        TabularPropertyPanel p = new TabularPropertyPanel();
        p.addRow("hi", "hello");
        p.addRow("hi2", "hello2");
        p.addRow("hi3", "hello3");
        p.addRow("hi4", "hello4");
        p.addRow("hi5", "hello5");
        p.addRow("hi6", "hello6");
        p.addFooter(new JTextField("hello out there2"));
        String title = "Frame Title";
        JFrame frame = new JFrame(title);
        frame.setLayout(new BorderLayout());
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().add((Component)p, "Center");
        int width = 300;
        int height = 300;
        frame.setSize(width, height);
        frame.setVisible(true);
    }
}

