/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.celleditor;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JDialog;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.controls.ControlsArb;
import oracle.dbtools.raptor.controls.celleditor.BFileInsertPanel;
import oracle.dbtools.raptor.controls.celleditor.ExtendedTypeEditPanel;
import oracle.dbtools.raptor.editors.IDBEditor;
import oracle.dbtools.raptor.extendedtype.BFILEType;
import oracle.dbtools.raptor.extendedtype.ExtendedType;
import oracle.dbtools.raptor.utils.Translate;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.editor.EditorManager;
import oracle.ide.help.HelpSystem;
import oracle.sql.BFILE;

public class BFileEditPanel
extends ExtendedTypeEditPanel {
    protected BFILEType bfileType;
    private String dirAlias_new = null;
    private String fileName_new = null;

    public BFileEditPanel(ExtendedType extendedType) {
        super(extendedType);
        this.bfileType = (BFILEType)extendedType;
    }

    protected void createGUI() {
        this.createDefaultGUI();
    }

    protected String[][] getTableData() {
        BFILEType bfile = (BFILEType)this.extendedType;
        String length = "";
        String name = "";
        String exists = "";
        String diralaias = "";
        try {
            length = Long.toString(bfile.length());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            name = bfile.getName();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            exists = Boolean.toString(bfile.fileExists());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            diralaias = bfile.getDirAlias();
        }
        catch (Exception e) {
            // empty catch block
        }
        return new String[][]{{"Name", name}, {Translate.translate("Data Length"), length}, {Translate.translate("File Exists"), exists}, {Translate.translate("Directory Alias"), diralaias}};
    }

    protected void load() {
        ArrayList<DbDirectory> dirList;
        Object conn;
        block12: {
            BFILE bfile = (BFILE)this.extendedType;
            conn = null;
            dirList = new ArrayList<DbDirectory>();
            try {
                conn = bfile.getOracleConnection();
            }
            catch (Exception e1) {
                if (!(EditorManager.getEditorManager().getCurrentEditor() instanceof IDBEditor)) break block12;
                conn = ((IDBEditor)EditorManager.getEditorManager().getCurrentEditor()).getConnection();
            }
        }
        try {
            PreparedStatement stmt = conn.prepareStatement("select  * from all_directories");
            ResultSet rs = stmt.executeQuery("select  * from all_directories");
            if (rs != null) {
                while (rs.next()) {
                    DbDirectory dbdir = new DbDirectory(rs.getString(1), rs.getString(2), rs.getString(3));
                    dirList.add(dbdir);
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (this.bfileType.getOrigBFile() != null) {
            try {
                this.dirAlias_new = this.bfileType.getDirAlias();
                this.fileName_new = this.bfileType.getName();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        final BFileInsertPanel bfPnl = new BFileInsertPanel(dirList, this.dirAlias_new, this.fileName_new);
        JEWTDialog dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)bfPnl, (Component)bfPnl, (String)ControlsArb.getString(0));
        HelpSystem.getHelpSystem().registerTopic((JComponent)bfPnl, "f1_extendeddataedit_html");
        dlg.addVetoableChangeListener(new VetoableChangeListener(){

            public void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
                if ("closed".equals(e.getPropertyName()) && Boolean.TRUE.equals(e.getNewValue())) {
                    Object obj = e.getSource();
                    if (bfPnl.getDir() == null || bfPnl.getFile() == null || bfPnl.getFile().length() <= 0) {
                        throw new PropertyVetoException(Translate.translate("Select Directory and File"), e);
                    }
                }
            }
        });
        dlg.setResizable(true);
        dlg.setOKButtonEnabled(true);
        if (WizardLauncher.runDialog((JDialog)dlg)) {
            String dir = bfPnl.getDir();
            String file = bfPnl.getFile();
            if (!(dir == null || file == null || dir.equals(this.dirAlias_new) && file.equals(this.fileName_new))) {
                this.dirAlias_new = dir;
                this.fileName_new = file;
            } else {
                this.dirAlias_new = null;
                this.fileName_new = null;
            }
        }
    }

    public void showAsImage(ExtendedType exType) {
        try {
            BFILEType bfile = (BFILEType)exType;
            bfile.openFile();
            super.showAsImage(exType);
            bfile.closeFile();
        }
        catch (Exception e) {
            this.imageLabel.setIcon(null);
            this.imageLabel.setText(null);
        }
    }

    protected void showAsText(ExtendedType exType) {
        try {
            BFILEType bfile = (BFILEType)exType;
            bfile.openFile();
            super.showAsText(exType);
            bfile.closeFile();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected boolean processExtendedType() {
        this.saveToDisk();
        if (this.dirAlias_new != null && this.fileName_new != null) {
            this.bfileType.setDirAlias_new(this.dirAlias_new);
            this.bfileType.setFileName_new(this.fileName_new);
            return true;
        }
        return false;
    }

    protected Component getDefaultComponent() {
        return this;
    }

    protected class DbDirectory {
        private String owner;
        private String name;
        private String path;

        public DbDirectory(String owner, String name, String path) {
            this.owner = owner;
            this.name = name;
            this.path = path;
        }

        public String toString() {
            return this.name;
        }

        public String getName() {
            return this.name;
        }

        public String getOwner() {
            return this.owner;
        }

        public String getPath() {
            return this.path;
        }
    }
}

