/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.celleditor;

import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JCheckBox;
import oracle.dbtools.raptor.controls.celleditor.ExtendedTypeEditPanel;
import oracle.dbtools.raptor.extendedtype.BLOBType;
import oracle.dbtools.raptor.extendedtype.ExtendedType;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.raptor.utils.Translate;
import oracle.ide.net.URLChooser;

public class BLOBEditPanel
extends ExtendedTypeEditPanel {
    protected URL loadFromURL = null;
    protected static URL _lastLoadUrl;
    protected BLOBType blobType;
    protected JCheckBox jButton3;
    protected static boolean showImage;

    public BLOBEditPanel(ExtendedType extendedType) {
        super(extendedType);
        this.blobType = (BLOBType)extendedType;
    }

    protected void createGUI() {
        this.createDefaultGUI();
    }

    protected String[][] getTableData() {
        BLOBType blobType = (BLOBType)this.extendedType;
        String length = "";
        String temp = "";
        String empty = "";
        String open = "";
        try {
            length = Long.toString(blobType.length());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            temp = Boolean.toString(blobType.isTemporary());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            empty = Boolean.toString(blobType.isEmptyLob());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            open = Boolean.toString(blobType.isOpen());
        }
        catch (Exception e) {
            // empty catch block
        }
        return new String[][]{{Translate.translate("Length"), length}, {Translate.translate("Empty"), empty}, {Translate.translate("Temporary"), temp}, {Translate.translate("Open"), open}};
    }

    protected void load() {
        URLChooser saveDialog = new URLChooser();
        saveDialog.setDefaultTitle("Choose File");
        saveDialog.setSelectionMode(0);
        saveDialog.setSelectionScope(0);
        saveDialog.clearChooseableURLFilters();
        if (_lastLoadUrl == null) {
            try {
                String s = System.getProperty("user.home");
                File homeDir = new File(s);
                saveDialog.setSelectedURL(homeDir.toURL());
            }
            catch (MalformedURLException malformedURLException) {}
        } else {
            saveDialog.setSelectedURL(_lastLoadUrl);
        }
        if (saveDialog.showSaveDialog((Component)this) == 0) {
            this.loadFromURL = saveDialog.getSelectedURL();
            _lastLoadUrl = saveDialog.getSelectedURL();
        }
    }

    public URL getLoadFromURL() {
        return this.loadFromURL;
    }

    protected boolean processExtendedType() {
        this.saveToDisk();
        URL url = this.getLoadFromURL();
        if (url != null) {
            try {
                FileInputStream fis = new FileInputStream(url.getFile());
                this.blobType.setFromDiskStream(fis);
                return true;
            }
            catch (FileNotFoundException e) {
                ExceptionHandler.handleException(e);
            }
        }
        return false;
    }

    protected Component getDefaultComponent() {
        return this;
    }

    static {
        showImage = false;
    }
}

