/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.celleditor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.JTableHeader;
import oracle.dbtools.raptor.extendedtype.ExtendedType;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.raptor.utils.Translate;
import oracle.ide.net.URLChooser;
import oracle.ide.util.ResourceUtils;

public abstract class ExtendedTypeEditPanel
extends JPanel {
    protected ExtendedType extendedType;
    protected URL saveToURL = null;
    protected static URL _lastSaveUrl;
    protected JButton loadButton = new JButton();
    protected JButton saveButton = new JButton();
    protected JPanel buttonPanel = new JPanel(new GridBagLayout());
    protected JLabel imageLabel = new JLabel();
    protected JTextArea textArea = new JTextArea();
    protected JCheckBox viewAsImageBtn;
    protected JCheckBox viewAsTextBtn;
    protected JTabbedPane tabbedPane;
    protected static boolean showImage;
    protected static boolean showText;

    public ExtendedTypeEditPanel(ExtendedType exType) {
        this.extendedType = exType;
        this.createGUI();
    }

    protected abstract void createGUI();

    protected void createDefaultGUI() {
        this.setLayout(new GridBagLayout());
        this.viewAsImageBtn = new JCheckBox();
        this.viewAsTextBtn = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.viewAsImageBtn, (String)Translate.translate("&Image"));
        ResourceUtils.resButton((AbstractButton)this.viewAsTextBtn, (String)Translate.translate("&Text"));
        this.viewAsImageBtn.setSelected(showImage);
        this.viewAsTextBtn.setSelected(showText);
        this.tabbedPane = new JTabbedPane(3);
        JScrollPane infoScrollPane = new JScrollPane(this.createTable());
        infoScrollPane.setPreferredSize(new Dimension(400, 300));
        infoScrollPane.setHorizontalScrollBarPolicy(30);
        infoScrollPane.setVerticalScrollBarPolicy(20);
        infoScrollPane.setViewportBorder(null);
        infoScrollPane.getViewport().setBackground(Color.white);
        this.tabbedPane.addTab(Translate.translate("Information"), infoScrollPane);
        this.imageLabel.setVerticalAlignment(3);
        final JScrollPane imageScrollPane = new JScrollPane(this.imageLabel);
        imageScrollPane.setPreferredSize(new Dimension(400, 300));
        imageScrollPane.setHorizontalScrollBarPolicy(32);
        imageScrollPane.setVerticalScrollBarPolicy(22);
        imageScrollPane.setViewportBorder(null);
        imageScrollPane.getViewport().setBackground(Color.white);
        try {
            if (showImage) {
                this.tabbedPane.addTab(Translate.translate("Image"), imageScrollPane);
                this.showAsImage(this.extendedType);
            }
        }
        catch (Exception e2) {
            this.showAsImage(null);
        }
        this.textArea.setEditable(false);
        final JScrollPane textScrollPane = new JScrollPane(this.textArea);
        textScrollPane.setPreferredSize(new Dimension(400, 300));
        textScrollPane.setHorizontalScrollBarPolicy(32);
        textScrollPane.setVerticalScrollBarPolicy(22);
        textScrollPane.setViewportBorder(null);
        textScrollPane.getViewport().setBackground(Color.white);
        try {
            if (showText) {
                this.tabbedPane.addTab(Translate.translate("Text"), textScrollPane);
                this.showAsText(this.extendedType);
            }
        }
        catch (Exception e2) {
            this.showAsText(null);
        }
        this.add((Component)this.tabbedPane, new GridBagConstraints(0, 0, 3, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.getButtonPanel(), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.viewAsImageBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    if (ExtendedTypeEditPanel.this.viewAsImageBtn.isSelected()) {
                        ExtendedTypeEditPanel.this.tabbedPane.addTab(Translate.translate("Image"), imageScrollPane);
                        ExtendedTypeEditPanel.this.showAsImage(ExtendedTypeEditPanel.this.extendedType);
                        showImage = true;
                        ExtendedTypeEditPanel.this.tabbedPane.setSelectedComponent(imageScrollPane);
                    } else {
                        ExtendedTypeEditPanel.this.tabbedPane.remove(imageScrollPane);
                        ExtendedTypeEditPanel.this.showAsImage(null);
                        showImage = false;
                    }
                }
                catch (Exception e1) {
                    ExtendedTypeEditPanel.this.showAsImage(null);
                }
            }
        });
        this.buttonPanel.add((Component)new JLabel(Translate.translate("View As:")), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.buttonPanel.add((Component)this.viewAsImageBtn, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.viewAsTextBtn.setSelected(showText);
        this.viewAsTextBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    if (ExtendedTypeEditPanel.this.viewAsTextBtn.isSelected()) {
                        ExtendedTypeEditPanel.this.tabbedPane.addTab(Translate.translate("Text"), textScrollPane);
                        ExtendedTypeEditPanel.this.showAsText(ExtendedTypeEditPanel.this.extendedType);
                        showText = true;
                        ExtendedTypeEditPanel.this.tabbedPane.setSelectedComponent(textScrollPane);
                    } else {
                        ExtendedTypeEditPanel.this.tabbedPane.remove(textScrollPane);
                        ExtendedTypeEditPanel.this.showAsText(null);
                        showText = false;
                    }
                }
                catch (Exception e1) {
                    ExtendedTypeEditPanel.this.showAsText(null);
                }
            }
        });
        this.buttonPanel.add((Component)this.viewAsTextBtn, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.buttonPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 0, 5), 0, 0));
    }

    protected JTable createTable() {
        Object[] columnNames = new String[]{Translate.translate("Property"), Translate.translate("Value")};
        Object[][] data = this.getTableData();
        JTable table = new JTable(data, columnNames){

            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        table.setBackground(this.getBackground());
        table.setRowHeight(20);
        table.setCellSelectionEnabled(true);
        table.setPreferredSize(new Dimension(350, 200));
        table.setTableHeader(new JTableHeader());
        return table;
    }

    protected abstract String[][] getTableData();

    protected abstract boolean processExtendedType();

    protected abstract Component getDefaultComponent();

    protected abstract void load();

    protected JButton getLoadButton() {
        ResourceUtils.resButton((AbstractButton)this.loadButton, (String)Translate.translate("&Load"));
        this.loadButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ExtendedTypeEditPanel.this.load();
            }
        });
        return this.loadButton;
    }

    protected JButton getSaveButton() {
        ResourceUtils.resButton((AbstractButton)this.saveButton, (String)Translate.translate("&Save"));
        this.saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ExtendedTypeEditPanel.this.save();
            }
        });
        return this.saveButton;
    }

    protected JPanel getButtonPanel() {
        this.buttonPanel.add((Component)this.getLoadButton(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.buttonPanel.add((Component)this.getSaveButton(), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 0, 5), 0, 0));
        return this.buttonPanel;
    }

    protected void save() {
        URLChooser saveDialog = new URLChooser();
        saveDialog.setDefaultTitle(Translate.translate("Choose File"));
        saveDialog.setSelectionMode(0);
        saveDialog.setSelectionScope(0);
        saveDialog.clearChooseableURLFilters();
        if (_lastSaveUrl == null) {
            try {
                String s = System.getProperty("user.home");
                File homeDir = new File(s);
                saveDialog.setSelectedURL(homeDir.toURL());
            }
            catch (MalformedURLException e) {}
        } else {
            saveDialog.setSelectedURL(_lastSaveUrl);
        }
        File f = new File(saveDialog.getSelectedURL().getFile());
        if (f.isDirectory()) {
            try {
                saveDialog.setSelectedURL(new URL(saveDialog.getSelectedURL() + File.separator + ".blob"));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (saveDialog.showSaveDialog((Component)this) == 0) {
            this.saveToURL = saveDialog.getSelectedURL();
            _lastSaveUrl = saveDialog.getSelectedURL();
        }
    }

    public URL getSaveToURL() {
        return this.saveToURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void showAsImage(ExtendedType exType) {
        if (exType == null) {
            this.imageLabel.setIcon(null);
            this.imageLabel.setText(null);
            return;
        }
        InputStream in = null;
        try {
            in = exType.getBinaryStream();
            if (in == null) {
                this.imageLabel.setIcon(null);
                this.imageLabel.setText(null);
                return;
            }
            BufferedImage image = ImageIO.read(in);
            if (image != null) {
                this.imageLabel.setIcon(new ImageIcon(image));
            } else {
                this.imageLabel.setText(Translate.translate("Image could not be decoded from the binary stream."));
            }
        }
        catch (Exception e) {
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void showAsText(ExtendedType exType) {
        if (exType != null) {
            BufferedReader in = null;
            try {
                in = new BufferedReader(new InputStreamReader(exType.getBinaryStream()));
                if (in != null) {
                    String s;
                    while ((s = in.readLine()) != null) {
                        this.textArea.append(s + "\n");
                    }
                }
            }
            catch (Exception e) {
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException e) {}
            }
        }
    }

    protected boolean saveToDisk() {
        FileOutputStream fos = null;
        URL url = this.getSaveToURL();
        if (url != null) {
            try {
                fos = new FileOutputStream(url.getFile());
                this.extendedType.setToDiskStream(fos);
                this.extendedType.saveToDisk(null, null, null, null, false);
                return true;
            }
            catch (Exception e) {
                ExceptionHandler.handleException(e);
            }
        }
        return false;
    }

    static {
        showImage = false;
        showText = false;
    }
}

