/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.celleditor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.EventObject;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.text.Document;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.controls.ControlsArb;
import oracle.dbtools.raptor.controls.celleditor.ExtendedTypeEditPanel;
import oracle.dbtools.raptor.extendedtype.ExtendedType;
import oracle.dbtools.raptor.extendedtype.ExtendedTypeFactory;
import oracle.dbtools.raptor.models.ResultSetTableModel;
import oracle.dbtools.raptor.utils.DataTypesUtil;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.resource.IdeIcons;
import oracle.ide.util.ResourceUtils;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.RAW;

public class ResultSetCellEditor
extends DefaultCellEditor {
    private Object origValue = null;

    public ResultSetCellEditor() {
        super(new JTextField());
    }

    public Component getTableCellEditorComponent(final JTable table, Object value, boolean isSelected, int row, int column) {
        int type;
        TableModel tm = table.getModel();
        ResultSetTableModel rsTm = null;
        if (tm instanceof ResultSetTableModel) {
            rsTm = (ResultSetTableModel)tm;
        }
        if (DataTypesUtil.isExtendedType(value, type = this.getType(table, column))) {
            this.origValue = value;
        }
        value = DataTypesUtil.stringValue(value, rsTm.getConn());
        final JTextField fld = (JTextField)super.getTableCellEditorComponent(table, value, isSelected, row, column);
        fld.setEditable(this.isEnabled(type));
        Document doc = fld.getDocument();
        if (doc != null) {
            doc.putProperty("filterNewlines", Boolean.FALSE);
            fld.setText(value != null ? value.toString() : "");
        }
        JComponent comp = fld;
        if (ResultSetCellEditor.hasExtendedEdit(type)) {
            JPanel pnl = new JPanel(new BorderLayout());
            pnl.add((Component)fld, "Center");
            JButton btn = new JButton(IdeIcons.getIcon((int)20));
            btn.setMargin(new Insets(2, 2, 2, 2));
            btn.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    if (ResultSetCellEditor.this.origValue instanceof BLOB || type == 2004 || ResultSetCellEditor.this.origValue instanceof BFILE || type == -13) {
                        ResultSetCellEditor.this.showExtendedTypeEdit(ResultSetCellEditor.this.origValue, type);
                    } else {
                        ResultSetCellEditor.this.showLongCharEdit(ResultSetCellEditor.this.getCellEditorValue(), true);
                    }
                    table.requestFocusInWindow();
                }
            });
            pnl.add((Component)btn, "East");
            pnl.addFocusListener(new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                    fld.requestFocusInWindow();
                }
            });
            comp = pnl;
        }
        return comp;
    }

    public boolean isCellEditable(EventObject anEvent) {
        return true;
    }

    public Object getCellEditorValue() {
        return this.origValue != null ? this.origValue : super.getCellEditorValue();
    }

    public void setValue(Object value) {
        this.delegate.setValue(value);
    }

    private int getType(JTable table, int column) {
        int type = 0;
        TableModel mdl = table.getModel();
        if (mdl instanceof ResultSetTableModel) {
            ResultSetTableModel rsMdl = (ResultSetTableModel)mdl;
            int[] types = rsMdl.getTypes();
            if (types != null && types.length >= column) {
                type = types[column];
            }
        } else if (mdl instanceof DefaultTableModel && column == 0) {
            return 2005;
        }
        return type;
    }

    private boolean isEnabled(int type) {
        switch (type) {
            case -13: 
            case -4: 
            case -3: 
            case -2: 
            case 2002: 
            case 2004: 
            case 2007: {
                return false;
            }
        }
        return true;
    }

    public static boolean hasExtendedEdit(int type) {
        switch (type) {
            case -13: 
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 12: 
            case 2004: 
            case 2005: {
                return true;
            }
        }
        return false;
    }

    private void showLongCharEdit(Object value, boolean canChange) {
        JPanel pnl = new JPanel(new GridBagLayout());
        JLabel lbl = new JLabel();
        JTextArea txt = new JTextArea();
        ResourceUtils.resLabel((JLabel)lbl, (Component)txt, (String)ControlsArb.getString(1));
        JScrollPane pane = new JScrollPane(txt);
        pane.setHorizontalScrollBarPolicy(32);
        pane.setVerticalScrollBarPolicy(22);
        txt.setRows(10);
        txt.setEditable(canChange);
        pnl.add((Component)lbl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        pnl.add((Component)pane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 0, 0, 0), 0, 0));
        JEWTDialog dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)pnl, (Component)txt, (String)ControlsArb.getString(0));
        HelpSystem.getHelpSystem().registerTopic((JComponent)pnl, "f1_extendeddataedit_html");
        dlg.addVetoableChangeListener(new VetoableChangeListener(){

            public void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
                if (!"closed".equals(e.getPropertyName()) || Boolean.TRUE.equals(e.getNewValue())) {
                    // empty if block
                }
            }
        });
        dlg.setResizable(true);
        dlg.setOKButtonEnabled(canChange);
        if (value instanceof RAW) {
            txt.setText(((RAW)value).stringValue());
        } else {
            txt.setText(value.toString());
        }
        if (WizardLauncher.runDialog((JDialog)dlg)) {
            this.setValue(txt.getText());
            this.stopCellEditing();
        } else {
            this.cancelCellEditing();
        }
    }

    private void showExtendedTypeEdit(Object value, int type) {
        ExtendedType extendedType = ExtendedTypeFactory.getExtendedType(value, type);
        if (extendedType == null) {
            return;
        }
        ExtendedTypeEditPanel extendedTypeEditPanel = ExtendedTypeFactory.getEditPanel(extendedType, type);
        JEWTDialog dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)extendedTypeEditPanel, (Component)extendedTypeEditPanel.getDefaultComponent(), (String)ControlsArb.getString(0));
        HelpSystem.getHelpSystem().registerTopic((JComponent)extendedTypeEditPanel, "f1_extendeddataedit_html");
        dlg.setResizable(true);
        dlg.setOKButtonEnabled(true);
        if (WizardLauncher.runDialog((JDialog)dlg)) {
            if (extendedTypeEditPanel.processExtendedType()) {
                this.origValue = extendedType;
                this.setValue(value);
                this.stopCellEditing();
            } else {
                this.cancelCellEditing();
            }
        }
    }
}

