/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.multidisplay;

import java.awt.Component;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.text.Document;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.controls.multidisplay.MultiDisplayAdapter;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.gutter.LineGutterPlugin;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.editor.plugins.LineHighlightPlugin;

public class MultiDisplayCodeEditor
extends MultiDisplayAdapter {
    private BasicEditorPane _codeArea;
    private JScrollPane _spSql;

    public void initTable() {
        if (this._codeArea == null) {
            this._codeArea = EditorFactory.createIdeEditorPane();
            this._codeArea.setText("");
            this._codeArea.setDocument((Document)new BasicDocument("foo.plsql"));
            this._codeArea.installPlugin((EditorPlugin)new LineHighlightPlugin());
            this._codeArea.setText("");
            this._codeArea.setEditable(false);
            LineGutterPlugin sqlGutter = new LineGutterPlugin();
            this._codeArea.installPlugin((EditorPlugin)sqlGutter);
            this._spSql = new JScrollPane((Component)this._codeArea, 22, 32);
            this._spSql.setRowHeaderView((Component)sqlGutter);
        }
    }

    public JComponent getUI() {
        this.initTable();
        return this._spSql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(boolean force) {
        HashMap binds = this.getQuery().getBindValues();
        StringBuilder sb = new StringBuilder();
        Connection connection = this.getConnection();
        synchronized (connection) {
            ResultSet rs = DBUtil.getInstance().executeQuery(this.getConnName(), this.getQuery().getSql(), binds);
            try {
                while (rs.next()) {
                    sb.append(rs.getString(1));
                }
            }
            catch (SQLException e) {
                ExceptionHandler.handleException(e);
            }
            finally {
                try {
                    rs.getStatement().close();
                }
                catch (SQLException e) {}
                try {
                    rs.close();
                }
                catch (SQLException e) {}
            }
        }
        this._codeArea.setEditable(true);
        this._codeArea.setText(sb.toString());
        this._codeArea.setEditable(false);
    }
}

