/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.multidisplay;

import java.sql.Connection;
import java.util.ArrayList;
import oracle.dbtools.raptor.query.Bind;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.utils.Connections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiDisplayModel {
    private Connection _conn;
    private String _connName;
    private String _title;
    private ArrayList<String> _subTitle;
    private ArrayList<Query> _queries;
    private ArrayList<ArrayList<Query>> _dualQueries;
    private ArrayList<ArrayList<Query>> _bottomQueries;
    private ArrayList<Bind> _queriesBinds;
    private ArrayList<ArrayList<Bind>> _bottomQueriesBinds;
    private String _mainType;
    private ArrayList<String> _subType;
    private ArrayList<String> _dualType;

    public boolean isDual() {
        return this._dualQueries != null || this._bottomQueries != null;
    }

    public boolean isDualChild() {
        return this._bottomQueries != null;
    }

    public boolean hasMultipleChildren() {
        return this._dualQueries.size() > 1 || this._bottomQueries.size() > 1;
    }

    public ArrayList<Query> getBottomQueries() {
        ArrayList<Query> ret = new ArrayList<Query>();
        for (ArrayList<Query> arr : this._bottomQueries) {
            ret.add(arr.get(0));
        }
        return ret;
    }

    public ArrayList<Bind> getBottomQueriesBinds(int idx) {
        return this._bottomQueriesBinds.get(idx);
    }

    public void setBottomQueriesBinds(int idx, ArrayList<Bind> queriesBinds) {
        this._bottomQueriesBinds.set(idx, queriesBinds);
    }

    public String getConnName() {
        return this._connName;
    }

    public void setConnName(String name) {
        this._connName = name;
    }

    public ArrayList<Query> getDualQueries() {
        ArrayList<Query> ret = new ArrayList<Query>();
        for (ArrayList<Query> arr : this._dualQueries) {
            ret.add(arr.get(0));
        }
        return ret;
    }

    public void setDualType(int idx, String type) {
        if (this._dualType == null) {
            this._dualType = new ArrayList();
        }
        this._dualType.set(idx, type);
    }

    public void addDualType(String type) {
        if (this._dualType == null) {
            this._dualType = new ArrayList();
        }
        this._dualType.add(type);
    }

    public String getMainType() {
        return this._mainType;
    }

    public void setMainType(String type) {
        this._mainType = type;
    }

    public ArrayList<Query> getQueries() {
        return this._queries;
    }

    public void setQueries(ArrayList<Query> _queries) {
        this._queries = _queries;
    }

    public ArrayList<Bind> getQueriesBinds() {
        return this._queriesBinds;
    }

    public void setQueriesBinds(ArrayList<Bind> binds) {
        this._queriesBinds = binds;
    }

    public String getSubTitle(int idx) {
        return this._subTitle.get(idx);
    }

    public void addSubTitle(String title) {
        if (this._subTitle == null) {
            this._subTitle = new ArrayList();
        }
        this._subTitle.add(title);
    }

    public void setSubTitle(int idx, String title) {
        if (this._subTitle == null) {
            this._subTitle = new ArrayList();
        }
        this._subTitle.set(idx, title);
    }

    public String getSubType(int idx) {
        return this._subType.get(idx);
    }

    public void setSubType(int idx, String type) {
        if (this._subType == null) {
            this._subType = new ArrayList();
        }
        this._subType.set(idx, type);
    }

    public void addSubType(String type) {
        if (this._subType == null) {
            this._subType = new ArrayList();
        }
        this._subType.add(type);
    }

    public String getTitle() {
        return this._title;
    }

    public void setTitle(String title) {
        this._title = title;
    }

    public Connection getConnection() {
        return this._conn == null ? Connections.getInstance().getConnection(this._connName) : this._conn;
    }

    public void setConnection(Connection conn) {
        this._conn = conn;
    }

    public void addDualQuery(String title, String type, Query query) {
        if (this._dualQueries == null) {
            this._dualQueries = new ArrayList();
        }
        ArrayList<Query> q = new ArrayList<Query>();
        q.add(query);
        this._dualQueries.add(q);
        this.addSubTitle(title);
        this.addSubType(type);
    }

    public void addSubQuery(String title, String type, Query query) {
        if (this._bottomQueries == null) {
            this._bottomQueries = new ArrayList();
        }
        ArrayList<Query> q = new ArrayList<Query>();
        q.add(query);
        this._bottomQueries.add(q);
        this.addSubTitle(title);
        this.addSubType(type);
    }
}

