/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.multidisplay;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.Connection;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.dbtools.raptor.controls.CustomTabbedPane;
import oracle.dbtools.raptor.controls.multidisplay.IMultiDisplay;
import oracle.dbtools.raptor.controls.multidisplay.MultiDisplayModel;
import oracle.dbtools.raptor.controls.multidisplay.MultiDisplayRegistry;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.utils.UIUtils;

public class MultiDisplayPanel
extends JPanel {
    private MultiDisplayModel _model;
    private JSplitPane _sp;
    private ArrayList<IMultiDisplay> _primaries = new ArrayList();
    private ArrayList<IMultiDisplay> _subsidaries;
    private String _connName;
    private Connection _conn;
    private CustomTabbedPane _tabbed;

    public MultiDisplayPanel(MultiDisplayModel model) {
        this.setLayout(new BorderLayout());
        if (model == null) {
            this._model = new MultiDisplayModel();
        } else {
            this._model = model;
            this.buildUI();
        }
        this.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent e) {
                MultiDisplayPanel.this.refreshMain();
                MultiDisplayPanel.this.refreshVisibleSubs();
            }
        });
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                MultiDisplayPanel.this.refreshMain();
                MultiDisplayPanel.this.refreshVisibleSubs();
            }
        });
        this.addAncestorListener(new AncestorListener(){

            public void ancestorAdded(AncestorEvent event) {
                MultiDisplayPanel.this.refreshMain();
                MultiDisplayPanel.this.refreshVisibleSubs();
            }

            public void ancestorRemoved(AncestorEvent event) {
            }

            public void ancestorMoved(AncestorEvent event) {
            }
        });
    }

    public Connection getConnection() {
        return this._model.getConnection();
    }

    public MultiDisplayModel getModel() {
        return this._model;
    }

    public void setModel(MultiDisplayModel model) {
        this._model = model;
    }

    public void init() {
        if (this._primaries == null) {
            this._primaries = new ArrayList();
        }
        if (this._subsidaries == null) {
            this._subsidaries = new ArrayList();
        }
    }

    public void buildUI() {
        try {
            if (this._model == null) {
                return;
            }
            IMultiDisplay main = MultiDisplayRegistry.getInstanceFor(this._model.getMainType());
            main.setConn(this.getConnection());
            main.setQuery(this._model.getQueries().get(0));
            this._primaries.add(main);
            this.add((Component)main.getScrollableUI(), "Center");
            main.getUI().addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2 && MultiDisplayPanel.this._subsidaries != null) {
                        for (IMultiDisplay display : MultiDisplayPanel.this._subsidaries) {
                            display.setConn(MultiDisplayPanel.this.getConnection());
                            display.setBindMap(((IMultiDisplay)MultiDisplayPanel.this._primaries.get(0)).getBinds(e.getPoint()));
                            MultiDisplayPanel.this.refreshVisibleSubs();
                        }
                    }
                }
            });
            if (this._model.isDual()) {
                if (this._subsidaries == null) {
                    this._subsidaries = new ArrayList();
                }
                this._tabbed = new CustomTabbedPane();
                this._tabbed.addChangeListener(new ChangeListener(){

                    public void stateChanged(ChangeEvent e) {
                        MultiDisplayPanel.this.refreshVisibleSubs();
                        MultiDisplayPanel.this.refreshMain();
                    }
                });
                ArrayList<Query> queries = this._model.isDualChild() ? this._model.getBottomQueries() : this._model.getDualQueries();
                IMultiDisplay sub = null;
                for (int i = 0; i < queries.size(); ++i) {
                    sub = MultiDisplayRegistry.getInstanceFor(this._model.getSubType(i));
                    sub.setConn(this.getConnection());
                    sub.setQuery(queries.get(i));
                    if (this._model.isDualChild()) {
                        this._subsidaries.add(sub);
                    } else {
                        this._primaries.add(sub);
                    }
                    sub.getUI().setBorder(BorderFactory.createEtchedBorder());
                    this._tabbed.addTab(null, this._model.getSubTitle(i), sub.getScrollableUI());
                }
                this.add(this.createSplitPane(main.getUI(), this._tabbed), "Center");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.refreshMain();
    }

    public void update() {
        this.update(false);
    }

    public void update(boolean force) {
        for (IMultiDisplay display : this._primaries) {
            display.setConn(this.getConnection());
            display.refresh(force);
            UIUtils.makeTitledBorder(display.getUI(), "M:" + System.currentTimeMillis());
        }
        if (this._subsidaries != null) {
            for (IMultiDisplay display : this._subsidaries) {
                display.setConn(this.getConnection());
                display.setBindMap(this._primaries.get(0).getBinds(null));
                display.refresh(force);
            }
        }
    }

    private Component createSplitPane(Component top, Component bottom) {
        this._sp = new JSplitPane(0);
        JScrollPane topPane = new JScrollPane(top);
        if (top instanceof JTable) {
            topPane.setRowHeaderView(((JTable)top).getTableHeader());
        }
        this._sp.setTopComponent(topPane);
        JScrollPane bottomPane = new JScrollPane(bottom);
        if (bottom instanceof JTable) {
            bottomPane.setRowHeaderView(((JTable)bottom).getTableHeader());
        }
        this._sp.setBottomComponent(bottom);
        return this._sp;
    }

    public void refreshVisibleSubs() {
        if (this._subsidaries != null) {
            for (IMultiDisplay display : this._subsidaries) {
                boolean vis = true;
                for (Container comp = display.getUI(); comp != null && vis && !(comp instanceof CustomTabbedPane); comp = comp.getParent()) {
                    vis = comp.isVisible();
                }
                if (!vis) continue;
                display.refresh();
            }
        }
    }

    public void refreshMain() {
        for (IMultiDisplay display : this._primaries) {
            boolean vis = true;
            for (Container comp = display.getUI(); comp != null && vis && comp.getParent() != null; comp = comp.getParent()) {
                vis = comp.isShowing();
            }
            display.toString();
            if (!vis) continue;
            display.refresh();
        }
    }
}

