/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.multidisplay;

import java.util.HashMap;
import oracle.dbtools.raptor.controls.multidisplay.IMultiDisplay;
import oracle.dbtools.raptor.controls.multidisplay.MultiDisplayCodeEditor;
import oracle.dbtools.raptor.controls.multidisplay.MultiDisplayResultTable;

public class MultiDisplayRegistry {
    private static HashMap<String, Class> _registry = new HashMap();

    public static synchronized void registerDisplay(String type, Class clazz) {
        if (!clazz.isAssignableFrom(IMultiDisplay.class)) {
            throw new IllegalArgumentException("Class must be instance of IMultiDisplay");
        }
        _registry.put(type, clazz);
    }

    public static synchronized void unregisterDisplay(String type) {
        _registry.remove(type);
    }

    public static synchronized IMultiDisplay getInstanceFor(String type) throws Exception {
        if (_registry.get(type) != null) {
            return (IMultiDisplay)_registry.get(type).newInstance();
        }
        return (IMultiDisplay)_registry.get("default").newInstance();
    }

    static {
        _registry.put("default", MultiDisplayResultTable.class);
        _registry.put("code", MultiDisplayCodeEditor.class);
    }
}

