/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.multidisplay;

import java.awt.Dimension;
import java.awt.Point;
import java.sql.Connection;
import java.util.Enumeration;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.table.TableColumn;
import oracle.dbtools.raptor.controls.ResultSetTable;
import oracle.dbtools.raptor.controls.multidisplay.MultiDisplayAdapter;
import oracle.ide.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiDisplayResultTable
extends MultiDisplayAdapter {
    private ResultSetTable _table;
    private HashMap<String, Object> _binds;
    private HashMap<String, Object> _lastBindMap;
    private String _lastSql;
    private Connection _lastConn;

    public void initTable() {
        if (this._table == null) {
            this._table = new ResultSetTable();
        }
        this._table.setMinimumSize(new Dimension(200, 200));
    }

    @Override
    public JComponent getUI() {
        this.initTable();
        return this._table;
    }

    @Override
    public void refresh(boolean force) {
        this._table.setThreaded(false);
        if ((force || this.isDirty()) && (this.getQuery().getSql().indexOf(":") == -1 || this.getQuery().getSql().indexOf(":") > 0 && this.getBindMap() != null)) {
            this._table.setQuery(this.getConnection(), null, this.getQuery().getSql(), this.getBindMap());
            this._table.refresh();
            Assert.println((String)"Loading....");
            this.setDirty(false);
        }
    }

    @Override
    public HashMap<String, Object> getBinds(Point p) {
        if (this._binds == null) {
            this._binds = new HashMap();
        } else {
            this._binds.clear();
        }
        int rowIndex = this._table.rowAtPoint(p);
        TableColumn col = null;
        Enumeration<TableColumn> cols = this._table.getColumnModel().getColumns();
        while (cols.hasMoreElements()) {
            col = cols.nextElement();
            int colIdx = col.getModelIndex() - 1;
            String name = col.getHeaderValue().toString();
            Object value = this._table.getValueAt(rowIndex, colIdx);
            this._binds.put(name, value);
        }
        return this._binds;
    }
}

