/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import oracle.dbtools.raptor.dialogs.CreateDialogArb;
import oracle.ide.Ide;
import oracle.ide.component.NewFilePanel;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DDLGenerator;
import oracle.javatools.db.Database;
import oracle.javatools.db.Ddl;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.ValidationException;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.cm.dt.ConnectionArb;
import oracle.jdeveloper.cm.dt.dialog.SQLErrorDialog;
import oracle.jdeveloper.cm.dt.ui.TabbedDBPanel;
import oracle.jdeveloper.cm.dt.ui.UIConstants;
import oracle.jdeveloper.cm.dt.verifier.Verifier;
import oracle.jdevimpl.cm.dt.sqlplus.SqlNode;
import oracle.jdevimpl.cm.dt.wizards.CmWizardsArb;

public abstract class TabbedDialogLauncher
extends Namespace
implements UIConstants {
    private Map _verifiers = new HashMap();
    protected List _tabs = new ArrayList();
    private String _title;
    protected String _topLabel;
    protected String _errTitle = null;

    protected TabbedDialogLauncher(Database db, Schema schema) {
        this.setProvider((DBObjectProvider)db);
        this.setSchema(schema);
        try {
            Schema[] schemas = db.listSchemas();
            this.put("SchemaList", schemas);
        }
        catch (DBException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof SQLException) {
                SQLErrorDialog.showErrorDialog(null, (String)"Error Getting Schema List", (SQLException)((SQLException)cause));
            }
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)(cause != null ? cause : ex), (String)"Error Getting Schema List", (String)"An error was encountered trying to get the list of schemas.", null);
        }
    }

    protected void setTitle(String title) {
        this._title = title;
    }

    protected void setProvider(DBObjectProvider db) {
        this.put("DBObjectProvider", db);
    }

    protected DBObjectProvider getProvider() {
        return (DBObjectProvider)this.get("DBObjectProvider");
    }

    protected void setSchema(Schema schema) {
        this.put("Schema", schema);
    }

    protected Schema getSchema() {
        return (Schema)this.get("Schema");
    }

    protected void setTopLabel(String lbl) {
        this._topLabel = lbl;
    }

    public void addTab(Class pageClass, String helpID, String pageTitle) {
        Navigable nav = new Navigable(pageTitle, pageClass);
        if (ModelUtil.hasLength((String)helpID)) {
            nav.setHelpID(helpID);
        }
        this.addTab(nav);
    }

    public void addTab(Navigable tab) {
        this._tabs.add(tab);
    }

    public void registerVerifier(String verifierKey, Class verifier) {
        this._verifiers.put(verifierKey, verifier);
    }

    public void unregisterVerifier(String verifierKey) {
        this._verifiers.remove(verifierKey);
    }

    public abstract boolean createObject();

    public abstract boolean editObject(SchemaObject var1);

    public final boolean createObjectImpl() {
        DBObjectProvider provider = (DBObjectProvider)this.get("DBObjectProvider");
        SchemaObject object = (SchemaObject)this.get("OriginalObject");
        SchemaObject copy = (SchemaObject)this.get("NewObject");
        for (String key : this._verifiers.keySet()) {
            Class cls = (Class)this._verifiers.get(key);
            try {
                Verifier verifier = (Verifier)cls.newInstance();
                verifier.initializeVerifier(provider, object, copy);
                this.put(key, verifier);
            }
            catch (Exception ex) {}
        }
        return this.runDialog(this._title);
    }

    public void setErrorTitle(String errTitle) {
        this._errTitle = errTitle;
    }

    protected boolean runDialog(String title) {
        TabbedDBPanel panel = this.createPanel(this._tabs.toArray(new Navigable[this._tabs.size()]));
        if (ModelUtil.hasLength((String)this._topLabel)) {
            panel.setTopLabel(this._topLabel);
        }
        if (ModelUtil.hasLength((String)this._errTitle)) {
            panel.setErrorTitle(this._errTitle);
        }
        TDialogLauncher launcher = new TDialogLauncher((Component)Ide.getMainWindow(), title, (Traversable)panel, (Namespace)this);
        launcher.setInitialSize(600, 500);
        return launcher.showDialog();
    }

    protected TabbedDBPanel createPanel(Navigable[] navs) {
        TabbedDBPanel panel = new TabbedDBPanel(navs);
        return panel;
    }

    protected static abstract class SQLTab
    extends DefaultTraversablePanel {
        private JButton _btnSave;
        private final JTextArea _txtSQL = new JTextArea();

        public void onEntry(TraversableContext dataContext) {
            String sql = this.getSQL(dataContext);
            this._txtSQL.setText(sql);
            try {
                this.validate(dataContext);
            }
            catch (ValidationException e) {
                MessageDialog.error((Component)((Object)this), (Object)e.getMessage(), (String)CreateDialogArb.getString(515), null);
            }
        }

        protected abstract String getSQL(TraversableContext var1);

        protected abstract void validate(TraversableContext var1) throws ValidationException;

        public Component getComponent() {
            if (this.getComponentCount() == 0) {
                this.setLayout(new GridBagLayout());
                JLabel lblSQL = new JLabel();
                ResourceUtils.resLabel((JLabel)lblSQL, (Component)this._txtSQL, (String)CmWizardsArb.getString((int)178));
                this._btnSave = new JButton();
                this._btnSave.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent ae) {
                        URLChooser chooser = DialogUtil.newURLChooser();
                        chooser.clearChooseableURLFilters();
                        chooser.setURLFilter(SqlNode.SQL_FILTER);
                        URL url = null;
                        while (chooser.showSaveDialog((Component)((Object)SQLTab.this)) == 0) {
                            url = chooser.getSelectedURL();
                            if (!ModelUtil.hasLength((String)URLFileSystem.getSuffix((URL)url))) {
                                String path = URLFileSystem.getPath((URL)url);
                                url = URLFactory.replacePathPart((URL)url, (String)(path + ".sql"));
                            }
                            try {
                                url = NewFilePanel.validateURL((Component)((Object)SQLTab.this), (URL)url, (String)ConnectionArb.getString((int)303), (boolean)true);
                            }
                            catch (TraversalException ex) {
                                ex.showMessageDialog((Component)((Object)SQLTab.this));
                                break;
                            }
                            if (url == null) continue;
                        }
                        if (url != null) {
                            try {
                                OutputStream os = URLFileSystem.openOutputStream((URL)url);
                                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(os, IdeUtil.getIdeEncoding()));
                                writer.write(SQLTab.this._txtSQL.getText());
                                ((Writer)writer).flush();
                                ((Writer)writer).close();
                            }
                            catch (IOException ex) {
                                ExceptionDialog.showExceptionDialog((Component)((Object)SQLTab.this), (Throwable)ex, (String)CmWizardsArb.getString((int)180), (String)CmWizardsArb.getString((int)181), null);
                            }
                        }
                    }
                });
                ResourceUtils.resButton((AbstractButton)this._btnSave, (String)CmWizardsArb.getString((int)179));
                this._txtSQL.setEditable(false);
                JScrollPane scrSQL = new JScrollPane(this._txtSQL);
                this.add(lblSQL, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
                this.add(scrSQL, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
                this.add(this._btnSave, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
            }
            return this;
        }
    }

    protected static class EditSQLTab
    extends SQLTab {
        protected EditSQLTab() {
        }

        protected String getSQL(TraversableContext dataContext) {
            SchemaObject sObject = (SchemaObject)dataContext.get("NewObject");
            SchemaObject orig = (SchemaObject)dataContext.get("OriginalObject");
            DDLGenerator gen = (DDLGenerator)dataContext.get("DDlGenerator");
            Ddl[] ddl = gen.getUpdateDDL(orig, sObject);
            String txt = "";
            if (ddl != null) {
                for (int i = 0; i < ddl.length; ++i) {
                    txt = txt + ddl[i].getDdl();
                }
            }
            return txt;
        }

        protected void validate(TraversableContext dataContext) throws ValidationException {
            SchemaObject sObject = (SchemaObject)dataContext.get("NewObject");
            SchemaObject oldObject = (SchemaObject)dataContext.get("OriginalObject");
            DBObjectProvider pro = (DBObjectProvider)dataContext.get("DBObjectProvider");
            pro.validateObject((DBObject)oldObject, (DBObject)sObject);
        }
    }

    protected static class CreateSQLTab
    extends SQLTab {
        protected CreateSQLTab() {
        }

        protected String getSQL(TraversableContext dataContext) {
            SchemaObject sObject = (SchemaObject)dataContext.get("NewObject");
            DDLGenerator gen = (DDLGenerator)dataContext.get("DDlGenerator");
            Ddl ddl = gen.getCreateDDL(sObject, false, false);
            return ddl.getDdl();
        }

        protected void validate(TraversableContext dataContext) throws ValidationException {
            SchemaObject sObject = (SchemaObject)dataContext.get("NewObject");
            DBObjectProvider pro = (DBObjectProvider)dataContext.get("DBObjectProvider");
            pro.validateObject((DBObject)sObject);
        }
    }
}

