/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.actions;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.JMenuItem;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.Translate;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectAction {
    public static final String ACTION_KEY = "ObjectAction.KEY";
    private String _className;
    private String _sql;
    private String _title;
    private String _help;
    private ArrayList<String> _prompts;
    private ArrayList<String> _promptTypes;
    private ArrayList<String> _values;
    private ArrayList<String> _defaults;
    private ArrayList<String> _reloadPrompts;
    private String _type;
    private IdeAction _action;
    private int _id;
    private boolean _reloadParent = false;
    private boolean _reload = false;
    private String _confirm;
    private String _confirmTitle;
    private String _confirmSql;
    private String _classArgs;
    private boolean _removeFromParent;
    private float _maxver;
    private float _minver;

    public ObjectAction(String type, String sql, String title, String help, String className, String confirmTitle, String confirm, String confirmSql) {
        this._className = className;
        this._sql = sql;
        this._title = Translate.translate(title);
        this._type = type;
        this._help = help;
        this._confirm = confirm;
        this._confirmTitle = confirmTitle;
        this._confirmSql = confirmSql;
        String md5 = this.getMD5(this._sql);
        this._id = Ide.findOrCreateCmdID((String)("raptor.objectmodifier." + this._type + "." + title + "." + md5));
        this._action = IdeAction.get((int)this._id, (String)this._title, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)("raptor.objectmodifier." + this._type + "." + title))));
    }

    private String getMD5(String s) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(s.getBytes());
            return new String(md5.digest());
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    public JMenuItem getMenuItem(ContextMenu contextMenu) {
        JMenuItem mi = contextMenu.createMenuItem((ToggleAction)this._action);
        mi.putClientProperty(ACTION_KEY, this);
        return mi;
    }

    public JMenuItem getMenuItem() {
        JMenuItem mi = new JMenuItem((Action)this._action);
        mi.putClientProperty(ACTION_KEY, this);
        return mi;
    }

    public void addPrompt(String prompt, String value, String type, String def, String reload) {
        if (this._prompts == null) {
            this._prompts = new ArrayList();
            this._values = new ArrayList();
            this._promptTypes = new ArrayList();
            this._defaults = new ArrayList();
            this._reloadPrompts = new ArrayList();
        }
        this._prompts.add(prompt == null ? "" : Translate.translate(prompt));
        this._values.add(value);
        this._promptTypes.add(type);
        this._defaults.add(def);
        this._reloadPrompts.add(reload);
    }

    public boolean isValidForVersion(DBObject dbObject) {
        if ((double)this._minver == 0.0 && (double)this._maxver == 0.0) {
            return true;
        }
        DBUtil.getInstance();
        return DBUtil.checkVersion(dbObject, this._minver, this._maxver);
    }

    public void setMinVersion(String s) {
        if (s != null) {
            this._minver = Float.parseFloat(s);
        }
    }

    public void setMaxVersion(String s) {
        if (s != null) {
            this._maxver = Float.parseFloat(s);
        }
    }

    public void setValues(ArrayList<String> value) {
        this._values = value;
    }

    public ArrayList<String> getValues() {
        return this._values;
    }

    public void setReload(boolean reload) {
        this._reload = reload;
    }

    public boolean getReload() {
        return this._reload;
    }

    public void setReloadParent(boolean reload) {
        this._reloadParent = reload;
    }

    public boolean getReloadParent() {
        return this._reloadParent;
    }

    public void setRemoveFromParent(boolean remove) {
        this._removeFromParent = remove;
    }

    public boolean isRemoveFromParent() {
        return this._removeFromParent;
    }

    public IdeAction getAction() {
        return this._action;
    }

    public int getId() {
        return this._id;
    }

    public String getHelp() {
        return this._help;
    }

    public String getType() {
        return this._type;
    }

    public ArrayList<String> getPrompts() {
        return this._prompts;
    }

    public ArrayList<String> getReloadPrompts() {
        return this._reloadPrompts;
    }

    public ArrayList<String> getPromptTypes() {
        return this._promptTypes;
    }

    public ArrayList<String> getDefaults() {
        return this._defaults;
    }

    public String getSql() {
        return this._sql;
    }

    public String getTitle() {
        return this._title;
    }

    public String getClassName() {
        return this._className;
    }

    public String getConfirm() {
        return this._confirm;
    }

    public String getConfirmSql() {
        return this._confirmSql;
    }

    public String getConfirmTitle() {
        return this._confirmTitle;
    }

    public void setClassArgs(String classargs) {
        this._classArgs = classargs;
    }

    public String getClassArgs() {
        return this._classArgs;
    }
}

