/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.actions;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.controls.CustomTabbedPane;
import oracle.dbtools.raptor.controls.PropertyPanel;
import oracle.dbtools.raptor.controls.ResultSetTable;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.dialogs.export.ColumnPanel;
import oracle.dbtools.raptor.dialogs.export.ExportFormatPanel;
import oracle.dbtools.raptor.dialogs.export.PredicatePanel;
import oracle.dbtools.raptor.format.CSVFormatter;
import oracle.dbtools.raptor.format.InsertFormatter;
import oracle.dbtools.raptor.format.LoaderFormatter;
import oracle.dbtools.raptor.format.ResultsFormatter;
import oracle.dbtools.raptor.format.TxtFormatter;
import oracle.dbtools.raptor.format.XMLFormatter;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.Translate;
import oracle.dbtools.raptor.utils.UIUtils;
import oracle.ide.Ide;
import oracle.ide.controls.tree.TreeCellCheckedEvent;
import oracle.ide.controls.tree.TreeCellCheckedListener;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.IdeUtil;

public class TableExportAction
extends AbstractMenuAction
implements ActionListener,
ChangeListener {
    private String _format;
    private ColumnPanel _cols;
    private PredicatePanel _predicate;
    private ExportFormatPanel _formatPanel;
    private JMenu _menu;
    private String _sql;
    private Connection _conn = null;
    private String _connName;
    private String _name;
    private String _schema;
    private String _tName;
    private String _from;
    private ArrayList _bindList = null;
    private HashMap _bindMap = null;
    private JTable _table;
    private JEWTDialog dlg;
    private TreeCellCheckedListener _colListener = new TreeCellCheckedListener(){

        public void cellChecked(TreeCellCheckedEvent arg0) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    TableExportAction.this._predicate.setSQL("select " + TableExportAction.this._cols.getSelectedColumns() + TableExportAction.this._from);
                }
            });
        }

        public void cellUnchecked(TreeCellCheckedEvent arg0) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    TableExportAction.this._predicate.setSQL("select " + TableExportAction.this._cols.getSelectedColumns() + TableExportAction.this._from);
                }
            });
        }
    };

    public void launch() {
        this._connName = this.getDBObject().getDatabase().getConnectionName();
        this._schema = this.getDBObject().getSchemaName();
        this._tName = this.getDBObject().getObjectName();
        this._sql = "select * from (select * from \"" + this._schema + "\".\"" + this._tName + "\")";
        this.scrubColList();
        this._name = this.getDBObject().getObjectName();
        this._from = "from (" + this._sql + ")";
        this.showPanels();
    }

    public void launchDlg() {
        this._connName = Connections.getInstance().getDatabase(this._conn).getConnectionName();
        this._name = this._table instanceof ResultSetTable ? ((ResultSetTable)this._table).getDefaultExportName() : "Export";
        this.scrubColList();
        this._sql = "select * from (" + this._sql + ")";
        this._from = "from (" + this._sql + ")";
        this.showPanels();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scrubColList() {
        Statement pstmt = null;
        ResultSet rset = null;
        try {
            pstmt = Connections.getInstance().getConnection(this._connName).prepareStatement(this._sql);
            if (this._bindList != null) {
                DBUtil.getInstance().bind((PreparedStatement)pstmt, this._bindList);
            } else if (this._bindMap != null) {
                DBUtil.getInstance().bind((PreparedStatement)pstmt, this._bindMap);
            }
            StringBuilder sb = new StringBuilder("select ");
            rset = pstmt.executeQuery();
            for (int i = 1; i <= rset.getMetaData().getColumnCount(); ++i) {
                boolean allowed;
                switch (rset.getMetaData().getColumnType(i)) {
                    case 2004: 
                    case 2005: {
                        allowed = false;
                        break;
                    }
                    default: {
                        allowed = true;
                    }
                }
                if (!allowed) continue;
                sb.append("\"" + rset.getMetaData().getColumnName(i) + "\",");
            }
            sb.replace(sb.length() - 1, sb.length(), "");
            sb.append(" from ( " + this._sql + ")");
            this._sql = sb.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (SQLException e) {}
            try {
                if (rset != null) {
                    rset.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    private void showPanels() {
        this._predicate = this._bindList != null ? new PredicatePanel(this._connName, this._sql, this._bindList) : (this._bindMap != null ? new PredicatePanel(this._connName, this._sql, this._bindMap) : new PredicatePanel(this._connName, this._sql));
        this._cols = this._bindList != null ? new ColumnPanel(this._connName, this._sql, this._bindList) : (this._bindMap != null ? new ColumnPanel(this._connName, this._sql, this._bindMap) : new ColumnPanel(this._connName, this._sql));
        if (this._cols.getColCount() == 0) {
            return;
        }
        this._cols.addTreeCellCheckedListener(this._colListener);
        this._formatPanel = new ExportFormatPanel(this._format);
        this._formatPanel.setDefaultName(this._name);
        String _type = "";
        _type = this._format.equals("CSV") ? "csv" : (this._format.equals("INSERT") ? "sql" : (this._format.equals("XML") ? "xml" : (this._format.equals("LOADER") ? "ldr" : (this._format.equals("TXT") ? "txt" : this._format))));
        this._formatPanel.setFileName(System.getProperty("user.home") + File.separator + this._name + "." + _type);
        JPanel[] panels = new JPanel[]{this._formatPanel, this._cols, this._predicate};
        HelpSystem.getHelpSystem().registerTopic((JComponent)this._formatPanel, "f1_idedexporttabledata_html");
        HelpSystem.getHelpSystem().registerTopic((JComponent)this._cols, "f1_idedexporttabledata_html");
        HelpSystem.getHelpSystem().registerTopic((JComponent)this._predicate, "f1_idedexporttabledata_html");
        String[] tabs = new String[]{"Format", "Columns", "Where"};
        UIUtils.showPanelAsTabbedDialog(panels, tabs, "Export Data", this, null, this);
    }

    public void setArgs(String args) {
        this._format = args;
    }

    public void actionPerformed(ActionEvent e) {
        String format = this._formatPanel.getFormat();
        Boolean export = true;
        try {
            BufferedOutputStream out = null;
            ByteArrayOutputStream bout = null;
            OutputStreamWriter outWriter = null;
            if (this._formatPanel.getDestination().equalsIgnoreCase("file")) {
                if (!this._formatPanel.getFileName().equals("")) {
                    FileOutputStream fout = new FileOutputStream(this._formatPanel.getFileName());
                    out = new BufferedOutputStream(fout);
                    try {
                        String encoding = IdeUtil.getIdeEncoding();
                        outWriter = new OutputStreamWriter((OutputStream)out, encoding);
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                } else {
                    export = false;
                    PropertyPanel panel = new PropertyPanel();
                    String title = Translate.translate("Warning Message");
                    JLabel mess = new JLabel(Translate.translate("Must provide a file name."));
                    panel.addSingleComp(mess);
                    panel.setBackground(UIManager.getColor("EWTDialog.background"));
                    this.dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)panel, null, (String)title, (int)1);
                    this.dlg.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            TableExportAction.this.dlg.dispose();
                        }
                    });
                    Dimension dim = panel.getPreferredSize();
                    int h = (int)dim.getHeight() + 100;
                    int w = (int)dim.getWidth() + 100;
                    this.dlg.setSize(w, h);
                    this.dlg.setPreferredSize(w, h);
                    IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)this.dlg);
                    this.dlg.setVisible(true);
                }
            } else {
                bout = new ByteArrayOutputStream();
                out = new BufferedOutputStream(bout);
                try {
                    String encoding = IdeUtil.getIdeEncoding();
                    outWriter = new OutputStreamWriter((OutputStream)out, encoding);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
            JTable table = null;
            String p = this._predicate.getPredicate();
            String c = this._cols.getSelectedColumns();
            table = this._predicate.getPredicate() != null && this._predicate.getPredicate().equals("") && this._cols.getSelectedColumns().equals(" * ") ? this._table : this._predicate.getTable();
            if (export.booleanValue()) {
                ResultsFormatter formatter = null;
                if (table != null) {
                    if (format.equalsIgnoreCase("XML")) {
                        formatter = new XMLFormatter(table, outWriter);
                    } else if (format.equalsIgnoreCase("CSV")) {
                        formatter = new CSVFormatter(table, outWriter);
                    } else if (format.equalsIgnoreCase("INSERT")) {
                        formatter = new InsertFormatter(table, outWriter, this._formatPanel.getDefaultName());
                    } else if (format.equalsIgnoreCase("LOADER")) {
                        formatter = new LoaderFormatter(table, outWriter, this._formatPanel.getDefaultName());
                    } else if (format.equalsIgnoreCase("TXT")) {
                        formatter = new TxtFormatter(table, outWriter);
                    }
                } else if (format.equalsIgnoreCase("XML")) {
                    formatter = new XMLFormatter(this._connName, this._sql, outWriter);
                } else if (format.equalsIgnoreCase("CSV")) {
                    formatter = new CSVFormatter(this._connName, this._sql, outWriter);
                } else if (format.equalsIgnoreCase("INSERT")) {
                    formatter = new InsertFormatter(this._connName, this._sql, outWriter, this._formatPanel.getDefaultName());
                } else if (format.equalsIgnoreCase("LOADER")) {
                    formatter = new LoaderFormatter(this._connName, this._sql, outWriter, this._formatPanel.getDefaultName());
                } else if (format.equalsIgnoreCase("TXT")) {
                    formatter = new TxtFormatter(this._connName, this._sql, outWriter);
                }
                if (formatter != null) {
                    formatter.printWithDialog();
                }
                if (!this._formatPanel.getDestination().equalsIgnoreCase("file")) {
                    UIUtils.setClipboard(bout.toString());
                }
                if (e.getSource() instanceof JEWTDialog) {
                    ((JEWTDialog)e.getSource()).dispose();
                }
                try {
                    outWriter.close();
                }
                catch (IOException e1) {}
            }
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
    }

    public void stateChanged(ChangeEvent e) {
        if (((CustomTabbedPane)e.getSource()).getSelectedIndex() == 2) {
            this._predicate.setSQL("select " + this._cols.getSelectedColumns() + this._from);
            this._predicate.showSampleData();
        }
    }

    public JMenu getMenu() {
        if (this._menu == null) {
            this._menu = new JMenu("Export");
            JMenuItem csv = new JMenuItem("CSV");
            JMenuItem xml = new JMenuItem("XML");
            JMenuItem ins = new JMenuItem("INSERT");
            JMenuItem load = new JMenuItem("LOADER");
            JMenuItem text = new JMenuItem("TEXT");
            text.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TableExportAction.this.setArgs("TXT");
                    TableExportAction.this.launchDlg();
                }
            });
            csv.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TableExportAction.this.setArgs("CSV");
                    TableExportAction.this.launchDlg();
                }
            });
            xml.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TableExportAction.this.setArgs("XML");
                    TableExportAction.this.launchDlg();
                }
            });
            ins.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TableExportAction.this.setArgs("INSERT");
                    TableExportAction.this.launchDlg();
                }
            });
            load.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TableExportAction.this.setArgs("LOADER");
                    TableExportAction.this.launchDlg();
                }
            });
            this._menu.add(csv);
            this._menu.add(xml);
            this._menu.add(ins);
            this._menu.add(load);
            this._menu.add(text);
        }
        return this._menu;
    }

    public void setSql(String sql) {
        this._sql = sql;
    }

    public void setConn(Connection conn) {
        this._conn = conn;
    }

    public void setBindList(ArrayList _bindList) {
        this._bindList = _bindList;
    }

    public void setBindMap(HashMap _bindMap) {
        this._bindMap = _bindMap;
    }

    public void setTable(JTable table) {
        this._table = table;
    }

    public JTable getTable() {
        return this._table;
    }
}

