/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.actions;

import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Stack;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.dbtools.raptor.dialogs.BasicObjectModifier;
import oracle.dbtools.raptor.dialogs.actions.ObjectAction;
import oracle.dbtools.raptor.explorer.dt.IViewerNode;
import oracle.dbtools.raptor.utils.AbstractFolderedXml;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.Translate;
import oracle.dbtools.raptor.utils.XMLHelper;
import oracle.dbtools.util.Resource;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.model.Node;
import oracle.ide.resource.IdeArb;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLBasedObjectAction {
    private static XMLBasedObjectAction _instance;
    private static Object LOCK;
    private static ArrayList<URL> _registeredContextMenus;
    private DefaultController _controller = null;
    private HashMap _menus;
    private ArrayList<ObjectAction> _actions;
    private HashMap _menus_to_actions = new HashMap();
    private IdeAction defaultAction = IdeAction.get((int)DEFAULT_CMD_ID, null, (String)Translate.translate("Actions"), null, null, (Icon)IdeArb.getIcon((int)143), null, (boolean)true);
    static final int DEFAULT_CMD_ID;

    public static synchronized void registerContextMenus(URL url) {
        _registeredContextMenus.add(url);
    }

    public static synchronized ArrayList<URL> getRegisterContextMenus() {
        return _registeredContextMenus;
    }

    private XMLBasedObjectAction() {
        this._controller = new DefaultController();
        this.defaultAction.addController((Controller)this._controller);
        Thread loader = new Thread(){

            public void run() {
                XMLBasedObjectAction.this.loadXML();
            }
        };
        loader.setName("XML Action Loader");
        loader.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XMLBasedObjectAction getInstance() {
        Object object = LOCK;
        synchronized (object) {
            if (_instance == null) {
                _instance = new XMLBasedObjectAction();
            }
        }
        return _instance;
    }

    public ObjectAction findCurrentAction(IdeAction action) {
        ObjectAction _currAction = null;
        for (int i = 0; _currAction == null && i < this._actions.size(); ++i) {
            if (this._actions.get(i).getId() != action.getCommandId()) continue;
            _currAction = this._actions.get(i);
        }
        return _currAction;
    }

    public IdeAction getIdeAction() {
        return this.defaultAction;
    }

    public void setController(Controller cont) {
        this._controller.setController(cont);
    }

    public JPopupMenu getMenu(DBObject dbObject) {
        int i;
        if (this._menus == null || Resource.DEV_MODE) {
            this.loadXML();
        }
        ArrayList actions = (ArrayList)this._menus.get(dbObject.getObjectType());
        ArrayList menus = (ArrayList)this._menus.get(dbObject.getObjectType() + "_MENUS");
        JPopupMenu menu = new JPopupMenu(Translate.translate("Actions"));
        for (i = 0; menus != null && i < menus.size(); ++i) {
            menu.add((JMenu)menus.get(i));
        }
        for (i = 0; actions != null && i < actions.size(); ++i) {
            menu.add(((ObjectAction)actions.get(i)).getMenuItem());
        }
        return menu;
    }

    public void addToMenu(ContextMenu contextMenu, DBObject dbObject) {
        int i;
        if (this._menus == null || Resource.DEV_MODE) {
            this.loadXML();
        }
        ArrayList actions = (ArrayList)this._menus.get(dbObject.getObjectType());
        ArrayList menus = (ArrayList)this._menus.get(dbObject.getObjectType() + "_MENUS");
        if (actions != null) {
            for (ObjectAction a : actions) {
                if (a.isValidForVersion(dbObject)) {
                    a.getAction().setEnabled(true);
                    continue;
                }
                a.getAction().setEnabled(false);
            }
        }
        for (i = 0; menus != null && i < menus.size(); ++i) {
            JMenu m = (JMenu)menus.get(i);
            this.setEnabled(m.getPopupMenu(), dbObject);
            contextMenu.add((Component)m);
        }
        for (i = 0; actions != null && i < actions.size(); ++i) {
            contextMenu.add((Component)((ObjectAction)actions.get(i)).getMenuItem(contextMenu));
        }
    }

    public void setEnabled(JPopupMenu folder, DBObject dbObject) {
        Component[] cps = folder.getComponents();
        for (int i = 0; i < cps.length; ++i) {
            Component cp = cps[i];
            ObjectAction objAct = (ObjectAction)this._menus_to_actions.get(cp);
            if (objAct == null) continue;
            if (objAct.isValidForVersion(dbObject)) {
                cp.setEnabled(true);
                continue;
            }
            cp.setEnabled(false);
        }
    }

    private void loadXML() {
        XMLParser parser = new XMLParser();
        this._actions = new ArrayList();
        this._menus = new HashMap();
        parser.processXML(Resource.getResourceAsStream(BasicObjectModifier.class, "ObjectActions.xml"));
        if (System.getProperty("raptor.user.contextmenu") != null) {
            String[] files = System.getProperty("raptor.user.contextmenu").split("[:;]");
            File f = null;
            for (int i = 0; i < files.length; ++i) {
                f = new File(files[i]);
                if (!f.exists()) continue;
                try {
                    parser.processXML(new FileInputStream(f));
                    continue;
                }
                catch (FileNotFoundException e) {
                    System.err.println("Could not process user actions:" + f.toString() + ":" + e.getMessage());
                }
            }
        }
        for (URL url : XMLBasedObjectAction.getRegisterContextMenus()) {
            try {
                parser.processXML(url.openStream());
            }
            catch (Exception e) {
                System.err.println("Could not process user actions:" + url + ":" + e.getMessage());
            }
        }
    }

    private ObjectAction processNode(org.w3c.dom.Node node) {
        String title = XMLHelper.getNodeValue(node, "title");
        String sql = XMLHelper.getNodeValue(node, "sql");
        String reloadparent = XMLHelper.getAttributeNode(node, "reloadparent");
        String reload = XMLHelper.getAttributeNode(node, "reload");
        String remove = XMLHelper.getAttributeNode(node, "removeFromParent");
        String type = XMLHelper.getAttributeNode(node, "type");
        String help = XMLHelper.getNodeValue(node, "help");
        String className = XMLHelper.getAttributeNode(node, "className");
        String classargs = XMLHelper.getAttributeNode(node, "classArgs");
        String confirm = XMLHelper.getNodeValue(XMLHelper.getChildNode(node, "confirmation"), "prompt");
        String confirmTitle = XMLHelper.getNodeValue(XMLHelper.getChildNode(node, "confirmation"), "title");
        String confirmSql = XMLHelper.getNodeValue(XMLHelper.getChildNode(node, "confirmation"), "sql");
        ObjectAction working = new ObjectAction(type, sql, title, help, className, confirmTitle, confirm, confirmSql);
        working.setReloadParent(reloadparent != null && reloadparent.equalsIgnoreCase("true"));
        working.setReload(reload != null && reload.equalsIgnoreCase("true"));
        working.setRemoveFromParent(Boolean.parseBoolean(remove));
        working.setClassArgs(classargs);
        working.setMinVersion(XMLHelper.getAttributeNode(node, "maxversion"));
        working.setMaxVersion(XMLHelper.getAttributeNode(node, "minversion"));
        NodeList nodes = node.getChildNodes();
        String name = null;
        String value = null;
        String def = null;
        String promptType = null;
        for (int i = 0; i < nodes.getLength(); ++i) {
            if (!nodes.item(i).getNodeName().equalsIgnoreCase("prompt")) continue;
            name = XMLHelper.getNodeValue(nodes.item(i), "label");
            value = XMLHelper.getNodeValue(nodes.item(i), "value");
            def = XMLHelper.getNodeValue(nodes.item(i), "default");
            promptType = XMLHelper.getAttributeNode(nodes.item(i), "type");
            reload = XMLHelper.getAttributeNode(nodes.item(i), "reload");
            working.addPrompt(name, value, promptType, def, reload);
        }
        working.getAction().addController((Controller)this._controller);
        this._actions.add(working);
        return working;
    }

    static {
        LOCK = new Object();
        _registeredContextMenus = new ArrayList();
        DEFAULT_CMD_ID = Ide.findOrCreateCmdID((String)"DEFAULT_XML_ACTION_ID");
    }

    private class DefaultController
    implements Controller {
        private Controller _controller;

        private DefaultController() {
        }

        public void setController(Controller c) {
            this._controller = c;
        }

        public boolean handleEvent(IdeAction action, Context context) {
            JPopupMenu menu;
            int cmdId = action.getCommandId();
            if (cmdId == DEFAULT_CMD_ID && context.getNode() instanceof IViewerNode && (menu = XMLBasedObjectAction.this.getMenu(new DBObject((Node)((IViewerNode)context.getNode()).getDatabaseNode()))).getComponentCount() > 0) {
                menu.show((Component)context.getEvent().getSource(), 0, 0);
            }
            return this._controller.handleEvent(action, context);
        }

        public boolean update(IdeAction action, Context context) {
            return this._controller.update(action, context);
        }
    }

    private final class XMLParser
    extends AbstractFolderedXml {
        private Stack<JMenu> folders = new Stack();

        private XMLParser() {
        }

        public void openFolder(String name, String desc, String tip, org.w3c.dom.Node node) {
            String type = XMLHelper.getAttributeNode(node, "type");
            if (this.folders.size() == 0) {
                JMenu menu = new JMenu(name);
                this.folders.push(menu);
                if (XMLBasedObjectAction.this._menus.get(type + "_MENUS") == null) {
                    XMLBasedObjectAction.this._menus.put(type + "_MENUS", new ArrayList());
                }
                ((ArrayList)XMLBasedObjectAction.this._menus.get(type + "_MENUS")).add(menu);
            } else {
                JMenu menu = new JMenu(name);
                this.folders.peek().add(menu);
            }
        }

        public void newItem(org.w3c.dom.Node node) {
            ObjectAction action = XMLBasedObjectAction.this.processNode(node);
            if (this.folders.size() > 0) {
                JMenuItem jmi = this.folders.peek().add((Action)action.getAction());
                XMLBasedObjectAction.this._menus_to_actions.put(jmi, action);
            } else {
                if (XMLBasedObjectAction.this._menus.get(action.getType()) == null) {
                    XMLBasedObjectAction.this._menus.put(action.getType(), new ArrayList());
                }
                ((ArrayList)XMLBasedObjectAction.this._menus.get(action.getType())).add(action);
            }
        }

        public void closeFolder() {
            this.folders.pop();
        }
    }
}

