/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.conn;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.dialogs.CreateDialogArb;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.cm.CMException;
import oracle.jdeveloper.cm.ConnectionCanceledException;
import oracle.jdeveloper.cm.ConnectionDescriptor;

public class ConnectionInfoPanel
extends DefaultTraversablePanel {
    private JPasswordField fldPwd = new JPasswordField();
    private JTextField fldUser = new JTextField();

    public static void promptForConnection(final ConnectionDescriptor desc) throws CMException {
        final ConnectionInfoPanel panel = new ConnectionInfoPanel();
        panel.init(desc);
        JEWTDialog dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)((Object)panel), (Component)panel.getInitialFocus(), (String)CreateDialogArb.getString(575));
        dlg.addVetoableChangeListener(new VetoableChangeListener(){

            public void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
                if ("closed".equals(e.getPropertyName()) && Boolean.TRUE.equals(e.getNewValue())) {
                    try {
                        panel.commit(desc);
                    }
                    catch (TraversalException ex) {
                        ex.showMessageDialog((Component)((Object)panel));
                        throw new PropertyVetoException("no", e);
                    }
                }
            }
        });
        dlg.setResizable(true);
        if (!WizardLauncher.runDialog((JDialog)dlg)) {
            throw new ConnectionCanceledException();
        }
    }

    public ConnectionInfoPanel() {
        try {
            this.jbInit();
            HelpSystem.getHelpSystem().registerTopic((JComponent)((Object)this), "f1_connection_info_html");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void init(ConnectionDescriptor desc) {
        String userName = desc.getUsername();
        this.fldUser.setText(userName != null ? userName : "");
        String pwd = desc.getPassword();
        this.fldPwd.setText(pwd != null ? pwd : "");
    }

    public void commit(ConnectionDescriptor desc) throws TraversalException {
        String userName = this.fldUser.getText();
        if (!ModelUtil.hasLength((String)userName)) {
            throw new TraversalException(CreateDialogArb.getString(576));
        }
        desc.setProperty("user", userName);
        char[] pwd = this.fldPwd.getPassword();
        if (pwd == null || pwd.length == 0) {
            throw new TraversalException(CreateDialogArb.getString(577));
        }
        desc.setProperty("password", new String(pwd));
    }

    private JTextField getInitialFocus() {
        return ModelUtil.hasLength((String)this.fldUser.getText()) ? this.fldPwd : this.fldUser;
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        JLabel lblUsername = new JLabel();
        JLabel lblPwd = new JLabel();
        ResourceUtils.resLabel((JLabel)lblUsername, (Component)this.fldUser, (String)CreateDialogArb.getString(573));
        ResourceUtils.resLabel((JLabel)lblPwd, (Component)this.fldPwd, (String)CreateDialogArb.getString(574));
        this.fldUser.setColumns(30);
        this.add(lblUsername, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.add(lblPwd, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.add(this.fldPwd, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this.fldUser, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
    }
}

