/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.dblink;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import oracle.dbtools.raptor.dialogs.CreateDialogArb;
import oracle.dbtools.raptor.dialogs.dblink.DblinkInfoVerifier;
import oracle.ide.Ide;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.dialogs.ProgressBar;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Assert;
import oracle.ide.util.ModelUtil;
import oracle.ide.wizard.WizardCallbacks;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.ora.DatabaseLink;
import oracle.javatools.db.ora.NameBasedRefID;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdeveloper.cm.dt.ConnectionArb;
import oracle.jdeveloper.cm.dt.ui.DBObjectRenderer;
import oracle.jdeveloper.cm.dt.ui.SchemaPicker;

public class DblinkTab
extends DefaultTraversablePanel
implements ActionListener {
    private JLabel dbLinkNameLabel = new JLabel();
    private JTextField dbLinkNameTextField = new JTextField();
    private JLabel serviceNameLabel = new JLabel();
    private JTextField serviceNameTextField = new JTextField();
    private JRadioButton currentUserRadioBtn = new JRadioButton();
    private JRadioButton fixedUserRadioBtn = new JRadioButton();
    private JLabel fixedUserNameLabel = new JLabel();
    private JLabel fixedUserPasswordLabel = new JLabel();
    private JTextField userNameTextField = new JTextField();
    private JPasswordField passwordField = new JPasswordField();
    private JCheckBox publicCheckBox = new JCheckBox();
    private JCheckBox sharedCheckBox = new JCheckBox();
    private JLabel authenUserNameLabel = new JLabel();
    private JLabel authenPasswordLabel = new JLabel();
    private JTextField authenTextFeild = new JTextField();
    private JPasswordField authenPasswordField = new JPasswordField();
    private JLabel currentUserLabel = new JLabel();
    private JLabel fixedUser = new JLabel();
    private JLabel publicLabel = new JLabel();
    private JLabel SharedLabel = new JLabel();
    private JCheckBox preserveCaseCheckBox = new JCheckBox();
    private JLabel preserveCaseLabel = new JLabel();
    private JSeparator jSeparator1 = new JSeparator();
    private JSeparator jSeparator2 = new JSeparator();
    private JLabel authenticationLabel = new JLabel();
    private JLabel jLabel1 = new JLabel();
    private ButtonGroup userTypeButtonGroup = new ButtonGroup();
    public static final String TABLESPACES_KEY = "Tablespaces";
    public static final String PUBLIC = "PUBLIC";
    private static final int LOAD_NOT_ATTEMPTED = 0;
    private static final int LOAD_COMPLETED = 1;
    private int m_ObjectStatus = 0;
    private ProgressBar m_progressBar = null;
    private static final String[] DATABASELINK_TYPES = new String[]{"TABLE", "VIEW", "SEQUENCE", "DATABASE LINK"};
    private static final String FORSCHEMACHANGED = "ForSchemaChanged";
    private static final String OBJECTCHANGED = "ObjectChanged";
    private static final String SETOBJECTBASED = "SetObjectBased";
    private static final String SETNAMEBASED = "SetNameBased";
    private static final String FIXEDUSER = "FixedUser";
    private static final String SHARED = "Shared";
    protected DBObjectProvider m_prov = null;
    protected DatabaseLink m_dblink = null;
    protected Schema m_forSchema = null;
    protected String m_savedName = null;
    private Schema[] m_schemas = null;
    private Schema m_originalSchema = null;
    private GridBagLayout layCenter = new GridBagLayout();
    private JLabel m_lblFor = new JLabel();
    private JLabel m_lblForSchemaName = new JLabel();
    private JComboBox m_cmbObject = new JComboBox();
    private JTextField m_txtName = new JTextField();
    private JRadioButton m_rdbObjectBased = new JRadioButton();
    private JRadioButton m_rdbNameBased = new JRadioButton();
    private ButtonGroup m_rbgBased = new ButtonGroup();
    private JMultiLineLabel m_lblDanglingBlather = new JMultiLineLabel();
    private DBObjectRenderer m_renderer = new DBObjectRenderer();
    private SchemaPicker m_cmbForSchema = new SchemaPicker();
    private DefaultComboBoxModel m_mdlSchema = new NonNullableComboBoxModel();
    private DefaultComboBoxModel m_mdlForSchema = new NonNullableComboBoxModel();
    private static final DefaultComboBoxModel EMPTY_MDL_OBJECT = new NonNullableComboBoxModel();
    private Map m_schemaMap = new HashMap();
    private DblinkInfoVerifier m_verifier;
    private boolean m_isDefaultObject = true;
    private boolean m_isNewDblinkObject = true;
    private boolean m_isInit = false;
    private HashMap m_loadingSchemas = new HashMap();

    public DblinkTab() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(null);
        this.setSize(new Dimension(330, 300));
        this.serviceNameLabel.setText("Service Name");
        this.serviceNameLabel.setBounds(new Rectangle(10, 10, 125, 25));
        this.serviceNameLabel.setToolTipText("null");
        this.serviceNameTextField.setBounds(new Rectangle(180, 10, 120, 20));
        this.currentUserRadioBtn.setBounds(new Rectangle(90, 30, 15, 20));
        this.currentUserRadioBtn.setHorizontalTextPosition(0);
        this.currentUserRadioBtn.setHorizontalAlignment(0);
        this.currentUserRadioBtn.setSelected(true);
        this.currentUserRadioBtn.setActionCommand(FIXEDUSER);
        this.currentUserRadioBtn.addActionListener(this);
        this.fixedUserRadioBtn.setText("");
        this.fixedUserRadioBtn.setBounds(new Rectangle(90, 50, 15, 20));
        this.fixedUserRadioBtn.setToolTipText("null");
        this.fixedUserRadioBtn.setHorizontalTextPosition(0);
        this.fixedUserRadioBtn.setHorizontalAlignment(0);
        this.fixedUserRadioBtn.setActionCommand(FIXEDUSER);
        this.fixedUserRadioBtn.addActionListener(this);
        this.userTypeButtonGroup.add(this.fixedUserRadioBtn);
        this.userTypeButtonGroup.add(this.currentUserRadioBtn);
        this.fixedUserNameLabel.setText("User Name");
        this.fixedUserNameLabel.setBounds(new Rectangle(100, 75, 75, 20));
        this.fixedUserNameLabel.setEnabled(false);
        this.fixedUserPasswordLabel.setText("Password");
        this.fixedUserPasswordLabel.setBounds(new Rectangle(100, 100, 75, 20));
        this.fixedUserPasswordLabel.setEnabled(false);
        this.userNameTextField.setBounds(new Rectangle(180, 75, 120, 20));
        this.userNameTextField.setEnabled(false);
        this.passwordField.setBounds(new Rectangle(180, 100, 120, 20));
        this.passwordField.setEnabled(false);
        this.sharedCheckBox.setBounds(new Rectangle(90, 160, 15, 20));
        this.sharedCheckBox.setHorizontalTextPosition(2);
        this.sharedCheckBox.setActionCommand(SHARED);
        this.sharedCheckBox.addActionListener(this);
        this.authenUserNameLabel.setText("User Name");
        this.authenUserNameLabel.setBounds(new Rectangle(100, 195, 75, 20));
        this.authenUserNameLabel.setEnabled(false);
        this.authenPasswordLabel.setText("Password");
        this.authenPasswordLabel.setBounds(new Rectangle(100, 215, 60, 25));
        this.authenPasswordLabel.setEnabled(false);
        this.authenTextFeild.setBounds(new Rectangle(180, 195, 120, 20));
        this.authenTextFeild.setEnabled(false);
        this.authenPasswordField.setBounds(new Rectangle(180, 220, 120, 20));
        this.authenPasswordField.setEnabled(false);
        this.currentUserLabel.setText("Current User");
        this.currentUserLabel.setBounds(new Rectangle(10, 30, 65, 20));
        this.currentUserLabel.setSize(new Dimension(85, 20));
        this.fixedUser.setText("Fixed User");
        this.fixedUser.setBounds(new Rectangle(10, 50, 55, 20));
        this.fixedUser.setSize(new Dimension(85, 20));
        this.SharedLabel.setText(SHARED);
        this.SharedLabel.setBounds(new Rectangle(10, 160, 50, 20));
        this.jSeparator1.setBounds(new Rectangle(5, 0, 315, 10));
        this.jSeparator2.setBounds(new Rectangle(5, 130, 315, 5));
        this.authenticationLabel.setText("Authentication");
        this.authenticationLabel.setBounds(new Rectangle(195, 180, 95, 10));
        this.jLabel1.setText("Connect To");
        this.jLabel1.setBounds(new Rectangle(200, 50, 90, 15));
        this.add(this.authenticationLabel, null);
        this.add(this.jSeparator2, null);
        this.add(this.SharedLabel, null);
        this.add(this.publicLabel, null);
        this.add(this.fixedUser, null);
        this.add(this.currentUserLabel, null);
        this.add(this.authenPasswordField, null);
        this.add(this.authenTextFeild, null);
        this.add(this.authenPasswordLabel, null);
        this.add(this.authenUserNameLabel, null);
        this.add(this.sharedCheckBox, null);
        this.add(this.publicCheckBox, null);
        this.add(this.passwordField, null);
        this.add(this.userNameTextField, null);
        this.add(this.fixedUserPasswordLabel, null);
        this.add(this.fixedUserNameLabel, null);
        this.add(this.fixedUserRadioBtn, null);
        this.add(this.currentUserRadioBtn, null);
        this.add(this.serviceNameTextField, null);
        this.add(this.serviceNameLabel, null);
    }

    private void currentUserRadioBtn_actionPerformed(ActionEvent e) {
    }

    private void fixedUserRadioBtn_actionPerformed(ActionEvent e) {
    }

    public String getHeaderTitle() {
        return CreateDialogArb.getString(237);
    }

    public Image getHeaderImage() {
        return ConnectionArb.getImage((int)451);
    }

    public String getHeaderDescription() {
        return CreateDialogArb.getString(238);
    }

    protected boolean isDangling(DBObjectID ref) {
        return false;
    }

    protected String getDanglingBlather() {
        return null;
    }

    public void onEntry(TraversableContext dataContext) {
        this.m_prov = (DBObjectProvider)dataContext.find("DBObjectProvider");
        this.m_dblink = (DatabaseLink)dataContext.find("NewObject");
        this.m_verifier = (DblinkInfoVerifier)((Object)dataContext.find(DblinkInfoVerifier.KEY));
        Schema[] schemas = (Schema[])dataContext.find("SchemaList");
        this.init(this.m_dblink, this.m_verifier, schemas);
        WizardCallbacks callbacks = dataContext.getWizardCallbacks();
        if (callbacks != null) {
            callbacks.wizardEnableButtons(Boolean.TRUE, Boolean.TRUE, Boolean.TRUE);
        }
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        DatabaseLink databaselink = (DatabaseLink)dataContext.find("NewObject");
        if (databaselink == null) {
            databaselink = new DatabaseLink();
        }
        Schema[] schemas = (Schema[])dataContext.find("SchemaList");
        this.commit(databaselink, schemas, dataContext.getDirection() != 2);
    }

    private void init(DatabaseLink model, DblinkInfoVerifier verifier, Schema[] schemas) {
        if (this.m_isInit) {
            return;
        }
        this.m_isInit = true;
        this.m_schemas = schemas;
        this.m_cmbForSchema.setProvider(this.m_prov);
        this.m_renderer.setProvider(this.m_prov);
        if (this.isDangling(model.getID())) {
            this.m_lblDanglingBlather.setText(this.getDanglingBlather());
        } else {
            this.m_lblDanglingBlather.setText(null);
        }
        this.m_mdlSchema.removeAllElements();
        this.m_mdlForSchema.removeAllElements();
        for (int i = 0; i < schemas.length; ++i) {
            this.m_mdlSchema.addElement(schemas[i]);
            this.m_mdlForSchema.addElement(schemas[i]);
        }
        this.m_originalSchema = model.getSchema();
        this.setOriginalSchema();
        this.m_forSchema = this.m_originalSchema;
        DBObjectID refID = model.getID();
        if (null != refID) {
            this.m_isNewDblinkObject = false;
            SchemaObject forObject = null;
            try {
                forObject = (SchemaObject)refID.resolveID();
            }
            catch (DBException dbe) {
                // empty catch block
            }
            if (forObject == null) {
                this.setForSchemaAndName(refID);
            } else {
                this.m_forSchema = forObject.getSchema();
            }
        }
        if (this.m_forSchema != null) {
            if (this.m_mdlForSchema.getIndexOf(this.m_forSchema) < 0) {
                this.m_mdlForSchema.addElement(this.m_forSchema);
            }
            this.m_mdlForSchema.setSelectedItem(this.m_forSchema);
        }
        SchemaObject ref = null;
        if (null != refID) {
            try {
                DBObject temp = refID.resolveID();
                if (temp instanceof SchemaObject) {
                    ref = (SchemaObject)temp;
                }
            }
            catch (DBException dbe) {
                // empty catch block
            }
        }
        if (null != ref) {
            this.m_isDefaultObject = false;
            this.m_forSchema = ref.getSchema();
        }
        this.m_mdlForSchema.setSelectedItem(this.m_forSchema);
        this.m_cmbForSchema.setSelectedItem((Object)this.m_forSchema);
        boolean nameBased = false;
        if (this.m_loadingSchemas.containsKey(this.m_forSchema.getName()) || null != refID && null == ref) {
            nameBased = true;
            this.m_cmbObject.setModel(EMPTY_MDL_OBJECT);
            this.m_txtName.setText(this.m_savedName);
        } else {
            if (!this.populateObjectField()) {
                nameBased = true;
            }
            if (this.m_cmbObject.getModel().getSize() < 1) {
                nameBased = true;
            }
            if (null != ref) {
                this.m_cmbObject.setSelectedItem(ref.getName());
            }
        }
        this.setEnabledFields(nameBased);
        this.m_lblFor.setEnabled(verifier == null || verifier.canChangeReference());
        this.m_lblForSchemaName.setEnabled(verifier == null || verifier.canChangeSchema());
        this.m_cmbForSchema.setEnabled(verifier == null || verifier.canChangeSchema());
        this.m_cmbForSchema.setEditable(verifier == null || verifier.canCreateSchema());
        this.m_rdbNameBased.setEnabled(verifier == null || verifier.canChangeReference());
        this.m_rdbObjectBased.setEnabled(verifier == null || verifier.canChangeReference());
        this.m_cmbObject.setEnabled(!nameBased && (verifier == null || verifier.canChangeReference()));
        this.m_txtName.setEditable(nameBased && (verifier == null || verifier.canChangeReference()));
        this.m_txtName.setEnabled(nameBased && (verifier == null || verifier.canChangeReference()));
        this.m_isNewDblinkObject = false;
    }

    private void setOriginalSchema() {
        if (this.m_originalSchema != null) {
            if (this.m_mdlSchema.getIndexOf(this.m_originalSchema) < 0) {
                this.m_mdlSchema.addElement(this.m_originalSchema);
            }
            if (!PUBLIC.equals(this.m_originalSchema.getName())) {
                try {
                    this.m_mdlSchema.removeElement(this.m_prov.getSchema(PUBLIC));
                }
                catch (DBException dBException) {
                    // empty catch block
                }
            }
            this.m_mdlSchema.setSelectedItem(this.m_originalSchema);
        }
    }

    private void commit(DatabaseLink databaselink, Schema[] schemas, boolean forward) throws TraversalException {
        DblinkInfoVerifier verifier = this.m_verifier;
        this.m_forSchema = this.m_cmbForSchema.getSchema(schemas);
        Object refObjName = null;
        if (forward && verifier != null) {
            verifier.verifyDblink();
        }
        databaselink.setHost(this.serviceNameTextField.getText());
        databaselink.setCurrentUser(this.currentUserRadioBtn.isSelected());
        databaselink.setUsername(this.userNameTextField.getText());
        databaselink.setPassword(new String(this.passwordField.getPassword()));
        databaselink.setShared(this.sharedCheckBox.isSelected());
        databaselink.setAuthentificationPassword(new String(this.authenPasswordField.getPassword()));
        databaselink.setAuthentificationUsername(this.authenTextFeild.getText());
    }

    public void actionPerformed(ActionEvent e) {
        boolean nameBased = this.m_rdbNameBased.isSelected();
        if (FIXEDUSER.equals(e.getActionCommand())) {
            if (this.fixedUserRadioBtn.isSelected()) {
                this.userNameTextField.setEnabled(true);
                this.passwordField.setEnabled(true);
                this.fixedUserNameLabel.setEnabled(true);
                this.fixedUserPasswordLabel.setEnabled(true);
            } else {
                this.userNameTextField.setEnabled(false);
                this.passwordField.setEnabled(false);
                this.fixedUserNameLabel.setEnabled(false);
                this.fixedUserPasswordLabel.setEnabled(false);
            }
        } else if (SHARED.equals(e.getActionCommand())) {
            if (this.sharedCheckBox.isSelected()) {
                this.authenUserNameLabel.setEnabled(true);
                this.authenPasswordLabel.setEnabled(true);
                this.authenTextFeild.setEnabled(true);
                this.authenPasswordField.setEnabled(true);
            } else {
                this.authenUserNameLabel.setEnabled(false);
                this.authenPasswordLabel.setEnabled(false);
                this.authenTextFeild.setEnabled(false);
                this.authenPasswordField.setEnabled(false);
            }
        } else if (FORSCHEMACHANGED.equals(e.getActionCommand())) {
            try {
                this.m_forSchema = this.m_cmbForSchema.getSchema(this.m_schemas);
                if (this.m_rdbObjectBased.isSelected() && !this.populateObjectField()) {
                    nameBased = true;
                }
            }
            catch (TraversalException te) {}
        } else if (OBJECTCHANGED.equals(e.getActionCommand())) {
            int selectedIndex = this.m_cmbObject.getSelectedIndex();
            this.m_isDefaultObject = this.m_isNewDblinkObject || selectedIndex == -1;
        } else if (SETOBJECTBASED.equals(e.getActionCommand())) {
            if (!this.populateObjectField()) {
                nameBased = true;
            } else {
                SchemaObject object;
                this.m_savedName = this.m_txtName.getText();
                if (ModelUtil.hasLength((String)this.m_savedName) && null != (object = this.findObject(this.m_savedName))) {
                    this.m_cmbObject.setSelectedItem(object.getName());
                }
                this.m_txtName.setText(null);
            }
        } else {
            SchemaObject ob = this.findObject((String)this.m_cmbObject.getSelectedItem());
            if (!this.m_isDefaultObject && null != ob) {
                this.m_txtName.setText(ob.getName());
            } else if (null != this.m_savedName && this.m_savedName.length() > 0) {
                this.m_txtName.setText(this.m_savedName);
            }
            nameBased = true;
        }
        this.setEnabledFields(nameBased);
    }

    private void setEnabledFields(boolean nameBased) {
        this.m_rdbNameBased.setSelected(nameBased);
        this.m_rdbObjectBased.setSelected(!nameBased);
        this.m_txtName.setEditable(nameBased);
        this.m_txtName.setEnabled(nameBased);
        this.m_cmbObject.setEnabled(!nameBased);
    }

    private void getAllDblinkObjects(Schema refSchema) {
        try {
            SchemaObject[] objects = this.m_prov.listObjects(DATABASELINK_TYPES, refSchema);
            SchemaObject originalDblink = this.m_verifier.getOriginalObject();
            String originalDblinkName = originalDblink != null ? originalDblink.getName() : null;
            Schema originalSchema = originalDblink != null ? originalDblink.getSchema() : null;
            NonNullableComboBoxModel objectModel = new NonNullableComboBoxModel();
            for (int i = 0; i < objects.length; ++i) {
                if (originalDblink != null && "DATABASE LINK".equals(objects[i].getType()) && ModelUtil.areEqual((Object)originalSchema, (Object)refSchema) && ModelUtil.areEqual((Object)originalDblinkName, (Object)objects[i].getName())) continue;
                objectModel.addElement(objects[i].getName());
            }
            this.m_schemaMap.put(refSchema.getName(), objectModel);
        }
        catch (DBException dBException) {
            // empty catch block
        }
    }

    private boolean setObjectModel(Schema refSchema) {
        DefaultComboBoxModel objectModel = null;
        if (this.m_verifier.canChangeReference()) {
            objectModel = (DefaultComboBoxModel)this.m_schemaMap.get(refSchema.getName());
        } else if (null != this.m_dblink) {
            objectModel = new NonNullableComboBoxModel();
        }
        this.m_cmbObject.setModel(objectModel != null ? objectModel : EMPTY_MDL_OBJECT);
        return objectModel != null;
    }

    private SchemaObject findObject(String name) {
        SchemaObject result = null;
        if (null != name) {
            for (int i = 0; i < DATABASELINK_TYPES.length; ++i) {
                try {
                    result = this.m_prov.getObject(DATABASELINK_TYPES[i], this.m_forSchema, name);
                    if (null == result) continue;
                    break;
                }
                catch (DBException e) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    private boolean populateObjectField() {
        Schema refSchema = this.m_forSchema;
        if (!this.m_schemaMap.containsKey(refSchema.getName())) {
            this.loadObjectModel(refSchema);
        }
        return this.setObjectModel(refSchema);
    }

    protected void setForSchemaAndName(DBObjectID refID) {
        if (refID instanceof NameBasedRefID) {
            NameBasedRefID sRefID = (NameBasedRefID)refID;
            String schemaName = sRefID.getSchemaName();
            if (schemaName != null) {
                try {
                    Schema forSchema = this.m_prov.getSchema(schemaName);
                    this.m_forSchema = null == forSchema ? new Schema(schemaName) : forSchema;
                }
                catch (DBException dbe) {
                    // empty catch block
                }
            }
            this.m_savedName = sRefID.getName();
        }
    }

    private void loadObjectModel(Schema refSchema) {
        if (!this.m_loadingSchemas.containsKey(refSchema.getName())) {
            ObjectModelLoader objectModelLoader = new ObjectModelLoader(refSchema);
            this.m_loadingSchemas.put(refSchema.getName(), objectModelLoader);
            objectModelLoader.execute();
        } else {
            ObjectModelLoader objectModelLoader = (ObjectModelLoader)this.m_loadingSchemas.get(refSchema.getName());
            if (objectModelLoader != null) {
                objectModelLoader.execute();
            }
        }
    }

    public String getTitle() {
        return CreateDialogArb.getString(246);
    }

    public String getProgressText() {
        return CreateDialogArb.getString(247);
    }

    private class ObjectModelLoader
    implements Runnable {
        private Schema m_schema;
        private ProgressBar m_bar;

        public ObjectModelLoader() {
        }

        public ObjectModelLoader(Schema schema) {
            this.m_schema = schema;
        }

        public void execute() {
            if (DblinkTab.this.m_prov instanceof Database) {
                this.m_bar = new ProgressBar((Component)Ide.getMainWindow(), DblinkTab.this.getTitle(), (Runnable)this, true);
                this.m_bar.start(DblinkTab.this.getProgressText(), this.m_schema.getName());
            } else {
                this.m_bar = null;
                this.run();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ProgressBar bar = this.m_bar;
            ObjectModelLoader objectModelLoader = this;
            synchronized (objectModelLoader) {
                if (DblinkTab.this.m_loadingSchemas.containsKey(this.m_schema.getName())) {
                    try {
                        Assert.println((String)("Start getAllDBLinkObjects for schema " + this.m_schema.getName()));
                        DblinkTab.this.getAllDblinkObjects(this.m_schema);
                    }
                    catch (Exception e) {
                        Assert.printStackTrace((Throwable)e);
                        ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)e, (String)e.getMessage());
                    }
                    DblinkTab.this.m_loadingSchemas.remove(this.m_schema.getName());
                    Assert.println((String)("Finished getAllDBLinkObjects for schema " + this.m_schema.getName()));
                }
                if (bar != null) {
                    bar.setDoneStatus();
                }
            }
        }
    }
}

