/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.dblink;

import java.awt.Component;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import oracle.dbtools.raptor.dialogs.CreateDialogArb;
import oracle.dbtools.raptor.dialogs.TabbedDialogLauncher;
import oracle.dbtools.raptor.dialogs.dblink.DblinkInfoVerifier;
import oracle.dbtools.raptor.dialogs.dblink.DblinkObjectInfoVerifier;
import oracle.dbtools.raptor.dialogs.dblink.DblinkTab;
import oracle.dbtools.raptor.dialogs.dblink.TabbedDblinkPanel;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.panels.Traversable;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.Namespace;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.ora.DatabaseLink;
import oracle.javatools.db.ora.OracleDDLGenerator;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.jdeveloper.cm.ds.db.DBUtil;
import oracle.jdeveloper.cm.dt.wizard.DBWizardLauncher;

public class TabbedOracleDblinkLauncher
extends TabbedDialogLauncher {
    public TabbedOracleDblinkLauncher(OracleDatabase db, Schema schema) {
        super((Database)db, schema);
        this.put("Tablespaces", db.listTablespaces());
        this.addTab(DblinkTab.class, "f1_dbnewdblinkwizarddblinkinfo_html", CreateDialogArb.getString(238));
    }

    public boolean createObject() {
        Schema schema = this.getSchema();
        DBObjectProvider db = this.getProvider();
        String uniqueName = db.getUniqueName("DATABASELINK", (DBObject)schema, null);
        DatabaseLink dbLink = new DatabaseLink(uniqueName, schema, null);
        dbLink.setID(TemporaryObjectID.createID((DBObject)dbLink));
        this.put("NewObject", dbLink);
        this.put("OriginalObject", null);
        this.put("DDlGenerator", new OracleDDLGenerator(db));
        try {
            Schema publicSchema = db.getSchema("PUBLIC");
            if (null != publicSchema) {
                ArrayList<Schema> schemas = new ArrayList<Schema>(Arrays.asList((Schema[])this.get("SchemaList")));
                schemas.add(publicSchema);
                Schema[] newSchemaArray = new Schema[schemas.size()];
                this.put("SchemaList", schemas.toArray(newSchemaArray));
            }
        }
        catch (DBException dbe) {
            // empty catch block
        }
        this.registerVerifier("SchemaObjectInfoVerifier", DblinkObjectInfoVerifier.class);
        this.registerVerifier(DblinkInfoVerifier.KEY, DblinkObjectInfoVerifier.class);
        this.addTab(TabbedDialogLauncher.CreateSQLTab.class, null, CreateDialogArb.getString(514));
        this.setTitle(CreateDialogArb.getString(235));
        this.setErrorTitle(MessageFormat.format(CreateDialogArb.getString(232), dbLink.getName()));
        return this.createObjectImpl();
    }

    public boolean editObject(SchemaObject object) {
        SchemaObject copy = (SchemaObject)DBUtil.makeTemporaryCopy((DBObject)object);
        DBObjectProvider db = this.getProvider();
        this.put("NewObject", object);
        this.put("OriginalObject", copy);
        this.put("DDlGenerator", new OracleDDLGenerator(db));
        this.registerVerifier("SchemaObjectInfoVerifier", DblinkObjectInfoVerifier.class);
        this.registerVerifier(DblinkInfoVerifier.KEY, DblinkObjectInfoVerifier.class);
        this.addTab(TabbedDialogLauncher.EditSQLTab.class, null, CreateDialogArb.getString(514));
        this.setTitle(CreateDialogArb.getString(236));
        this.setErrorTitle(MessageFormat.format(CreateDialogArb.getString(232), object.getName()));
        return this.createObjectImpl();
    }

    public static boolean createDblink(Context ctx, OracleDatabase db) {
        try {
            Schema schema = DBWizardLauncher.determineSchema((Context)ctx, (Database)db);
            TabbedOracleDblinkLauncher launcher = new TabbedOracleDblinkLauncher(db, schema);
            return launcher.createObject();
        }
        catch (DBException dBException) {
            return false;
        }
    }

    public static boolean editDblink(OracleDatabase db, DatabaseLink dbLink) {
        TabbedOracleDblinkLauncher launcher = new TabbedOracleDblinkLauncher(db, dbLink.getSchema());
        return launcher.editObject((SchemaObject)dbLink);
    }

    protected boolean runDialog(String title) {
        TabbedDblinkPanel panel = new TabbedDblinkPanel(this._tabs.toArray(new Navigable[this._tabs.size()]));
        if (ModelUtil.hasLength((String)this._topLabel)) {
            panel.setTopLabel(this._topLabel);
        }
        if (ModelUtil.hasLength((String)this._errTitle)) {
            panel.setErrorTitle(this._errTitle);
        }
        TDialogLauncher launcher = new TDialogLauncher((Component)Ide.getMainWindow(), title, (Traversable)panel, (Namespace)this);
        launcher.setInitialSize(600, 500);
        return launcher.showDialog();
    }
}

