/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.grants;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.dialogs.CreateDialogArb;
import oracle.dbtools.raptor.dialogs.grants.GrantPrivilegesPanel;
import oracle.dbtools.raptor.dialogs.grants.PrivListener;
import oracle.dbtools.raptor.dialogs.grants.RevokePrivilegesPanel;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.Translate;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.util.IdeUtil;
import oracle.ide.view.View;
import oracle.jdeveloper.cm.dt.ConnectionArb;

public class GenericGrantEditor
implements Controller {
    public static String HELP_TABLE_GRANT = "f1_granttablehtml";
    public static String HELP_TABLE_REVOKE = "f1_revoketablehtml";
    private static final int GRANT_TABLE_CMD_ID = Ide.findOrCreateCmdID((String)"GRANT_TABLE_CMD_ID");
    private static final int REVOKE_TABLE_CMD_ID = Ide.findOrCreateCmdID((String)"REVOKE_TABLE_CMD_ID");
    private DBObject _dbObject;
    private Toolbar _toolbar;
    private View _view;
    private ArrayList<PrivListener> _listeners = new ArrayList();

    public GenericGrantEditor(DBObject dbObject) {
        this._dbObject = dbObject;
        this.createActions();
        this.addActionToToolbar();
    }

    public GenericGrantEditor(View view, Toolbar toolbar, DBObject dbObject) {
        this._dbObject = dbObject;
        this._view = view;
        this._toolbar = toolbar;
        this.createActions();
        this.addActionToToolbar();
    }

    public void grantPrivileges() {
        GrantPrivilegesPanel panel = new GrantPrivilegesPanel(this._dbObject);
        JEWTDialog dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)panel, null, (String)Translate.translate("Grant"), (int)10);
        dlg.addActionListener((ActionListener)panel);
        dlg.setSize(600, 300);
        dlg.pack();
        dlg.setPreferredSize(panel.getPreferredSize());
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)dlg);
        dlg.setVisible(true);
        this.firePrivChanges();
    }

    public void revokePrivileges() {
        RevokePrivilegesPanel panel = new RevokePrivilegesPanel(this._dbObject);
        JEWTDialog dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)panel, null, (String)Translate.translate("Revoke"), (int)10);
        dlg.addActionListener((ActionListener)panel);
        dlg.setSize(600, 300);
        dlg.pack();
        dlg.setPreferredSize(panel.getPreferredSize());
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)dlg);
        dlg.setVisible(true);
        this.firePrivChanges();
    }

    private void createActions() {
        IdeAction.get((int)GRANT_TABLE_CMD_ID, null, (String)CreateDialogArb.getString(549), null, null, (Icon)ConnectionArb.getIcon((int)493), null, (boolean)true).addController((Controller)this);
        IdeAction.get((int)REVOKE_TABLE_CMD_ID, null, (String)CreateDialogArb.getString(550), null, null, (Icon)ConnectionArb.getIcon((int)494), null, (boolean)true).addController((Controller)this);
    }

    public void addActionToToolbar() {
        if (this._toolbar != null) {
            JButton button = new JButton((Action)IdeAction.find((int)GRANT_TABLE_CMD_ID).newLocalAction(this._view));
            button.setToolTipText(Translate.translate("Grant"));
            this._toolbar.add((Component)button);
            button = new JButton((Action)IdeAction.find((int)REVOKE_TABLE_CMD_ID).newLocalAction(this._view));
            button.setToolTipText(Translate.translate("Revoke"));
            this._toolbar.add((Component)button);
        }
    }

    public boolean handleEvent(IdeAction action, Context context) {
        int commandId = action.getCommandId();
        if (commandId == GRANT_TABLE_CMD_ID) {
            this.grantPrivileges();
        } else if (commandId == REVOKE_TABLE_CMD_ID) {
            this.revokePrivileges();
        }
        return true;
    }

    public void addPrivListener(PrivListener listener) {
        this._listeners.add(listener);
    }

    public void firePrivChanges() {
        for (int i = 0; i < this._listeners.size(); ++i) {
            this._listeners.get(i).privledgesChanges();
        }
    }

    public boolean update(IdeAction action, Context context) {
        return false;
    }

    public void setDBObject(DBObject dbObject) {
        this._dbObject = dbObject;
    }
}

