/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.grants;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.dialogs.CreateDialogArb;
import oracle.dbtools.raptor.dialogs.grants.PrivilegesInfoPanel;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.Log;
import oracle.dbtools.raptor.utils.Translate;
import oracle.dbtools.util.Resource;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.jdeveloper.cm.dt.dialog.SQLErrorDialog;

public class GrantPrivilegesPanel
extends PrivilegesInfoPanel
implements ActionListener {
    protected JCheckBox chkAdmin = new JCheckBox();

    protected GrantPrivilegesPanel(DBObject dbObject) {
        super(dbObject);
        ResourceUtils.resButton((AbstractButton)this.chkAdmin, (String)CreateDialogArb.getString(557));
        this.addItem(this.jPanel1, Translate.translate("Admin"), this.chkAdmin, true);
        this.init();
    }

    protected void init() {
        try {
            Schema[] schemas = this._dbObject.getDatabase().listSchemas();
            this.mdlUsers.removeAllElements();
            this.mdlUsers.addElement(new Schema("PUBLIC"));
            for (int i = 0; i < schemas.length; ++i) {
                this.mdlUsers.addElement(schemas[i]);
            }
            Schema selUser = (Schema)this.cbxUsers.getSelectedItem();
            String[] privs = this.getAvailablePrivileges(selUser.getName());
            this.mdlPrivFrom.removeAllElements();
            for (int i = 0; i < privs.length; ++i) {
                this.mdlPrivFrom.addElement(privs[i]);
            }
        }
        catch (Exception e) {
            if (e instanceof SQLException) {
                SQLErrorDialog.showErrorDialog(null, (String)"Error updating privileges. ", (SQLException)((SQLException)e));
            }
            e.printStackTrace();
        }
    }

    protected String[] getAvailablePrivileges(String user) throws IOException {
        Properties props = new Properties();
        props.load(Resource.getResourceAsStream(this.getClass(), "privileges.properties"));
        String csvPrivs = props.getProperty(this._dbObject.getObjectType().replace(' ', '_'));
        return csvPrivs.split(",");
    }

    protected void performGrant() {
        Database db = this._dbObject.getDatabase();
        StringBuilder sb = new StringBuilder();
        sb.append("grant ");
        if (this.chkAll.isSelected()) {
            sb.append("ALL");
        } else {
            List privs = this.getSelectedPrivileges();
            for (int i = 0; i < privs.size(); ++i) {
                if (i != privs.size() - 1) {
                    sb.append(privs.get(i) + ",");
                    continue;
                }
                sb.append(privs.get(i));
            }
        }
        sb.append(" on ");
        sb.append("\"" + this._dbObject.getSchemaName() + "\".\"" + this._dbObject.getObjectName() + "\"");
        sb.append(" to ");
        sb.append("\"" + ((Schema)this.cbxUsers.getSelectedItem()).getName() + "\"");
        if (this.chkAdmin.isSelected()) {
            sb.append(" WITH GRANT OPTION");
        }
        DBUtil dbUtil = new DBUtil();
        Log.log("GRANTING:" + sb.toString());
        dbUtil.execute(this._dbObject.getDatabase().getConnectionName(), sb.toString(), (ArrayList)null);
    }

    public void actionPerformed(ActionEvent e) {
        this.performGrant();
        this.close(e);
    }
}

