/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.mview;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.dialogs.mview.CreateMViewVerifier;
import oracle.dbtools.raptor.dialogs.mview.MViewVerifier;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.controls.UpperCaseTextField;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.FastStringBuffer;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.ora.MaterializedView;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdeveloper.cm.dt.dialog.SQLErrorDialog;
import oracle.jdeveloper.cm.dt.ui.BaseInfoPanel;
import oracle.jdeveloper.cm.dt.ui.DBObjectRenderer;
import oracle.jdeveloper.cm.dt.verifier.Verifier;
import oracle.jdeveloper.cm.dt.wizard.DBWizardLauncher;
import oracle.jdevimpl.cm.dt.wizards.CmWizardsArb;

public class MViewPanel
extends BaseInfoPanel
implements ItemListener,
DocumentListener,
VetoableChangeListener {
    private BorderLayout layMain = new BorderLayout();
    private JMultiLineLabel lblTop = new JMultiLineLabel();
    private JPanel pnlView = new JPanel();
    private GridBagLayout layView = new GridBagLayout();
    private JLabel lblOwner = new JLabel();
    private JComboBox cmbOwner = new JComboBox();
    private JTextField fldName = new JTextField();
    private JLabel lblName = new JLabel();
    private JScrollPane scrQuery = new JScrollPane();
    private JLabel lblAliases = new JLabel();
    private JTextField fldAliases = new JTextField();
    private JLabel lblCons = new JLabel();
    private JTextField fldCons = new UpperCaseTextField();
    private JLabel lblQuery = new JLabel();
    private JTextArea txtQuery = new JTextArea();
    private JPanel pnlRestrictions = new JPanel();
    private GridBagLayout layRestrictions = new GridBagLayout();
    private DefaultComboBoxModel mdlOwner = new NonNullableComboBoxModel();
    private ButtonGroup grpRestrictions = new ButtonGroup();
    private JPanel pnlOwner = new JPanel();
    private JLabel lblRestrictions = new JLabel();
    private JComboBox cmbRestrictions = new JComboBox();
    private JCheckBox chkForce = new JCheckBox();
    private DefaultComboBoxModel mdlRestrictions = new NonNullableComboBoxModel((Object[])OPTIONS);
    private DBObjectRenderer renderer = new DBObjectRenderer();
    private MaterializedView _mview;
    private JEWTDialog _dlg;
    private static final String NO_RESTRICTIONS = "None";
    private static final String READ_ONLY = "Read Only";
    private static final String CHECK_OPTION = "Check Option";
    private static final String[] OPTIONS = new String[]{"None", "Read Only", "Check Option"};
    private GridLayout layOwner = new GridLayout();
    private JCheckBox chkReplace = new JCheckBox();
    private JPanel pnlBottom = new JPanel();
    private GridLayout layBottom = new GridLayout();
    private JPanel spacer = new JPanel();

    public MViewPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.layMain);
        this.lblTop.setText(CmWizardsArb.getString((int)191));
        this.pnlView.setLayout(this.layView);
        ResourceUtils.resLabel((JLabel)this.lblOwner, (Component)this.cmbOwner, (String)CmWizardsArb.getString((int)192));
        this.cmbOwner.setModel(this.mdlOwner);
        this.cmbOwner.setRenderer(this.renderer);
        ResourceUtils.resLabel((JLabel)this.lblName, (Component)this.fldName, (String)CmWizardsArb.getString((int)18));
        this.fldName.getDocument().addDocumentListener(this);
        this.txtQuery.getDocument().addDocumentListener(this);
        ResourceUtils.resLabel((JLabel)this.lblAliases, (Component)this.fldAliases, (String)CmWizardsArb.getString((int)194));
        this.txtQuery.setRows(6);
        ResourceUtils.resLabel((JLabel)this.lblCons, (Component)this.fldCons, (String)CmWizardsArb.getString((int)196));
        this.fldCons.setColumns(30);
        ResourceUtils.resLabel((JLabel)this.lblQuery, (Component)this.txtQuery, (String)CmWizardsArb.getString((int)193));
        this.pnlRestrictions.setLayout(this.layRestrictions);
        this.pnlOwner.setLayout(this.layOwner);
        ResourceUtils.resLabel((JLabel)this.lblRestrictions, (Component)this.cmbRestrictions, (String)CmWizardsArb.getString((int)195));
        this.cmbRestrictions.setModel(this.mdlRestrictions);
        this.cmbRestrictions.addItemListener(this);
        ResourceUtils.resButton((AbstractButton)this.chkForce, (String)"&Force");
        this.layOwner.setHgap(24);
        this.layOwner.setColumns(2);
        this.layOwner.setRows(2);
        ResourceUtils.resButton((AbstractButton)this.chkReplace, (String)CmWizardsArb.getString((int)197));
        this.pnlBottom.setLayout(this.layBottom);
        this.layBottom.setColumns(2);
        this.layBottom.setHgap(24);
        this.add((Component)this.lblTop, "North");
        this.scrQuery.getViewport().add((Component)this.txtQuery, null);
        this.pnlView.add((Component)this.scrQuery, new GridBagConstraints(0, 3, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.pnlView.add((Component)this.lblAliases, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 0), 0, 0));
        this.pnlView.add((Component)this.fldAliases, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.pnlView.add((Component)this.lblQuery, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.pnlRestrictions.add((Component)this.lblCons, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 12, 5, 12), 0, 0));
        this.pnlRestrictions.add((Component)this.fldCons, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.pnlRestrictions.add((Component)this.lblRestrictions, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 12), 0, 0));
        this.pnlRestrictions.add((Component)this.cmbRestrictions, new GridBagConstraints(1, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.pnlRestrictions.add((Component)this.spacer, new GridBagConstraints(3, 0, 1, 2, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.pnlView.add((Component)this.pnlRestrictions, new GridBagConstraints(0, 5, 2, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.pnlOwner.add((Component)this.lblOwner, null);
        this.pnlOwner.add((Component)this.lblName, null);
        this.pnlOwner.add((Component)this.cmbOwner, null);
        this.pnlOwner.add((Component)this.fldName, null);
        this.pnlView.add((Component)this.pnlOwner, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.pnlBottom.add((Component)this.chkForce, null);
        this.pnlBottom.add((Component)this.chkReplace, null);
        this.pnlView.add((Component)this.pnlBottom, new GridBagConstraints(0, 6, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.pnlView, "Center");
    }

    public void addNotify() {
        super.addNotify();
        for (Container parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof JEWTDialog)) continue;
            this._dlg = (JEWTDialog)parent;
            this._dlg.setResizable(true);
            break;
        }
        this._updateState();
    }

    public void init(DBObjectProvider db, MaterializedView mview, MViewVerifier verifier) {
        Schema owner;
        int idx;
        super.init(db, (Verifier)verifier);
        this._mview = mview;
        try {
            Schema[] schemas = db.listSchemas();
            for (int i = 0; i < schemas.length; ++i) {
                this.mdlOwner.addElement(schemas[i]);
            }
        }
        catch (DBException ex) {
            // empty catch block
        }
        if ((idx = this.mdlOwner.getIndexOf(owner = mview.getSchema())) == -1) {
            this.mdlOwner.addElement(owner);
            idx = this.mdlOwner.getIndexOf(owner);
        }
        if (this.mdlOwner.getSize() > 1) {
            Schema schema = (Schema)this.mdlOwner.getElementAt(idx == 0 ? 1 : 0);
            this.cmbOwner.setEnabled(db.hasPriviledge("MATERIALIZED VIEW", schema, "CREATE"));
        }
        this.mdlOwner.setSelectedItem(owner);
        String name = this.getExternalName(mview.getName());
        this.fldName.setText(name);
        this.cmbRestrictions.setSelectedItem(NO_RESTRICTIONS);
        this._updateState();
    }

    public boolean commit() {
        boolean result = false;
        String query = this.txtQuery.getText();
        if (ModelUtil.hasLength((String)query)) {
            try {
                DBObjectProvider prov;
                Schema schema = (Schema)this.mdlOwner.getSelectedItem();
                String name = this.getInternalName(this.fldName.getText());
                FastStringBuffer buf = new FastStringBuffer();
                buf.append(query);
                Object sel = this.cmbRestrictions.getSelectedItem();
                if (READ_ONLY.equals(sel)) {
                    buf.append(" WITH READ ONLY");
                } else if (CHECK_OPTION.equals(sel)) {
                    buf.append(" WITH CHECK OPTION");
                    String cons = this.fldCons.getText();
                    if (ModelUtil.hasLength((String)cons)) {
                        buf.append(" CONSTRAINT ");
                        buf.append('\"').append(cons).append('\"');
                    }
                }
                this._mview.setSchema(schema);
                this._mview.setName(name);
                ArrayList<Column> aList = new ArrayList<Column>();
                String alias = this.fldAliases.getText();
                if (ModelUtil.hasLength((String)alias)) {
                    StringTokenizer tkn = new StringTokenizer(alias, ", ");
                    while (tkn.hasMoreTokens()) {
                        String col = tkn.nextToken();
                        if (col == null || !ModelUtil.hasLength((String)(col = col.trim()))) continue;
                        aList.add(new Column(col));
                    }
                }
                Column[] aliases = aList.toArray(new Column[aList.size()]);
                this._mview.setColumns(aliases);
                boolean replace = this.chkReplace.isSelected();
                MViewVerifier verifier = (MViewVerifier)this.getVerifier();
                if (verifier != null) {
                    verifier.verifyMView(replace);
                }
                if ((prov = this.getProvider()) != null) {
                    prov.createObject((SchemaObject)this._mview, replace);
                    result = true;
                }
            }
            catch (TraversalException ex) {
                ex.showMessageDialog((Component)((Object)this));
            }
            catch (DBException ex) {
                Throwable cause = ex.getCause();
                if (cause instanceof SQLException) {
                    SQLErrorDialog.showErrorDialog((Component)((Object)this), (String)CmWizardsArb.getString((int)199), (SQLException)((SQLException)cause));
                }
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)(cause != null ? cause : ex), (String)CmWizardsArb.getString((int)199), (String)CmWizardsArb.getString((int)198), null);
            }
        }
        return result;
    }

    private void _updateState() {
        Object sel = this.mdlRestrictions.getSelectedItem();
        this.fldCons.setEnabled(CHECK_OPTION.equals(sel));
        if (this._dlg != null) {
            this._dlg.setOKButtonEnabled(ModelUtil.hasLength((String)this.txtQuery.getText()) && ModelUtil.hasLength((String)this.fldName.getText()));
        }
    }

    public void insertUpdate(DocumentEvent p0) {
        this._updateState();
    }

    public void removeUpdate(DocumentEvent p0) {
        this._updateState();
    }

    public void changedUpdate(DocumentEvent p0) {
        this._updateState();
    }

    public void itemStateChanged(ItemEvent e) {
        this._updateState();
    }

    public void vetoableChange(PropertyChangeEvent pce) throws PropertyVetoException {
        if ("closed".equals(pce.getPropertyName()) && Boolean.TRUE.equals(pce.getNewValue()) && !this.commit()) {
            throw new PropertyVetoException("bogus", pce);
        }
    }

    public static boolean createMView(Context ctx, Database db) {
        boolean result = false;
        MaterializedView mview = null;
        try {
            Schema schema = DBWizardLauncher.determineSchema((Context)ctx, (Database)db);
            String name = db.getUniqueName("MATERIALIZED VIEW", (DBObject)schema, null);
            mview = new MaterializedView(name, schema);
        }
        catch (DBException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof SQLException) {
                SQLErrorDialog.showErrorDialog(null, (String)"Error Getting Schema List", (SQLException)((SQLException)cause));
            } else {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)(cause != null ? cause : ex), (String)"Error Getting Schema List", (String)"An error was encountered trying to get the list of schemas.", null);
            }
            return false;
        }
        if (mview != null) {
            MViewPanel panel = new MViewPanel();
            panel.init((DBObjectProvider)db, mview, new CreateMViewVerifier((DBObjectProvider)db, mview));
            HelpSystem.getHelpSystem().registerTopic((JComponent)((Object)panel), "f1_bdbdcreateview_html");
            result = OnePageWizardDialogFactory.runDialog((Component)((Object)panel), (Component)panel.fldName, (String)CmWizardsArb.getString((int)185), (int)7, (VetoableChangeListener)panel);
        }
        return result;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }
}

