/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.plsql;

import java.util.HashSet;
import oracle.dbtools.raptor.dialogs.plsql.PlSqlParametersVerifier;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.NameInUseException;
import oracle.javatools.db.PlSqlParameter;
import oracle.javatools.db.PlSqlSubprogram;
import oracle.javatools.db.Schema;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.cm.dt.verifier.AbstractSchemaObjectVerifier;
import oracle.jdeveloper.cm.dt.verifier.SchemaObjectInfoVerifier;
import oracle.jdevimpl.cm.dt.wizards.CmWizardsArb;

public class CreateFunctionVerifier
extends AbstractSchemaObjectVerifier
implements SchemaObjectInfoVerifier,
PlSqlParametersVerifier {
    public boolean canChangeName() {
        return true;
    }

    public boolean canChangeSchema() {
        return true;
    }

    public boolean canCreateSchema() {
        return false;
    }

    public void verifySchemaName(String string) throws TraversalException {
    }

    public void verifyObject() throws TraversalException {
        Database db;
        PlSqlSubprogram plsql = (PlSqlSubprogram)this.getModifiedObject();
        Schema schema = plsql.getSchema();
        if (schema == null) {
            throw new TraversalException("The schema containing the new subprogram must be specified.", "Missing Schema", null);
        }
        DBObjectProvider prov = this.getProvider();
        if (prov instanceof Database && !(db = (Database)prov).hasPriviledge(plsql.getType(), schema, "CREATE")) {
            throw new TraversalException("The current Oracle user does not have enough privileges to create a subprogram in the specified schema.", CmWizardsArb.getString((int)33), null);
        }
        String name = plsql.getName();
        try {
            prov.validateName(name);
            prov.validateUniqueName(plsql.getType(), (DBObject)schema, name);
        }
        catch (NameInUseException ex) {
            throw new TraversalException(ex.getMessage());
        }
        catch (InvalidNameException ex) {
            throw new TraversalException(ex.getMessage());
        }
        HashSet<String> names = new HashSet<String>();
        for (PlSqlParameter param : plsql.getParameters()) {
            String pName = param.getName();
            if (names.contains(pName)) {
                throw new TraversalException("Duplicate param");
            }
            names.add(pName);
        }
    }

    public void verifyReturnType(DataType retType) throws TraversalException {
    }

    public void verifyParameter(PlSqlParameter param) throws TraversalException {
        DBObjectProvider prov = this.getProvider();
        String name = param.getName();
        try {
            prov.validateName(name);
        }
        catch (InvalidNameException ex) {
            throw new TraversalException(ex.getMessage());
        }
        PlSqlParameter.Mode mode = param.getMode();
        String def = param.getDefaultValue();
        if (ModelUtil.hasLength((String)def) && (mode == PlSqlParameter.Mode.OUT || mode == PlSqlParameter.Mode.INOUT)) {
            throw new TraversalException("An OUT or IN OUT parameter cannot have a default value.");
        }
    }
}

