/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.plsql;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.raptor.dialogs.plsql.PlSqlParametersVerifier;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.DeclarativePlSql;
import oracle.javatools.db.PlSqlParameter;
import oracle.javatools.db.datatypes.DataType;

public class ParamsModel
extends AbstractTableModel {
    static final int NAME_POS = 0;
    static final int TYPE_POS = 1;
    static final int MODE_POS = 2;
    static final int DEFAULT_POS = 3;
    private List<PlSqlParameter> _params = new ArrayList<PlSqlParameter>();
    private DBObjectProvider _prov;
    private boolean _isFunction;

    private String getUniqueParamName() {
        int i;
        String base = "param";
        HashSet<String> names = new HashSet<String>();
        int n = i = this._isFunction ? 1 : 0;
        while (i < this._params.size()) {
            names.add(this._params.get(i).getName());
            ++i;
        }
        return DBUtil.getUniqueName(names, (String)base, (boolean)true);
    }

    public void addParameter() {
        this.addParameter(this._params.size() - 1);
    }

    public void addParameter(int idx) {
        PlSqlParameter param = new PlSqlParameter(this.getUniqueParamName(), this._prov.getDataType("VARCHAR2"));
        this._params.add(++idx, param);
        this.fireTableRowsInserted(idx, idx);
    }

    public boolean canRemoveRow(int rowIndex) {
        int firstRow = this._isFunction ? 1 : 0;
        return rowIndex >= firstRow && rowIndex < this._params.size();
    }

    public void removeParameter(int idx) {
        this._params.remove(idx);
        this.fireTableRowsDeleted(idx, idx);
    }

    public boolean canMoveRowUp(int rowIndex) {
        int firstRow = this._isFunction ? 1 : 0;
        return rowIndex > firstRow && rowIndex < this._params.size();
    }

    public void moveUp(int idx) {
        PlSqlParameter param = this._params.remove(idx);
        this._params.add(idx - 1, param);
        this.fireTableRowsUpdated(idx - 1, idx);
    }

    public boolean canMoveRowDown(int rowIndex) {
        int firstRow = this._isFunction ? 1 : 0;
        return rowIndex >= firstRow && rowIndex < this._params.size() - 1;
    }

    public void moveDown(int idx) {
        PlSqlParameter param = this._params.remove(idx);
        this._params.add(idx + 1, param);
        this.fireTableRowsUpdated(idx, idx + 1);
    }

    public void init(DBObjectProvider prov, DeclarativePlSql plsql, boolean isFunction) {
        PlSqlParameter[] params;
        this._prov = prov;
        this._isFunction = isFunction;
        this._params.clear();
        if (isFunction) {
            DataType retType = plsql.getReturnType();
            if (retType == null) {
                retType = this._prov.getDataType("VARCHAR2");
            }
            PlSqlParameter ret = new PlSqlParameter("<Return>", retType);
            this._params.add(ret);
        }
        if ((params = plsql.getParameters()) != null) {
            for (PlSqlParameter param : params) {
                this._params.add(param);
            }
        }
    }

    public void commit(DeclarativePlSql plsql, PlSqlParametersVerifier verifier) throws TraversalException {
        int offset = 0;
        DataType retType = null;
        if (this._isFunction) {
            ++offset;
            if (this._params.size() == 0) {
                throw new TraversalException("A Function must have a return type");
            }
            PlSqlParameter param = this._params.get(0);
            retType = param.getDataType();
            verifier.verifyReturnType(retType);
        }
        PlSqlParameter[] params = new PlSqlParameter[this._params.size() - offset];
        for (int i = 0; i < params.length; ++i) {
            params[i] = this._params.get(i + offset);
            verifier.verifyParameter(params[i]);
        }
        plsql.setParameters(params);
        plsql.setReturnType(retType);
    }

    public int getColumnCount() {
        return 4;
    }

    public int getRowCount() {
        return this._params.size();
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        String value = null;
        PlSqlParameter param = this._params.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                value = param.getName();
                break;
            }
            case 1: {
                DataType type = param.getDataType();
                value = type.getName();
                break;
            }
            case 2: {
                PlSqlParameter.Mode mode = param.getMode();
                value = mode != null ? mode : "";
                break;
            }
            case 3: {
                value = param.getDefaultValue();
                break;
            }
            default: {
                throw new ArrayIndexOutOfBoundsException(columnIndex);
            }
        }
        return value;
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        PlSqlParameter param = this._params.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                param.setName((String)aValue);
                break;
            }
            case 1: {
                String name = param.getName();
                PlSqlParameter.Mode mode = param.getMode();
                String def = param.getDefaultValue();
                DataType type = this._prov.getDataType((String)aValue);
                param = new PlSqlParameter(name, type);
                param.setDefaultValue(def);
                param.setMode(mode);
                this._params.set(rowIndex, param);
                break;
            }
            case 2: {
                param.setMode(aValue instanceof PlSqlParameter.Mode ? (PlSqlParameter.Mode)aValue : null);
                break;
            }
            case 3: {
                param.setDefaultValue((String)aValue);
                break;
            }
            default: {
                throw new ArrayIndexOutOfBoundsException(columnIndex);
            }
        }
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return !this._isFunction || rowIndex > 0 || columnIndex == 1;
    }
}

