/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.plsql;

import java.net.URL;
import oracle.dbtools.raptor.dialogs.CreateDialogArb;
import oracle.dbtools.raptor.dialogs.TabbedDialogLauncher;
import oracle.dbtools.raptor.dialogs.plsql.CreateFunctionVerifier;
import oracle.dbtools.raptor.dialogs.plsql.PlSqlParametersPanel;
import oracle.dbtools.raptor.dialogs.plsql.PlSqlTabbedPanel;
import oracle.dbtools.raptor.utils.Translate;
import oracle.ide.Context;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.TraversableContext;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DDLGenerator;
import oracle.javatools.db.Database;
import oracle.javatools.db.Function;
import oracle.javatools.db.PlSqlParameter;
import oracle.javatools.db.PlSqlSubprogram;
import oracle.javatools.db.Procedure;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.ora.OracleDDLGenerator;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.cm.dt.CmUtil;
import oracle.jdeveloper.cm.dt.ui.TabbedDBPanel;

public abstract class PlSqlLauncher
extends TabbedDialogLauncher {
    protected PlSqlLauncher(Context ctx, OracleDatabase db, Schema schema) {
        super((Database)db, schema);
        this.put("DDlGenerator", new OracleDDLGenerator((DBObjectProvider)db));
        Element[] sel = ctx.getSelection();
        URL url = ((Locatable)sel[0]).getURL();
        this.put("ConnectionName", CmUtil.getConnName((URL)url));
    }

    public boolean createObject() {
        Schema schema = this.getSchema();
        DBObjectProvider db = this.getProvider();
        PlSqlSubprogram prog = this.getInitialSubprogram(schema, db);
        prog.setID(TemporaryObjectID.createID((DBObject)prog));
        this.put("NewObject", prog);
        this.put("OriginalObject", null);
        this.registerVerifier("SchemaObjectInfoVerifier", CreateFunctionVerifier.class);
        this.registerVerifier("PlSqlParametersVerifier", CreateFunctionVerifier.class);
        this.addTab(PlSqlParametersPanel.class, null, "Parameters");
        this.addTab(FunctionSQLTab.class, null, CreateDialogArb.getString(514));
        if (prog instanceof Function) {
            this.setTitle(Translate.translate("Create Function"));
            this.setErrorTitle(Translate.translate(" Error Creating Function"));
        } else if (prog instanceof Procedure) {
            this.setTitle(Translate.translate("Create Procedure"));
            this.setErrorTitle(Translate.translate(" Error Creating Procedure"));
        }
        return this.createObjectImpl();
    }

    protected abstract PlSqlSubprogram getInitialSubprogram(Schema var1, DBObjectProvider var2);

    public boolean editObject(SchemaObject object) {
        return false;
    }

    protected TabbedDBPanel createPanel(Navigable[] navs) {
        return new PlSqlTabbedPanel(navs);
    }

    protected static String getDDL(PlSqlSubprogram proc, DDLGenerator gen) {
        StringBuffer buf = new StringBuffer();
        buf.append("CREATE OR REPLACE ");
        buf.append(PlSqlLauncher.getFunctionSQL(proc, gen));
        return buf.toString();
    }

    protected static String getFunctionSQL(PlSqlSubprogram proc, DDLGenerator gen) {
        DataType retType;
        StringBuffer buf = new StringBuffer();
        buf.append(proc.getType()).append(' ');
        buf.append(proc.getSchema().getName()).append('.').append(proc.getName());
        PlSqlParameter[] params = proc.getParameters();
        if (params != null && params.length > 0) {
            buf.append('\n').append('(');
            PlSqlLauncher.convertParam(buf, params[0]);
            for (int i = 1; i < params.length; ++i) {
                buf.append(", ");
                PlSqlLauncher.convertParam(buf, params[i]);
            }
            buf.append(')');
        }
        if ((retType = proc.getReturnType()) != null) {
            buf.append('\n').append("RETURN").append(' ');
            buf.append(retType.getName());
        }
        buf.append(' ').append("AS").append('\n');
        String body = proc.getBody();
        buf.append(body);
        return buf.toString();
    }

    protected static void convertParam(StringBuffer buf, PlSqlParameter param) {
        buf.append(param.getName());
        PlSqlParameter.Mode mode = param.getMode();
        if (mode != null) {
            buf.append(' ').append(mode);
        }
        DataType type = param.getDataType();
        buf.append(' ').append(type.getName());
        String def = param.getDefaultValue();
        if (ModelUtil.hasLength((String)def)) {
            buf.append(' ').append("DEFAULT").append(' ').append(def);
        }
    }

    private static class FunctionSQLTab
    extends TabbedDialogLauncher.CreateSQLTab {
        private FunctionSQLTab() {
        }

        protected String getSQL(TraversableContext dataContext) {
            return PlSqlLauncher.getDDL((PlSqlSubprogram)dataContext.find("NewObject"), (DDLGenerator)dataContext.find("DDlGenerator"));
        }
    }
}

