/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.sequence;

import java.text.MessageFormat;
import oracle.dbtools.raptor.dialogs.CreateDialogArb;
import oracle.dbtools.raptor.dialogs.TabbedDialogLauncher;
import oracle.dbtools.raptor.dialogs.sequence.SequenceInfoVerifier;
import oracle.dbtools.raptor.dialogs.sequence.SequenceObjectInfoVerifier;
import oracle.dbtools.raptor.dialogs.sequence.SequenceTab;
import oracle.ide.Context;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Sequence;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.ora.OracleDDLGenerator;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.jdeveloper.cm.ds.db.DBUtil;
import oracle.jdeveloper.cm.dt.wizard.DBWizardLauncher;
import oracle.jdevimpl.cm.dt.wizards.CmWizardsArb;

public class TabbedOracleSequenceLauncher
extends TabbedDialogLauncher {
    public TabbedOracleSequenceLauncher(OracleDatabase db, Schema schema) {
        super((Database)db, schema);
        this.put("Tablespaces", db.listTablespaces());
        this.addTab(SequenceTab.class, "f1_dbnewsequencewizardsequenceinfo_html", CmWizardsArb.getString((int)363));
    }

    public boolean createObject() {
        Schema schema = this.getSchema();
        DBObjectProvider db = this.getProvider();
        Sequence sequence = new Sequence(db.getUniqueName("SEQUENCE", (DBObject)schema, null), schema);
        sequence.setID(TemporaryObjectID.createID((DBObject)sequence));
        this.put("NewObject", sequence);
        this.put("OriginalObject", null);
        this.put("DDlGenerator", new OracleDDLGenerator(db));
        this.registerVerifier("SchemaObjectInfoVerifier", SequenceObjectInfoVerifier.class);
        this.registerVerifier(SequenceInfoVerifier.KEY, SequenceInfoVerifier.class);
        this.addTab(TabbedDialogLauncher.CreateSQLTab.class, "f1_dbnewsequencewizardsequenceinfo_html", CreateDialogArb.getString(514));
        this.setTitle(CmWizardsArb.getString((int)360));
        this.setErrorTitle(MessageFormat.format(CmWizardsArb.getString((int)240), sequence.getName()));
        return this.createObjectImpl();
    }

    public boolean editObject(SchemaObject object) {
        SchemaObject copy = (SchemaObject)DBUtil.makeTemporaryCopy((DBObject)object);
        DBObjectProvider db = this.getProvider();
        this.put("NewObject", object);
        this.put("OriginalObject", copy);
        this.put("DDlGenerator", new OracleDDLGenerator(db));
        this.registerVerifier("SchemaObjectInfoVerifier", SequenceObjectInfoVerifier.class);
        this.registerVerifier(SequenceInfoVerifier.KEY, SequenceInfoVerifier.class);
        this.addTab(TabbedDialogLauncher.EditSQLTab.class, "f1_dbnewsequencewizardsequenceinfo_html", CreateDialogArb.getString(514));
        this.setTitle(CmWizardsArb.getString((int)361));
        this.setErrorTitle(MessageFormat.format(CmWizardsArb.getString((int)240), object.getName()));
        return this.createObjectImpl();
    }

    public static boolean createSequence(Context ctx, OracleDatabase db) {
        try {
            Schema schema = DBWizardLauncher.determineSchema((Context)ctx, (Database)db);
            TabbedOracleSequenceLauncher launcher = new TabbedOracleSequenceLauncher(db, schema);
            return launcher.createObject();
        }
        catch (DBException dBException) {
            return false;
        }
    }

    public static boolean editSequence(OracleDatabase db, Sequence sequence) {
        TabbedOracleSequenceLauncher launcher = new TabbedOracleSequenceLauncher(db, sequence.getSchema());
        return launcher.editObject((SchemaObject)sequence);
    }
}

