/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.synonym;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import oracle.dbtools.raptor.dialogs.synonym.SynonymInfoVerifier;
import oracle.ide.Ide;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.dialogs.ProgressBar;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Assert;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.ResourceUtils;
import oracle.ide.wizard.WizardCallbacks;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Synonym;
import oracle.javatools.db.ora.NameBasedRefID;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdeveloper.cm.dt.ConnectionArb;
import oracle.jdeveloper.cm.dt.ui.DBObjectRenderer;
import oracle.jdeveloper.cm.dt.ui.SchemaPicker;
import oracle.jdevimpl.cm.dt.wizards.CmWizardsArb;

public class SynonymTab
extends DefaultTraversablePanel
implements ActionListener {
    public static final String TABLESPACES_KEY = "Tablespaces";
    public static final String PUBLIC = "PUBLIC";
    private static final int LOAD_NOT_ATTEMPTED = 0;
    private static final int LOAD_COMPLETED = 1;
    private int m_ObjectStatus = 0;
    private ProgressBar m_progressBar = null;
    private static final String[] SYNONYM_TYPES = new String[]{"TABLE", "VIEW", "SEQUENCE", "SYNONYM", "FUNCTION", "PROCEDURE", "PACKAGE"};
    private static final String FORSCHEMACHANGED = "ForSchemaChanged";
    private static final String OBJECTCHANGED = "ObjectChanged";
    private static final String SETOBJECTBASED = "SetObjectBased";
    private static final String SETNAMEBASED = "SetNameBased";
    protected DBObjectProvider m_prov = null;
    protected Synonym m_synonym = null;
    protected Schema m_forSchema = null;
    protected String m_savedName = null;
    private Schema[] m_schemas = null;
    private Schema m_originalSchema = null;
    private GridBagLayout layCenter = new GridBagLayout();
    private JLabel m_lblFor = new JLabel();
    private JLabel m_lblForSchemaName = new JLabel();
    private JMultiLineLabel m_lblDanglingBlather = new JMultiLineLabel();
    private SchemaPicker m_cmbForSchema = new SchemaPicker();
    private JComboBox m_cmbObject = new JComboBox();
    private JTextField m_txtName = new JTextField();
    private JRadioButton m_rdbObjectBased = new JRadioButton();
    private JRadioButton m_rdbNameBased = new JRadioButton();
    private ButtonGroup m_rbgBased = new ButtonGroup();
    private DBObjectRenderer m_renderer = new DBObjectRenderer();
    private DefaultComboBoxModel m_mdlSchema = new NonNullableComboBoxModel();
    private DefaultComboBoxModel m_mdlForSchema = new NonNullableComboBoxModel();
    private static final DefaultComboBoxModel EMPTY_MDL_OBJECT = new NonNullableComboBoxModel();
    private Map m_schemaMap = new HashMap();
    private SynonymInfoVerifier m_verifier;
    private boolean m_isDefaultObject = true;
    private boolean m_isNewSynonymObject = true;
    private boolean m_isInit = false;
    private HashMap m_loadingSchemas = new HashMap();

    public SynonymTab() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.layCenter);
        this.m_cmbForSchema.setModel((ComboBoxModel)this.m_mdlForSchema);
        this.m_cmbForSchema.setRenderer((ListCellRenderer)this.m_renderer);
        this.m_cmbForSchema.setActionCommand(FORSCHEMACHANGED);
        this.m_cmbForSchema.addActionListener((ActionListener)this);
        this.m_cmbObject.setRenderer(this.m_renderer);
        this.m_cmbObject.setModel(EMPTY_MDL_OBJECT);
        this.m_cmbObject.setEditable(false);
        this.m_cmbObject.setActionCommand(OBJECTCHANGED);
        this.m_cmbObject.addActionListener(this);
        this.m_lblFor.setText(CmWizardsArb.getString((int)376));
        this.m_lblDanglingBlather.setPreferredAspectRatio(0.0f);
        ResourceUtils.resLabel((JLabel)this.m_lblForSchemaName, (Component)this.m_cmbForSchema, (String)CmWizardsArb.getString((int)377));
        ResourceUtils.resButton((AbstractButton)this.m_rdbObjectBased, (String)CmWizardsArb.getString((int)378));
        this.m_rdbObjectBased.setActionCommand(SETOBJECTBASED);
        this.m_rdbObjectBased.addActionListener(this);
        ResourceUtils.resButton((AbstractButton)this.m_rdbNameBased, (String)CmWizardsArb.getString((int)379));
        this.m_rdbNameBased.setActionCommand(SETNAMEBASED);
        this.m_rdbNameBased.addActionListener(this);
        this.m_rbgBased.add(this.m_rdbObjectBased);
        this.m_rbgBased.add(this.m_rdbNameBased);
        this.setLayout(this.layCenter);
        int y = 0;
        this.add(this.m_lblFor, new GridBagConstraints(1, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(15, 0, 0, 0), 0, 0));
        this.add(this.m_lblForSchemaName, new GridBagConstraints(1, ++y, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 5), 0, 0));
        this.add((Component)this.m_cmbForSchema, new GridBagConstraints(2, y, 0, 1, 1.0, 0.0, 17, 2, new Insets(5, 10, 0, 0), 0, 0));
        this.add(this.m_rdbObjectBased, new GridBagConstraints(1, ++y, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 5), 0, 0));
        this.add(this.m_cmbObject, new GridBagConstraints(2, y, 0, 1, 1.0, 0.0, 17, 2, new Insets(5, 10, 0, 0), 0, 0));
        this.add(this.m_rdbNameBased, new GridBagConstraints(1, ++y, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 5), 0, 0));
        this.add(this.m_txtName, new GridBagConstraints(2, y, 0, 1, 0.0, 0.0, 17, 2, new Insets(5, 10, 0, 0), 0, 0));
        this.add((Component)this.m_lblDanglingBlather, new GridBagConstraints(1, ++y, 0, 1, 0.0, 0.0, 17, 2, new Insets(5, 10, 0, 0), 0, 0));
        this.add(Box.createVerticalGlue(), new GridBagConstraints(1, ++y, 1, 1, 0.0, 1.0, 18, 3, new Insets(0, 0, 0, 0), 0, 0));
    }

    public String getHeaderTitle() {
        return CmWizardsArb.getString((int)374);
    }

    public Image getHeaderImage() {
        return ConnectionArb.getImage((int)447);
    }

    public String getHeaderDescription() {
        return CmWizardsArb.getString((int)375);
    }

    protected boolean isDangling(DBObjectID ref) {
        return false;
    }

    protected String getDanglingBlather() {
        return null;
    }

    public void onEntry(TraversableContext dataContext) {
        this.m_prov = (DBObjectProvider)dataContext.find("DBObjectProvider");
        this.m_synonym = (Synonym)dataContext.find("NewObject");
        this.m_verifier = (SynonymInfoVerifier)((Object)dataContext.find(SynonymInfoVerifier.KEY));
        Schema[] schemas = (Schema[])dataContext.find("SchemaList");
        this.init(this.m_synonym, this.m_verifier, schemas);
        WizardCallbacks callbacks = dataContext.getWizardCallbacks();
        if (callbacks != null) {
            callbacks.wizardEnableButtons(Boolean.TRUE, Boolean.TRUE, Boolean.TRUE);
        }
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        Synonym synonym = (Synonym)dataContext.find("NewObject");
        if (synonym == null) {
            synonym = new Synonym();
        }
        Schema[] schemas = (Schema[])dataContext.find("SchemaList");
        this.commit(synonym, schemas, dataContext.getDirection() != 2);
    }

    private void init(Synonym model, SynonymInfoVerifier verifier, Schema[] schemas) {
        if (this.m_isInit) {
            return;
        }
        this.m_isInit = true;
        this.m_schemas = schemas;
        this.m_cmbForSchema.setProvider(this.m_prov);
        this.m_renderer.setProvider(this.m_prov);
        if (this.isDangling(model.getReference())) {
            this.m_lblDanglingBlather.setText(this.getDanglingBlather());
        } else {
            this.m_lblDanglingBlather.setText(null);
        }
        this.m_mdlSchema.removeAllElements();
        this.m_mdlForSchema.removeAllElements();
        for (int i = 0; i < schemas.length; ++i) {
            this.m_mdlSchema.addElement(schemas[i]);
            this.m_mdlForSchema.addElement(schemas[i]);
        }
        this.m_originalSchema = model.getSchema();
        this.setOriginalSchema();
        this.m_forSchema = this.m_originalSchema;
        boolean nameBased = true;
        DBObjectID refID = model.getReference();
        if (null != refID) {
            this.m_isNewSynonymObject = false;
            nameBased = refID instanceof NameBasedRefID;
            SchemaObject forObject = null;
            try {
                forObject = (SchemaObject)refID.resolveID();
            }
            catch (DBException dbe) {
                // empty catch block
            }
            if (forObject == null) {
                this.setForSchemaAndName(refID);
            } else {
                this.m_forSchema = forObject.getSchema();
            }
        }
        this.setEnabledFields(nameBased);
        if (this.m_forSchema != null) {
            if (this.m_mdlForSchema.getIndexOf(this.m_forSchema) < 0) {
                this.m_mdlForSchema.addElement(this.m_forSchema);
            }
            this.m_mdlForSchema.setSelectedItem(this.m_forSchema);
        }
        SchemaObject ref = null;
        if (null != refID) {
            try {
                DBObject temp = refID.resolveID();
                if (temp instanceof SchemaObject) {
                    ref = (SchemaObject)temp;
                }
            }
            catch (DBException dbe) {
                // empty catch block
            }
        }
        if (null != ref) {
            this.m_isDefaultObject = false;
            this.m_forSchema = ref.getSchema();
        }
        this.m_mdlForSchema.setSelectedItem(this.m_forSchema);
        this.m_cmbForSchema.setSelectedItem((Object)this.m_forSchema);
        if (nameBased) {
            this.m_cmbObject.setModel(EMPTY_MDL_OBJECT);
            this.m_txtName.setText(this.m_savedName);
        } else {
            if (!this.populateObjectField()) {
                nameBased = true;
            }
            if (this.m_cmbObject.getModel().getSize() < 1) {
                nameBased = true;
            }
            if (null != ref) {
                this.m_cmbObject.setSelectedItem(ref.getName());
            }
        }
        this.setEnabledFields(nameBased);
        this.m_lblFor.setEnabled(verifier == null || verifier.canChangeReference());
        this.m_lblForSchemaName.setEnabled(verifier == null || verifier.canChangeSchema());
        this.m_cmbForSchema.setEnabled(verifier == null || verifier.canChangeSchema());
        this.m_cmbForSchema.setEditable(verifier == null || verifier.canCreateSchema());
        this.m_rdbNameBased.setEnabled(verifier == null || verifier.canChangeReference());
        this.m_rdbObjectBased.setEnabled(verifier == null || verifier.canChangeReference());
        this.m_cmbObject.setEnabled(!nameBased && (verifier == null || verifier.canChangeReference()));
        this.m_txtName.setEditable(nameBased && (verifier == null || verifier.canChangeReference()));
        this.m_txtName.setEnabled(nameBased && (verifier == null || verifier.canChangeReference()));
        this.m_isNewSynonymObject = false;
    }

    private void setOriginalSchema() {
        if (this.m_originalSchema != null) {
            if (this.m_mdlSchema.getIndexOf(this.m_originalSchema) < 0) {
                this.m_mdlSchema.addElement(this.m_originalSchema);
            }
            if (!PUBLIC.equals(this.m_originalSchema.getName())) {
                try {
                    this.m_mdlSchema.removeElement(this.m_prov.getSchema(PUBLIC));
                }
                catch (DBException dBException) {
                    // empty catch block
                }
            }
            this.m_mdlSchema.setSelectedItem(this.m_originalSchema);
        }
    }

    private void commit(Synonym synonym, Schema[] schemas, boolean forward) throws TraversalException {
        SynonymInfoVerifier verifier = this.m_verifier;
        this.m_forSchema = this.m_cmbForSchema.getSchema(schemas);
        String refObjName = null;
        boolean objectBased = this.m_rdbObjectBased.isSelected();
        refObjName = objectBased ? (String)this.m_cmbObject.getSelectedItem() : this.m_txtName.getText();
        if (!ModelUtil.hasLength((String)refObjName)) {
            throw new TraversalException(CmWizardsArb.getString((int)382));
        }
        SchemaObject refObj = this.findObject(refObjName);
        if (objectBased && null != refObj) {
            synonym.setReference(refObj.getID());
        } else {
            NameBasedRefID nameBasedReference = new NameBasedRefID(this.m_forSchema, refObjName);
            synonym.setReference((DBObjectID)nameBasedReference);
        }
        if (forward && verifier != null) {
            verifier.verifySynonym();
        }
    }

    public void actionPerformed(ActionEvent e) {
        boolean nameBased = this.m_rdbNameBased.isSelected();
        if (FORSCHEMACHANGED.equals(e.getActionCommand())) {
            try {
                this.m_forSchema = this.m_cmbForSchema.getSchema(this.m_schemas);
                if (this.m_rdbObjectBased.isSelected() && !this.populateObjectField()) {
                    nameBased = true;
                }
            }
            catch (TraversalException te) {}
        } else if (OBJECTCHANGED.equals(e.getActionCommand())) {
            int selectedIndex = this.m_cmbObject.getSelectedIndex();
            this.m_isDefaultObject = this.m_isNewSynonymObject || selectedIndex == -1;
        } else if (SETOBJECTBASED.equals(e.getActionCommand())) {
            if (!this.populateObjectField()) {
                nameBased = true;
            } else {
                SchemaObject object;
                this.m_savedName = this.m_txtName.getText();
                if (ModelUtil.hasLength((String)this.m_savedName) && null != (object = this.findObject(this.m_savedName))) {
                    this.m_cmbObject.setSelectedItem(object.getName());
                }
                this.m_txtName.setText(null);
            }
        } else {
            SchemaObject ob = this.findObject((String)this.m_cmbObject.getSelectedItem());
            if (!this.m_isDefaultObject && null != ob) {
                this.m_txtName.setText(ob.getName());
            } else if (null != this.m_savedName && this.m_savedName.length() > 0) {
                this.m_txtName.setText(this.m_savedName);
            }
            nameBased = true;
        }
        this.setEnabledFields(nameBased);
    }

    private void setEnabledFields(boolean nameBased) {
        this.m_rdbNameBased.setSelected(nameBased);
        this.m_rdbObjectBased.setSelected(!nameBased);
        this.m_txtName.setEditable(nameBased);
        this.m_txtName.setEnabled(nameBased);
        this.m_cmbObject.setEnabled(!nameBased);
    }

    private void getAllSynonymObjects(Schema refSchema) {
        try {
            SchemaObject[] objects = this.m_prov.listObjects(SYNONYM_TYPES, refSchema);
            SchemaObject originalSynonym = this.m_verifier.getOriginalObject();
            String originalSynonymName = originalSynonym != null ? originalSynonym.getName() : null;
            Schema originalSchema = originalSynonym != null ? originalSynonym.getSchema() : null;
            NonNullableComboBoxModel objectModel = new NonNullableComboBoxModel();
            for (int i = 0; i < objects.length; ++i) {
                if (originalSynonym != null && "SYNONYM".equals(objects[i].getType()) && ModelUtil.areEqual((Object)originalSchema, (Object)refSchema) && ModelUtil.areEqual((Object)originalSynonymName, (Object)objects[i].getName())) continue;
                objectModel.addElement(objects[i].getName());
            }
            this.m_schemaMap.put(refSchema.getName(), objectModel);
        }
        catch (DBException dBException) {
            // empty catch block
        }
    }

    private boolean setObjectModel(Schema refSchema) {
        DefaultComboBoxModel objectModel = null;
        if (this.m_verifier.canChangeReference()) {
            objectModel = (DefaultComboBoxModel)this.m_schemaMap.get(refSchema.getName());
        } else if (null != this.m_synonym) {
            objectModel = new NonNullableComboBoxModel();
            try {
                DBObject refob = this.m_synonym.getReference().resolveID();
                if (null != refob) {
                    objectModel.addElement(refob.getName());
                }
            }
            catch (DBException dbe) {
                Assert.printStackTrace((Throwable)dbe);
            }
        }
        this.m_cmbObject.setModel(objectModel != null ? objectModel : EMPTY_MDL_OBJECT);
        return objectModel != null;
    }

    private SchemaObject findObject(String name) {
        SchemaObject result = null;
        if (null != name) {
            for (int i = 0; i < SYNONYM_TYPES.length; ++i) {
                try {
                    result = this.m_prov.getObject(SYNONYM_TYPES[i], this.m_forSchema, name);
                    if (null == result) continue;
                    break;
                }
                catch (DBException e) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    private boolean populateObjectField() {
        Schema refSchema = this.m_forSchema;
        if (!this.m_schemaMap.containsKey(refSchema.getName())) {
            this.loadObjectModel(refSchema);
        }
        return this.setObjectModel(refSchema);
    }

    protected void setForSchemaAndName(DBObjectID refID) {
        if (refID instanceof NameBasedRefID) {
            NameBasedRefID sRefID = (NameBasedRefID)refID;
            String schemaName = sRefID.getSchemaName();
            if (schemaName != null) {
                try {
                    Schema forSchema = this.m_prov.getSchema(schemaName);
                    this.m_forSchema = null == forSchema ? new Schema(schemaName) : forSchema;
                }
                catch (DBException dbe) {
                    // empty catch block
                }
            }
            this.m_savedName = sRefID.getName();
        }
    }

    private void loadObjectModel(Schema refSchema) {
        if (!this.m_loadingSchemas.containsKey(refSchema.getName())) {
            ObjectModelLoader objectModelLoader = new ObjectModelLoader(refSchema);
            this.m_loadingSchemas.put(refSchema.getName(), objectModelLoader);
            objectModelLoader.execute();
        } else {
            ObjectModelLoader objectModelLoader = (ObjectModelLoader)this.m_loadingSchemas.get(refSchema.getName());
            if (objectModelLoader != null) {
                objectModelLoader.execute();
            }
        }
    }

    public String getTitle() {
        return CmWizardsArb.getString((int)383);
    }

    public String getProgressText() {
        return CmWizardsArb.getString((int)384);
    }

    private class ObjectModelLoader
    implements Runnable {
        private Schema m_schema;
        private ProgressBar m_bar;

        public ObjectModelLoader() {
        }

        public ObjectModelLoader(Schema schema) {
            this.m_schema = schema;
        }

        public void execute() {
            if (SynonymTab.this.m_prov instanceof Database) {
                this.m_bar = new ProgressBar((Component)Ide.getMainWindow(), SynonymTab.this.getTitle(), (Runnable)this, true);
                this.m_bar.start(SynonymTab.this.getProgressText(), this.m_schema.getName());
            } else {
                this.m_bar = null;
                this.run();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ProgressBar bar = this.m_bar;
            ObjectModelLoader objectModelLoader = this;
            synchronized (objectModelLoader) {
                if (SynonymTab.this.m_loadingSchemas.containsKey(this.m_schema.getName())) {
                    try {
                        Assert.println((String)("Start getAllSynonymObjects for schema " + this.m_schema.getName()));
                        SynonymTab.this.getAllSynonymObjects(this.m_schema);
                    }
                    catch (Exception e) {
                        Assert.printStackTrace((Throwable)e);
                        ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)e, (String)e.getMessage());
                    }
                    SynonymTab.this.m_loadingSchemas.remove(this.m_schema.getName());
                    Assert.println((String)("Finished getAllSynonymObjects for schema " + this.m_schema.getName()));
                }
                if (bar != null) {
                    bar.setDoneStatus();
                }
            }
        }
    }
}

