/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.synonym;

import java.awt.Component;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import oracle.dbtools.raptor.dialogs.CreateDialogArb;
import oracle.dbtools.raptor.dialogs.TabbedDialogLauncher;
import oracle.dbtools.raptor.dialogs.synonym.SynonymInfoVerifier;
import oracle.dbtools.raptor.dialogs.synonym.SynonymObjectInfoVerifier;
import oracle.dbtools.raptor.dialogs.synonym.SynonymTab;
import oracle.dbtools.raptor.dialogs.synonym.TabbedSynonymPanel;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.panels.Traversable;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.Namespace;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Synonym;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.ora.OracleDDLGenerator;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.jdeveloper.cm.ds.db.DBUtil;
import oracle.jdeveloper.cm.dt.wizard.DBWizardLauncher;
import oracle.jdevimpl.cm.dt.wizards.CmWizardsArb;

public class TabbedOracleSynonymLauncher
extends TabbedDialogLauncher {
    public TabbedOracleSynonymLauncher(OracleDatabase db, Schema schema) {
        super((Database)db, schema);
        this.put("Tablespaces", db.listTablespaces());
        this.addTab(SynonymTab.class, "f1_dbnewsynonymwizardsynonyminfo_html", CmWizardsArb.getString((int)375));
    }

    public boolean createObject() {
        Schema schema = this.getSchema();
        DBObjectProvider db = this.getProvider();
        Synonym synonym = new Synonym(db.getUniqueName("SYNONYM", (DBObject)schema, null), schema, null);
        synonym.setID(TemporaryObjectID.createID((DBObject)synonym));
        this.put("NewObject", synonym);
        this.put("OriginalObject", null);
        this.put("DDlGenerator", new OracleDDLGenerator(db));
        try {
            Schema publicSchema = db.getSchema("PUBLIC");
            if (null != publicSchema) {
                ArrayList<Schema> schemas = new ArrayList<Schema>(Arrays.asList((Schema[])this.get("SchemaList")));
                schemas.add(publicSchema);
                Schema[] newSchemaArray = new Schema[schemas.size()];
                this.put("SchemaList", schemas.toArray(newSchemaArray));
            }
        }
        catch (DBException dbe) {
            // empty catch block
        }
        this.registerVerifier("SchemaObjectInfoVerifier", SynonymObjectInfoVerifier.class);
        this.registerVerifier(SynonymInfoVerifier.KEY, SynonymInfoVerifier.class);
        this.addTab(TabbedDialogLauncher.CreateSQLTab.class, "f1_dbnewsynonymwizardsynonyminfo_html", CreateDialogArb.getString(514));
        this.setTitle(CmWizardsArb.getString((int)372));
        this.setErrorTitle(MessageFormat.format(CmWizardsArb.getString((int)237), synonym.getName()));
        return this.createObjectImpl();
    }

    public boolean editObject(SchemaObject object) {
        SchemaObject copy = (SchemaObject)DBUtil.makeTemporaryCopy((DBObject)object);
        DBObjectProvider db = this.getProvider();
        this.put("NewObject", object);
        this.put("OriginalObject", copy);
        this.put("DDlGenerator", new OracleDDLGenerator(db));
        this.registerVerifier("SchemaObjectInfoVerifier", SynonymObjectInfoVerifier.class);
        this.registerVerifier(SynonymInfoVerifier.KEY, SynonymInfoVerifier.class);
        this.addTab(TabbedDialogLauncher.EditSQLTab.class, "f1_dbnewsynonymwizardsynonyminfo_html", CreateDialogArb.getString(514));
        this.setTitle(CmWizardsArb.getString((int)373));
        this.setErrorTitle(MessageFormat.format(CmWizardsArb.getString((int)237), object.getName()));
        return this.createObjectImpl();
    }

    public static boolean createSynonym(Context ctx, OracleDatabase db) {
        try {
            Schema schema = DBWizardLauncher.determineSchema((Context)ctx, (Database)db);
            TabbedOracleSynonymLauncher launcher = new TabbedOracleSynonymLauncher(db, schema);
            return launcher.createObject();
        }
        catch (DBException dBException) {
            return false;
        }
    }

    public static boolean editSynonym(OracleDatabase db, Synonym synonym) {
        TabbedOracleSynonymLauncher launcher = new TabbedOracleSynonymLauncher(db, synonym.getSchema());
        return launcher.editObject((SchemaObject)synonym);
    }

    protected boolean runDialog(String title) {
        TabbedSynonymPanel panel = new TabbedSynonymPanel(this._tabs.toArray(new Navigable[this._tabs.size()]));
        if (ModelUtil.hasLength((String)this._topLabel)) {
            panel.setTopLabel(this._topLabel);
        }
        if (ModelUtil.hasLength((String)this._errTitle)) {
            panel.setErrorTitle(this._errTitle);
        }
        TDialogLauncher launcher = new TDialogLauncher((Component)Ide.getMainWindow(), title, (Traversable)panel, (Namespace)this);
        launcher.setInitialSize(600, 500);
        return launcher.showDialog();
    }
}

