/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.table;

import java.util.ArrayList;
import java.util.List;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ModelUtil;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.jdeveloper.cm.dt.verifier.table.AbstractColumnInfoVerifier;
import oracle.jdevimpl.cm.dt.wizards.CmWizardsArb;

public class EditColumnInfoVerifier
extends AbstractColumnInfoVerifier {
    private List _colSet = new ArrayList();

    public void initializeVerifier(DBObjectProvider prov, SchemaObject orig, SchemaObject changed) {
        super.initializeVerifier(prov, orig, changed);
        Table table = (Table)changed;
        Column[] cols = table.getColumns();
        for (int i = 0; i < cols.length; ++i) {
            this._colSet.add(cols[i]);
        }
    }

    public boolean canRemoveColumn(Column col) {
        return true;
    }

    public boolean canMoveColumnUp(Column col) {
        return this.isNewColumn(col);
    }

    public boolean canMoveColumnDown(Column col) {
        return this.isNewColumn(col);
    }

    public boolean canChangeColumnComment(Column col) {
        return this.isNewColumn(col);
    }

    public boolean canChangeColumnDefaultValue(Column col) {
        return true;
    }

    public boolean canChangeColumnNotNullState(Column col) {
        return true;
    }

    public boolean canChangeColumnType(Column col) {
        return true;
    }

    public boolean canChangeColumnSize(Column col) {
        return true;
    }

    public boolean canRenameColumn(Column col) {
        return true;
    }

    private boolean isNewColumn(Column col) {
        return !this._colSet.contains(col);
    }

    public void verifyColumn(Column oldCol, Column newCol) throws TraversalException {
        super.verifyColumn(oldCol, newCol);
        if (ModelUtil.areDifferent((Object)oldCol, (Object)newCol) && !this.isNewColumn(oldCol)) {
            DataTypeAttribute size;
            DataTypeUsage dataTypeUsage = newCol.getDataTypeUsage();
            DataTypeUsage oldDataTypeUsage = oldCol.getDataTypeUsage();
            DBObjectID typeID = dataTypeUsage.getDataTypeID();
            DBObjectID oldTypeID = oldDataTypeUsage.getDataTypeID();
            DataType type = null;
            try {
                type = typeID == null ? null : (DataType)typeID.resolveID();
            }
            catch (DBException dbe) {
                // empty catch block
            }
            if (type == null) {
                throw new TraversalException(CmWizardsArb.format((int)66, (Object)newCol.getName()), CmWizardsArb.getString((int)67));
            }
            DataTypeAttribute dataTypeAttribute = size = type.getDataTypeAttribute("precision") == null ? type.getDataTypeAttribute("size") : type.getDataTypeAttribute("precision");
            if (size != null && size.isDeclarable()) {
                Long s = DataTypeHelper.getLongAttributeValue((DataTypeUsage)oldDataTypeUsage, (String)"precision");
                s = s == null ? DataTypeHelper.getLongAttributeValue((DataTypeUsage)oldDataTypeUsage, (String)"size") : s;
                long oldPrec = s != null ? s : 0L;
                s = DataTypeHelper.getLongAttributeValue((DataTypeUsage)dataTypeUsage, (String)"precision");
                s = s == null ? DataTypeHelper.getLongAttributeValue((DataTypeUsage)dataTypeUsage, (String)"size") : s;
                long newPrec = s != null ? s : 0L;
                long oldScale = 0L;
                long newScale = 0L;
                DataTypeAttribute scale = type.getDataTypeAttribute("scale");
                if (scale != null && scale.isDeclarable()) {
                    s = (Long)oldCol.getDataTypeUsage().getAttributeValue("scale");
                    oldScale = s == null ? 0L : s;
                    s = (Long)newCol.getDataTypeUsage().getAttributeValue("scale");
                    newScale = s == null ? 0L : s;
                }
            }
        }
    }
}

