/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import oracle.javatools.db.Column;
import oracle.javatools.db.ColumnConstraint;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Index;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.sql.IndexObject;
import oracle.javatools.db.sql.ParserUtils;
import oracle.jdeveloper.cm.dt.verifier.table.AbstractIndexInfoVerifier;

public class EditIndexInfoVerifier
extends AbstractIndexInfoVerifier {
    private ArrayList m_indexSet = null;

    public void initializeVerifier(DBObjectProvider prov, SchemaObject orig, SchemaObject changed) {
        super.initializeVerifier(prov, orig, changed);
        Table table = (Table)changed;
        Index[] indexes = table.getIndexes();
        this.m_indexSet = new ArrayList<Index>(Arrays.asList(indexes));
    }

    public boolean canRenameIndex(Index index) {
        return this.isNewIndex(index);
    }

    public boolean canRemoveIndexes() {
        return this.isEditable();
    }

    public boolean canRemoveIndex(Index index) {
        boolean constraint = false;
        HashSet<Column> constraintCols = new HashSet<Column>();
        Table table = index.getTable();
        Constraint[] cons = table.getConstraints();
        for (int i = 0; i < cons.length; ++i) {
            if (!"PKConstraint".equals(cons[i].getConstraintType()) && !"UniqueConstraint".equals(cons[i].getConstraintType())) continue;
            constraintCols.addAll(Arrays.asList(((ColumnConstraint)cons[i]).getColumns()));
        }
        IndexObject[] columnExpressions = index.getColumnExpressions();
        for (int i = 0; !constraint && i < columnExpressions.length; ++i) {
            Collection ceCols = ParserUtils.getColumnNames((String)columnExpressions[i].getSQLText());
            Iterator ceColi = ceCols.iterator();
            while (!constraint && ceColi.hasNext()) {
                if (!constraintCols.contains(table.getColumn((String)ceColi.next()))) continue;
                constraint = true;
            }
        }
        return this.isEditable() && (this.isNewIndex(index) || !constraint);
    }

    public boolean canReorderIndexes() {
        return this.isEditable();
    }

    public boolean canMoveIndexUp(Index index) {
        return this.isNewIndex(index);
    }

    public boolean canMoveIndexDown(Index index) {
        return this.isNewIndex(index);
    }

    public boolean canAddIndexes() {
        return this.isEditable();
    }

    public boolean canAddIndex(Index index) {
        return this.isEditable();
    }

    public boolean canEditIndex(Index index) {
        return this.isNewIndex(index);
    }

    private boolean isNewIndex(Index index) {
        return !this.m_indexSet.contains(index);
    }
}

