/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.dbtools.raptor.dialogs.CreateDialogArb;
import oracle.dbtools.raptor.dialogs.table.CreationColumnInfoVerifier;
import oracle.dbtools.raptor.dialogs.table.CreationConstraintsInfoVerifier;
import oracle.dbtools.raptor.dialogs.table.CreationTableInfoVerifier;
import oracle.ide.Context;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Assert;
import oracle.ide.util.Namespace;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.PredefinedDataType;
import oracle.jdeveloper.cm.dt.CmUtil;
import oracle.jdeveloper.cm.dt.ConnectionArb;
import oracle.jdeveloper.cm.dt.ConnectionNode;
import oracle.jdeveloper.cm.dt.DatabaseConnectionNode;
import oracle.jdeveloper.cm.dt.browser.ConnectionBrowser;
import oracle.jdeveloper.cm.dt.ui.DBObjectOnePageDialog;
import oracle.jdeveloper.cm.dt.ui.DBObjectOnePagePanel;
import oracle.jdeveloper.cm.dt.wizard.DBWizardLauncher;
import oracle.jdevimpl.cm.dt.browser.jdbc.JdbcBrowser;

public class SimpleCreateTableDlg
extends DBObjectOnePagePanel
implements KeyListener {
    private GridBagLayout _layoutGB = new GridBagLayout();
    private JLabel _lblTableName = new JLabel();
    private JTextField _fldTableName = new JTextField();
    private JMultiLineLabel _lblNameError = new JMultiLineLabel();
    private SimpleTableModel _columnModel = new SimpleTableModel();
    private JTable _tblColumnList = new JTable();
    private JButton _btnAddColumn = new JButton();
    private JButton _btnRemoveColumn = new JButton();
    private JComboBox _cmbColType = new JComboBox();
    private DefaultComboBoxModel _mdlTypes = new NonNullableComboBoxModel();
    private DBObjectProvider _prov;
    private Table _table;
    protected CreationTableInfoVerifier _tableVerifier = null;
    protected CreationColumnInfoVerifier _columnVerifier = null;
    protected CreationConstraintsInfoVerifier _constraintVerifier = null;
    private ArrayList _typeArray = new ArrayList(4);

    public SimpleCreateTableDlg() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this._layoutGB);
        this._lblTableName.setText("Table Name:");
        this._fldTableName.setEditable(true);
        this._fldTableName.addKeyListener(this);
        this._lblNameError.setPreferredColumns(40);
        this._btnAddColumn.setText("Add Column");
        this._btnRemoveColumn.setText("Remove Column");
        this._btnAddColumn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int row = SimpleCreateTableDlg.this._tblColumnList.getSelectedRow();
                if (row < 0) {
                    row = SimpleCreateTableDlg.this._columnModel.size();
                }
                SimpleCreateTableDlg.this._columnModel.addRow(row);
            }
        });
        this._btnRemoveColumn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (SimpleCreateTableDlg.this._tblColumnList.getSelectedRow() >= 0) {
                    SimpleCreateTableDlg.this._columnModel.deleteRow(SimpleCreateTableDlg.this._tblColumnList.getSelectedRow());
                }
            }
        });
        this._tblColumnList.setModel(this._columnModel);
        TableColumn colType = this._tblColumnList.getColumnModel().getColumn(1);
        String[] items = new String[]{"VARCHAR2", "NUNBER", "DATE", "CLOB"};
        colType.setCellEditor(new DefaultCellEditor(new JComboBox<String>(items)));
        TableColumnModel tableColumnModel = this._tblColumnList.getColumnModel();
        TableColumn col = tableColumnModel.getColumn(0);
        col.setMinWidth(110);
        col = tableColumnModel.getColumn(1);
        col.setMinWidth(110);
        col.setMaxWidth(150);
        col = tableColumnModel.getColumn(2);
        col.setMinWidth(50);
        col.setMaxWidth(60);
        col = tableColumnModel.getColumn(3);
        col.setMinWidth(60);
        col.setMaxWidth(60);
        col = tableColumnModel.getColumn(4);
        col.setMinWidth(70);
        col.setMaxWidth(70);
        JScrollPane scrollPane = new JScrollPane(this._tblColumnList);
        this._tblColumnList.setPreferredScrollableViewportSize(new Dimension(500, 100));
        this._tblColumnList.setSelectionMode(0);
        ColumnListCellRenderer renderer = new ColumnListCellRenderer();
        try {
            this._tblColumnList.setDefaultRenderer(Class.forName("java.lang.Object"), renderer);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.add(this._lblTableName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this._fldTableName, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this._lblNameError, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(scrollPane, new GridBagConstraints(0, 1, 3, 3, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this._btnAddColumn, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 0), 0, 0));
        this.add(this._btnRemoveColumn, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0));
    }

    public void init(DBObjectProvider prov) {
        DataType[] types = prov.listSupportedDataTypes();
        boolean bVarCharAdded = false;
        for (int i = 0; i < types.length; ++i) {
            if (!(types[i] instanceof PredefinedDataType)) continue;
            if (types[i].getName().equals("VARCHAR2")) {
                if (bVarCharAdded) continue;
                this._typeArray.add(0, types[i]);
                bVarCharAdded = true;
                continue;
            }
            if (types[i].getName().equals("NUMBER")) {
                this._typeArray.add(1, types[i]);
                continue;
            }
            if (types[i].getName().equals("DATE")) {
                this._typeArray.add(1, types[i]);
                continue;
            }
            if (!types[i].getName().equals("CLOB")) continue;
            this._typeArray.add(1, types[i]);
        }
        TableColumn colType = this._tblColumnList.getColumnModel().getColumn(1);
        colType.setCellEditor(new DefaultCellEditor(new JComboBox<Object>(this._typeArray.toArray())));
        this._columnModel.addRow(0);
    }

    public String getHeaderTitle() {
        return "Table";
    }

    public Image getHeaderImage() {
        return ConnectionArb.getImage((int)429);
    }

    public String getHeaderDescription() {
        return "Add columns to create your table.";
    }

    public void onEntry(TraversableContext dataContext) {
        this._prov = (DBObjectProvider)dataContext.find("DBObjectProvider");
        this._table = (Table)dataContext.find("NewObject");
        this._tableVerifier = (CreationTableInfoVerifier)((Object)dataContext.find("SchemaObjectInfoVerifier"));
        this._columnVerifier = (CreationColumnInfoVerifier)((Object)dataContext.find("ColumnInfoVerifier"));
        this._constraintVerifier = (CreationConstraintsInfoVerifier)((Object)dataContext.find("ConstraintsInfoVerifier"));
        this._tableVerifier.initializeVerifier(this._prov, null, (SchemaObject)this._table);
        this._columnVerifier.initializeVerifier(this._prov, null, (SchemaObject)this._table);
        this._constraintVerifier.initializeVerifier(this._prov, null, (SchemaObject)this._table);
        this._fldTableName.setText(this._table.getName());
    }

    public void onExit(TraversableContext dataContext) {
        Assert.println((String)"exiting");
        int size = this._columnModel.size();
        ArrayList<Column> cols = new ArrayList<Column>(size);
        for (int i = 0; i < size; ++i) {
            Column col = new Column(this._columnModel.getValueAt(i, 0).toString());
            col.setNotNull(((Boolean)this._columnModel.getValueAt(i, 3)).booleanValue());
            col.setDataTypeUsage(((DataType)this._columnModel.getValueAt(i, 1)).createDefaultUsage());
            cols.add(col);
        }
        this._table.setColumns(cols.toArray(new Column[cols.size()]));
        if (this._columnVerifier != null) {
            try {
                this._columnVerifier.verifyRelation();
            }
            catch (TraversalException ex) {
                System.err.println((Object)ex);
            }
        }
    }

    public static boolean launchSimpleTableNew(Context context) {
        ConnectionBrowser browser;
        ConnectionNode node = CmUtil.getConnectionNode((Context)context);
        if (node instanceof DatabaseConnectionNode && node.isOpen() && (browser = node.getConnectionBrowser()) instanceof JdbcBrowser) {
            Database db = ((JdbcBrowser)browser).getDatabase();
            DBObjectOnePageDialog d = new DBObjectOnePageDialog(500, 400);
            try {
                Schema schema = DBWizardLauncher.determineSchema((Context)context, (Database)db);
                Table table = new Table(db.getUniqueName("TABLE", (DBObject)schema, null), schema);
                table.setID(TemporaryObjectID.createID((DBObject)table));
                Namespace ns = d.createCreateNamespace((DBObjectProvider)db, (SchemaObject)table, null);
                ns.put("SchemaObjectInfoVerifier", (Object)new CreationTableInfoVerifier());
                ns.put("ColumnInfoVerifier", (Object)new CreationColumnInfoVerifier());
                ns.put("ConstraintsInfoVerifier", (Object)new CreationConstraintsInfoVerifier());
                SimpleCreateTableDlg panel = new SimpleCreateTableDlg();
                panel.init((DBObjectProvider)db);
                panel.setHelpID("f1_bdbwcreatetablecolumns_html");
                d.doOnePageCreateDialog(CreateDialogArb.getString(2), (DefaultTraversablePanel)panel, ns);
            }
            catch (DBException ex) {
                return false;
            }
        }
        return true;
    }

    public void updateName() {
        String name = this._fldTableName.getText();
        name = this._prov.getInternalName(name, this._table.getType());
        try {
            if (this._tableVerifier != null) {
                this._tableVerifier.verifyName(name);
            }
            this._table.setName(name);
            this._fldTableName.setBackground(new Color(255, 255, 255));
            this._lblNameError.setText("");
        }
        catch (TraversalException ex) {
            this._fldTableName.setBackground(new Color(255, 150, 150));
            this._lblNameError.setText(ex.getLocalizedMessage());
            return;
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        this.updateName();
    }

    private class ColumnListCellRenderer
    extends DefaultTableCellRenderer {
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component cell = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            TableModel model = table.getModel();
            if (!table.isRowSelected(row)) {
                if (!model.isCellEditable(row, column)) {
                    cell.setBackground(Color.lightGray);
                } else {
                    cell.setBackground(Color.white);
                }
            }
            return cell;
        }
    }

    private class SimpleTableModel
    extends AbstractTableModel {
        public String[] columnNames = new String[]{"Column Name", "Type", "Size", "Not Null", "Primary Key"};
        private ArrayList _data = new ArrayList(1);
        private DefaultListModel _mdlColumns = new DefaultListModel();

        public SimpleTableModel() {
            this._mdlColumns.addElement("COLUMN");
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return this._data.size();
        }

        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public Object getValueAt(int row, int col) {
            if (row >= this._data.size()) {
                return null;
            }
            ArrayList colList = (ArrayList)this._data.get(row);
            if (col >= colList.size()) {
                return null;
            }
            return colList.get(col);
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        public boolean isCellEditable(int row, int col) {
            Object o;
            String type;
            return !(col == 2 ? (type = (o = this.getValueAt(row, 1)).toString()).equals("DATE") || type.equals("CLOB") : col == 4 && (type = (o = this.getValueAt(row, 1)).toString()).equals("CLOB"));
        }

        public void setValueAt(Object value, int row, int col) {
            if (row >= this._data.size()) {
                return;
            }
            ArrayList colList = (ArrayList)this._data.get(row);
            if (col >= colList.size()) {
                return;
            }
            if (col == 0) {
                this._mdlColumns.removeElement(colList.get(0));
                this._mdlColumns.addElement(value);
            }
            colList.set(col, value);
            if (col == 1) {
                if (value.toString().equals("VARCHAR2")) {
                    colList.set(2, "4000");
                } else if (value.toString().equals("NUMBER")) {
                    colList.set(2, "10");
                } else if (value.toString().equals("CLOB")) {
                    colList.set(4, new Boolean(false));
                    colList.set(2, "");
                    this.fireTableCellUpdated(row, 4);
                } else {
                    colList.set(2, "");
                }
                this.fireTableCellUpdated(row, 2);
            }
            this.fireTableCellUpdated(row, col);
        }

        public void addRow(int row) {
            ArrayList<Object> colList = new ArrayList<Object>(5);
            String name = SimpleCreateTableDlg.getUniqueName((String)"COLUMN", (DefaultListModel)this._mdlColumns);
            this._mdlColumns.addElement(name);
            colList.add(name);
            colList.add(SimpleCreateTableDlg.this._typeArray.get(0));
            colList.add("4000");
            colList.add(new Boolean(false));
            colList.add(new Boolean(false));
            this._data.add(row, colList);
            this.fireTableDataChanged();
        }

        public void deleteRow(int row) {
            this._data.remove(row);
            this.fireTableDataChanged();
        }

        public int size() {
            return this._data.size();
        }
    }
}

