/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.table;

import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.dbtools.raptor.dialogs.CreateDialogArb;
import oracle.ide.Ide;
import oracle.ide.controls.WaitCursor;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.Table;
import oracle.jdeveloper.cm.dt.ui.TabbedDBPanel;
import oracle.jdeveloper.cm.dt.ui.table.TableTypePanel;
import oracle.jdevimpl.cm.dt.wizards.table.TablePanelLibrary;

public class TabbedTablePanel
extends TabbedDBPanel {
    private JLabel _lblType = new JLabel();
    private TableTypePanel _pnlType = new TableTypePanel(false);
    private Table.TableType _lastType;
    private TablePanelLibrary _lib;
    private Table _table;
    private JCheckBox _cbxAdvanced = new JCheckBox();

    public TabbedTablePanel(Navigable[] navs) {
        super(navs);
    }

    protected JPanel buildPnlInfo() {
        JPanel pnlInfo = super.buildPnlInfo();
        ResourceUtils.resButton((AbstractButton)this._cbxAdvanced, (String)CreateDialogArb.getString(567));
        this._cbxAdvanced.addItemListener(new ItemListener(){
            private boolean resetting;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void itemStateChanged(ItemEvent e) {
                if (this.resetting) {
                    this.resetting = false;
                    return;
                }
                WaitCursor wc = Ide.getWaitCursor();
                wc.show();
                try {
                    if (TabbedTablePanel.this._cbxAdvanced.isSelected()) {
                        Table.TableType type = TabbedTablePanel.this._pnlType.getTableType();
                        if (!TabbedTablePanel.this.updateTabs(type)) {
                            this.resetting = true;
                            TabbedTablePanel.this._cbxAdvanced.setSelected(false);
                        }
                    } else if (!TabbedTablePanel.this.updateTabs(null)) {
                        this.resetting = true;
                        TabbedTablePanel.this._cbxAdvanced.setSelected(true);
                    }
                }
                finally {
                    wc.hide();
                }
            }
        });
        this._lblType.setText(CreateDialogArb.getString(10));
        this._pnlType.addActionListener((ActionListener)((Object)this));
        pnlInfo.add((Component)this._cbxAdvanced, this.gbc(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
        pnlInfo.add((Component)this._lblType, this.gbc(0, 3, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 0, 0, 15), 0, 0));
        pnlInfo.add((Component)this._pnlType, this.gbc(1, 3, 2, 1, 1.0, 0.0, 18, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.showTypes(false);
        return pnlInfo;
    }

    private void showTypes(boolean show) {
        this._lblType.setVisible(show);
        this._pnlType.setVisible(show);
    }

    public void onEntry(TraversableContext dataContext) {
        this._table = null;
        super.onEntry(dataContext);
        this._lib = (TablePanelLibrary)dataContext.find("PANEL_LIBRARY");
        this._table = (Table)dataContext.find("NewObject");
        Table.TableType type = (Table.TableType)this._table.getProperty("TableType", (Object)Table.TableType.NORMAL);
        this._pnlType.setTableType(type);
        if (dataContext.find("OriginalObject") != null) {
            this.setRootNavigables(this._lib.getEditNavigables(this._table, this.getProvider()));
            this._cbxAdvanced.setVisible(false);
            this._pnlType.enableAllComponents(false);
            this.showTypes(true);
        }
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        super.onExit(dataContext);
        if (!this._edit && dataContext.find("AutoPopulatedTrigger") != null) {
            if (dataContext.find("AutoPopulatedSequence") != null) {
                this.createObject(dataContext, "AutoPopulatedSequence");
            }
            this.createObject(dataContext, "AutoPopulatedTrigger");
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this._pnlType) {
            Table.TableType type = this._pnlType.getTableType();
            if (this._lastType != type) {
                this.updateTabs(type);
                this._lastType = type;
                if (this._table != null) {
                    this._table.setProperty("TableType", (Object)type);
                }
            }
        } else {
            super.actionPerformed(e);
        }
    }

    private boolean updateTabs(Table.TableType type) {
        boolean success = false;
        String key = "DEFAULT";
        if (type != null) {
            key = type.toString();
            Navigable[] navs = this._lib.getCreateNavigables(type, this.getProvider());
            this.addTabSet(navs, key);
        }
        try {
            this.showTabSet(key);
            this.showTypes(type != null);
            success = true;
        }
        catch (TraversalException ex) {
            ex.showMessageDialog((Component)((Object)this));
        }
        return success;
    }
}

