/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.trigger;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.ListModel;
import oracle.bali.ewt.shuttle.ItemPicker;
import oracle.bali.ewt.shuttle.ListPicker;
import oracle.bali.ewt.shuttle.Shuttle;
import oracle.dbtools.raptor.dialogs.trigger.BaseTriggerPanel;
import oracle.dbtools.raptor.dialogs.trigger.DMLSubPanel;
import oracle.dbtools.raptor.dialogs.trigger.TriggerPanel;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.FastStringBuffer;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Schema;
import oracle.javatools.db.Table;
import oracle.javatools.db.Trigger;
import oracle.jdeveloper.cm.dt.ui.DBObjectRenderer;
import oracle.jdeveloper.cm.dt.verifier.trigger.TriggerVerifier;
import oracle.jdevimpl.cm.dt.wizards.CmWizardsArb;

public class TableTriggerPanel
extends BaseTriggerPanel
implements ItemListener,
ActionListener {
    private GridBagLayout _layMain = new GridBagLayout();
    private JPanel _pnlSub = new JPanel();
    private GridLayout _laySub = new GridLayout();
    private JPanel _pnlSubLeft = new JPanel();
    private GridBagLayout _laySubLeft = new GridBagLayout();
    private JPanel _pnlSubRight = new JPanel();
    private GridBagLayout _laySubRight = new GridBagLayout();
    private JLabel _lblOwner = new JLabel();
    private JComboBox _cmbOwner = new JComboBox();
    private DBObjectRenderer _ownerRenderer = new DBObjectRenderer();
    private JLabel _lblTable = new JLabel();
    private JComboBox _cmbTable = new JComboBox();
    private JRadioButton _radBefore = new JRadioButton();
    private JRadioButton _radAfter = new JRadioButton();
    private ButtonGroup _grpTiming = new ButtonGroup();
    private JRadioButton _radStatement = new JRadioButton();
    private JRadioButton _radRow = new JRadioButton();
    private ButtonGroup _grpLevel = new ButtonGroup();
    private DMLSubPanel _pnlDMLOption = new DMLSubPanel();
    private JLabel _lblAvail = new JLabel();
    private JList _lstAvail = new JList();
    private ListPicker _pckAvail = new ListPicker(this._lstAvail);
    private JLabel _lblSel = new JLabel();
    private JList _lstSel = new JList();
    private ListPicker _pckSel = new ListPicker(this._lstSel);
    private Shuttle _shtCols = new Shuttle();
    private JLabel _lblWhen = new JLabel();
    private JTextField _fldWhen = new JTextField();
    private HashMap _tableMap = new HashMap();
    private HashMap _columnMap = new HashMap();
    private static final BaseTriggerPanel.ModelPair DEFAULT_EMPTY_MODEL = new BaseTriggerPanel.ModelPair(new String[0], true);

    public TableTriggerPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void commit() throws TraversalException {
        Schema tableOwner = (Schema)this._cmbOwner.getSelectedItem();
        String tableName = (String)this._cmbTable.getSelectedItem();
        int timing = this._radBefore.isSelected() ? 0 : 1;
        boolean stmtTrigger = this._radStatement.isSelected();
        ArrayList cols = new ArrayList();
        if (this._pnlDMLOption.isUpdateSelected() && this._lstAvail.getModel().getSize() > 0) {
            ListModel model = this._lstSel.getModel();
            int count = model.getSize();
            for (int i = 0; i < count; ++i) {
                cols.add(model.getElementAt(i));
            }
        }
        Trigger trigger = this.getTrigger();
        trigger.setTableOwner(tableOwner);
        trigger.setTableName(tableName);
        trigger.setTiming(timing);
        trigger.setStatementLevel(stmtTrigger);
        trigger.setColumns(cols);
        String whenClause = this._fldWhen.getText();
        if (this._fldWhen.isEnabled() && ModelUtil.hasLength((String)whenClause)) {
            trigger.setWhenClause(whenClause);
        } else {
            trigger.setWhenClause(null);
        }
        this._pnlDMLOption.commit();
    }

    public void init(DBObjectProvider prov, Trigger trigger, Schema[] schemas, boolean canChangeSchema, TriggerVerifier verifier) {
        super.init(prov, trigger, schemas, canChangeSchema, verifier);
        this._cmbOwner.setModel(this.getSchemas());
        this._cmbOwner.setSelectedItem(trigger.getSchema());
        this._cmbOwner.setEnabled(canChangeSchema);
        this._pnlDMLOption.init(prov, trigger, schemas, canChangeSchema, verifier);
        this._updateShuttle(this._pnlDMLOption.isUpdateSelected());
        this.updateOK();
    }

    private void jbInit() throws Exception {
        this.setLayout(this._layMain);
        this._pnlSub.setLayout(this._laySub);
        this._pnlSubLeft.setLayout(this._laySubLeft);
        this._pnlSubRight.setLayout(this._laySubRight);
        this._laySub.setColumns(2);
        this._laySub.setRows(1);
        this._laySub.setHgap(24);
        this._cmbOwner.setRenderer(this._ownerRenderer);
        ResourceUtils.resLabel((JLabel)this._lblOwner, (Component)this._cmbOwner, (String)CmWizardsArb.getString((int)210));
        this._cmbOwner.addActionListener(this);
        ResourceUtils.resLabel((JLabel)this._lblTable, (Component)this._cmbTable, (String)CmWizardsArb.getString((int)211));
        this._cmbTable.addActionListener(this);
        ResourceUtils.resButton((AbstractButton)this._radBefore, (String)CmWizardsArb.getString((int)208));
        this._grpTiming.add(this._radBefore);
        ResourceUtils.resButton((AbstractButton)this._radAfter, (String)CmWizardsArb.getString((int)209));
        this._grpTiming.add(this._radAfter);
        this._radBefore.setSelected(true);
        ResourceUtils.resButton((AbstractButton)this._radStatement, (String)CmWizardsArb.getString((int)212));
        this._grpLevel.add(this._radStatement);
        this._radStatement.addItemListener(this);
        ResourceUtils.resButton((AbstractButton)this._radRow, (String)CmWizardsArb.getString((int)213));
        this._grpLevel.add(this._radRow);
        this._radStatement.setSelected(true);
        this._pnlDMLOption.addUpdateItemListener(this);
        ResourceUtils.resLabel((JLabel)this._lblAvail, (Component)this._lstAvail, (String)CmWizardsArb.getString((int)214));
        this._shtCols.setFromPicker((ItemPicker)this._pckAvail);
        this._lstAvail.addFocusListener(this);
        ResourceUtils.resLabel((JLabel)this._lblSel, (Component)this._lstSel, (String)CmWizardsArb.getString((int)215));
        this._shtCols.setToPicker((ItemPicker)this._pckSel);
        this._lstSel.addFocusListener(this);
        this._lstSel.addPropertyChangeListener("model", this);
        ResourceUtils.resLabel((JLabel)this._lblWhen, (Component)this._fldWhen, (String)CmWizardsArb.getString((int)216));
        this._pnlSubLeft.add((Component)this._lblOwner, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this._pnlSubLeft.add((Component)this._cmbOwner, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
        this._pnlSubLeft.add((Component)this._radBefore, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this._pnlSubLeft.add((Component)this._radAfter, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this._pnlSubRight.add((Component)this._lblTable, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this._pnlSubRight.add((Component)this._cmbTable, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
        this._pnlSubRight.add((Component)this._radStatement, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this._pnlSubRight.add((Component)this._radRow, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this._pnlSub.add((Component)this._pnlSubLeft, null);
        this._pnlSub.add((Component)this._pnlSubRight, null);
        this._shtCols.add((Component)this._lblAvail, (Object)"FromHeader");
        this._shtCols.add((Component)this._lblSel, (Object)"ToHeader");
        this.add(this._pnlSub, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)((Object)this._pnlDMLOption), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)this._shtCols, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this._lblWhen, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this._fldWhen, new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
    }

    public void itemStateChanged(ItemEvent e) {
        Object src = e.getSource();
        if (src == this._radStatement) {
            boolean row = !this._radStatement.isSelected();
            this._pnlDMLOption.setReferencingEnabled(row);
            this._fldWhen.setEnabled(row);
        }
        this._updateShuttle(this._pnlDMLOption.isUpdateSelected());
    }

    private void _updateShuttle(boolean enabled) {
        this._shtCols.setEnabled(enabled);
        this._lstAvail.setEnabled(enabled);
        this._lstSel.setEnabled(enabled);
    }

    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this._cmbOwner) {
            this._updateSchema((Schema)this._cmbOwner.getSelectedItem());
        } else if (src == this._cmbTable) {
            this._updateTable((Schema)this._cmbOwner.getSelectedItem(), (String)this._cmbTable.getSelectedItem());
        }
    }

    private void _updateSchema(Schema schema) {
        DefaultComboBoxModel model = (DefaultComboBoxModel)this._tableMap.get(schema);
        if (model == null) {
            model = new NonNullableComboBoxModel();
            try {
                DBObjectProvider prov = this.getProvider();
                String[] tables = prov.listObjects("TABLE", schema);
                for (int i = 0; i < tables.length; ++i) {
                    model.addElement(tables[i]);
                }
            }
            catch (DBException dBException) {
                // empty catch block
            }
            this._tableMap.put(schema, model);
        }
        this._cmbTable.setModel(model);
        this._updateTable(schema, (String)this._cmbTable.getSelectedItem());
    }

    private void _updateTable(Schema schema, String tableName) {
        String key;
        BaseTriggerPanel.ModelPair model = DEFAULT_EMPTY_MODEL;
        if (tableName != null && (model = (BaseTriggerPanel.ModelPair)this._columnMap.get(key = this._getKey(schema, tableName))) == null) {
            Table table = null;
            try {
                DBObjectProvider prov = this.getProvider();
                table = (Table)prov.getObject("TABLE", schema, tableName);
            }
            catch (DBException ex) {
                // empty catch block
            }
            if (table != null) {
                Column[] cols = table.getColumns();
                String[] colNames = new String[cols.length];
                for (int i = 0; i < colNames.length; ++i) {
                    colNames[i] = cols[i].getName();
                }
                model = new BaseTriggerPanel.ModelPair(colNames, true);
            }
            this._columnMap.put(key, model);
        }
        this._lstAvail.setModel(model.getAvailableModel());
        this._lstSel.setModel(model.getSelectedModel());
    }

    private String _getKey(Schema schema, String tableName) {
        FastStringBuffer buf = new FastStringBuffer();
        if (schema != null) {
            buf.append(schema.getName()).append('.');
        }
        buf.append(tableName);
        return buf.toString();
    }

    void setParent(TriggerPanel parent) {
        super.setParent(parent);
        this._pnlDMLOption.setParent(parent);
    }

    protected boolean getCurrentOKState() {
        return this._pnlDMLOption.getCurrentOKState() && (!this._pnlDMLOption.isUpdateSelected() || this._lstSel.getModel().getSize() > 0);
    }
}

