/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.trigger;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.sql.SQLException;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.dialogs.trigger.BaseTriggerPanel;
import oracle.dbtools.raptor.dialogs.trigger.CreateTriggerVerifier;
import oracle.dbtools.raptor.dialogs.trigger.DBTriggerPanel;
import oracle.dbtools.raptor.dialogs.trigger.SchemaTriggerPanel;
import oracle.dbtools.raptor.dialogs.trigger.TableTriggerPanel;
import oracle.dbtools.raptor.dialogs.trigger.ViewTriggerPanel;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Trigger;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdeveloper.cm.dt.dialog.SQLErrorDialog;
import oracle.jdeveloper.cm.dt.ui.BaseInfoPanel;
import oracle.jdeveloper.cm.dt.ui.DBObjectRenderer;
import oracle.jdeveloper.cm.dt.verifier.Verifier;
import oracle.jdeveloper.cm.dt.verifier.trigger.TriggerVerifier;
import oracle.jdeveloper.cm.dt.wizard.DBWizardLauncher;
import oracle.jdevimpl.cm.dt.wizards.CmWizardsArb;

public class TriggerPanel
extends BaseInfoPanel
implements DocumentListener,
ActionListener,
VetoableChangeListener {
    private GridBagLayout _layMain = new GridBagLayout();
    private JLabel _lblSchema = new JLabel();
    private JComboBox _cmbSchema = new JComboBox();
    private DBObjectRenderer _schemaRenderer = new DBObjectRenderer();
    private JLabel _lblName = new JLabel();
    private JTextField _fldName = new JTextField();
    private JLabel _lblType = new JLabel();
    private NonNullableComboBoxModel _mdlType = new NonNullableComboBoxModel((Object[])Trigger.TRIGGER_TYPES);
    private JComboBox _cmbType = new JComboBox();
    private JPanel _pnlType = new JPanel();
    private CardLayout _layType = new CardLayout();
    private BaseTriggerPanel _pnlTable = new TableTriggerPanel();
    private BaseTriggerPanel _pnlView = new ViewTriggerPanel();
    private BaseTriggerPanel _pnlSchema = new SchemaTriggerPanel();
    private BaseTriggerPanel _pnlDB = new DBTriggerPanel();
    private BaseTriggerPanel[] _typePanels = new BaseTriggerPanel[]{this._pnlTable, this._pnlView, this._pnlSchema, this._pnlDB};
    private Trigger _trigger;
    private Schema[] _schemas;
    private BaseTriggerPanel _currentTypePanel;
    private JEWTDialog _dlg;

    public TriggerPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addNotify() {
        super.addNotify();
        for (Container parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof JEWTDialog)) continue;
            this._dlg = (JEWTDialog)parent;
            this.updateOK();
            break;
        }
    }

    public void init(DBObjectProvider prov, Trigger trigger, TriggerVerifier verifier) {
        super.init(prov, (Verifier)verifier);
        this._trigger = trigger;
        try {
            this._schemas = prov.listSchemas();
            this._cmbSchema.setModel(new NonNullableComboBoxModel((Object[])this._schemas));
        }
        catch (DBException ex) {
            // empty catch block
        }
        Schema schema = trigger.getSchema();
        this._cmbSchema.setSelectedItem(schema);
        Schema otherSchema = null;
        if (this._schemas != null) {
            for (int i = 0; i < this._schemas.length; ++i) {
                if (!ModelUtil.areDifferent((Object)this._schemas[i], (Object)schema)) continue;
                otherSchema = this._schemas[i];
                break;
            }
        }
        boolean enabled = otherSchema != null ? prov.hasPriviledge("TRIGGER", otherSchema, "CREATE") : true;
        this._cmbSchema.setEnabled(enabled);
        String name = this.getExternalName(trigger.getName());
        this._fldName.setText(name);
        this._cmbType.setSelectedIndex(trigger.getBaseType());
        this._updateSubPanel();
    }

    public void commit() throws TraversalException {
        this._trigger.setSchema((Schema)this._cmbSchema.getSelectedItem());
        String name = this.getInternalName(this._fldName.getText());
        this._trigger.setName(name);
        this._trigger.setBaseType(this._cmbType.getSelectedIndex());
        this._currentTypePanel.commit();
        TriggerVerifier verifier = (TriggerVerifier)this.getVerifier();
        if (verifier != null) {
            verifier.verifyTrigger(false);
        }
        try {
            DBObjectProvider prov = this.getProvider();
            if (prov != null) {
                prov.createObject((SchemaObject)this._trigger, false);
            }
        }
        catch (DBException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof SQLException) {
                SQLErrorDialog.showErrorDialog((Component)((Object)this), (String)CmWizardsArb.getString((int)231), (SQLException)((SQLException)cause));
            } else {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)(cause != null ? cause : ex), (String)CmWizardsArb.getString((int)231), (String)CmWizardsArb.getString((int)230), null);
            }
            throw new TraversalException(null);
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this._layMain);
        this._pnlType.setLayout(this._layType);
        this._cmbSchema.setRenderer(this._schemaRenderer);
        ResourceUtils.resLabel((JLabel)this._lblSchema, (Component)this._cmbSchema, (String)CmWizardsArb.getString((int)206));
        ResourceUtils.resLabel((JLabel)this._lblName, (Component)this._fldName, (String)CmWizardsArb.getString((int)18));
        this._fldName.getDocument().addDocumentListener(this);
        ResourceUtils.resLabel((JLabel)this._lblType, (Component)this._cmbType, (String)CmWizardsArb.getString((int)207));
        this._cmbType.setModel(this._mdlType);
        this._cmbType.addActionListener(this);
        this._pnlType.add((Component)((Object)this._pnlTable), Trigger.TRIGGER_TYPES[0]);
        this._pnlType.add((Component)((Object)this._pnlView), Trigger.TRIGGER_TYPES[1]);
        this._pnlType.add((Component)((Object)this._pnlSchema), Trigger.TRIGGER_TYPES[2]);
        this._pnlType.add((Component)((Object)this._pnlDB), Trigger.TRIGGER_TYPES[3]);
        this.add(this._lblSchema, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 12), 0, 0));
        this.add(this._cmbSchema, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this._lblName, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 12), 0, 0));
        this.add(this._fldName, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this._lblType, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 12), 0, 0));
        this.add(this._cmbType, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this._pnlType, new GridBagConstraints(0, 3, 2, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
    }

    public void insertUpdate(DocumentEvent e) {
        this.updateOK();
    }

    public void removeUpdate(DocumentEvent e) {
        this.updateOK();
    }

    public void changedUpdate(DocumentEvent e) {
        this.updateOK();
    }

    public void actionPerformed(ActionEvent e) {
        this._updateSubPanel();
    }

    void updateOK() {
        if (this._dlg != null) {
            boolean enabled = ModelUtil.hasLength((String)this._fldName.getText()) && (this._currentTypePanel == null || this._currentTypePanel.getCurrentOKState());
            this._dlg.setOKButtonEnabled(enabled);
        }
    }

    private String getSchema() {
        return (String)this._cmbSchema.getSelectedItem();
    }

    private String getTriggerName() {
        return this._fldName.getText();
    }

    private void _updateSubPanel() {
        BaseTriggerPanel panel;
        int idx = this._cmbType.getSelectedIndex();
        BaseTriggerPanel baseTriggerPanel = panel = idx != -1 ? this._typePanels[idx] : null;
        if (panel != this._currentTypePanel) {
            if (this._currentTypePanel != null) {
                this._currentTypePanel.setParent(null);
            }
            if (panel != null) {
                panel.setParent(this);
                panel.init(this.getProvider(), this._trigger, this._schemas, this._cmbSchema.isEnabled(), (TriggerVerifier)this.getVerifier());
                this._layType.show(this._pnlType, Trigger.TRIGGER_TYPES[idx]);
            }
            this._currentTypePanel = panel;
            this.updateOK();
        }
    }

    public void vetoableChange(PropertyChangeEvent pce) throws PropertyVetoException {
        if ("closed".equals(pce.getPropertyName()) && Boolean.TRUE.equals(pce.getNewValue())) {
            try {
                this.commit();
            }
            catch (TraversalException ex) {
                ex.showMessageDialog((Component)((Object)this));
                throw new PropertyVetoException("bogus", pce);
            }
        }
    }

    public static boolean createTrigger(Context ctx, Database db) {
        boolean result = false;
        Trigger trigger = null;
        try {
            Schema schema = DBWizardLauncher.determineSchema((Context)ctx, (Database)db);
            String name = db.getUniqueName("TRIGGER", (DBObject)schema, null);
            trigger = new Trigger(schema, name);
        }
        catch (DBException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof SQLException) {
                SQLErrorDialog.showErrorDialog(null, (String)"Error Getting Schema List", (SQLException)((SQLException)cause));
            } else {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)(cause != null ? cause : ex), (String)"Error Getting Schema List", (String)"An error was encountered trying to get the list of schemas.", null);
            }
            return false;
        }
        if (trigger != null) {
            TriggerPanel panel = new TriggerPanel();
            panel.init((DBObjectProvider)db, trigger, new CreateTriggerVerifier((DBObjectProvider)db, trigger));
            HelpSystem.getHelpSystem().registerTopic((JComponent)((Object)panel), "f1_bdbdcreatetrigger_html");
            result = OnePageWizardDialogFactory.runDialog((Component)((Object)panel), (Component)panel._fldName, (String)CmWizardsArb.getString((int)205), (int)7, (VetoableChangeListener)panel);
        }
        return result;
    }
}

