/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.view;

import oracle.dbtools.raptor.dialogs.CreateDialogArb;
import oracle.dbtools.raptor.dialogs.TabbedDialogLauncher;
import oracle.dbtools.raptor.dialogs.view.CreateViewVerifier;
import oracle.dbtools.raptor.dialogs.view.EditViewVerifier;
import oracle.dbtools.raptor.dialogs.view.ViewInfoTab;
import oracle.ide.Context;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.View;
import oracle.javatools.db.ora.OracleDDLGenerator;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.javatools.db.ora.OracleSQLQuery;
import oracle.javatools.db.sql.SQLQuery;
import oracle.jdeveloper.cm.ds.db.DBUtil;
import oracle.jdeveloper.cm.dt.ui.sql.QueryPanel;
import oracle.jdeveloper.cm.dt.wizard.DBWizardLauncher;
import oracle.jdevimpl.cm.dt.wizards.CmWizardsArb;

public class TabbedOracleViewLauncher
extends TabbedDialogLauncher {
    public TabbedOracleViewLauncher(OracleDatabase db, Schema schema) {
        super((Database)db, schema);
        this.put("Tablespaces", db.listTablespaces());
        this.addTab(QueryPanel.class, "f1_dbviewwizardentiresqlquery_html", CmWizardsArb.getString((int)294));
        this.addTab(ViewInfoTab.class, "f1_dbviewwizardviewinfo_html", CmWizardsArb.getString((int)285));
    }

    public boolean createObject() {
        Schema schema = this.getSchema();
        DBObjectProvider db = this.getProvider();
        View view = new View(db.getUniqueName("VIEW", (DBObject)schema, null), schema);
        view.setSQLQuery((SQLQuery)new OracleSQLQuery());
        view.setID(TemporaryObjectID.createID((DBObject)view));
        this.put("NewObject", view);
        this.put("OriginalObject", null);
        this.put("DDlGenerator", new OracleDDLGenerator(db));
        this.registerVerifier("SchemaObjectInfoVerifier", CreateViewVerifier.class);
        this.addTab(TabbedDialogLauncher.CreateSQLTab.class, "f1_dbviewwizardfinish_html", CreateDialogArb.getString(514));
        this.setTitle(CmWizardsArb.getString((int)185));
        this.setErrorTitle(CmWizardsArb.getString((int)187));
        return this.createObjectImpl();
    }

    public boolean editObject(SchemaObject object) {
        SchemaObject copy = (SchemaObject)DBUtil.makeTemporaryCopy((DBObject)object);
        DBObjectProvider db = this.getProvider();
        this.put("NewObject", object);
        this.put("OriginalObject", copy);
        this.put("DDlGenerator", new OracleDDLGenerator(db));
        this.registerVerifier("SchemaObjectInfoVerifier", EditViewVerifier.class);
        this.addTab(TabbedDialogLauncher.EditSQLTab.class, "f1_dbviewwizardfinish_html", CreateDialogArb.getString(514));
        this.setTitle(CmWizardsArb.getString((int)186));
        this.setErrorTitle(CmWizardsArb.getString((int)187));
        return this.createObjectImpl();
    }

    public static boolean createView(Context ctx, OracleDatabase db) {
        try {
            Schema schema = DBWizardLauncher.determineSchema((Context)ctx, (Database)db);
            TabbedOracleViewLauncher launcher = new TabbedOracleViewLauncher(db, schema);
            return launcher.createObject();
        }
        catch (DBException dBException) {
            return false;
        }
    }

    public static boolean editView(OracleDatabase db, View view) {
        TabbedOracleViewLauncher launcher = new TabbedOracleViewLauncher(db, view.getSchema());
        return launcher.editObject((SchemaObject)view);
    }
}

