/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.explorer.dt.dialog;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.raptor.explorer.dt.dialog.CommonDialog;
import oracle.dbtools.raptor.explorer.dt.dialog.ConnectionDialogArb;
import oracle.dbtools.raptor.utils.TCPTNSEntry;
import oracle.dbtools.raptor.utils.TNSHelper;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.cm.CMException;
import oracle.jdeveloper.cm.ConnectionDescriptor;
import oracle.jdeveloper.cm.ConnectionManager;
import oracle.jdeveloper.cm.ConnectionWrapper;

public class ConnectionDialog
extends JPanel {
    public static String OCI_URL = "jdbc:oracle:oci8:@";
    private JScrollPane jScrollPane1 = new JScrollPane();
    private JPanel jPanel1 = new JPanel();
    private JPanel jPanel2 = new JPanel();
    private JTabbedPane jTabbedPane1 = new JTabbedPane();
    private JLabel lblName = new JLabel();
    private JTextField tfdConnName = new JTextField(15);
    private JLabel lblUser = new JLabel();
    private JTextField tfdUser = new JTextField(15);
    private JLabel lblPassword = new JLabel();
    private JPasswordField tfdPassword = new JPasswordField(15);
    private JCheckBox chkSavePassword = new JCheckBox();
    private JLabel lblRole = new JLabel();
    private String[] roles = new String[]{"default", "SYSDBA"};
    private JComboBox cbxRole = new JComboBox<String>(this.roles);
    private JSplitPane jSplitPane1 = new JSplitPane();
    private CommonDialog _dlg = null;
    private JButton btnClear = new JButton();
    private JButton btnTest = new JButton();
    private JLabel lblStatus = new JLabel(ConnectionDialogArb.getString(26));
    private static ConnectionDialog dlg = null;
    private ConnectionModel model = new ConnectionModel();
    private JTable jTable1 = new JTable(this.model){

        public void valueChanged(ListSelectionEvent e) {
            int[] rows = this.getSelectedRows();
            if (rows.length > 0) {
                ConnectionDescriptor cd = (ConnectionDescriptor)ConnectionDialog.this.model.getData().get(rows[0]);
                ConnectionDialog.this.tfdConnName.setText(cd.getConnectionName());
                ConnectionDialog.this.tfdUser.setText(cd.getUsername());
                ConnectionDialog.this.tfdPassword.setText(cd.getPassword());
                ConnectionDialog.this.chkSavePassword.setSelected(Boolean.parseBoolean(cd.getProperty("SavePassword", Boolean.TRUE.toString())));
                String role = cd.getRole();
                if (role != null) {
                    ConnectionDialog.this.cbxRole.setSelectedItem(role);
                } else {
                    ConnectionDialog.this.cbxRole.setSelectedItem("default");
                }
                String hostname = cd.getHostname();
                if (hostname != null) {
                    ConnectionDialog.this.jTabbedPane1.setSelectedComponent(ConnectionDialog.this.basicPanel);
                    ConnectionDialog.this.basicPanel.tfdHost.setText(hostname);
                    String port = cd.getJdbcPort();
                    ConnectionDialog.this.basicPanel.tfdPort.setText(port != null ? port : "1521");
                    ConnectionDialog.this.basicPanel.tfdSid.setText(cd.getSid());
                    ConnectionDialog.this.basicPanel.tfdService.setText(cd.getProperty("ServiceName"));
                    if (ConnectionDialog.this.basicPanel.tfdSid.getText().length() > 0) {
                        ConnectionDialog.this.basicPanel.btnSid.setSelected(true);
                        ConnectionDialog.this.toggleSidOrService(ConnectionDialog.this.basicPanel.btnSid);
                    } else {
                        ConnectionDialog.this.basicPanel.btnService.setSelected(true);
                        ConnectionDialog.this.toggleSidOrService(ConnectionDialog.this.basicPanel.btnService);
                    }
                } else {
                    ConnectionDialog.this.jTabbedPane1.setSelectedComponent(ConnectionDialog.this.tNSPanel);
                    String url = cd.getURL();
                    String sid = url.substring(url.lastIndexOf(64) + 1);
                    ConnectionDialog.this.tNSPanel.cbxTnsName.setSelectedItem(sid);
                    if (ConnectionDialog.this.tNSPanel.cbxTnsName.getSelectedItem() != null && ConnectionDialog.this.tNSPanel.cbxTnsName.getSelectedItem().equals(sid)) {
                        ConnectionDialog.this.tNSPanel.btnTns.setSelected(true);
                        ConnectionDialog.this.toggleTNSOrSqlNet(ConnectionDialog.this.tNSPanel.btnTns);
                    } else {
                        ConnectionDialog.this.tNSPanel.tfdSqlNetName.setText(sid);
                        ConnectionDialog.this.tNSPanel.btnSqlNet.setSelected(true);
                        ConnectionDialog.this.toggleTNSOrSqlNet(ConnectionDialog.this.tNSPanel.btnSqlNet);
                    }
                }
            }
            this.clearSelection();
        }
    };
    private BasicPanel basicPanel = new BasicPanel();
    private TNSPanel tNSPanel = new TNSPanel();
    private AdvancedPanel advancedPanel = new AdvancedPanel();
    private ConnectionDescriptor connectionDescriptor = null;

    public ConnectionDescriptor getConnectionDescriptor() {
        return this.connectionDescriptor;
    }

    public void setConnectionDescriptor(ConnectionDescriptor connectionDescriptor) {
        this.connectionDescriptor = connectionDescriptor;
    }

    public ConnectionDialog() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        ResourceUtils.resButton((AbstractButton)this.btnClear, (String)ConnectionDialogArb.getString(21));
        ResourceUtils.resButton((AbstractButton)this.btnTest, (String)ConnectionDialogArb.getString(22));
        ResourceUtils.resLabel((JLabel)this.lblName, (Component)this.tfdConnName, (String)ConnectionDialogArb.getString(6));
        ResourceUtils.resLabel((JLabel)this.lblUser, (Component)this.tfdUser, (String)ConnectionDialogArb.getString(9));
        ResourceUtils.resLabel((JLabel)this.lblPassword, (Component)this.tfdPassword, (String)ConnectionDialogArb.getString(10));
        ResourceUtils.resButton((AbstractButton)this.chkSavePassword, (String)ConnectionDialogArb.getString(11));
        ResourceUtils.resLabel((JLabel)this.lblRole, (Component)this.cbxRole, (String)ConnectionDialogArb.getString(12));
        this.setLayout(new BorderLayout());
        this.jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.jPanel2.setOpaque(false);
        this.jSplitPane1.setOpaque(false);
        this.jTable1.setOpaque(false);
        this.jPanel2.setLayout(new GridBagLayout());
        this.jPanel2.add((Component)this.lblName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.tfdConnName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.lblUser, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.tfdUser, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 5, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.lblPassword, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.tfdPassword, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 5, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.chkSavePassword, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.lblRole, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.cbxRole, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 5, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.jPanel2, null);
        this.jTabbedPane1.addTab(ConnectionDialogArb.getString(16), this.basicPanel);
        this.jTabbedPane1.addTab(ConnectionDialogArb.getString(17), this.tNSPanel);
        this.jTabbedPane1.addTab(ConnectionDialogArb.getString(20), this.advancedPanel);
        this.jPanel1.add((Component)this.jTabbedPane1, null);
        this.jTabbedPane1.setPreferredSize(this.basicPanel.getPreferredSize());
        this.jScrollPane1.getViewport().add((Component)this.jTable1, null);
        this.jSplitPane1.add((Component)this.jPanel1, "left");
        this.jSplitPane1.add((Component)this.jScrollPane1, "right");
        this.add((Component)this.jSplitPane1, "Center");
        this.add((Component)this.lblStatus, "South");
        SpringLayout layout = new SpringLayout();
        this.jPanel1.setLayout(layout);
        this.jPanel1.setOpaque(false);
        layout.putConstraint("North", (Component)this.jPanel2, 0, "North", (Component)this.jPanel2.getParent());
        layout.putConstraint("East", (Component)this.jPanel2.getParent(), 0, "East", (Component)this.jPanel2);
        layout.putConstraint("West", (Component)this.jTabbedPane1, 0, "West", (Component)this.jTabbedPane1.getParent());
        layout.putConstraint("North", (Component)this.jTabbedPane1, 0, "South", (Component)this.jPanel2);
        layout.putConstraint("South", (Component)this.jTabbedPane1.getParent(), 0, "South", (Component)this.jTabbedPane1);
        layout.putConstraint("East", (Component)this.jPanel2, 0, "East", (Component)this.jTabbedPane1);
        layout.putConstraint("West", (Component)this.jPanel2, 0, "West", (Component)this.jTabbedPane1);
        this.jPanel2.setMinimumSize(new Dimension(280, 120));
        this.jPanel2.setMaximumSize(new Dimension(430, 130));
        this.jTabbedPane1.setMinimumSize(new Dimension(280, 300));
        this.jTabbedPane1.setMaximumSize(new Dimension(430, 285));
        this.jScrollPane1.setMinimumSize(new Dimension(450, 420));
        this.jScrollPane1.setOpaque(false);
        PropertyChangeListener pcl = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent pce) {
                Component src = (Component)pce.getSource();
                ConnectionDialog.this.jTabbedPane1.setSelectedComponent(src.getParent().getParent());
            }
        };
        this.btnClear.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ConnectionDialog.this.clearFields();
            }
        });
        this.btnTest.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                try {
                    ConnectionDialog.this.testConnection();
                }
                catch (CMException cme) {
                    ConnectionDialog.this.lblStatus.setText(ConnectionDialogArb.getString(28) + cme.getMessage());
                    ConnectionDialog.this.lblStatus.setForeground(Color.RED);
                    ConnectionDialog.this.lblStatus.getAccessibleContext().setAccessibleName(ConnectionDialog.this.lblStatus.getText());
                }
            }
        });
        ActionListener syncBtns1 = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AbstractButton btn = (AbstractButton)e.getSource();
                ConnectionDialog.this.toggleSidOrService(btn);
            }
        };
        this.basicPanel.btnSid.addActionListener(syncBtns1);
        this.basicPanel.btnService.addActionListener(syncBtns1);
        this.basicPanel.btnSid.setSelected(true);
        this.basicPanel.tfdSid.setEnabled(true);
        this.basicPanel.btnService.setSelected(false);
        this.basicPanel.tfdService.setEnabled(false);
        ActionListener syncBtns2 = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AbstractButton btn = (AbstractButton)e.getSource();
                ConnectionDialog.this.toggleTNSOrSqlNet(btn);
            }
        };
        this.tNSPanel.btnTns.addActionListener(syncBtns2);
        this.tNSPanel.btnSqlNet.addActionListener(syncBtns2);
        this.tNSPanel.btnTns.setSelected(true);
        this.tNSPanel.cbxTnsName.setEnabled(true);
        this.tNSPanel.btnSqlNet.setSelected(false);
        this.tNSPanel.tfdSqlNetName.setEnabled(false);
        this.jTable1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1) {
                    ConnectionDialog.this._dlg.ok();
                }
            }
        });
        this.jTable1.getColumnModel().getColumn(1).setPreferredWidth(50);
    }

    public void setHistoryData(List data) {
        this.model.setData(data);
        this.jTable1.updateUI();
    }

    public void setTNSConnectionData(List data) {
        this.tNSPanel.model.setData(data);
    }

    private ConnectionDescriptor runDialog(String name) {
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_idewcxnwelcome_html");
        this.jTabbedPane1.setSelectedComponent(this.basicPanel);
        this._dlg = new CommonDialog("");
        this._dlg.addCustomButton(this.btnClear);
        this._dlg.addCustomButton(this.btnTest);
        this._dlg.setInitialFocus(this.jTable1);
        this._dlg.setContent(this);
        this._dlg.setPreferredSize(800, 420);
        this._dlg.setResizable(true);
        this._dlg.setOKButtonText(ConnectionDialogArb.getString(23));
        this._dlg.addVetoableChangeListener(new VetoableChangeListener(){

            public void vetoableChange(PropertyChangeEvent event) throws PropertyVetoException {
                ConnectionDialog.this._dlg;
                if (CommonDialog.isDialogClosingEvent((PropertyChangeEvent)event)) {
                    if (ConnectionDialog.this.tfdConnName.getText().length() <= 0) {
                        ConnectionDialog.this.lblStatus.setText(ConnectionDialogArb.getString(29));
                        ConnectionDialog.this.lblStatus.setForeground(Color.RED);
                        ConnectionDialog.this.tfdConnName.requestFocusInWindow();
                        throw new PropertyVetoException(ConnectionDialogArb.getString(29), event);
                    }
                    try {
                        ConnectionDialog.this.testConnection();
                    }
                    catch (CMException cme) {
                        ConnectionDialog.this.lblStatus.setText(ConnectionDialogArb.getString(28) + cme.getMessage());
                        ConnectionDialog.this.lblStatus.setForeground(Color.RED);
                        throw new PropertyVetoException(cme.getMessage(), event);
                    }
                }
            }
        });
        if (name != null && name.length() > 0) {
            this._dlg.setTitle(name);
        } else {
            this._dlg.setTitle(ConnectionDialogArb.getString(24));
            this.clearFields();
        }
        ConnectionDescriptor cd = null;
        if (WizardLauncher.runDialog((JDialog)((Object)this._dlg))) {
            cd = this.getInput();
        }
        this.lblStatus.setText(ConnectionDialogArb.getString(26));
        this.lblStatus.setForeground(Color.BLACK);
        return cd;
    }

    public void select(String connName) {
        if (connName != null && connName.trim().length() > 0) {
            for (int i = 0; i < this.model.getRowCount(); ++i) {
                ConnectionDescriptor cd = (ConnectionDescriptor)this.model.getRowData(i);
                if (!cd.getConnectionName().equals(connName)) continue;
                this.jTable1.getSelectionModel().setSelectionInterval(i, i);
                break;
            }
        }
    }

    private void testConnection() throws CMException {
        ConnectionDescriptor cd = this.getInput();
        this.lblStatus.setText(ConnectionDialogArb.getString(26));
        this.lblStatus.setForeground(Color.BLACK);
        this.testConnection(cd);
        this.lblStatus.setText(ConnectionDialogArb.getString(27));
        this.lblStatus.setForeground(Color.BLACK);
    }

    protected void testConnection(ConnectionDescriptor desc) throws CMException {
        ConnectionWrapper wrapper = null;
        try {
            ConnectionManager cm = ConnectionManager.getInstance();
            wrapper = cm.getConnection(desc);
            Iterator iter = wrapper.getPresentationIterator();
            while (iter.hasNext()) {
                wrapper.testPresentation((String)iter.next());
            }
            wrapper.closeConnection();
            wrapper = null;
        }
        catch (CMException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            throw new CMException((Exception)ex);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Error t) {
            throw new CMException(t.getLocalizedMessage());
        }
        finally {
            if (wrapper != null) {
                try {
                    wrapper.closeConnection();
                }
                catch (Exception ex) {}
            }
        }
    }

    private ConnectionDescriptor getInput() {
        ConnectionDescriptor cd = new ConnectionDescriptor();
        cd.put((Object)"ConnectionType", (Object)"JDBC");
        cd.put((Object)"DeployPassword", (Object)"false");
        cd.put((Object)"JdbcDriver", (Object)"oracle.jdbc.driver.OracleDriver");
        cd.put((Object)"ORACLE_JDBC_TYPE", (Object)"thin");
        cd.put((Object)"user", (Object)this.tfdUser.getText());
        cd.put((Object)"password", (Object)new String(this.tfdPassword.getPassword()));
        cd.put((Object)"SavePassword", (Object)Boolean.toString(this.chkSavePassword.isSelected()));
        String role = (String)this.cbxRole.getSelectedItem();
        if (role.equals(this.roles[0])) {
            cd.put((Object)"Role", (Object)"");
        } else {
            cd.put((Object)"Role", (Object)role);
        }
        if (this.tfdConnName.getText().length() > 0) {
            cd.put((Object)"ConnectionName", (Object)this.tfdConnName.getText());
        } else {
            cd.put((Object)"ConnectionName", (Object)cd.getConnectionName());
        }
        CDComponentView cdv = (CDComponentView)((Object)this.jTabbedPane1.getSelectedComponent());
        cdv.populateComponent(cd);
        return cd;
    }

    private void clearFields() {
        this.basicPanel.tfdHost.setText("");
        this.basicPanel.tfdPort.setText("1521");
        this.tfdPassword.setText("");
        this.chkSavePassword.setSelected(false);
        this.basicPanel.tfdSid.setText("");
        this.basicPanel.tfdService.setText("");
        this.tfdUser.setText("");
        this.cbxRole.setSelectedItem("default");
        if (this.tNSPanel.cbxTnsName.getItemCount() > 0) {
            this.tNSPanel.cbxTnsName.setSelectedIndex(0);
        }
        this.tNSPanel.tfdSqlNetName.setText("");
        Thread t = new Thread(){

            public void run() {
                ConnectionDialog.this.preFillConnName();
            }
        };
        t.start();
    }

    public static void main(String[] args) {
        ConnectionDialog cd = new ConnectionDialog();
        ComponentAdapter ca = new ComponentAdapter(){

            public void componentResized(ComponentEvent ce) {
                Component src = (Component)ce.getSource();
                System.out.println(src + ".size=" + src.getSize());
            }
        };
        cd.jPanel2.addComponentListener(ca);
        cd.jTabbedPane1.addComponentListener(ca);
        cd.jScrollPane1.addComponentListener(ca);
        cd.addComponentListener(ca);
        JFrame frm = new JFrame("Test");
        frm.setDefaultCloseOperation(3);
        frm.getContentPane().setLayout(new GridLayout(1, 1));
        frm.getContentPane().add(cd);
        frm.setSize(730, 375);
        frm.setVisible(true);
    }

    private void toggleSidOrService(AbstractButton btn) {
        if (btn.equals(this.basicPanel.btnSid)) {
            if (btn.isSelected()) {
                this.basicPanel.tfdSid.setEnabled(true);
                this.basicPanel.tfdService.setEnabled(false);
            } else {
                this.basicPanel.tfdSid.setEnabled(false);
                this.basicPanel.tfdService.setEnabled(true);
            }
        } else if (btn.equals(this.basicPanel.btnService)) {
            if (btn.isSelected()) {
                this.basicPanel.tfdSid.setEnabled(false);
                this.basicPanel.tfdService.setEnabled(true);
            } else {
                this.basicPanel.tfdSid.setEnabled(true);
                this.basicPanel.tfdService.setEnabled(false);
            }
        }
    }

    private void toggleTNSOrSqlNet(AbstractButton btn) {
        if (btn.equals(this.tNSPanel.btnTns)) {
            if (btn.isSelected()) {
                this.tNSPanel.cbxTnsName.setEnabled(true);
                this.tNSPanel.tfdSqlNetName.setEnabled(false);
            } else {
                this.tNSPanel.cbxTnsName.setEnabled(false);
                this.tNSPanel.tfdSqlNetName.setEnabled(true);
            }
        } else if (btn.equals(this.tNSPanel.btnSqlNet)) {
            if (btn.isSelected()) {
                this.tNSPanel.cbxTnsName.setEnabled(false);
                this.tNSPanel.tfdSqlNetName.setEnabled(true);
            } else {
                this.tNSPanel.cbxTnsName.setEnabled(true);
                this.tNSPanel.tfdSqlNetName.setEnabled(false);
            }
        }
    }

    private void preFillConnName() {
        TreeSet<Object> sNames = new TreeSet<Object>();
        String prefix = ConnectionDialogArb.getString(25);
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            sNames.add(this.model.getValueAt(i, 0));
        }
        List<Object> lNames = Arrays.asList(sNames.toArray());
        int i = 1;
        int j = 0;
        while (j >= 0) {
            j = lNames.indexOf(prefix + i++);
        }
        this.tfdConnName.setText(prefix + (i - 1));
        this.tfdConnName.updateUI();
    }

    public static ConnectionDescriptor selectConnection(String initial) {
        List connections;
        if (dlg == null) {
            dlg = new ConnectionDialog();
        }
        if ((connections = ConnectionDialog.getAllConnections()) == null) {
            connections = new ArrayList();
        }
        dlg.setHistoryData(connections);
        dlg.select(initial);
        connections = ConnectionDialog.getTNSConnections();
        if (connections == null) {
            connections = new ArrayList();
        }
        dlg.setTNSConnectionData(connections);
        return dlg.runDialog(initial);
    }

    public static void registerConnection(ConnectionDescriptor desc) throws IOException {
        if (desc != null) {
            ConnectionManager.getInstance().putConnectionDescriptor(desc.getConnectionName(), desc);
        }
    }

    private static List getAllConnections() {
        ConnectionManager cm = ConnectionManager.getInstance();
        try {
            String[] connNames = cm.getConnectionNames();
            TreeSet<ConnectionDescriptor> l = new TreeSet<ConnectionDescriptor>(new CDComparator());
            for (int i = 0; i < connNames.length; ++i) {
                l.add(cm.getConnectionDescriptor(connNames[i]));
            }
            return Arrays.asList(l.toArray());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static List getTNSConnections() {
        TreeSet<ConnectionDescriptor> l = new TreeSet<ConnectionDescriptor>(new CDComparator());
        ArrayList<TCPTNSEntry> entries = TNSHelper.getTNSEntries();
        for (int i = 0; i < entries.size(); ++i) {
            ConnectionDescriptor cd = new ConnectionDescriptor();
            cd.put((Object)"ConnectionType", (Object)"JDBC");
            cd.put((Object)"DeployPassword", (Object)"false");
            cd.put((Object)"Role", (Object)"");
            cd.put((Object)"JdbcDriver", (Object)"oracle.jdbc.driver.OracleDriver");
            cd.put((Object)"ORACLE_JDBC_TYPE", (Object)"thin");
            cd.put((Object)"user", (Object)"");
            cd.put((Object)"password", (Object)"");
            cd.put((Object)"ConnectionName", (Object)entries.get(i).getName());
            cd.put((Object)"URL", (Object)entries.get(i).getJDBCUrl());
            l.add(cd);
        }
        return Arrays.asList(l.toArray());
    }

    private static class CDComparator
    implements Comparator {
        private CDComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 instanceof ConnectionDescriptor && o2 instanceof ConnectionDescriptor) {
                ConnectionDescriptor cd1 = (ConnectionDescriptor)o1;
                ConnectionDescriptor cd2 = (ConnectionDescriptor)o2;
                return cd1.getConnectionName().compareTo(cd2.getConnectionName());
            }
            throw new IllegalArgumentException(o1 + " and " + o2 + " are not comparable.");
        }

        public boolean equals(Object obj) {
            return this.equals(obj);
        }
    }

    private class BasicPanel
    extends JPanel
    implements CDComponentView {
        private GridLayout gridLayout1 = new GridLayout();
        private JLabel jLabel1 = new JLabel();
        private JTextField tfdHost = new JTextField(15);
        private JLabel jLabel2 = new JLabel();
        private JTextField tfdPort = new JTextField(15);
        private JTextField tfdSid = new JTextField(15);
        private JTextField tfdService = new JTextField(15);
        private JRadioButton btnSid = new JRadioButton();
        private JRadioButton btnService = new JRadioButton();
        private ButtonGroup group = new ButtonGroup();

        public BasicPanel() {
            try {
                this.jbInit();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void populateComponent(ConnectionDescriptor cd) {
            cd.put((Object)"HOSTNAME", (Object)this.tfdHost.getText());
            cd.put((Object)"JDBC_PORT", (Object)this.tfdPort.getText());
            if (this.btnSid.isSelected()) {
                cd.put((Object)"SID", (Object)this.tfdSid.getText());
            } else if (this.btnService.isSelected()) {
                cd.put((Object)"ServiceName", (Object)this.tfdService.getText());
            }
        }

        private void jbInit() throws Exception {
            this.setSize(new Dimension(385, 266));
            this.gridLayout1.setColumns(2);
            this.gridLayout1.setRows(4);
            this.gridLayout1.setVgap(30);
            this.gridLayout1.setHgap(-200);
            ResourceUtils.resLabel((JLabel)this.jLabel1, (Component)this.tfdHost, (String)ConnectionDialogArb.getString(7));
            ResourceUtils.resLabel((JLabel)this.jLabel2, (Component)this.tfdPort, (String)ConnectionDialogArb.getString(8));
            ResourceUtils.resButton((AbstractButton)this.btnSid, (String)ConnectionDialogArb.getString(13));
            ResourceUtils.resButton((AbstractButton)this.btnService, (String)ConnectionDialogArb.getString(14));
            this.group.add(this.btnSid);
            this.group.add(this.btnService);
            this.add((Component)this.jLabel1, null);
            this.add((Component)this.tfdHost, null);
            this.add((Component)this.jLabel2, null);
            this.add((Component)this.tfdPort, null);
            this.add((Component)this.btnSid, null);
            this.add((Component)this.tfdSid, null);
            this.add((Component)this.btnService, null);
            this.add((Component)this.tfdService, null);
            SpringLayout layout = new SpringLayout();
            this.setLayout(layout);
            layout.putConstraint("West", (Component)this.jLabel1, 5, "West", (Component)this.jLabel1.getParent());
            layout.putConstraint("North", (Component)this.jLabel1, 10, "North", (Component)this.jLabel1.getParent());
            layout.putConstraint("North", (Component)this.tfdHost, 0, "North", (Component)this.jLabel1);
            layout.putConstraint("East", (Component)this.tfdHost, 0, "East", (Component)this.tfdService);
            layout.putConstraint("West", (Component)this.tfdHost, 0, "West", (Component)this.tfdService);
            layout.putConstraint("West", (Component)this.jLabel2, 5, "West", (Component)this.jLabel2.getParent());
            layout.putConstraint("North", (Component)this.jLabel2, 10, "South", (Component)this.jLabel1);
            layout.putConstraint("North", (Component)this.tfdPort, 0, "North", (Component)this.jLabel2);
            layout.putConstraint("East", (Component)this.tfdPort, 0, "East", (Component)this.tfdService);
            layout.putConstraint("West", (Component)this.tfdPort, 0, "West", (Component)this.tfdService);
            layout.putConstraint("West", (Component)this.btnSid, 5, "West", (Component)this.btnSid.getParent());
            layout.putConstraint("North", (Component)this.btnSid, 10, "South", (Component)this.jLabel2);
            layout.putConstraint("North", (Component)this.tfdSid, 0, "North", (Component)this.btnSid);
            layout.putConstraint("East", (Component)this.tfdSid, 0, "East", (Component)this.tfdService);
            layout.putConstraint("West", (Component)this.tfdSid, 0, "West", (Component)this.tfdService);
            layout.putConstraint("West", (Component)this.btnService, 5, "West", (Component)this.btnService.getParent());
            layout.putConstraint("North", (Component)this.btnService, 5, "South", (Component)this.btnSid);
            layout.putConstraint("West", (Component)this.tfdService, 5, "East", (Component)this.btnService);
            layout.putConstraint("North", (Component)this.tfdService, 0, "North", (Component)this.btnService);
            layout.putConstraint("East", (Component)this.tfdHost.getParent(), 5, "East", (Component)this.tfdService);
        }
    }

    private class AdvancedPanel
    extends JPanel
    implements CDComponentView {
        private JLabel jLabel1 = new JLabel();
        private JTextArea tfdUrl = new JTextArea();

        public AdvancedPanel() {
            try {
                this.jbInit();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void populateComponent(ConnectionDescriptor cd) {
            cd.put((Object)"URL", (Object)this.tfdUrl.getText());
        }

        private void jbInit() throws Exception {
            this.add((Component)this.jLabel1, null);
            JScrollPane scr = new JScrollPane(this.tfdUrl);
            this.add((Component)scr, null);
            ResourceUtils.resLabel((JLabel)this.jLabel1, (Component)this.tfdUrl, (String)ConnectionDialogArb.getString(15));
            SpringLayout layout = new SpringLayout();
            this.setLayout(layout);
            layout.putConstraint("West", (Component)this.jLabel1, 5, "West", (Component)this.jLabel1.getParent());
            layout.putConstraint("North", (Component)this.jLabel1, 10, "North", (Component)this.jLabel1.getParent());
            layout.putConstraint("North", (Component)scr, 10, "South", (Component)this.jLabel1);
            layout.putConstraint("West", (Component)scr, 5, "West", (Component)scr.getParent());
            layout.putConstraint("East", (Component)scr.getParent(), 5, "East", (Component)scr);
            layout.putConstraint("South", (Component)scr.getParent(), 10, "South", (Component)scr);
        }
    }

    private class TNSPanel
    extends JPanel
    implements CDComponentView {
        private JRadioButton btnTns = new JRadioButton();
        private JRadioButton btnSqlNet = new JRadioButton();
        private JTextField tfdSqlNetName = new JTextField(15);
        private ButtonGroup group = new ButtonGroup();
        private DataModel model = new DataModel();
        private JComboBox cbxTnsName = new JComboBox(this.model);

        public TNSPanel() {
            try {
                this.jbInit();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void populateComponent(ConnectionDescriptor cd) {
            if (this.btnTns.isSelected()) {
                int index = this.cbxTnsName.getSelectedIndex();
                if (index >= 0) {
                    String name = (String)this.cbxTnsName.getSelectedItem();
                    ArrayList<TCPTNSEntry> entries = TNSHelper.getTNSEntries();
                    String url = null;
                    for (int i = 0; i < entries.size(); ++i) {
                        if (!entries.get(i).getName().equals(name)) continue;
                        url = entries.get(i).getJDBCUrl();
                    }
                    cd.put((Object)"URL", url);
                }
            } else if (this.btnSqlNet.isSelected()) {
                String url = OCI_URL + this.tfdSqlNetName.getText();
                cd.put((Object)"URL", (Object)url);
            }
        }

        private void jbInit() throws Exception {
            ResourceUtils.resButton((AbstractButton)this.btnTns, (String)ConnectionDialogArb.getString(18));
            ResourceUtils.resButton((AbstractButton)this.btnSqlNet, (String)ConnectionDialogArb.getString(19));
            this.group.add(this.btnTns);
            this.group.add(this.btnSqlNet);
            this.add((Component)this.btnTns, null);
            this.add((Component)this.cbxTnsName, null);
            this.add((Component)this.tfdSqlNetName, null);
            this.add((Component)this.btnSqlNet, null);
            SpringLayout layout = new SpringLayout();
            this.setLayout(layout);
            layout.putConstraint("West", (Component)this.btnTns, 5, "West", (Component)this.btnTns.getParent());
            layout.putConstraint("North", (Component)this.btnTns, 10, "North", (Component)this.btnTns.getParent());
            layout.putConstraint("North", (Component)this.cbxTnsName, 0, "North", (Component)this.btnTns);
            layout.putConstraint("East", (Component)this.cbxTnsName.getParent(), 5, "East", (Component)this.cbxTnsName);
            layout.putConstraint("West", (Component)this.btnSqlNet, 0, "West", (Component)this.btnTns);
            layout.putConstraint("North", (Component)this.btnSqlNet, 10, "South", (Component)this.btnTns);
            layout.putConstraint("North", (Component)this.tfdSqlNetName, 0, "North", (Component)this.btnSqlNet);
            layout.putConstraint("East", (Component)this.cbxTnsName, 0, "East", (Component)this.tfdSqlNetName);
            layout.putConstraint("West", (Component)this.cbxTnsName, 0, "West", (Component)this.tfdSqlNetName);
            layout.putConstraint("West", (Component)this.tfdSqlNetName, 5, "East", (Component)this.btnSqlNet);
        }

        private class DataModel
        extends DefaultComboBoxModel {
            List data = null;

            private DataModel() {
            }

            public void setData(List data) {
                assert (data != null);
                this.data = data;
                TNSPanel.this.cbxTnsName.updateUI();
            }

            public List getData() {
                return this.data;
            }

            public ConnectionDescriptor getRowData(int row) {
                return (ConnectionDescriptor)this.data.get(row);
            }

            public Object getElementAt(int index) {
                return this.getRowData(index).getConnectionName();
            }

            public int getSize() {
                return this.data != null ? this.data.size() : 0;
            }
        }
    }

    private static interface CDComponentView {
        public void populateComponent(ConnectionDescriptor var1);
    }

    private class ConnectionModel
    extends AbstractTableModel {
        List data = null;

        private ConnectionModel() {
        }

        public void setData(List data) {
            assert (data != null);
            this.data = data;
        }

        public List getData() {
            return this.data;
        }

        public String getColumnName(int column) {
            String o = null;
            switch (column) {
                case 0: {
                    o = ConnectionDialogArb.getString(4);
                    break;
                }
                case 1: {
                    o = ConnectionDialogArb.getString(5);
                }
            }
            return o;
        }

        public int getRowCount() {
            return this.data != null ? this.data.size() : 0;
        }

        public int getColumnCount() {
            return 2;
        }

        public Object getValueAt(int row, int column) {
            ConnectionDescriptor cd = (ConnectionDescriptor)this.getRowData(row);
            String o = null;
            switch (column) {
                case 0: {
                    o = cd.getConnectionName();
                    break;
                }
                case 1: {
                    String hostname = cd.getHostname();
                    if (hostname != null) {
                        String port = cd.getJdbcPort();
                        String dest = cd.getSid();
                        dest = dest != null ? dest : cd.get((Object)"ServiceName").toString();
                        o = "//" + cd.getHostname() + ":" + (port != null ? port : "1521") + "/" + dest;
                    } else {
                        String url = cd.getURL();
                        o = url.substring(url.lastIndexOf(64) + 1);
                    }
                    String uname = cd.getUsername() != null ? cd.getUsername() : "";
                    o = uname + "@" + o;
                }
            }
            return o;
        }

        public Object getRowData(int row) {
            return this.data.get(row);
        }
    }
}

