/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.explorer.jdev;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import oracle.dbtools.raptor.explorer.dt.dialog.ConnectionDialog;
import oracle.dbtools.raptor.utils.TCPTNSEntry;
import oracle.dbtools.raptor.utils.TNSHelper;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdeveloper.cm.ConnectionDescriptor;
import oracle.jdeveloper.cm.ConnectionManager;
import oracle.jdeveloper.cm.dt.ConnectionArb;
import oracle.jdeveloper.cm.dt.ConnectionEditorDelegate;
import oracle.jdeveloper.cm.dt.ConnectionNode;
import oracle.jdeveloper.cm.dt.ConnectionsProvider;

public class ConnectionEditorImpl
implements ConnectionEditorDelegate {
    Frame parent = null;
    private static ConnectionDialog dlg = null;

    public boolean runConnectionEditor(String connName, int cmd, String[] allowedTypes) {
        String exTitle;
        String exMsg;
        ConnectionDescriptor newCdesc = ConnectionDialog.selectConnection(connName);
        try {
            ConnectionDialog.registerConnection(newCdesc);
        }
        catch (IOException e) {
            exMsg = e.getLocalizedMessage();
            exTitle = ConnectionArb.getString((int)98);
            if (exMsg == null || exMsg.length() == 0) {
                exMsg = e.toString();
            }
            ExceptionDialog.showExceptionDialog((Component)dlg.getParent(), (Throwable)e, (String)exTitle, (String)exMsg, null);
        }
        if (newCdesc != null) {
            try {
                ConnectionManager.getInstance().putConnectionDescriptor(newCdesc.getConnectionName(), newCdesc);
                ConnectionNode node = ConnectionsProvider.getInstance().getConnectionNode(newCdesc.getConnectionName());
                node.open();
            }
            catch (Exception e) {
                exMsg = e.getLocalizedMessage();
                exTitle = ConnectionArb.getString((int)98);
                if (exMsg == null || exMsg.length() == 0) {
                    exMsg = e.toString();
                }
                ExceptionDialog.showExceptionDialog((Component)dlg.getParent(), (Throwable)e, (String)exTitle, (String)exMsg, null);
            }
            return true;
        }
        return false;
    }

    public ConnectionDescriptor getConnectionDescriptor() {
        return dlg.getConnectionDescriptor();
    }

    public void setConnectionDescriptor(ConnectionDescriptor newCdesc) {
        dlg.setConnectionDescriptor(newCdesc);
    }

    public void setParentFrame(Frame parentFrame) {
        this.parent = parentFrame;
    }

    public void setParentDialog(Dialog parentDialog) {
    }

    private static List getAllConnections() {
        ConnectionManager cm = ConnectionManager.getInstance();
        try {
            String[] connNames = cm.getConnectionNames();
            TreeSet<ConnectionDescriptor> l = new TreeSet<ConnectionDescriptor>(new CDComparator());
            for (int i = 0; i < connNames.length; ++i) {
                l.add(cm.getConnectionDescriptor(connNames[i]));
            }
            return Arrays.asList(l.toArray());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static List getTNSConnections() {
        TreeSet<ConnectionDescriptor> l = new TreeSet<ConnectionDescriptor>(new CDComparator());
        ArrayList<TCPTNSEntry> entries = TNSHelper.getTNSEntries();
        for (int i = 0; i < entries.size(); ++i) {
            ConnectionDescriptor cd = new ConnectionDescriptor();
            cd.put((Object)"ConnectionType", (Object)"JDBC");
            cd.put((Object)"DeployPassword", (Object)"false");
            cd.put((Object)"Role", (Object)"");
            cd.put((Object)"JdbcDriver", (Object)"oracle.jdbc.driver.OracleDriver");
            cd.put((Object)"ORACLE_JDBC_TYPE", (Object)"thin");
            cd.put((Object)"user", (Object)"");
            cd.put((Object)"password", (Object)"");
            cd.put((Object)"URL", (Object)entries.get(i).getJDBCUrl());
            cd.put((Object)"ConnectionName", (Object)entries.get(i).getName());
            l.add(cd);
        }
        return Arrays.asList(l.toArray());
    }

    private static class CDComparator
    implements Comparator {
        private CDComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 instanceof ConnectionDescriptor && o2 instanceof ConnectionDescriptor) {
                ConnectionDescriptor cd1 = (ConnectionDescriptor)o1;
                ConnectionDescriptor cd2 = (ConnectionDescriptor)o2;
                return cd1.getConnectionName().compareTo(cd2.getConnectionName());
            }
            throw new IllegalArgumentException(o1 + " and " + o2 + " are not comparable.");
        }

        public boolean equals(Object obj) {
            return this.equals(obj);
        }
    }
}

