/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.extendedtype;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import oracle.dbtools.raptor.extendedtype.ExtendedType;
import oracle.jdbc.driver.OracleConnection;
import oracle.sql.BLOB;
import oracle.sql.BlobDBAccess;

public class BLOBType
extends BLOB
implements ExtendedType {
    private InputStream in = null;
    private OutputStream out = null;
    private BLOB origBlob;

    public BLOBType(BLOB blob) {
        this.origBlob = blob;
    }

    public BLOB getOrigBlob() {
        return this.origBlob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveToDb(Connection conn, String tableName, String columnName, String rowId, String rowScn, boolean dataIntegrity) throws SQLException, IOException {
        int updates;
        PreparedStatement prep = null;
        if (this.in != null) {
            BLOB blob = null;
            StringBuffer selectSql = new StringBuffer();
            selectSql.append("SELECT " + columnName + " FROM " + tableName + " WHERE ROWID='" + rowId + "'");
            if (rowScn != null && dataIntegrity) {
                selectSql.append(" AND ORA_ROWSCN='" + rowScn + "'");
            }
            selectSql.append(" FOR UPDATE");
            try {
                prep = conn.prepareStatement(selectSql.toString());
                ResultSet rs = prep.executeQuery();
                if (rs.next()) {
                    blob = (BLOB)rs.getBlob(1);
                }
                if (blob != null) {
                    OutputStream blobOutputStream = null;
                    try {
                        blob.truncate(0L);
                        blobOutputStream = blob.setBinaryStream(0L);
                        int n2 = blob.getBufferSize();
                        n2 = n2 > 0 ? n2 : 10240;
                        byte[] buffer = new byte[n2];
                        int nread = -1;
                        while ((nread = this.in.read(buffer)) != -1) {
                            blobOutputStream.write(buffer, 0, nread);
                        }
                        blobOutputStream.flush();
                    }
                    finally {
                        this.in.close();
                        blobOutputStream.close();
                        this.origBlob = blob;
                    }
                    boolean bl = true;
                    return bl;
                }
                StringBuffer insertEmptySql = new StringBuffer();
                insertEmptySql.append(" BEGIN UPDATE " + tableName + " SET " + columnName + "= EMPTY_BLOB()" + " WHERE ROWID='" + rowId + "'");
                if (dataIntegrity && rowScn != null) {
                    insertEmptySql.append(" AND ORA_ROWSCN='" + rowScn + "'");
                }
                insertEmptySql.append(" RETURNING ROWID INTO ?; END;");
                Object var12_18 = null;
                CallableStatement callableStatement = conn.prepareCall(insertEmptySql.toString());
                callableStatement.registerOutParameter(1, 1);
                int updates2 = callableStatement.executeUpdate();
                if (updates2 == 1) {
                    String newRowId = callableStatement.getString(1);
                    boolean bl = this.saveToDb(conn, tableName, columnName, newRowId, this.selectRowscn(conn, tableName, newRowId), dataIntegrity);
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                if (prep != null) {
                    prep.close();
                }
            }
        }
        StringBuffer insertEmptySql = new StringBuffer();
        insertEmptySql.append("UPDATE " + tableName + " SET " + columnName + "= EMPTY_BLOB()" + " WHERE ROWID='" + rowId + "'");
        if (dataIntegrity && rowScn != null) {
            insertEmptySql.append(" AND ORA_ROWSCN='" + rowScn + "'");
        }
        return (updates = (prep = conn.prepareStatement(insertEmptySql.toString())).executeUpdate(insertEmptySql.toString())) == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String selectRowscn(Connection conn, String tableName, String rowId) {
        String selectRowscn = "SELECT ORA_ROWSCN FROM " + tableName + " WHERE ROWID = ?";
        ResultSet rs = null;
        PreparedStatement prep2 = null;
        try {
            prep2 = conn.prepareStatement(selectRowscn);
            prep2.setString(1, rowId);
            rs = prep2.executeQuery();
            if (!rs.next()) {
                String string = rs.getString(1);
                return string;
            }
        }
        catch (SQLException ex) {
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ex) {}
            try {
                if (prep2 != null) {
                    prep2.close();
                }
            }
            catch (SQLException ex) {}
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveToDisk(String tableName, String columnName, String rowId, String rowScn, boolean dataIntegrity) throws SQLException, IOException {
        if (this.origBlob != null && this.out != null) {
            InputStream blobStream = null;
            try {
                blobStream = this.origBlob.getBinaryStream();
                if (blobStream != null) {
                    byte[] buffer = new byte[10];
                    int nbytes = 0;
                    while ((nbytes = blobStream.read(buffer)) != -1) {
                        this.out.write(buffer, 0, nbytes);
                    }
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.out.close();
                if (blobStream != null) {
                    blobStream.close();
                }
            }
        }
        return false;
    }

    public void setFromDiskStream(InputStream in) {
        this.in = in;
    }

    public void setToDiskStream(OutputStream out) {
        this.out = out;
    }

    public boolean equals(Object o) {
        return o == this;
    }

    public InputStream asciiStreamValue() throws SQLException {
        return this.origBlob.asciiStreamValue();
    }

    public BigDecimal bigDecimalValue() throws SQLException {
        return this.origBlob.bigDecimalValue();
    }

    public InputStream binaryStreamValue() throws SQLException {
        return this.origBlob.binaryStreamValue();
    }

    public boolean booleanValue() throws SQLException {
        return this.origBlob.booleanValue();
    }

    public byte byteValue() throws SQLException {
        return this.origBlob.byteValue();
    }

    public Reader characterStreamValue() throws SQLException {
        return this.origBlob.characterStreamValue();
    }

    public void close() throws SQLException {
        this.origBlob.close();
    }

    public Date dateValue() throws SQLException {
        return this.origBlob.dateValue();
    }

    public double doubleValue() throws SQLException {
        return this.origBlob.doubleValue();
    }

    public float floatValue() throws SQLException {
        return this.origBlob.floatValue();
    }

    public void freeTemporary() throws SQLException {
        this.origBlob.freeTemporary();
    }

    public OutputStream getBinaryOutputStream() throws SQLException {
        return this.origBlob.getBinaryOutputStream();
    }

    public OutputStream getBinaryOutputStream(long arg0) throws SQLException {
        return this.origBlob.getBinaryOutputStream(arg0);
    }

    public InputStream getBinaryStream() throws SQLException {
        return this.origBlob.getBinaryStream();
    }

    public InputStream getBinaryStream(long arg0) throws SQLException {
        return this.origBlob.getBinaryStream(arg0);
    }

    public int getBufferSize() throws SQLException {
        return this.origBlob.getBufferSize();
    }

    public byte[] getBytes() {
        return this.origBlob.getBytes();
    }

    public int getBytes(long arg0, int arg1, byte[] arg2) throws SQLException {
        return this.origBlob.getBytes(arg0, arg1, arg2);
    }

    public byte[] getBytes(long arg0, int arg1) throws SQLException {
        return this.origBlob.getBytes(arg0, arg1);
    }

    public int getChunkSize() throws SQLException {
        return this.origBlob.getChunkSize();
    }

    public OracleConnection getConnection() throws SQLException {
        return this.origBlob.getConnection();
    }

    public BlobDBAccess getDBAccess() throws SQLException {
        return this.origBlob.getDBAccess();
    }

    public oracle.jdbc.internal.OracleConnection getInternalConnection() throws SQLException {
        return this.origBlob.getInternalConnection();
    }

    public Connection getJavaSqlConnection() throws SQLException {
        return this.origBlob.getJavaSqlConnection();
    }

    public long getLength() {
        return this.origBlob.getLength();
    }

    public byte[] getLocator() {
        return this.origBlob.getLocator();
    }

    public oracle.jdbc.OracleConnection getOracleConnection() throws SQLException {
        return this.origBlob.getOracleConnection();
    }

    public InputStream getStream() {
        return this.origBlob.getStream();
    }

    public int hashCode() {
        return this.origBlob.hashCode();
    }

    public int intValue() throws SQLException {
        return this.origBlob.intValue();
    }

    public boolean isConvertibleTo(Class arg0) {
        return this.origBlob.isConvertibleTo(arg0);
    }

    public boolean isEmptyLob() throws SQLException {
        return this.origBlob.isEmptyLob();
    }

    public boolean isOpen() throws SQLException {
        return this.origBlob.isOpen();
    }

    public boolean isTemporary() throws SQLException {
        return this.origBlob.isTemporary();
    }

    public long length() throws SQLException {
        return this.origBlob.length();
    }

    public long longValue() throws SQLException {
        return this.origBlob.longValue();
    }

    public Object makeJdbcArray(int arg0) {
        return this.origBlob.makeJdbcArray(arg0);
    }

    public void open(int arg0) throws SQLException {
        this.origBlob.open(arg0);
    }

    public long position(Blob arg0, long arg1) throws SQLException {
        return this.origBlob.position(arg0, arg1);
    }

    public long position(byte[] arg0, long arg1) throws SQLException {
        return this.origBlob.position(arg0, arg1);
    }

    public int putBytes(long arg0, byte[] arg1, int arg2) throws SQLException {
        return this.origBlob.putBytes(arg0, arg1, arg2);
    }

    public int putBytes(long arg0, byte[] arg1) throws SQLException {
        return this.origBlob.putBytes(arg0, arg1);
    }

    public OutputStream setBinaryStream(long arg0) throws SQLException {
        return this.origBlob.setBinaryStream(arg0);
    }

    public void setBytes(byte[] arg0) {
        this.origBlob.setBytes(arg0);
    }

    public int setBytes(long arg0, byte[] arg1, int arg2, int arg3) throws SQLException {
        return this.origBlob.setBytes(arg0, arg1, arg2, arg3);
    }

    public int setBytes(long arg0, byte[] arg1) throws SQLException {
        return this.origBlob.setBytes(arg0, arg1);
    }

    public void setLocator(byte[] arg0) {
        this.origBlob.setLocator(arg0);
    }

    public void setPhysicalConnectionOf(Connection arg0) {
        this.origBlob.setPhysicalConnectionOf(arg0);
    }

    public void setShareBytes(byte[] arg0) {
        this.origBlob.setShareBytes(arg0);
    }

    public byte[] shareBytes() {
        return this.origBlob.shareBytes();
    }

    public String stringValue() throws SQLException {
        return this.origBlob.stringValue();
    }

    public Timestamp timestampValue() throws SQLException {
        return this.origBlob.timestampValue();
    }

    public Time timeValue() throws SQLException {
        return this.origBlob.timeValue();
    }

    public Object toJdbc() throws SQLException {
        return this.origBlob.toJdbc();
    }

    public void trim(long arg0) throws SQLException {
        this.origBlob.trim(arg0);
    }

    public void truncate(long arg0) throws SQLException {
        this.origBlob.truncate(arg0);
    }

    public String toString() {
        return "(BLOB)";
    }

    public InputStream getCharStream() throws SQLException {
        return this.asciiStreamValue();
    }
}

